/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.integrationtests.drl;

import java.util.ArrayList;
import org.assertj.core.api.Assertions;
import org.drools.testcoverage.common.model.Person;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.runtime.KieSession;

public abstract class AbstractDeclareTest {
    protected final KieBaseTestConfiguration kieBaseTestConfiguration;

    public AbstractDeclareTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeclaresWithArrayFields() {
        String drl = "package org.drools.compiler.integrationtests.drl; \nimport " + Person.class.getName() + ";\n\nglobal java.util.List list;\ndeclare Cheese\n   name : String = \"ched\" \nend \ndeclare X\n    fld \t: String   = \"xx\"                                      @key \n    achz\t: Cheese[] \n    astr\t: String[]  = new String[] {\"x\", \"y11\" } \n    aint\t: int[] \n    sint\t: short[] \n    bint\t: byte[] \n    lint\t: long[] \n    dint\t: double[] \n    fint\t: float[] \n    zint\t: Integer[]  = new Integer[] {2,3}                   @key \n    aaaa\t: String[][] \n    bbbb\t: int[][] \n    aprs\t: Person[]  = new Person[] { } \nend\n\nrule \"Init\"\nwhen\n\nthen\n    X x = new X( \"xx\", \n                 new Cheese[0], \n                 new String[] { \"x\", \"y22\" }, \n                 new int[] { 7, 9 }, \n                 new short[] { 3, 4 }, \n                 new byte[] { 1, 2 }, \n                 new long[] { 100L, 200L }, \n                 new double[] { 3.2, 4.4 }, \n                 new float[] { 3.2f, 4.4f }, \n                 new Integer[] { 2, 3 }, \n                 new String[2][3], \n                 new int[5][3], \n                 null \n    ); \n   insert( x );\n      X x2 = new X(); \n   x2.setAint( new int[2] ); \n    x2.getAint()[0] = 7; \n   insert( x2 );\n      if ( x.hashCode() == x2.hashCode() ) list.add( \"hash\" );  \n      if( x.equals( x2 ) ) list.add( \"equals\" );  \n      list.add( x.getAint(  )[0] );  \nend \n\nrule \"Check\"\nwhen\n    X( astr != null,               \n       astr.length > 0,            \n       astr[0] == \"x\",           \n       $x : astr[1],               \n       aint[0] == 7  )             \nthen\n System.out.println(\"Fired!!!!!!!!!!!!!!\" + $x); \n    list.add( $x );\nend \n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"declare-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        try {
            ArrayList list = new ArrayList();
            ksession.setGlobal("list", list);
            ksession.fireAllRules();
            System.out.println(list);
            Assertions.assertThat((boolean)list.contains("hash")).isTrue();
            Assertions.assertThat((boolean)list.contains("equals")).isTrue();
            Assertions.assertThat((boolean)list.contains(7)).isTrue();
            if (this.kieBaseTestConfiguration.isIdentity()) {
                Assertions.assertThat((boolean)list.contains("y11")).isTrue();
            }
            Assertions.assertThat((boolean)list.contains("y22")).isTrue();
        }
        finally {
            ksession.dispose();
        }
    }
}

