/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.integrationtests.operators;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.drools.core.base.ClassObjectType;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.MemoryFactory;
import org.drools.core.common.NodeMemories;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.impl.RuleBase;
import org.drools.core.reteoo.BetaMemory;
import org.drools.core.reteoo.BetaNode;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.RightTupleImpl;
import org.drools.core.reteoo.Tuple;
import org.drools.core.reteoo.TupleMemory;
import org.drools.kiesession.session.StatefulKnowledgeSessionImpl;
import org.drools.testcoverage.common.model.AFact;
import org.drools.testcoverage.common.model.Cheese;
import org.drools.testcoverage.common.model.Person;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.FactHandle;

@RunWith(value=Parameterized.class)
public class NotTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public NotTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLastMemoryEntryNotBug() {
        String drl = "package org.drools.compiler.integrationtests.operators \nimport " + AFact.class.getCanonicalName() + "\nglobal java.util.List list \nrule x1 \nwhen \n    $s : String( this == 'x1' ) \n    not AFact( this != null ) \nthen \n  list.add(\"fired x1\"); \nend  \nrule x2 \nwhen \n    $s : String( this == 'x2' ) \n    not AFact( field1 == $s, this != null ) \nthen \n  list.add(\"fired x2\"); \nend  \n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"not-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        try {
            ArrayList list = new ArrayList();
            ksession.setGlobal("list", list);
            ksession.insert((Object)"x1");
            ksession.insert((Object)"x2");
            AFact a1 = new AFact("x1", null);
            AFact a2 = new AFact("x2", null);
            FactHandle fa1 = ksession.insert((Object)a1);
            FactHandle fa2 = ksession.insert((Object)a2);
            ksession.update(fa1, (Object)a1);
            ksession.update(fa2, (Object)a2);
            ksession.fireAllRules();
            Assertions.assertThat((int)list.size()).isEqualTo(0);
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNegatedConstaintInNot() {
        String drl = "package org.drools.compiler.integrationtests.operators;\nimport " + Person.class.getCanonicalName() + ";\n\nrule R1 when\n    not( Person( !(age > 18) ) )\nthen\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"negated-not-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        try {
            ksession.insert((Object)new Person("Mario", 45));
            Assertions.assertThat((int)ksession.fireAllRules()).isEqualTo(1);
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMissingRootBlockerEquality() {
        String drl = "package org.drools.compiler.integrationtests.operators;\nimport " + Person.class.getCanonicalName() + ";\nimport " + Cheese.class.getCanonicalName() + ";\n\nrule R1 when\n    Cheese($type : type)\n    not( Person( likes == $type, salary == null ) )\nthen\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"not-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        try {
            Cheese cheese = new Cheese("cheddar");
            Person p1 = new Person("John");
            p1.setLikes("cheddar");
            p1.setSalary(null);
            Person p2 = new Person("Paul");
            p2.setLikes("cheddar");
            p2.setSalary(null);
            Person p3 = new Person("George");
            p3.setLikes("cheddar");
            p3.setSalary(null);
            ksession.insert((Object)cheese);
            InternalFactHandle handle1 = (InternalFactHandle)ksession.insert((Object)p1);
            InternalFactHandle handle2 = (InternalFactHandle)ksession.insert((Object)p2);
            InternalFactHandle handle3 = (InternalFactHandle)ksession.insert((Object)p3);
            Assertions.assertThat((int)ksession.fireAllRules()).isEqualTo(0);
            InternalFactHandle blockerHandle = this.getBlockerFactHandle(ksession);
            Person blockerFact = (Person)blockerHandle.getObject();
            blockerFact.setAge(40);
            ksession.update((FactHandle)blockerHandle, (Object)blockerFact, new String[]{"age"});
            Assertions.assertThat((int)ksession.fireAllRules()).isEqualTo(0);
            blockerFact.setSalary(new BigDecimal(1000));
            ksession.update((FactHandle)blockerHandle, (Object)blockerFact, new String[]{"salary"});
            Assertions.assertThat((int)ksession.fireAllRules()).isEqualTo(0);
            ArrayList<InternalFactHandle> handleList = new ArrayList<InternalFactHandle>();
            handleList.add(handle1);
            handleList.add(handle2);
            handleList.add(handle3);
            handleList.remove(blockerHandle);
            for (InternalFactHandle handle : handleList) {
                Person p = (Person)handle.getObject();
                p.setSalary(new BigDecimal(1000));
                ksession.update((FactHandle)handle, (Object)p, new String[]{"salary"});
            }
            Assertions.assertThat((int)ksession.fireAllRules()).isEqualTo(1);
        }
        finally {
            ksession.dispose();
        }
    }

    private InternalFactHandle getBlockerFactHandle(KieSession ksession) {
        ObjectTypeNode otn = NotTest.getObjectTypeNode(ksession.getKieBase(), Person.class);
        BetaNode notNode = (BetaNode)otn.getSinks()[0].getSinks()[0];
        StatefulKnowledgeSessionImpl ksessionImpl = (StatefulKnowledgeSessionImpl)ksession;
        NodeMemories nodeMemories = ksessionImpl.getNodeMemories();
        BetaMemory betaMemory = (BetaMemory)nodeMemories.getNodeMemory((MemoryFactory)notNode, (ReteEvaluator)ksessionImpl);
        TupleMemory rightTupleMemory = betaMemory.getRightTupleMemory();
        Tuple[] tuples = rightTupleMemory.toArray();
        for (int i = 0; i < tuples.length; ++i) {
            RightTupleImpl tuple = (RightTupleImpl)tuples[i];
            if (tuple.getBlocked() == null) continue;
            return tuple.getFactHandle();
        }
        Assertions.fail((String)"Cannot find blocker in BetaMemory");
        return null;
    }

    public static ObjectTypeNode getObjectTypeNode(KieBase kbase, Class<?> nodeClass) {
        List nodes = ((RuleBase)kbase).getRete().getObjectTypeNodes();
        for (ObjectTypeNode n : nodes) {
            if (((ClassObjectType)n.getObjectType()).getClassType() != nodeClass) continue;
            return n;
        }
        return null;
    }

    @Test
    public void testNotWithInnerJoin() {
        String drl = "package org.drools.compiler.integrationtests.operators;\nglobal java.util.List results;\nimport " + Visit.class.getCanonicalName() + ";\n\nrule R1 when\n    $visit : Visit( previous != null )\n    not( Visit( previous != null, previous == $visit.location ) )\nthen    results.add($visit.getLocation());\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"not-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        ArrayList results = new ArrayList();
        ksession.setGlobal("results", results);
        Visit london = new Visit("London", "Brussels");
        Visit dublin = new Visit("Dublin", "London");
        Visit paris = new Visit("Paris", "Dublin");
        FactHandle dublinFH = ksession.insert((Object)dublin);
        FactHandle londonFH = ksession.insert((Object)london);
        FactHandle parisFH = ksession.insert((Object)paris);
        ksession.fireAllRules();
        results.clear();
        paris.setPrevious("London");
        ksession.update(parisFH, (Object)paris);
        dublin.setPrevious(null);
        ksession.update(dublinFH, (Object)dublin);
        ksession.fireAllRules();
        Assertions.assertThat((int)results.size()).isEqualTo(1);
        Assertions.assertThat((String)((String)results.get(0))).isEqualTo("Paris");
    }

    public static class Visit {
        private final String location;
        private String previous;

        private Visit(String location) {
            this(location, null);
        }

        private Visit(String location, String previous) {
            this.location = location;
            this.previous = previous;
        }

        public String getLocation() {
            return this.location;
        }

        public String getPrevious() {
            return this.previous;
        }

        public void setPrevious(String previous) {
            this.previous = previous;
        }

        public String toString() {
            return "Visit{location='" + this.location + "'}";
        }
    }
}

