/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.compiler.builder.impl;

import org.assertj.core.api.Assertions;
import org.drools.compiler.builder.impl.KnowledgeBuilderConfigurationImpl;
import org.junit.Test;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.builder.conf.ParallelRulesBuildThresholdOption;

public class KnowledgeBuilderConfigurationImplTest {
    @Test
    public void testParallelRulesBuildThresholdConfiguration() {
        try {
            System.getProperties().put("drools.parallelRulesBuildThreshold", "20");
            KnowledgeBuilderConfigurationImpl kbConfigImpl = (KnowledgeBuilderConfigurationImpl)KnowledgeBuilderFactory.newKnowledgeBuilderConfiguration().as(KnowledgeBuilderConfigurationImpl.KEY);
            Assertions.assertThat((int)((ParallelRulesBuildThresholdOption)kbConfigImpl.getOption(ParallelRulesBuildThresholdOption.KEY)).getParallelRulesBuildThreshold()).isEqualTo(20);
        }
        finally {
            System.getProperties().remove("drools.parallelRulesBuildThreshold");
        }
    }

    @Test
    public void testMinusOneParallelRulesBuildThresholdConfiguration() {
        try {
            System.getProperties().put("drools.parallelRulesBuildThreshold", "-1");
            KnowledgeBuilderConfigurationImpl kbConfigImpl = (KnowledgeBuilderConfigurationImpl)KnowledgeBuilderFactory.newKnowledgeBuilderConfiguration().as(KnowledgeBuilderConfigurationImpl.KEY);
            Assertions.assertThat((int)((ParallelRulesBuildThresholdOption)kbConfigImpl.getOption(ParallelRulesBuildThresholdOption.KEY)).getParallelRulesBuildThreshold()).isEqualTo(-1);
        }
        finally {
            System.getProperties().remove("drools.parallelRulesBuildThreshold");
        }
    }
}

