/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.compiler.lang.dsl;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.drools.drl.parser.lang.dsl.DSLMappingEntry;
import org.drools.drl.parser.lang.dsl.DSLMappingFile;
import org.drools.drl.parser.lang.dsl.DSLTokenizedMappingFile;
import org.drools.drl.parser.lang.dsl.DefaultExpander;
import org.junit.Test;

public class DSLTokenizedMappingFileTest {
    private static final String lookbehind = "(?:(?<=^)|(?<=\\W))";
    private static final String NL = System.getProperty("line.separator");
    private DSLMappingFile file = null;
    private final String filename = "test_metainfo.dsl";

    @Test
    public void testParseFile() {
        try {
            InputStreamReader reader = new InputStreamReader(this.getClass().getResourceAsStream(this.filename));
            this.file = new DSLTokenizedMappingFile();
            boolean parsingResult = this.file.parseAndLoad((Reader)reader);
            ((Reader)reader).close();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)parsingResult).as(this.file.getErrors().toString(), new Object[0])).isTrue();
            Assertions.assertThat((boolean)this.file.getErrors().isEmpty()).isTrue();
            Assertions.assertThat((int)this.file.getMapping().getEntries().size()).isEqualTo(31);
        }
        catch (IOException e) {
            e.printStackTrace();
            Assertions.fail((String)"Should not raise exception ");
        }
    }

    @Test
    public void testParseFileWithBrackets() {
        String file = "[when]ATTRIBUTE \"{attr}\" IS IN [{list}]=Attribute( {attr} in ({list}) )";
        try {
            StringReader reader = new StringReader(file);
            this.file = new DSLTokenizedMappingFile();
            boolean parsingResult = this.file.parseAndLoad((Reader)reader);
            ((Reader)reader).close();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)parsingResult).as(this.file.getErrors().toString(), new Object[0])).isTrue();
            Assertions.assertThat((boolean)this.file.getErrors().isEmpty()).isTrue();
            Assertions.assertThat((int)this.file.getMapping().getEntries().size()).isEqualTo(1);
            DSLMappingEntry entry = (DSLMappingEntry)this.file.getMapping().getEntries().get(0);
            Assertions.assertThat((Comparable)entry.getSection()).isEqualTo((Object)DSLMappingEntry.CONDITION);
            Assertions.assertThat((Comparable)entry.getMetaData()).isEqualTo((Object)DSLMappingEntry.EMPTY_METADATA);
            Assertions.assertThat((String)entry.getKeyPattern().toString()).isEqualTo("(?:(?<=^)|(?<=\\W))ATTRIBUTE\\s+\"(.*?)\"\\s+IS\\s+IN\\s+[(.*?)](?=\\W|$)");
            Assertions.assertThat((String)entry.getValuePattern()).isEqualTo("Attribute( {attr} in ({list}) )");
        }
        catch (IOException e) {
            e.printStackTrace();
            Assertions.fail((String)"Should not raise exception ");
        }
    }

    @Test
    public void testParseFileWithEscaptedBrackets() {
        String file = "[when]ATTRIBUTE \"{attr}\" IS IN \\[{list}\\]=Attribute( {attr} in ({list}) )";
        try {
            StringReader reader = new StringReader(file);
            this.file = new DSLTokenizedMappingFile();
            boolean parsingResult = this.file.parseAndLoad((Reader)reader);
            ((Reader)reader).close();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)parsingResult).as(this.file.getErrors().toString(), new Object[0])).isTrue();
            Assertions.assertThat((boolean)this.file.getErrors().isEmpty()).isTrue();
            Assertions.assertThat((int)this.file.getMapping().getEntries().size()).isEqualTo(1);
            DSLMappingEntry entry = (DSLMappingEntry)this.file.getMapping().getEntries().get(0);
            Assertions.assertThat((Comparable)entry.getSection()).isEqualTo((Object)DSLMappingEntry.CONDITION);
            Assertions.assertThat((Comparable)entry.getMetaData()).isEqualTo((Object)DSLMappingEntry.EMPTY_METADATA);
            Assertions.assertThat((String)entry.getKeyPattern().toString()).isEqualTo("(?:(?<=^)|(?<=\\W))ATTRIBUTE\\s+\"(.*?)\"\\s+IS\\s+IN\\s+\\[(.*?)\\](?=\\W|$)");
            Assertions.assertThat((String)entry.getValuePattern()).isEqualTo("Attribute( {attr} in ({list}) )");
        }
        catch (IOException e) {
            e.printStackTrace();
            Assertions.fail((String)"Should not raise exception ");
        }
    }

    @Test
    public void testParseFileWithEscapes() {
        String file = "[then]TEST=System.out.println(\"DO_SOMETHING\");" + NL + "[when]code {code1} occurs and sum of all digit not equal \\( {code2} \\+ {code3} \\)=AAAA( cd1 == {code1}, cd2 != ( {code2} + {code3} ))" + NL + "[when]code {code1} occurs=BBBB" + NL;
        try {
            StringReader reader = new StringReader(file);
            this.file = new DSLTokenizedMappingFile();
            boolean parsingResult = this.file.parseAndLoad((Reader)reader);
            ((Reader)reader).close();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)parsingResult).as(this.file.getErrors().toString(), new Object[0])).isTrue();
            Assertions.assertThat((boolean)this.file.getErrors().isEmpty()).isTrue();
            String LHS = "code 1041 occurs and sum of all digit not equal ( 1034 + 1035 )";
            String rule = "rule \"x\"" + NL + "when" + NL + "code 1041 occurs and sum of all digit not equal ( 1034 + 1035 )" + NL + "then" + NL + "TEST" + NL + "end";
            DefaultExpander de = new DefaultExpander();
            de.addDSLMapping(this.file.getMapping());
            String ruleAfterExpansion = de.expand(rule);
            String expected = "rule \"x\"" + NL + "when" + NL + "AAAA( cd1 == 1041, cd2 != ( 1034 + 1035 ))" + NL + "then" + NL + "System.out.println(\"DO_SOMETHING\");" + NL + "end";
            Assertions.assertThat((String)ruleAfterExpansion).isEqualTo(expected);
        }
        catch (IOException e) {
            e.printStackTrace();
            Assertions.fail((String)"Should not raise exception ");
        }
    }

    @Test
    public void testParseFileWithEscaptedEquals() {
        String file = "[when]something:\\={value}=Attribute( something == \"{value}\" )";
        try {
            StringReader reader = new StringReader(file);
            this.file = new DSLTokenizedMappingFile();
            boolean parsingResult = this.file.parseAndLoad((Reader)reader);
            ((Reader)reader).close();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)parsingResult).as(this.file.getErrors().toString(), new Object[0])).isTrue();
            Assertions.assertThat((boolean)this.file.getErrors().isEmpty()).isTrue();
            Assertions.assertThat((int)this.file.getMapping().getEntries().size()).isEqualTo(1);
            DSLMappingEntry entry = (DSLMappingEntry)this.file.getMapping().getEntries().get(0);
            Assertions.assertThat((Comparable)entry.getSection()).isEqualTo((Object)DSLMappingEntry.CONDITION);
            Assertions.assertThat((Comparable)entry.getMetaData()).isEqualTo((Object)DSLMappingEntry.EMPTY_METADATA);
            Assertions.assertThat((String)entry.getKeyPattern().toString()).isEqualTo("(?:(?<=^)|(?<=\\W))something:\\=(.*?)$");
            Assertions.assertThat((String)entry.getValuePattern()).isEqualTo("Attribute( something == \"{value}\" )");
        }
        catch (IOException e) {
            e.printStackTrace();
            Assertions.fail((String)"Should not raise exception ");
        }
    }
}

