/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.extractors;

import org.assertj.core.api.Assertions;
import org.drools.core.base.ClassFieldAccessorCache;
import org.drools.core.base.TestBean;
import org.drools.core.rule.accessor.ReadAccessor;
import org.drools.mvel.accessors.ClassFieldAccessorStore;
import org.drools.mvel.extractors.BaseClassFieldExtractorsTest;
import org.junit.Before;
import org.junit.Test;

public class LongClassFieldExtractorTest
extends BaseClassFieldExtractorsTest {
    private static final long VALUE = 5L;
    ReadAccessor extractor;
    TestBean bean = new TestBean();

    @Before
    public void setUp() throws Exception {
        ClassFieldAccessorStore store = new ClassFieldAccessorStore();
        store.setClassFieldAccessorCache(new ClassFieldAccessorCache(Thread.currentThread().getContextClassLoader()));
        store.setEagerWire(true);
        this.extractor = store.getReader(TestBean.class, "longAttr");
    }

    @Override
    @Test
    public void testGetBooleanValue() {
        try {
            this.extractor.getBooleanValue(null, (Object)this.bean);
            Assertions.fail((String)"Should have throw an exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    @Test
    public void testGetByteValue() {
        try {
            Assertions.assertThat((byte)this.extractor.getByteValue(null, (Object)this.bean)).isEqualTo((byte)5);
        }
        catch (Exception e) {
            Assertions.fail((String)"Should not throw an exception");
        }
    }

    @Override
    @Test
    public void testGetCharValue() {
        try {
            this.extractor.getCharValue(null, (Object)this.bean);
            Assertions.fail((String)"Should have throw an exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    @Test
    public void testGetDoubleValue() {
        try {
            Assertions.assertThat((double)this.extractor.getDoubleValue(null, (Object)this.bean)).isCloseTo(5.0, Assertions.within((Double)0.01));
        }
        catch (Exception e) {
            Assertions.fail((String)"Should not throw an exception");
        }
    }

    @Override
    @Test
    public void testGetFloatValue() {
        try {
            Assertions.assertThat((float)this.extractor.getFloatValue(null, (Object)this.bean)).isCloseTo(5.0f, Assertions.within((Float)Float.valueOf(0.01f)));
        }
        catch (Exception e) {
            Assertions.fail((String)"Should not throw an exception");
        }
    }

    @Override
    @Test
    public void testGetIntValue() {
        try {
            Assertions.assertThat((int)this.extractor.getIntValue(null, (Object)this.bean)).isEqualTo(5L);
        }
        catch (Exception e) {
            Assertions.fail((String)"Should not throw an exception");
        }
    }

    @Override
    @Test
    public void testGetLongValue() {
        try {
            Assertions.assertThat((long)this.extractor.getLongValue(null, (Object)this.bean)).isEqualTo(5L);
        }
        catch (Exception e) {
            Assertions.fail((String)"Should not throw an exception");
        }
    }

    @Override
    @Test
    public void testGetShortValue() {
        try {
            Assertions.assertThat((short)this.extractor.getShortValue(null, (Object)this.bean)).isEqualTo((short)5);
        }
        catch (Exception e) {
            Assertions.fail((String)"Should not throw an exception");
        }
    }

    @Override
    @Test
    public void testGetValue() {
        try {
            Assertions.assertThat((Object)this.extractor.getValue(null, (Object)this.bean)).isEqualTo((Object)new Long(5L));
            Assertions.assertThat((boolean)(this.extractor.getValue(null, (Object)this.bean) instanceof Long)).isTrue();
        }
        catch (Exception e) {
            Assertions.fail((String)"Should not throw an exception");
        }
    }

    @Override
    @Test
    public void testIsNullValue() {
        try {
            Assertions.assertThat((boolean)this.extractor.isNullValue(null, (Object)this.bean)).isFalse();
        }
        catch (Exception e) {
            Assertions.fail((String)"Should not throw an exception");
        }
    }
}

