/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.drools.mvel.compiler.Cheese;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.runtime.KieSession;

@RunWith(value=Parameterized.class)
public class EdgeCaseNonExecModelTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public EdgeCaseNonExecModelTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)false);
    }

    @Test
    public void testNamedConsequencesInsideOR1() {
        String str = "import org.drools.mvel.compiler.Cheese;\n global java.util.List results;\n\nrule R1 when\n    ( $a: Cheese ( type == \"stilton\" ) do[t1]\n    or\n    $b: Cheese ( type == \"gorgonzola\" ) )\n    $c: Cheese ( type == \"cheddar\" )\nthen\n    results.add( $c.getType() );\nthen[t1]\n    results.add( $a.getType() );\nend\n";
        List<String> results = this.executeTestWithDRL(str);
        Assertions.assertThat((int)results.size()).isEqualTo(2);
        Assertions.assertThat((boolean)results.contains("cheddar")).isTrue();
        Assertions.assertThat((boolean)results.contains("stilton")).isTrue();
    }

    @Test
    public void testNamedConsequencesInsideOR2() {
        String str = "import org.drools.mvel.compiler.Cheese;\n global java.util.List results;\n\nrule R1 when\n    ( $a: Cheese ( type == \"stilton\" )\n    or\n    $b: Cheese ( type == \"gorgonzola\" ) do[t1] )\n    $c: Cheese ( type == \"cheddar\" )\nthen\n    results.add( $c.getType() );\nthen[t1]\n    results.add( $b.getType() );\nend\n";
        List<String> results = this.executeTestWithDRL(str);
        Assertions.assertThat((int)results.size()).isEqualTo(1);
        Assertions.assertThat((boolean)results.contains("cheddar")).isTrue();
    }

    private List<String> executeTestWithDRL(String drl) {
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        ArrayList<String> results = new ArrayList<String>();
        ksession.setGlobal("results", results);
        Cheese stilton = new Cheese("stilton", 5);
        Cheese cheddar = new Cheese("cheddar", 7);
        Cheese brie = new Cheese("brie", 5);
        ksession.insert((Object)stilton);
        ksession.insert((Object)cheddar);
        ksession.insert((Object)brie);
        ksession.fireAllRules();
        return results;
    }
}

