/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests;

import java.util.ArrayList;
import java.util.Collection;
import org.assertj.core.api.Assertions;
import org.drools.mvel.compiler.I18nPerson;
import org.drools.mvel.compiler.Person;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.KieUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.KieModule;
import org.kie.api.builder.ReleaseId;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.KieSession;
import org.kie.internal.io.ResourceFactory;

@RunWith(value=Parameterized.class)
public class I18nTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public I18nTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    @Test
    @Ignore(value="Fails because of JBRULES-3435. But the JBRULES-2853 part works fine. Support for i18n properties must be fixed in mvel")
    public void readDrlInEncodingUtf8() throws Exception {
        Resource drlResource = ResourceFactory.newClassPathResource((String)"test_I18nPerson_utf8.drl", (String)"UTF-8", this.getClass());
        drlResource.setResourceType(ResourceType.DRL);
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromResources((String)"i18n-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (Resource[])new Resource[]{drlResource});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        I18nPerson i18nPerson = new I18nPerson();
        i18nPerson.setGar\u00e7on("Value 1");
        i18nPerson.set\u00c9l\u00e8ve("Value 2");
        i18nPerson.set\u0418\u043c\u044f("Value 3");
        i18nPerson.set\u540d\u79f0("Value 4");
        ksession.insert((Object)i18nPerson);
        ksession.fireAllRules();
        Assertions.assertThat((boolean)list.contains("gar\u00e7on")).isTrue();
        Assertions.assertThat((boolean)list.contains("\u00e9l\u00e8ve")).isTrue();
        Assertions.assertThat((boolean)list.contains("\u0438\u043c\u044f")).isTrue();
        Assertions.assertThat((boolean)list.contains("\u540d\u79f0")).isTrue();
        ksession.dispose();
    }

    @Test
    public void readDrlInEncodingLatin1() throws Exception {
        Resource drlResource = ResourceFactory.newClassPathResource((String)"test_I18nPerson_latin1.drl.latin1", (String)"ISO-8859-1", this.getClass());
        drlResource.setResourceType(ResourceType.DRL);
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromResources((String)"i18n-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (Resource[])new Resource[]{drlResource});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        I18nPerson i18nPerson = new I18nPerson();
        i18nPerson.setGar\u00e7on("Value 1");
        ksession.insert((Object)i18nPerson);
        ksession.fireAllRules();
        Assertions.assertThat((boolean)list.contains("gar\u00e7on")).isTrue();
        ksession.dispose();
    }

    @Test
    public void testIdeographicSpaceInDSL() throws Exception {
        String dsl = "// Testing 'IDEOGRAPHIC SPACE' (U+3000)\n[when]\u540d\u524d\u304c {firstName}=Person(name==\"\u5c71\u672c\u3000{firstName}\")\n[then]\u30e1\u30c3\u30bb\u30fc\u30b8 {message}=messages.add(\"\u30e1\u30c3\u30bb\u30fc\u30b8\u3000\" + {message});";
        String dslr = "package test\n\nimport org.drools.mvel.compiler.Person\n\nexpander test_I18n.dsl\n\nglobal java.util.List messages;\n\nrule \"IDEOGRAPHIC SPACE test\"\n    when\n        // Person(name==\"\u5c71\u672c\u3000\u592a\u90ce\")\n        \u540d\u524d\u304c \u592a\u90ce\n    then\n        // messages.add(\"\u30e1\u30c3\u30bb\u30fc\u30b8\u3000\u30eb\u30fc\u30eb\u306b\u30d2\u30c3\u30c8\u3057\u307e\u3057\u305f\");\n         \u30e1\u30c3\u30bb\u30fc\u30b8 \"\u30eb\u30fc\u30eb\u306b\u30d2\u30c3\u30c8\u3057\u307e\u3057\u305f\"\nend";
        Resource dslResource = ResourceFactory.newByteArrayResource((byte[])dsl.getBytes("UTF-8"));
        dslResource.setResourceType(ResourceType.DSL);
        dslResource.setTargetPath("src/main/resources/test.dsl");
        Resource dslrResource = ResourceFactory.newByteArrayResource((byte[])dslr.getBytes("UTF-8"));
        dslrResource.setResourceType(ResourceType.DSLR);
        dslrResource.setTargetPath("src/main/resources/test-rule.dslr");
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromResources((String)"i18n-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (Resource[])new Resource[]{dslResource, dslrResource});
        KieSession ksession = kbase.newKieSession();
        ArrayList messages = new ArrayList();
        ksession.setGlobal("messages", messages);
        Person person = new Person();
        person.setName("\u5c71\u672c\u3000\u592a\u90ce");
        ksession.insert((Object)person);
        ksession.fireAllRules();
        Assertions.assertThat((boolean)messages.contains("\u30e1\u30c3\u30bb\u30fc\u30b8\u3000\u30eb\u30fc\u30eb\u306b\u30d2\u30c3\u30c8\u3057\u307e\u3057\u305f")).isTrue();
        ksession.dispose();
    }

    @Test
    public void testNewClassPathResource() {
        Resource drl = ResourceFactory.newClassPathResource((String)"test_I18nPerson_utf8_forTestNewClassPathResource.drl", this.getClass());
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromResources((String)"i18n-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (Resource[])new Resource[]{drl});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        I18nPerson i18nPerson = new I18nPerson();
        i18nPerson.set\u540d\u79f0("\u5c71\u7530\u82b1\u5b50");
        ksession.insert((Object)i18nPerson);
        ksession.fireAllRules();
        Assertions.assertThat((boolean)list.contains("\u540d\u79f0\u306f\u5c71\u7530\u82b1\u5b50\u3067\u3059")).isTrue();
        ksession.dispose();
    }

    @Test
    public void testKieFileSystem() {
        String str = "package org.drools.mvel.compiler.i18ntest;\nimport org.drools.mvel.compiler.I18nPerson;\n\nglobal java.util.List list;\nrule \"\u540d\u79f0 is \u5c71\u7530\u82b1\u5b50\"\n    when\n        p : I18nPerson( \u540d\u79f0 == \"\u5c71\u7530\u82b1\u5b50\" )\n    then\n        list.add( \"\u540d\u79f0\u306f\u5c71\u7530\u82b1\u5b50\u3067\u3059\" );\nend\n";
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kfs = ks.newKieFileSystem().write("src/main/resources/r1.drl", str);
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromKieFileSystem((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (KieFileSystem)kfs, (boolean)true);
        Assertions.assertThat((boolean)kieBuilder.buildAll().getResults().getMessages().isEmpty()).isTrue();
        ReleaseId releaseId = kieBuilder.getKieModule().getReleaseId();
        KieContainer kieContainer = ks.newKieContainer(releaseId);
        KieSession ksession = kieContainer.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        I18nPerson i18nPerson = new I18nPerson();
        i18nPerson.set\u540d\u79f0("\u5c71\u7530\u82b1\u5b50");
        ksession.insert((Object)i18nPerson);
        ksession.fireAllRules();
        Assertions.assertThat((boolean)list.contains("\u540d\u79f0\u306f\u5c71\u7530\u82b1\u5b50\u3067\u3059")).isTrue();
        ksession.dispose();
    }

    @Test
    public void testKieModuleJar() {
        String str = "package org.drools.mvel.compiler.i18ntest;\nimport org.drools.mvel.compiler.I18nPerson;\n\nglobal java.util.List list;\nrule \"\u540d\u79f0 is \u5c71\u7530\u82b1\u5b50\"\n    when\n        p : I18nPerson( \u540d\u79f0 == \"\u5c71\u7530\u82b1\u5b50\" )\n    then\n        list.add( \"\u540d\u79f0\u306f\u5c71\u7530\u82b1\u5b50\u3067\u3059\" );\nend\n";
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId = ks.newReleaseId("org.kie", "118ntest", "1.0.0");
        KieModule kmodule = KieUtil.getKieModuleFromDrls((ReleaseId)releaseId, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieContainer kc = ks.newKieContainer(kmodule.getReleaseId());
        KieSession ksession = kc.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        I18nPerson i18nPerson = new I18nPerson();
        i18nPerson.set\u540d\u79f0("\u5c71\u7530\u82b1\u5b50");
        ksession.insert((Object)i18nPerson);
        ksession.fireAllRules();
        Assertions.assertThat((boolean)list.contains("\u540d\u79f0\u306f\u5c71\u7530\u82b1\u5b50\u3067\u3059")).isTrue();
        ksession.dispose();
    }

    @Test
    public void testMultibytePositonalQueryParam() {
        String drl = "package org.drools.mvel.compiler.i18ntest;\nimport org.drools.mvel.compiler.Person;\n\nquery testquery(int $a, Person $t)\n    $t := Person(age > $a)\nend\n\nrule \"hoge\"\n    when\n        testquery(30, $\u3042\u3042\u3042;)\n    then\n        System.out.println($\u3042\u3042\u3042.getName());\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"i18n-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        Person p1 = new Person("John", 25);
        Person p2 = new Person("Paul", 35);
        ksession.insert((Object)p1);
        ksession.insert((Object)p2);
        int fired = ksession.fireAllRules();
        Assertions.assertThat((int)fired).isEqualTo(1);
        ksession.dispose();
    }
}

