/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests.phreak;

import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.TupleSets;
import org.drools.core.reteoo.JoinNodeLeftTuple;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.LeftTupleSink;
import org.drools.core.reteoo.RightTuple;
import org.drools.core.reteoo.RightTupleImpl;
import org.drools.core.reteoo.Sink;
import org.drools.core.reteoo.Tuple;
import org.drools.mvel.integrationtests.phreak.Pair;
import org.drools.mvel.integrationtests.phreak.Scenario;

public class BaseLeftTuplesBuilder<T extends BaseLeftTuplesBuilder> {
    protected InternalWorkingMemory wm;
    protected LeftTupleSink sink;
    protected TupleSets<LeftTuple> leftTuples;
    protected Scenario scenario;
    private boolean testStagedInsert;
    private boolean testStagedDelete;
    private boolean testStagedUpdate;

    public BaseLeftTuplesBuilder(Scenario scenario, TupleSets<LeftTuple> leftTuples) {
        this.wm = scenario.getWorkingMemory();
        this.scenario = scenario;
        this.sink = scenario.getSinkNode();
        this.leftTuples = leftTuples;
    }

    public boolean isTestStagedInsert() {
        return this.testStagedInsert;
    }

    public boolean isTestStagedDelete() {
        return this.testStagedDelete;
    }

    public boolean isTestStagedUpdate() {
        return this.testStagedUpdate;
    }

    public T insert(Object ... objects) {
        this.testStagedInsert = true;
        if (objects == null) {
            objects = new Object[]{};
        }
        for (int i = 0; i < objects.length; ++i) {
            InternalFactHandle fh1;
            if (!(objects[i] instanceof Pair)) {
                Object o1 = objects[i];
                fh1 = this.wm.getFactHandle(o1);
                JoinNodeLeftTuple leftTuple = new JoinNodeLeftTuple(fh1, (Sink)this.sink, true);
                this.leftTuples.addInsert((Tuple)leftTuple);
                continue;
            }
            Pair p = (Pair)objects[i];
            fh1 = this.wm.getFactHandle(p.getO1());
            JoinNodeLeftTuple leftTuple1 = new JoinNodeLeftTuple(fh1, (Sink)this.sink, true);
            InternalFactHandle fh2 = this.wm.getFactHandle(p.getO2());
            LeftTuple leftTuple2 = this.sink.createLeftTuple((LeftTuple)leftTuple1, (RightTuple)new RightTupleImpl(fh2), (Sink)this.sink);
            this.leftTuples.addInsert((Tuple)leftTuple2);
        }
        return (T)this;
    }

    public T delete(Object ... objects) {
        this.testStagedDelete = true;
        if (objects == null) {
            objects = new Object[]{};
        }
        for (int i = 0; i < objects.length; ++i) {
            InternalFactHandle fh1;
            if (!(objects[i] instanceof Pair)) {
                Object o1 = objects[i];
                fh1 = this.wm.getFactHandle(o1);
                JoinNodeLeftTuple leftTuple = new JoinNodeLeftTuple(fh1, (Sink)this.sink, true);
                this.leftTuples.addDelete((Tuple)leftTuple);
                continue;
            }
            Pair p = (Pair)objects[i];
            fh1 = this.wm.getFactHandle(p.getO1());
            JoinNodeLeftTuple leftTuple1 = new JoinNodeLeftTuple(fh1, (Sink)this.sink, true);
            InternalFactHandle fh2 = this.wm.getFactHandle(p.getO2());
            LeftTuple leftTuple2 = this.sink.createLeftTuple((LeftTuple)leftTuple1, (RightTuple)new RightTupleImpl(fh2), (Sink)this.sink);
            this.leftTuples.addDelete((Tuple)leftTuple2);
        }
        return (T)this;
    }

    public T update(Object ... objects) {
        this.testStagedUpdate = true;
        if (objects == null) {
            objects = new Object[]{};
        }
        for (int i = 0; i < objects.length; ++i) {
            InternalFactHandle fh1;
            if (!(objects[i] instanceof Pair)) {
                Object o1 = objects[i];
                fh1 = this.wm.getFactHandle(o1);
                JoinNodeLeftTuple leftTuple = new JoinNodeLeftTuple(fh1, (Sink)this.sink, true);
                this.leftTuples.addUpdate((Tuple)leftTuple);
                continue;
            }
            Pair p = (Pair)objects[i];
            fh1 = this.wm.getFactHandle(p.getO1());
            JoinNodeLeftTuple leftTuple1 = new JoinNodeLeftTuple(fh1, (Sink)this.sink, true);
            InternalFactHandle fh2 = this.wm.getFactHandle(p.getO2());
            LeftTuple leftTuple2 = this.sink.createLeftTuple((LeftTuple)leftTuple1, (RightTuple)new RightTupleImpl(fh2), (Sink)this.sink);
            this.leftTuples.addUpdate((Tuple)leftTuple2);
        }
        return (T)this;
    }

    TupleSets<LeftTuple> get() {
        return this.leftTuples;
    }

    public Scenario run() {
        return this.scenario.run();
    }
}

