/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests.phreak;

import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.PhreakPropagationContext;
import org.drools.core.common.PropagationContext;
import org.drools.core.common.TupleSets;
import org.drools.core.reteoo.RightTuple;
import org.drools.core.reteoo.RightTupleImpl;
import org.drools.core.reteoo.RightTupleSink;
import org.drools.core.reteoo.SegmentMemory;
import org.drools.core.reteoo.Tuple;
import org.drools.mvel.integrationtests.phreak.Scenario;
import org.drools.mvel.integrationtests.phreak.StagedBuilder;

public class RightBuilder {
    private InternalWorkingMemory wm;
    private RightTupleSink sink;
    private TupleSets<RightTuple> rightTuples;
    private Scenario scenario;

    public RightBuilder(Scenario scenario) {
        this.wm = scenario.getWorkingMemory();
        this.scenario = scenario;
        this.sink = scenario.getBetaNode();
        this.rightTuples = scenario.getRightTuples();
    }

    public RightBuilder insert(Object ... objects) {
        for (Object object : objects) {
            InternalFactHandle fh = (InternalFactHandle)this.wm.insert(object);
            RightTupleImpl rightTuple = new RightTupleImpl(fh, this.sink);
            rightTuple.setPropagationContext((PropagationContext)new PhreakPropagationContext());
            this.rightTuples.addInsert((Tuple)rightTuple);
        }
        return this;
    }

    public RightBuilder update(Object ... objects) {
        for (Object object : objects) {
            InternalFactHandle fh = (InternalFactHandle)this.wm.insert(object);
            RightTuple rightTuple = fh.getFirstRightTuple();
            rightTuple.setPropagationContext((PropagationContext)new PhreakPropagationContext());
            this.rightTuples.addUpdate((Tuple)rightTuple);
        }
        return this;
    }

    public RightBuilder delete(Object ... objects) {
        for (Object object : objects) {
            InternalFactHandle fh = (InternalFactHandle)this.wm.insert(object);
            RightTuple rightTuple = fh.getFirstRightTuple();
            rightTuple.setPropagationContext((PropagationContext)new PhreakPropagationContext());
            this.rightTuples.addDelete((Tuple)rightTuple);
        }
        return this;
    }

    public StagedBuilder result() {
        StagedBuilder stagedBuilder = new StagedBuilder(this.scenario, null);
        this.scenario.setExpectedResultBuilder(stagedBuilder);
        return stagedBuilder;
    }

    public StagedBuilder preStaged(SegmentMemory sm) {
        StagedBuilder stagedBuilder = new StagedBuilder(this.scenario, sm);
        this.scenario.addPreStagedBuilder(stagedBuilder);
        return stagedBuilder;
    }

    public StagedBuilder postStaged(SegmentMemory sm) {
        StagedBuilder stagedBuilder = new StagedBuilder(this.scenario, sm);
        this.scenario.addPostStagedBuilder(stagedBuilder);
        return stagedBuilder;
    }

    public Scenario run() {
        return this.scenario.run();
    }
}

