/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests.session;

import java.util.Collection;
import org.assertj.core.api.Assertions;
import org.drools.core.base.RuleNameEndsWithAgendaFilter;
import org.drools.core.base.RuleNameEqualsAgendaFilter;
import org.drools.core.base.RuleNameMatchesAgendaFilter;
import org.drools.core.base.RuleNameStartsWithAgendaFilter;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.KieServices;
import org.kie.api.conf.Option;
import org.kie.api.event.rule.AfterMatchFiredEvent;
import org.kie.api.event.rule.AgendaEventListener;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.api.runtime.conf.DirectFiringOption;
import org.kie.api.runtime.rule.AgendaFilter;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;

@RunWith(value=Parameterized.class)
public class AgendaFilterTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public AgendaFilterTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    @Test
    public void testAgendaFilterRuleNameStartsWith() {
        this.testAgendaFilter((AgendaFilter)new RuleNameStartsWithAgendaFilter("B"), "Bbb");
    }

    @Test
    public void testAgendaFilterRuleNameEndsWith() {
        this.testAgendaFilter((AgendaFilter)new RuleNameEndsWithAgendaFilter("a"), "Aaa");
    }

    @Test
    public void testAgendaFilterRuleNameMatches() {
        this.testAgendaFilter((AgendaFilter)new RuleNameMatchesAgendaFilter(".*b."), "Bbb");
    }

    @Test
    public void testAgendaFilterRuleNameEquals() {
        this.testAgendaFilter((AgendaFilter)new RuleNameEqualsAgendaFilter("Aaa"), "Aaa");
    }

    private void testAgendaFilter(AgendaFilter agendaFilter, String expectedMatchingRuleName) {
        String str = "package org.drools.compiler\nrule Aaa when then end\nrule Bbb when then end\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"package org.drools.compiler\nrule Aaa when then end\nrule Bbb when then end\n"});
        KieSession ksession = kbase.newKieSession();
        AgendaEventListener ael = (AgendaEventListener)Mockito.mock(AgendaEventListener.class);
        ksession.addEventListener(ael);
        int rules = ksession.fireAllRules(agendaFilter);
        Assertions.assertThat((int)rules).isEqualTo(1);
        ArgumentCaptor arg = ArgumentCaptor.forClass(AfterMatchFiredEvent.class);
        ((AgendaEventListener)Mockito.verify((Object)ael)).afterMatchFired((AfterMatchFiredEvent)arg.capture());
        Assertions.assertThat((String)((AfterMatchFiredEvent)arg.getValue()).getMatch().getRule().getName()).isEqualTo(expectedMatchingRuleName);
    }

    @Test
    public void testDirectFiringIgnoresAgendaFilter() {
        String str = "rule R when\n  String() \nthen\n  throw new IllegalStateException();\nend";
        try {
            KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
            KieSessionConfiguration config = KieServices.get().newKieSessionConfiguration();
            config.setOption((Option)DirectFiringOption.YES);
            Environment environment = KieServices.get().newEnvironment();
            KieSession ksession = kbase.newKieSession(config, environment);
            ksession.insert((Object)"Lukas");
            Assertions.assertThat((int)ksession.fireAllRules(match -> false)).isEqualTo(0);
        }
        catch (Throwable ex) {
            Assertions.fail((String)"Should not have thrown.", (Throwable)ex);
        }
    }
}

