/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.integrationtests;

import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.drools.compiler.builder.impl.KnowledgeBuilderImpl;
import org.drools.io.ReaderResource;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.KieBaseConfiguration;
import org.kie.api.KieServices;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.internal.builder.KnowledgeBuilderFactory;

public class ErrorOnInsertLogicalTest {
    private static final String RULES_FILE = "package rules\nimport " + FieldObject.class.getCanonicalName() + "\n\nfunction String f0(FieldObject objectToTest) {\n    if (objectToTest.getValue().equals(\"TriggerError\")) {\n        throw new RuntimeException(\"Forced error triggered.\");\n    }\n    return \"There is no error: \" + objectToTest.getValue();\n}\n\nrule R1 when\n    o1: FieldObject(getKey() == \"o1\" && getValue() == \"ABC\")\n    o2: FieldObject(getKey() == \"o2\")\nthen\n    insertLogical(new FieldObject(\"o3\", f0(o2)));\nend;";

    @Test
    public void testErrorHandling() {
        KieBaseConfiguration config = KieServices.Factory.get().newKieBaseConfiguration();
        KnowledgeBuilderImpl kbuilder = (KnowledgeBuilderImpl)KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add((Resource)new ReaderResource((Reader)new StringReader(RULES_FILE)), ResourceType.DRL);
        KieBase kb = kbuilder.newKnowledgeBase(config);
        KieSession session = kb.newKieSession();
        FieldObject o1 = new FieldObject("o1", "ABC");
        FieldObject o2 = new FieldObject("o2", "1");
        FactHandle fh1 = session.insert((Object)o1);
        FactHandle fh2 = session.insert((Object)o2);
        session.fireAllRules();
        List createdObjects = session.getObjects().stream().map(o -> (FieldObject)o).filter(o -> o.getKey().equals("o3")).collect(Collectors.toList());
        Assertions.assertThat((int)createdObjects.size()).isEqualTo(1);
        Assertions.assertThat((String)((FieldObject)createdObjects.get(0)).getKey()).isEqualTo("o3");
        Assertions.assertThat((String)((FieldObject)createdObjects.get(0)).getValue()).isEqualTo("There is no error: 1");
        o2.setValue("TriggerError");
        session.update(fh1, (Object)o1);
        session.update(fh2, (Object)o2);
        try {
            session.fireAllRules();
            Assertions.fail((String)"this firing should throw an exception");
        }
        catch (RuntimeException e) {
            Assertions.assertThat((String)e.getCause().getMessage()).isEqualTo("Forced error triggered.");
        }
        createdObjects = session.getObjects().stream().map(o -> (FieldObject)o).filter(o -> o.getKey().equals("o3")).collect(Collectors.toList());
        Assertions.assertThat((int)createdObjects.size()).isEqualTo(1);
        Assertions.assertThat((String)((FieldObject)createdObjects.get(0)).getKey()).isEqualTo("o3");
        Assertions.assertThat((String)((FieldObject)createdObjects.get(0)).getValue()).isEqualTo("There is no error: 1");
        o2.setValue("2");
        session.update(fh1, (Object)o1);
        session.update(fh2, (Object)o2);
        session.fireAllRules();
        createdObjects = session.getObjects().stream().map(o -> (FieldObject)o).filter(o -> o.getKey().equals("o3")).collect(Collectors.toList());
        Assertions.assertThat((int)createdObjects.size()).isEqualTo(1);
        Assertions.assertThat((String)((FieldObject)createdObjects.get(0)).getKey()).isEqualTo("o3");
        Assertions.assertThat((String)((FieldObject)createdObjects.get(0)).getValue()).isEqualTo("There is no error: 2");
    }

    public static class FieldObject {
        private String key;
        private String value;

        public FieldObject(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }
}

