/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.integrationtests.drl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.drools.kiesession.rulebase.InternalKnowledgeBase;
import org.drools.testcoverage.common.model.Cheese;
import org.drools.testcoverage.common.model.Cheesery;
import org.drools.testcoverage.common.model.FirstClass;
import org.drools.testcoverage.common.model.Person;
import org.drools.testcoverage.common.model.SecondClass;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.KieUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.Message;
import org.kie.api.runtime.KieSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
public class ImportsTest {
    private static final Logger logger = LoggerFactory.getLogger(ImportsTest.class);
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public ImportsTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    @Test
    public void testImportFunctions() {
        this.testImportFunctionsBase(StaticMethods.class.getCanonicalName(), StaticMethods2.class.getCanonicalName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testImport() {
        String drl = "package org.drools.compiler.integrationtests.drl;\nimport " + Cheese.class.getCanonicalName() + ";\nimport java.lang.Math;\nrule \"Test Rule\"\n  dialect \"mvel\"\n  when\n  then\n    new Cheese(Cheese.STILTON);\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"imports-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession session = kbase.newKieSession();
        try {
            session.fireAllRules();
        }
        finally {
            session.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testImportColision() {
        String drl1 = "package org.drools.compiler.integrationtests.drl;\n\n//list any import classes here.\nimport " + FirstClass.class.getCanonicalName() + ";\nimport " + FirstClass.class.getCanonicalName() + ".AlternativeKey;\n\n//declare any global variables here\n\nrule \"First Class\"\n\n    when\n        FirstClass()\n        FirstClass.AlternativeKey()\n    then\n        System.out.println(\"First class!\");\n\nend";
        String drl2 = "package org.drools.compiler.integrationtests.drl;\n\n//list any import classes here.\nimport " + SecondClass.class.getCanonicalName() + ";\nimport " + SecondClass.class.getCanonicalName() + ".AlternativeKey;\n\n//declare any global variables here\n\nrule \"Second Class\"\n\n    when\n        SecondClass()\n        SecondClass.AlternativeKey()\n    then\n        System.out.println(\"Second class!\");\n\nend";
        InternalKnowledgeBase kbase = (InternalKnowledgeBase)KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"imports-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl1});
        Collection kpkgs = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"imports-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl2}).getKiePackages();
        kbase.addPackages(kpkgs);
        KieSession ksession = kbase.newKieSession();
        try {
            ksession.insert((Object)new FirstClass());
            ksession.insert((Object)new SecondClass());
            ksession.insert((Object)new FirstClass.AlternativeKey());
            ksession.insert((Object)new SecondClass.AlternativeKey());
            ksession.fireAllRules();
        }
        finally {
            ksession.dispose();
        }
    }

    @Test
    public void testImportConflict() {
        String drl = "package org.drools.compiler.integrationtests.drl;\n\nimport " + Person.class.getCanonicalName() + ";\n\nrule \"A rule\"\n    when\n        p:Person( )\n    then\n        // do something\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"imports-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        ksession.dispose();
    }

    @Test
    public void testMissingImport() {
        String drl = "package org.drools.compiler.integrationtests.drl;\nimport " + Person.class.getName() + ";\nglobal java.util.List list \nrule rule1 \nwhen \n    $i : Cheese() \n         MissingClass( fieldName == $i ) \nthen \n    list.add( $i ); \nend \n";
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromDrls((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (boolean)false, (String[])new String[]{drl});
        Assertions.assertThat((List)kieBuilder.getResults().getMessages()).isNotEmpty();
        Assertions.assertThat((List)kieBuilder.getResults().getMessages()).extracting(Message::getText).doesNotContain((Object[])new String[]{""});
    }

    @Test
    public void testMissingImports() {
        String drl = "package foo;\n\nrule \"Generates NPE\"\n  when\n    $count : Thing( size > 0 ) from collect( Gizmo( length == 1 ) )\n  then\n    System.out.println(\"boo\");\nend";
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromDrls((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (boolean)false, (String[])new String[]{"package foo;\n\nrule \"Generates NPE\"\n  when\n    $count : Thing( size > 0 ) from collect( Gizmo( length == 1 ) )\n  then\n    System.out.println(\"boo\");\nend"});
        Assertions.assertThat((List)kieBuilder.getResults().getMessages()).isNotEmpty();
        Assertions.assertThat((List)kieBuilder.getResults().getMessages()).extracting(Message::getText).doesNotContain((Object[])new String[]{""});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPackageImportWithMvelDialect() {
        String drl = "package org.drools.compiler.integrationtests.drl;\nimport " + Cheese.class.getCanonicalName() + "\nimport " + Person.class.getCanonicalName() + "\ndialect \"mvel\"\nrule R1 no-loop when\n   $p : Person( )   $c : Cheese( )then\n   modify($p) { setCheese($c) };\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"imports-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        try {
            Person p = new Person("Mario", 38);
            ksession.insert((Object)p);
            Cheese c = new Cheese("Gorgonzola");
            ksession.insert((Object)c);
            Assertions.assertThat((int)ksession.fireAllRules()).isEqualTo(1);
            Assertions.assertThat((Object)p.getCheese()).isSameAs((Object)c);
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testImportStaticClass() {
        String drl = "package org.drools.compiler.integrationtests.drl;\n\nimport " + Person.class.getCanonicalName() + ";\nimport " + Cheesery.class.getCanonicalName() + ";\nimport " + Cheesery.Maturity.class.getCanonicalName() + ";\nglobal java.util.List list\n\nrule \"status, int based enum\"\n    salience 10\n    when\n           p : Cheesery(status == Cheesery.SELLING_CHEESE, maturity == Maturity.OLD)\n    then\n        list.add( p );\n\nend   \n\nrule \"maturity, object based enum\"\n    when\n           p : Cheesery(status == Cheesery.MAKING_CHEESE, maturity == Maturity.YOUNG)\n    then\n        list.add( p );\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"imports-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession session = kbase.newKieSession();
        try {
            ArrayList list = new ArrayList();
            session.setGlobal("list", list);
            Cheesery cheesery1 = new Cheesery();
            cheesery1.setStatus(1);
            cheesery1.setMaturity(Cheesery.Maturity.OLD);
            session.insert((Object)cheesery1);
            Cheesery cheesery2 = new Cheesery();
            cheesery2.setStatus(0);
            cheesery2.setMaturity(Cheesery.Maturity.YOUNG);
            session.insert((Object)cheesery2);
            session.fireAllRules();
            Assertions.assertThat((int)list.size()).isEqualTo(2);
            Assertions.assertThat(list.get(0)).isEqualTo((Object)cheesery1);
            Assertions.assertThat(list.get(1)).isEqualTo((Object)cheesery2);
        }
        finally {
            session.dispose();
        }
    }

    @Test
    public void testImportInnerFunctions() {
        String drl = "package org.drools.compiler.integrationtests.drl;\nimport function " + StaticMethods.class.getCanonicalName() + ".*;\nimport function " + StaticMethods2.class.getCanonicalName() + ".getString3;\nimport " + Cheese.class.getCanonicalName() + ";\nglobal java.util.List list;\n\nfunction String getString4( String string ) {\n    return string;\n}\n\nrule \"test rule1\"\n    salience 30\n    when\n        Cheese()\n    then\n        list.add( getString1( \"rule1\" ) );\nend    \n\nrule \"test rule2\"\n    salience 20\n    when\n        Cheese( type == ( getString2(\"stilton\") ) );\n    then\n        list.add( getString3( \"rule\", new Integer( 2 ) ) );\nend    \n\nrule \"test rule3\"\n    salience 10\n    when\n        Cheese( $type : type);\n        eval( $type.equals( getString1( \"stilton\" ) ) );\n    then\n        list.add( getString2( \"rule3\" ) );\nend    \n\nrule \"test rule4\"\n    salience 0\n    when\n        Cheese();\n    then\n        list.add( getString4( \"rule4\" ) );\nend";
        this.testImportFunctionsBase(StaticMethods.class.getCanonicalName(), StaticMethods2.class.getCanonicalName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testImportFunctionsBase(String staticMethodImport1, String staticMethodImport2) {
        String drl = "package org.drools.compiler.integrationtests.drl;\nimport function " + staticMethodImport1 + ".*;\nimport function " + staticMethodImport2 + ".getString3;\nimport " + Cheese.class.getCanonicalName() + ";\nglobal java.util.List list;\n\nfunction String getString4( String string ) {\n    return string;\n}\n\nrule \"test rule1\"\n    salience 30\n    when\n        Cheese()\n    then\n        list.add( getString1( \"rule1\" ) );\nend    \n\nrule \"test rule2\"\n    salience 20\n    when\n        Cheese( type == ( getString2(\"stilton\") ) );\n    then\n        list.add( getString3( \"rule\", new Integer( 2 ) ) );\nend    \n\nrule \"test rule3\"\n    salience 10\n    when\n        Cheese( $type : type);\n        eval( $type.equals( getString1( \"stilton\" ) ) );\n    then\n        list.add( getString2( \"rule3\" ) );\nend    \n\nrule \"test rule4\"\n    salience 0\n    when\n        Cheese();\n    then\n        list.add( getString4( \"rule4\" ) );\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"imports-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession session = kbase.newKieSession();
        try {
            Cheese cheese = new Cheese("stilton", 15);
            session.insert((Object)cheese);
            List list = new ArrayList();
            session.setGlobal("list", list);
            int fired = session.fireAllRules();
            list = (List)session.getGlobal("list");
            Assertions.assertThat((int)fired).isEqualTo(4);
            Assertions.assertThat((int)list.size()).isEqualTo(4);
            Assertions.assertThat(list.get(0)).isEqualTo((Object)"rule1");
            Assertions.assertThat(list.get(1)).isEqualTo((Object)"rule2");
            Assertions.assertThat(list.get(2)).isEqualTo((Object)"rule3");
            Assertions.assertThat(list.get(3)).isEqualTo((Object)"rule4");
        }
        finally {
            session.dispose();
        }
    }

    @Test
    public void testWrongImportWithDeclaredType() {
        String drl = "package org.acme.order\n\nimport org.kie.order.Order\n\ndeclare ExpressDeliverer\n  term: int\nend\n\nrule R1 when\n    $order: Order ()\n    $deliverer: ExpressDeliverer ()\nthen\n    $order.setDiscount(0);\n    $deliverer.setTerm(5);\nend";
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromDrls((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (boolean)false, (String[])new String[]{"package org.acme.order\n\nimport org.kie.order.Order\n\ndeclare ExpressDeliverer\n  term: int\nend\n\nrule R1 when\n    $order: Order ()\n    $deliverer: ExpressDeliverer ()\nthen\n    $order.setDiscount(0);\n    $deliverer.setTerm(5);\nend"});
        Assertions.assertThat((List)kieBuilder.getResults().getMessages()).isNotEmpty();
        Assertions.assertThat((List)kieBuilder.getResults().getMessages()).extracting(Message::getText).doesNotContain((Object[])new String[]{""});
    }

    public static class StaticMethods2 {
        public static String getString3(String string, Integer integer) {
            return string + integer;
        }
    }

    public static class StaticMethods {
        public static String getString1(String string) {
            return string;
        }

        public static String getString2(String string) {
            return string;
        }
    }
}

