/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.compiler.builder.impl;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.drools.compiler.builder.impl.KnowledgeBuilderConfigurationImpl;
import org.drools.compiler.builder.impl.KnowledgeBuilderImpl;
import org.drools.compiler.compiler.Dialect;
import org.drools.compiler.compiler.DialectCompiletimeRegistry;
import org.drools.compiler.compiler.PackageRegistry;
import org.drools.core.base.ClassObjectType;
import org.drools.core.common.ActivationGroupNode;
import org.drools.core.common.ActivationNode;
import org.drools.core.common.InternalAgendaGroup;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalRuleFlowGroup;
import org.drools.core.common.PropagationContext;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.definitions.InternalKnowledgePackage;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.impl.RuleBase;
import org.drools.core.phreak.RuleAgendaItem;
import org.drools.core.reteoo.JoinNodeLeftTuple;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.LeftTupleSink;
import org.drools.core.reteoo.LeftTupleSource;
import org.drools.core.reteoo.RuleTerminalNode;
import org.drools.core.reteoo.TerminalNode;
import org.drools.core.reteoo.builder.BuildContext;
import org.drools.core.rule.Behavior;
import org.drools.core.rule.Declaration;
import org.drools.core.rule.EvalCondition;
import org.drools.core.rule.GroupElement;
import org.drools.core.rule.JavaDialectRuntimeData;
import org.drools.core.rule.Pattern;
import org.drools.core.rule.SlidingTimeWindow;
import org.drools.core.rule.TypeDeclaration;
import org.drools.core.rule.accessor.CompiledInvoker;
import org.drools.core.rule.consequence.Consequence;
import org.drools.core.rule.consequence.InternalMatch;
import org.drools.core.rule.consequence.KnowledgeHelper;
import org.drools.core.rule.constraint.Constraint;
import org.drools.drl.ast.descr.AndDescr;
import org.drools.drl.ast.descr.BaseDescr;
import org.drools.drl.ast.descr.BehaviorDescr;
import org.drools.drl.ast.descr.BindingDescr;
import org.drools.drl.ast.descr.ConditionalElementDescr;
import org.drools.drl.ast.descr.EvalDescr;
import org.drools.drl.ast.descr.ExistsDescr;
import org.drools.drl.ast.descr.ExprConstraintDescr;
import org.drools.drl.ast.descr.FieldConstraintDescr;
import org.drools.drl.ast.descr.GlobalDescr;
import org.drools.drl.ast.descr.LiteralRestrictionDescr;
import org.drools.drl.ast.descr.NotDescr;
import org.drools.drl.ast.descr.OrDescr;
import org.drools.drl.ast.descr.PackageDescr;
import org.drools.drl.ast.descr.PatternDescr;
import org.drools.drl.ast.descr.RestrictionDescr;
import org.drools.drl.ast.descr.RuleDescr;
import org.drools.drl.ast.descr.TypeDeclarationDescr;
import org.drools.drl.ast.descr.TypeFieldDescr;
import org.drools.drl.parser.DroolsParserException;
import org.drools.drl.parser.ParserError;
import org.drools.ecj.EclipseJavaCompiler;
import org.drools.kiesession.consequence.DefaultKnowledgeHelper;
import org.drools.kiesession.rulebase.InternalKnowledgeBase;
import org.drools.kiesession.rulebase.KnowledgeBaseFactory;
import org.drools.kiesession.session.StatefulKnowledgeSessionImpl;
import org.drools.mvel.MockBetaNode;
import org.drools.mvel.compiler.Cheese;
import org.drools.mvel.compiler.Primitives;
import org.drools.mvel.compiler.StockTick;
import org.drools.mvel.integrationtests.SerializationHelper;
import org.drools.mvel.java.JavaForMvelDialectConfiguration;
import org.junit.After;
import org.junit.Ignore;
import org.junit.Test;
import org.kie.api.definition.type.FactField;
import org.kie.api.definition.type.FactType;
import org.kie.api.definition.type.Role;
import org.kie.api.definition.type.TypeSafe;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.internal.builder.KnowledgeBuilderConfiguration;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.memorycompiler.JavaCompiler;
import org.kie.memorycompiler.JavaConfiguration;
import org.kie.memorycompiler.jdknative.NativeJavaCompiler;

public class KnowledgeBuilderTest {
    @After
    public void tearDown() {
        System.getProperties().remove("drools.warning.filters");
        System.getProperties().remove("drools.kbuilder.severity.duplicateFunction");
        System.getProperties().remove("drools.kbuilder.severity.duplicateRule");
    }

    @Test
    public void testErrors() throws Exception {
        KnowledgeBuilderImpl builder = new KnowledgeBuilderImpl();
        PackageDescr packageDescr = new PackageDescr("p1");
        RuleDescr ruleDescr = new RuleDescr("rule-1");
        packageDescr.addRule(ruleDescr);
        AndDescr lhs = new AndDescr();
        ruleDescr.setLhs(lhs);
        PatternDescr pattern = new PatternDescr(Cheese.class.getName(), "stilton");
        lhs.addDescr((BaseDescr)pattern);
        BindingDescr fieldBindingDescr = new BindingDescr("x", "price");
        pattern.addConstraint((BaseDescr)fieldBindingDescr);
        fieldBindingDescr = new BindingDescr("y", "price");
        pattern.addConstraint((BaseDescr)fieldBindingDescr);
        packageDescr.addGlobal(new GlobalDescr("map", "java.util.Map"));
        pattern.addConstraint((BaseDescr)new ExprConstraintDescr("price == x"));
        ruleDescr.setConsequence((Object)"update(m);");
        builder.addPackage(packageDescr);
        Assertions.assertThat((builder.getErrors().getErrors().length > 0 ? 1 : 0) != 0).isTrue();
    }

    @Test
    public void testErrorsInParser() throws Exception {
        KnowledgeBuilderImpl builder = new KnowledgeBuilderImpl();
        builder.addPackageFromDrl((Reader)new InputStreamReader(this.getClass().getResourceAsStream("bad_rule.drl")));
        Assertions.assertThat((boolean)builder.hasErrors()).isTrue();
    }

    @Test
    public void testReload() throws Exception {
        KnowledgeBuilderImpl builder = new KnowledgeBuilderImpl();
        PackageDescr packageDescr = new PackageDescr("p1");
        RuleDescr ruleDescr = new RuleDescr("rule-1");
        packageDescr.addRule(ruleDescr);
        AndDescr lhs = new AndDescr();
        ruleDescr.setLhs(lhs);
        packageDescr.addGlobal(new GlobalDescr("map", "java.util.Map"));
        ruleDescr.setConsequence((Object)"map.put(\"value\", new Integer(1) );");
        builder.addPackage(packageDescr);
        InternalKnowledgePackage pkg = builder.getPackage(packageDescr.getName());
        RuleImpl rule = pkg.getRule("rule-1");
        Assertions.assertThat((Object[])builder.getErrors().getErrors()).hasSize(0);
        InternalKnowledgeBase kBase = KnowledgeBaseFactory.newKnowledgeBase();
        kBase.addGlobal("map", Map.class);
        KieSession workingMemory = kBase.newKieSession();
        HashMap map = new HashMap();
        workingMemory.setGlobal("map", map);
        MockTuple tuple = new MockTuple(new HashMap());
        tuple.setLeftTupleSink((LeftTupleSink)new RuleTerminalNode(1, (LeftTupleSource)new MockBetaNode(), rule, rule.getLhs(), 0, new BuildContext((RuleBase)kBase, Collections.emptyList())));
        MockInternalMatch internalMatch = new MockInternalMatch(rule, 0, rule.getLhs(), (LeftTuple)tuple);
        DefaultKnowledgeHelper knowledgeHelper = new DefaultKnowledgeHelper((ReteEvaluator)((StatefulKnowledgeSessionImpl)workingMemory));
        knowledgeHelper.setActivation((InternalMatch)internalMatch);
        rule.getConsequence().evaluate((KnowledgeHelper)knowledgeHelper, (ReteEvaluator)((StatefulKnowledgeSessionImpl)workingMemory));
        Assertions.assertThat(map.get("value")).isEqualTo((Object)1);
        ruleDescr.setConsequence((Object)"map.put(\"value\", new Integer(2) );");
        pkg.removeRule(rule);
        Assertions.assertThat((int)((JavaDialectRuntimeData)pkg.getDialectRuntimeRegistry().getDialectData("java")).getStore().size()).isEqualTo(0);
        builder.addPackage(packageDescr);
        pkg = builder.getPackage(packageDescr.getName());
        rule = pkg.getRule("rule-1");
        knowledgeHelper = new DefaultKnowledgeHelper((ReteEvaluator)((StatefulKnowledgeSessionImpl)workingMemory));
        knowledgeHelper.setActivation((InternalMatch)internalMatch);
        rule.getConsequence().evaluate((KnowledgeHelper)knowledgeHelper, (ReteEvaluator)((StatefulKnowledgeSessionImpl)workingMemory));
        Assertions.assertThat(map.get("value")).isEqualTo((Object)2);
    }

    @Test
    public void testSerializable() throws Exception {
        KnowledgeBuilderImpl builder = new KnowledgeBuilderImpl();
        PackageDescr packageDescr = new PackageDescr("p1");
        RuleDescr ruleDescr = new RuleDescr("rule-1");
        packageDescr.addRule(ruleDescr);
        AndDescr lhs = new AndDescr();
        ruleDescr.setLhs(lhs);
        packageDescr.addGlobal(new GlobalDescr("map", "java.util.Map"));
        ruleDescr.setConsequence((Object)"map.put(\"value\", new Integer(1) );");
        PackageDescr back = SerializationHelper.serializeObject(packageDescr);
        Assertions.assertThat((Object)back).isNotNull();
        Assertions.assertThat((String)back.getName()).isEqualTo("p1");
        builder.addPackage(packageDescr);
        InternalKnowledgePackage pkg = builder.getPackage(packageDescr.getName());
        RuleImpl rule = pkg.getRule("rule-1");
        Assertions.assertThat((Object[])builder.getErrors().getErrors()).hasSize(0);
        InternalKnowledgePackage newPkg = SerializationHelper.serializeObject(pkg);
        RuleImpl newRule = newPkg.getRule("rule-1");
        InternalKnowledgeBase kBase = KnowledgeBaseFactory.newKnowledgeBase();
        newPkg.getDialectRuntimeRegistry().onAdd(kBase.getRootClassLoader());
        newPkg.getDialectRuntimeRegistry().onBeforeExecute();
        kBase.getGlobals().put("map", Map.class);
        KieSession workingMemory = kBase.newKieSession();
        HashMap map = new HashMap();
        workingMemory.setGlobal("map", map);
        MockTuple tuple = new MockTuple(new HashMap());
        tuple.setLeftTupleSink((LeftTupleSink)new RuleTerminalNode(1, (LeftTupleSource)new MockBetaNode(), newRule, newRule.getLhs(), 0, new BuildContext((RuleBase)kBase, Collections.emptyList())));
        MockInternalMatch internalMatch = new MockInternalMatch(newRule, 0, newRule.getLhs(), (LeftTuple)tuple);
        DefaultKnowledgeHelper knowledgeHelper = new DefaultKnowledgeHelper((ReteEvaluator)((StatefulKnowledgeSessionImpl)workingMemory));
        knowledgeHelper.setActivation((InternalMatch)internalMatch);
        newRule.getConsequence().evaluate((KnowledgeHelper)knowledgeHelper, (ReteEvaluator)((StatefulKnowledgeSessionImpl)workingMemory));
        Assertions.assertThat(map.get("value")).isEqualTo((Object)1);
    }

    @Test
    @Ignore
    public void testNoPackageName() throws Exception {
        KnowledgeBuilderImpl builder = new KnowledgeBuilderImpl();
        try {
            builder.addPackage(new PackageDescr(null));
            Assertions.fail((String)"should have errored here.");
        }
        catch (RuntimeException e) {
            Assertions.assertThat((String)e.getMessage()).isNotNull();
        }
        try {
            builder.addPackage(new PackageDescr(""));
            Assertions.fail((String)"should have errored here.");
        }
        catch (RuntimeException e) {
            Assertions.assertThat((String)e.getMessage()).isNotNull();
        }
        builder.addPackageFromDrl((Reader)new StringReader("package foo"));
        builder.addPackageFromDrl((Reader)new StringReader("rule x then end"));
    }

    @Test
    public void testErrorReset() throws Exception {
        KnowledgeBuilderImpl builder = new KnowledgeBuilderImpl();
        builder.addPackageFromDrl((Reader)new StringReader("package foo \n rule ORB"));
        Assertions.assertThat((boolean)builder.hasErrors()).isTrue();
        builder.resetErrors();
        Assertions.assertThat((boolean)builder.hasErrors()).isFalse();
        builder.addPackageFromDrl((Reader)new StringReader("package foo \n rule ORB"));
        Assertions.assertThat((boolean)builder.hasErrors()).isTrue();
    }

    @Test
    public void testLiteral() throws Exception {
        KnowledgeBuilderImpl builder = new KnowledgeBuilderImpl();
        PackageDescr packageDescr = new PackageDescr("p1");
        RuleDescr ruleDescr = new RuleDescr("rule-1");
        packageDescr.addRule(ruleDescr);
        AndDescr lhs = new AndDescr();
        ruleDescr.setLhs(lhs);
        PatternDescr pattern = new PatternDescr(Cheese.class.getName(), "stilton");
        lhs.addDescr((BaseDescr)pattern);
        pattern.addConstraint((BaseDescr)new ExprConstraintDescr("type == 'stilton'"));
        ruleDescr.setConsequence((Object)"update(stilton);");
        builder.addPackage(packageDescr);
        Assertions.assertThat((Object[])builder.getErrors().getErrors()).hasSize(0);
    }

    @Test
    public void testReturnValue() throws Exception {
        KnowledgeBuilderImpl builder = new KnowledgeBuilderImpl();
        PackageDescr packageDescr = new PackageDescr("p1");
        RuleDescr ruleDescr = new RuleDescr("rule-1");
        packageDescr.addRule(ruleDescr);
        AndDescr lhs = new AndDescr();
        ruleDescr.setLhs(lhs);
        PatternDescr pattern = new PatternDescr(Cheese.class.getName(), "stilton");
        lhs.addDescr((BaseDescr)pattern);
        BindingDescr fieldBindingDescr = new BindingDescr("x", "price");
        pattern.addConstraint((BaseDescr)fieldBindingDescr);
        fieldBindingDescr = new BindingDescr("y", "price");
        pattern.addConstraint((BaseDescr)fieldBindingDescr);
        packageDescr.addGlobal(new GlobalDescr("map", "java.util.Map"));
        pattern.addConstraint((BaseDescr)new ExprConstraintDescr("price == (( (Integer) map.get( new Integer( x )) ).intValue() * y)"));
        ruleDescr.setConsequence((Object)"update(stilton);");
        builder.addPackage(packageDescr);
        ((AbstractIntegerAssert)Assertions.assertThat((int)builder.getErrors().getErrors().length).as("Should not have any errors", new Object[0])).isEqualTo(0);
    }

    @Test
    public void testReturnValueMethodCompare() {
        KnowledgeBuilderImpl builder1 = new KnowledgeBuilderImpl();
        PackageDescr packageDescr1 = new PackageDescr("package1");
        this.createReturnValueRule(packageDescr1, " x + y ");
        builder1.addPackage(packageDescr1);
        if (builder1.hasErrors()) {
            Assertions.fail((String)builder1.getErrors().toString());
        }
        Pattern pattern1 = (Pattern)((RuleImpl)builder1.getPackage("package1").getRules().iterator().next()).getLhs().getChildren().get(0);
        Constraint returnValue1 = (Constraint)pattern1.getConstraints().get(0);
        KnowledgeBuilderImpl builder2 = new KnowledgeBuilderImpl();
        PackageDescr packageDescr2 = new PackageDescr("package2");
        this.createReturnValueRule(packageDescr2, " x + y ");
        builder2.addPackage(packageDescr2);
        Pattern pattern2 = (Pattern)((RuleImpl)builder2.getPackage("package2").getRules().iterator().next()).getLhs().getChildren().get(0);
        Constraint returnValue2 = (Constraint)pattern2.getConstraints().get(0);
        KnowledgeBuilderImpl builder3 = new KnowledgeBuilderImpl();
        PackageDescr packageDescr3 = new PackageDescr("package3");
        this.createReturnValueRule(packageDescr3, " x - y ");
        builder3.addPackage(packageDescr3);
        Pattern pattern3 = (Pattern)((RuleImpl)builder3.getPackage("package3").getRules().iterator().next()).getLhs().getChildren().get(0);
        Constraint returnValue3 = (Constraint)pattern3.getConstraints().get(0);
        Assertions.assertThat((Object)returnValue2).isEqualTo((Object)returnValue1);
        Assertions.assertThat((boolean)returnValue1.equals(returnValue3)).isFalse();
        Assertions.assertThat((boolean)returnValue2.equals(returnValue3)).isFalse();
    }

    @Test
    public void testPredicate() throws Exception {
        KnowledgeBuilderImpl builder = new KnowledgeBuilderImpl();
        PackageDescr packageDescr = new PackageDescr("p1");
        RuleDescr ruleDescr = new RuleDescr("rule-1");
        packageDescr.addRule(ruleDescr);
        AndDescr lhs = new AndDescr();
        ruleDescr.setLhs(lhs);
        PatternDescr pattern = new PatternDescr(Cheese.class.getName(), "stilton");
        lhs.addDescr((BaseDescr)pattern);
        BindingDescr fieldBindingDescr = new BindingDescr("x", "price");
        pattern.addConstraint((BaseDescr)fieldBindingDescr);
        BindingDescr fieldBindingDescr2 = new BindingDescr("y", "price");
        pattern.addConstraint((BaseDescr)fieldBindingDescr2);
        packageDescr.addGlobal(new GlobalDescr("map", "java.util.Map"));
        ExprConstraintDescr predicate = new ExprConstraintDescr("eval(( ( Integer )map.get( new Integer(x) )).intValue() == y)");
        pattern.addConstraint((BaseDescr)predicate);
        ruleDescr.setConsequence((Object)"update(stilton);");
        builder.addPackage(packageDescr);
        Assertions.assertThat((Object[])builder.getErrors().getErrors()).hasSize(0);
    }

    @Test
    public void testPredicateMethodCompare() {
        KnowledgeBuilderImpl builder1 = new KnowledgeBuilderImpl();
        PackageDescr packageDescr1 = new PackageDescr("package1");
        this.createPredicateRule(packageDescr1, "eval(x==y)");
        builder1.addPackage(packageDescr1);
        if (builder1.hasErrors()) {
            Assertions.fail((String)builder1.getErrors().toString());
        }
        Pattern pattern1 = (Pattern)((RuleImpl)builder1.getPackage("package1").getRules().iterator().next()).getLhs().getChildren().get(0);
        Constraint predicate1 = (Constraint)pattern1.getConstraints().get(0);
        KnowledgeBuilderImpl builder2 = new KnowledgeBuilderImpl();
        PackageDescr packageDescr2 = new PackageDescr("package2");
        this.createPredicateRule(packageDescr2, "eval(x==y)");
        builder2.addPackage(packageDescr2);
        if (builder2.hasErrors()) {
            Assertions.fail((String)builder2.getErrors().toString());
        }
        Pattern pattern2 = (Pattern)((RuleImpl)builder2.getPackage("package2").getRules().iterator().next()).getLhs().getChildren().get(0);
        Constraint predicate2 = (Constraint)pattern2.getConstraints().get(0);
        KnowledgeBuilderImpl builder3 = new KnowledgeBuilderImpl();
        if (builder3.hasErrors()) {
            Assertions.fail((String)builder3.getErrors().toString());
        }
        PackageDescr packageDescr3 = new PackageDescr("package3");
        this.createPredicateRule(packageDescr3, "eval(x!=y)");
        builder3.addPackage(packageDescr3);
        Pattern pattern3 = (Pattern)((RuleImpl)builder3.getPackage("package3").getRules().iterator().next()).getLhs().getChildren().get(0);
        Constraint predicate3 = (Constraint)pattern3.getConstraints().get(0);
        Assertions.assertThat((Object)predicate2).isEqualTo((Object)predicate1);
        Assertions.assertThat((boolean)predicate1.equals(predicate3)).isFalse();
        Assertions.assertThat((boolean)predicate2.equals(predicate3)).isFalse();
    }

    @Test
    public void testEval() throws Exception {
        KnowledgeBuilderImpl builder = new KnowledgeBuilderImpl();
        PackageDescr packageDescr = new PackageDescr("p1");
        RuleDescr ruleDescr = new RuleDescr("rule-1");
        packageDescr.addRule(ruleDescr);
        AndDescr lhs = new AndDescr();
        ruleDescr.setLhs(lhs);
        PatternDescr pattern = new PatternDescr(Cheese.class.getName(), "stilton");
        lhs.addDescr((BaseDescr)pattern);
        BindingDescr fieldBindingDescr = new BindingDescr("x", "price");
        pattern.addConstraint((BaseDescr)fieldBindingDescr);
        fieldBindingDescr = new BindingDescr("y", "price");
        pattern.addConstraint((BaseDescr)fieldBindingDescr);
        packageDescr.addGlobal(new GlobalDescr("map", "java.util.Map"));
        EvalDescr evalDescr = new EvalDescr((Object)"( ( Integer )map.get( new Integer(x) ) ).intValue() == y");
        lhs.addDescr((BaseDescr)evalDescr);
        ruleDescr.setConsequence((Object)"update(stilton);");
        builder.addPackage(packageDescr);
        Assertions.assertThat((Object[])builder.getErrors().getErrors()).hasSize(0);
        InternalKnowledgePackage pkg = builder.getPackage(packageDescr.getName());
        RuleImpl rule = pkg.getRule("rule-1");
        EvalCondition eval = (EvalCondition)rule.getLhs().getChildren().get(1);
        CompiledInvoker invoker = (CompiledInvoker)eval.getEvalExpression();
        String s = invoker.getMethodBytecode();
    }

    @Test
    public void testEvalMethodCompare() {
        KnowledgeBuilderImpl builder1 = new KnowledgeBuilderImpl();
        PackageDescr packageDescr1 = new PackageDescr("package1");
        this.createEvalRule(packageDescr1, "1==1");
        builder1.addPackage(packageDescr1);
        EvalCondition eval1 = (EvalCondition)((RuleImpl)builder1.getPackage("package1").getRules().iterator().next()).getLhs().getChildren().get(0);
        KnowledgeBuilderImpl builder2 = new KnowledgeBuilderImpl();
        PackageDescr packageDescr2 = new PackageDescr("package2");
        this.createEvalRule(packageDescr2, "1==1");
        builder2.addPackage(packageDescr2);
        EvalCondition eval2 = (EvalCondition)((RuleImpl)builder2.getPackage("package2").getRules().iterator().next()).getLhs().getChildren().get(0);
        KnowledgeBuilderImpl builder3 = new KnowledgeBuilderImpl();
        PackageDescr packageDescr3 = new PackageDescr("package3");
        this.createEvalRule(packageDescr3, "1==3");
        builder3.addPackage(packageDescr3);
        EvalCondition eval3 = (EvalCondition)((RuleImpl)builder3.getPackage("package3").getRules().iterator().next()).getLhs().getChildren().get(0);
        Assertions.assertThat((Object)eval2).isEqualTo((Object)eval1);
        Assertions.assertThat((boolean)eval1.equals((Object)eval3)).isFalse();
        Assertions.assertThat((boolean)eval2.equals((Object)eval3)).isFalse();
    }

    @Test
    public void testOr() throws Exception {
        KnowledgeBuilderImpl builder = new KnowledgeBuilderImpl();
        RuleImpl rule = this.createRule((ConditionalElementDescr)new OrDescr(), builder, "update(stilton);");
        Assertions.assertThat((Object[])builder.getErrors().getErrors()).hasSize(0);
        GroupElement lhs = rule.getLhs();
        Assertions.assertThat((List)lhs.getChildren()).hasSize(1);
        GroupElement or = (GroupElement)lhs.getChildren().get(0);
        Assertions.assertThat((List)or.getChildren()).hasSize(1);
        Pattern pattern = (Pattern)or.getChildren().get(0);
    }

    @Test
    public void testAnd() throws Exception {
        KnowledgeBuilderImpl builder = new KnowledgeBuilderImpl();
        RuleImpl rule = this.createRule((ConditionalElementDescr)new AndDescr(), builder, "update(stilton);");
        Assertions.assertThat((Object[])builder.getErrors().getErrors()).hasSize(0);
        GroupElement lhs = rule.getLhs();
        Assertions.assertThat((List)lhs.getChildren()).hasSize(1);
        GroupElement and = (GroupElement)lhs.getChildren().get(0);
        Assertions.assertThat((List)and.getChildren()).hasSize(1);
        Pattern pattern = (Pattern)and.getChildren().get(0);
    }

    @Test
    public void testNot() throws Exception {
        KnowledgeBuilderImpl builder = new KnowledgeBuilderImpl();
        this.createRule((ConditionalElementDescr)new NotDescr(), builder, "update(stilton);");
        Assertions.assertThat((boolean)builder.hasErrors()).isTrue();
        builder = new KnowledgeBuilderImpl();
        RuleImpl rule = this.createRule((ConditionalElementDescr)new NotDescr(), builder, "");
        Assertions.assertThat((int)builder.getErrors().getErrors().length).isEqualTo(0);
        GroupElement lhs = rule.getLhs();
        Assertions.assertThat((List)lhs.getChildren()).hasSize(1);
        GroupElement not = (GroupElement)lhs.getChildren().get(0);
        Assertions.assertThat((List)not.getChildren()).hasSize(1);
        Pattern pattern = (Pattern)not.getChildren().get(0);
    }

    @Test
    public void testExists() throws Exception {
        KnowledgeBuilderImpl builder = new KnowledgeBuilderImpl();
        this.createRule((ConditionalElementDescr)new ExistsDescr(), builder, "update(stilton);");
        Assertions.assertThat((boolean)builder.hasErrors()).isTrue();
        builder = new KnowledgeBuilderImpl();
        RuleImpl rule = this.createRule((ConditionalElementDescr)new ExistsDescr(), builder, "");
        Assertions.assertThat((int)builder.getErrors().getErrors().length).isEqualTo(0);
        GroupElement lhs = rule.getLhs();
        Assertions.assertThat((List)lhs.getChildren()).hasSize(1);
        GroupElement exists = (GroupElement)lhs.getChildren().get(0);
        Assertions.assertThat((List)exists.getChildren()).hasSize(1);
        Pattern pattern = (Pattern)exists.getChildren().get(0);
    }

    @Test
    public void testNumbers() throws Exception {
        this.createLiteralRule((BaseDescr)new ExprConstraintDescr("booleanPrimitive == true "));
        this.createLiteralRule((BaseDescr)new ExprConstraintDescr("booleanPrimitive == false "));
        this.createLiteralRule((BaseDescr)new ExprConstraintDescr("charPrimitive == 'a' "));
        this.createLiteralRule((BaseDescr)new ExprConstraintDescr("charPrimitive == \"a\" "));
        this.createLiteralRule((BaseDescr)new ExprConstraintDescr("bytePrimitive == 1 "));
        this.createLiteralRule((BaseDescr)new ExprConstraintDescr("bytePrimitive == 0 "));
        this.createLiteralRule((BaseDescr)new ExprConstraintDescr("bytePrimitive == -1 "));
        this.createLiteralRule((BaseDescr)new ExprConstraintDescr("shortPrimitive == 1 "));
        this.createLiteralRule((BaseDescr)new ExprConstraintDescr("shortPrimitive == 0 "));
        this.createLiteralRule((BaseDescr)new ExprConstraintDescr("shortPrimitive == -1 "));
        this.createLiteralRule((BaseDescr)new ExprConstraintDescr("intPrimitive == 1"));
        this.createLiteralRule((BaseDescr)new ExprConstraintDescr("intPrimitive == 0"));
        this.createLiteralRule((BaseDescr)new ExprConstraintDescr("intPrimitive == -1"));
        this.createLiteralRule((BaseDescr)new ExprConstraintDescr("longPrimitive == 1"));
        this.createLiteralRule((BaseDescr)new ExprConstraintDescr("longPrimitive == 0"));
        this.createLiteralRule((BaseDescr)new ExprConstraintDescr("longPrimitive == -1"));
        this.createLiteralRule((BaseDescr)new ExprConstraintDescr("floatPrimitive == 1.1"));
        this.createLiteralRule((BaseDescr)new ExprConstraintDescr("floatPrimitive == 0"));
        this.createLiteralRule((BaseDescr)new ExprConstraintDescr("floatPrimitive == -1.1"));
        this.createLiteralRule((BaseDescr)new ExprConstraintDescr("doublePrimitive == 1.1"));
        this.createLiteralRule((BaseDescr)new ExprConstraintDescr("doublePrimitive == 0"));
        this.createLiteralRule((BaseDescr)new ExprConstraintDescr("doublePrimitive == -1.1"));
    }

    @Test
    public void testNull() {
        KnowledgeBuilderImpl builder = new KnowledgeBuilderImpl();
        PackageDescr packageDescr = new PackageDescr("p1");
        RuleDescr ruleDescr = new RuleDescr("rule-1");
        packageDescr.addRule(ruleDescr);
        AndDescr lhs = new AndDescr();
        ruleDescr.setLhs(lhs);
        PatternDescr patternDescr = new PatternDescr(Cheese.class.getName(), "stilton");
        FieldConstraintDescr literalDescr = new FieldConstraintDescr("type");
        literalDescr.addRestriction((RestrictionDescr)new LiteralRestrictionDescr("==", null));
        patternDescr.addConstraint((BaseDescr)literalDescr);
        ruleDescr.setConsequence((Object)"");
        builder.addPackage(packageDescr);
        InternalKnowledgePackage pkg = builder.getPackage(packageDescr.getName());
        RuleImpl rule = pkg.getRule("rule-1");
        Assertions.assertThat((Object[])builder.getErrors().getErrors()).hasSize(0);
    }

    @Test
    public void testWarnings() {
        System.setProperty("drools.kbuilder.severity.duplicateRule", "WARNING");
        KnowledgeBuilderImpl builder = new KnowledgeBuilderImpl();
        PackageDescr packageDescr1 = this.createBasicPackageWithOneRule(11, 1);
        PackageDescr packageDescr2 = this.createBasicPackageWithOneRule(22, 2);
        builder.addPackage(packageDescr1);
        builder.addPackage(packageDescr2);
        Assertions.assertThat((boolean)builder.hasErrors()).isFalse();
        Assertions.assertThat((boolean)builder.hasWarnings()).isTrue();
    }

    @Test
    public void testWarningsReportAsErrors() {
        System.setProperty("drools.kbuilder.severity.duplicateRule", "ERROR");
        KnowledgeBuilderConfigurationImpl cfg = (KnowledgeBuilderConfigurationImpl)KnowledgeBuilderFactory.newKnowledgeBuilderConfiguration().as(KnowledgeBuilderConfigurationImpl.KEY);
        KnowledgeBuilderImpl builder = new KnowledgeBuilderImpl((KnowledgeBuilderConfiguration)cfg);
        PackageDescr packageDescr1 = this.createBasicPackageWithOneRule(11, 1);
        PackageDescr packageDescr2 = this.createBasicPackageWithOneRule(22, 2);
        builder.addPackage(packageDescr1);
        builder.addPackage(packageDescr2);
        Assertions.assertThat((boolean)builder.hasErrors()).isTrue();
        Assertions.assertThat((boolean)builder.hasWarnings()).isFalse();
    }

    @Test
    public void testResetWarnings() {
        System.setProperty("drools.kbuilder.severity.duplicateRule", "WARNING");
        KnowledgeBuilderImpl builder = new KnowledgeBuilderImpl();
        PackageDescr packageDescr1 = this.createBasicPackageWithOneRule(11, 1);
        PackageDescr packageDescr2 = this.createBasicPackageWithOneRule(22, 2);
        builder.addPackage(packageDescr1);
        builder.addPackage(packageDescr2);
        Assertions.assertThat((boolean)builder.hasWarnings()).isTrue();
        builder.resetWarnings();
        Assertions.assertThat((boolean)builder.hasWarnings()).isFalse();
        builder.addPackage(packageDescr1);
        Assertions.assertThat((boolean)builder.hasWarnings()).isTrue();
    }

    @Test
    public void testResetProblems() throws DroolsParserException, IOException {
        System.setProperty("drools.kbuilder.severity.duplicateRule", "WARNING");
        System.setProperty("drools.kbuilder.severity.duplicateFunction", "ERROR");
        KnowledgeBuilderImpl builder = new KnowledgeBuilderImpl();
        PackageDescr packageDescr1 = this.createBasicPackageWithOneRule(11, 1);
        PackageDescr packageDescr2 = this.createBasicPackageWithOneRule(22, 2);
        builder.addPackage(packageDescr1);
        builder.addPackage(packageDescr2);
        builder.addPackageFromDrl((Reader)new StringReader("package foo \n rule ORB"));
        builder.addPackageFromDrl((Reader)new StringReader("package org.drools\nfunction boolean testIt() {\n  return true;\n}\n"));
        builder.addPackageFromDrl((Reader)new StringReader("package org.drools\nfunction boolean testIt() {\n  return false;\n}\n"));
        Assertions.assertThat((boolean)builder.hasWarnings()).isTrue();
        Assertions.assertThat((boolean)builder.hasErrors()).isTrue();
        builder.resetProblems();
        Assertions.assertThat((boolean)builder.hasWarnings()).isFalse();
        Assertions.assertThat((boolean)builder.hasErrors()).isFalse();
    }

    @Test
    public void testResetWarningsButNotErrors() throws DroolsParserException, IOException {
        System.setProperty("drools.kbuilder.severity.duplicateRule", "WARNING");
        System.setProperty("drools.kbuilder.severity.duplicateFunction", "ERROR");
        KnowledgeBuilderImpl builder = new KnowledgeBuilderImpl();
        PackageDescr packageDescr1 = this.createBasicPackageWithOneRule(11, 1);
        PackageDescr packageDescr2 = this.createBasicPackageWithOneRule(22, 2);
        builder.addPackage(packageDescr1);
        builder.addPackage(packageDescr2);
        builder.addPackageFromDrl((Reader)new StringReader("package foo \n rule ORB"));
        builder.addPackageFromDrl((Reader)new StringReader("package org.drools\nfunction boolean testIt() {\n  return true;\n}\n"));
        builder.addPackageFromDrl((Reader)new StringReader("package org.drools\nfunction boolean testIt() {\n  return false;\n}\n"));
        Assertions.assertThat((boolean)builder.hasWarnings()).isTrue();
        Assertions.assertThat((boolean)builder.hasErrors()).isTrue();
        builder.resetWarnings();
        Assertions.assertThat((boolean)builder.hasWarnings()).isFalse();
        Assertions.assertThat((boolean)builder.hasErrors()).isTrue();
    }

    @Test
    public void testWarnOnFunctionReplacement() throws DroolsParserException, IOException {
        System.setProperty("drools.kbuilder.severity.duplicateFunction", "WARNING");
        KnowledgeBuilderImpl builder = new KnowledgeBuilderImpl();
        builder.addPackageFromDrl((Reader)new StringReader("package org.drools\nfunction boolean testIt() {\n  return true;\n}\n"));
        builder.addPackageFromDrl((Reader)new StringReader("package org.drools\nfunction boolean testIt() {\n  return false;\n}\n"));
        Assertions.assertThat((boolean)builder.hasWarnings()).isTrue();
    }

    @Test
    public void testDuplicateRuleNames() throws Exception {
        KnowledgeBuilderImpl builder = new KnowledgeBuilderImpl();
        PackageDescr packageDescr = this.createBasicPackageWithOneRule(1, 1);
        RuleDescr ruleDescr = new RuleDescr("rule-1");
        ruleDescr.setLocation(42, 43);
        packageDescr.addRule(ruleDescr);
        AndDescr lhs = new AndDescr();
        ruleDescr.setLhs(lhs);
        PatternDescr patternDescr = new PatternDescr(Cheese.class.getName(), "stilton");
        FieldConstraintDescr literalDescr = new FieldConstraintDescr("type");
        literalDescr.addRestriction((RestrictionDescr)new LiteralRestrictionDescr("!=", null));
        patternDescr.addConstraint((BaseDescr)literalDescr);
        ruleDescr.setConsequence((Object)"");
        ruleDescr = new RuleDescr("rule-2");
        ruleDescr.setLocation(42, 43);
        packageDescr.addRule(ruleDescr);
        lhs = new AndDescr();
        ruleDescr.setLhs(lhs);
        patternDescr = new PatternDescr(Cheese.class.getName(), "stilton");
        literalDescr = new FieldConstraintDescr("type");
        literalDescr.addRestriction((RestrictionDescr)new LiteralRestrictionDescr("!=", null));
        patternDescr.addConstraint((BaseDescr)literalDescr);
        ruleDescr.setConsequence((Object)"");
        builder.addPackage(packageDescr);
        Assertions.assertThat((Object[])builder.getErrors().getErrors()).hasSize(2);
        ParserError err = (ParserError)builder.getErrors().getErrors()[0];
        Assertions.assertThat((int)err.getRow()).isEqualTo(42);
        Assertions.assertThat((int)err.getCol()).isEqualTo(43);
    }

    private PackageDescr createBasicPackageWithOneRule(int line, int col) {
        PackageDescr packageDescr = new PackageDescr("p1");
        RuleDescr ruleDescr = new RuleDescr("rule-1");
        ruleDescr.setLocation(line, col);
        packageDescr.addRule(ruleDescr);
        AndDescr lhs = new AndDescr();
        ruleDescr.setLhs(lhs);
        PatternDescr patternDescr = new PatternDescr(Cheese.class.getName(), "stilton");
        FieldConstraintDescr literalDescr = new FieldConstraintDescr("type");
        literalDescr.addRestriction((RestrictionDescr)new LiteralRestrictionDescr("==", null));
        patternDescr.addConstraint((BaseDescr)literalDescr);
        ruleDescr.setConsequence((Object)"");
        return packageDescr;
    }

    @Test
    @Ignore
    public void testDuplicateDeclaration() {
        KnowledgeBuilderImpl builder = new KnowledgeBuilderImpl();
        PackageDescr packageDescr = new PackageDescr("p1");
        RuleDescr ruleDescr = new RuleDescr("rule-1");
        packageDescr.addRule(ruleDescr);
        AndDescr lhs = new AndDescr();
        ruleDescr.setLhs(lhs);
        PatternDescr pattern1 = new PatternDescr(Cheese.class.getName());
        lhs.addDescr((BaseDescr)pattern1);
        BindingDescr fieldBindingDescr = new BindingDescr("$type", "type");
        FieldConstraintDescr literalDescr = new FieldConstraintDescr("type");
        literalDescr.addRestriction((RestrictionDescr)new LiteralRestrictionDescr("==", "stilton"));
        pattern1.addConstraint((BaseDescr)fieldBindingDescr);
        pattern1.addConstraint((BaseDescr)literalDescr);
        PatternDescr pattern2 = new PatternDescr(Cheese.class.getName());
        lhs.addDescr((BaseDescr)pattern2);
        pattern2.addConstraint((BaseDescr)fieldBindingDescr);
        ruleDescr.setConsequence((Object)"update(stilton);");
        builder.addPackage(packageDescr);
        Assertions.assertThat((Object[])builder.getErrors().getErrors()).hasSize(2);
    }

    @Test
    public void testCompilerConfiguration() throws Exception {
        KnowledgeBuilderImpl builder = new KnowledgeBuilderImpl();
        PackageDescr pkgDescr = new PackageDescr("org.drools.mvel.compiler.test");
        builder.addPackage(pkgDescr);
        Field dialectField = builder.getClass().getDeclaredField("defaultDialect");
        dialectField.setAccessible(true);
        String dialectName = (String)dialectField.get(builder);
        DialectCompiletimeRegistry reg = builder.getPackageRegistry(pkgDescr.getName()).getDialectCompiletimeRegistry();
        Dialect dialect = reg.getDialect(dialectName);
        Field compilerField = dialect.getClass().getDeclaredField("compiler");
        compilerField.setAccessible(true);
        JavaCompiler compiler = (JavaCompiler)compilerField.get(dialect);
        KnowledgeBuilderConfigurationImpl conf = (KnowledgeBuilderConfigurationImpl)KnowledgeBuilderFactory.newKnowledgeBuilderConfiguration().as(KnowledgeBuilderConfigurationImpl.KEY);
        JavaForMvelDialectConfiguration javaConf = (JavaForMvelDialectConfiguration)conf.getDialectConfiguration("java");
        switch (javaConf.getCompiler()) {
            case NATIVE: {
                Assertions.assertThat(compiler.getClass()).isSameAs(NativeJavaCompiler.class);
                break;
            }
            case ECLIPSE: {
                Assertions.assertThat(compiler.getClass()).isSameAs(EclipseJavaCompiler.class);
                break;
            }
            default: {
                Assertions.fail((String)"Unrecognized java compiler");
            }
        }
        conf = (KnowledgeBuilderConfigurationImpl)KnowledgeBuilderFactory.newKnowledgeBuilderConfiguration().as(KnowledgeBuilderConfigurationImpl.KEY);
        javaConf = (JavaForMvelDialectConfiguration)conf.getDialectConfiguration("java");
        javaConf.setCompiler(JavaConfiguration.CompilerType.ECLIPSE);
        builder = new KnowledgeBuilderImpl((KnowledgeBuilderConfiguration)conf);
        builder.addPackage(pkgDescr);
        dialectName = (String)dialectField.get(builder);
        reg = builder.getPackageRegistry(pkgDescr.getName()).getDialectCompiletimeRegistry();
        dialect = reg.getDialect(dialectName);
        compiler = (JavaCompiler)compilerField.get(dialect);
        Assertions.assertThat(compiler.getClass()).isSameAs(EclipseJavaCompiler.class);
    }

    @Test
    public void testTypeDeclaration() throws Exception {
        PackageDescr pkgDescr = new PackageDescr("org.drools.mvel.compiler");
        TypeDeclarationDescr typeDescr = new TypeDeclarationDescr("StockTick");
        typeDescr.addAnnotation(Role.class.getCanonicalName(), "Event");
        typeDescr.addAnnotation(TypeSafe.class.getCanonicalName(), "true");
        pkgDescr.addTypeDeclaration(typeDescr);
        KnowledgeBuilderImpl builder = new KnowledgeBuilderImpl();
        builder.addPackage(pkgDescr);
        if (builder.hasErrors()) {
            Assertions.fail((String)builder.getErrors().toString());
        }
        InternalKnowledgePackage pkg = builder.getPackage(pkgDescr.getName());
        Assertions.assertThat((int)pkg.getTypeDeclarations().size()).isEqualTo(1);
        TypeDeclaration type = pkg.getTypeDeclaration("StockTick");
        Assertions.assertThat((boolean)type.isTypesafe()).isTrue();
        Assertions.assertThat((Comparable)type.getRole()).isEqualTo((Object)Role.Type.EVENT);
        Assertions.assertThat((Class)type.getTypeClass()).isEqualTo(StockTick.class);
    }

    @Test
    public void testTypeDeclarationNewBean() throws Exception {
        PackageDescr pkgDescr = new PackageDescr("org.drools.mvel.compiler.test");
        TypeDeclarationDescr typeDescr = new TypeDeclarationDescr("NewBean");
        TypeFieldDescr f1 = new TypeFieldDescr("name", new PatternDescr("String"));
        TypeFieldDescr f2 = new TypeFieldDescr("age", new PatternDescr("int"));
        typeDescr.addField(f1);
        typeDescr.addField(f2);
        pkgDescr.addTypeDeclaration(typeDescr);
        KnowledgeBuilderImpl builder = new KnowledgeBuilderImpl();
        builder.addPackage(pkgDescr);
        InternalKnowledgePackage pkg = builder.getPackage(pkgDescr.getName());
        Assertions.assertThat((int)pkg.getTypeDeclarations().size()).isEqualTo(1);
        TypeDeclaration type = pkg.getTypeDeclaration("NewBean");
        Assertions.assertThat((String)type.getTypeName()).isEqualTo("NewBean");
        Assertions.assertThat((Comparable)type.getRole()).isEqualTo((Object)Role.Type.FACT);
        Assertions.assertThat((String)type.getTypeClass().getName()).isEqualTo("org.drools.mvel.compiler.test.NewBean");
        Assertions.assertThat((boolean)builder.hasErrors()).isFalse();
        InternalKnowledgePackage bp = builder.getPackage(pkgDescr.getName());
        Class<?> newBean = bp.getPackageClassLoader().loadClass("org.drools.mvel.compiler.test.NewBean");
        Assertions.assertThat(newBean).isNotNull();
    }

    @Test
    public void testTypeDeclarationWithFieldMetadata() throws Exception {
        PackageDescr pkgDescr = new PackageDescr("org.drools.mvel.compiler.test");
        TypeDeclarationDescr typeDescr = new TypeDeclarationDescr("TypeWithFieldMeta");
        TypeFieldDescr f1 = new TypeFieldDescr("field", new PatternDescr("String"));
        f1.addAnnotation("custom", null);
        typeDescr.addField(f1);
        pkgDescr.addTypeDeclaration(typeDescr);
        KnowledgeBuilderImpl builder = new KnowledgeBuilderImpl();
        builder.addPackage(pkgDescr);
        Assertions.assertThat((boolean)builder.hasErrors()).isFalse();
        InternalKnowledgePackage bp = builder.getPackage(pkgDescr.getName());
        FactType factType = bp.getFactType("org.drools.mvel.compiler.test.TypeWithFieldMeta");
        Assertions.assertThat((Object)factType).isNotNull();
        FactField field = factType.getField("field");
        Assertions.assertThat((Object)field).isNotNull();
        Map fieldMetaData = field.getMetaData();
        ((MapAssert)Assertions.assertThat((Map)fieldMetaData).as("No field-level custom metadata got compiled", new Object[0])).isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)fieldMetaData.containsKey("custom")).as("Field metadata does not include expected value", new Object[0])).isTrue();
    }

    @Test
    public void testPackageMerge() throws Exception {
        KnowledgeBuilderImpl builder = new KnowledgeBuilderImpl();
        try {
            builder.addPackage(new PackageDescr("org.drools"));
            builder.addPackageFromDrl((Reader)new StringReader("package org.drools\nfunction boolean testIt() {\n  return true;\n}\n"));
        }
        catch (RuntimeException e) {
            Assertions.fail((String)("Should not raise any exception: " + e.getMessage()));
        }
    }

    private void createReturnValueRule(PackageDescr packageDescr, String expression) {
        RuleDescr ruleDescr = new RuleDescr("rule-1");
        packageDescr.addRule(ruleDescr);
        AndDescr lhs = new AndDescr();
        ruleDescr.setLhs(lhs);
        PatternDescr pattern = new PatternDescr(Cheese.class.getName(), "stilton");
        lhs.addDescr((BaseDescr)pattern);
        BindingDescr fieldBindingDescr = new BindingDescr("x", "price");
        pattern.addConstraint((BaseDescr)fieldBindingDescr);
        fieldBindingDescr = new BindingDescr("y", "price");
        pattern.addConstraint((BaseDescr)fieldBindingDescr);
        packageDescr.addGlobal(new GlobalDescr("map", "java.util.Map"));
        pattern.addConstraint((BaseDescr)new ExprConstraintDescr("price == (" + expression + ")"));
        ruleDescr.setConsequence((Object)"update(stilton);");
    }

    private void createPredicateRule(PackageDescr packageDescr, String expression) {
        RuleDescr ruleDescr = new RuleDescr("rule-1");
        packageDescr.addRule(ruleDescr);
        AndDescr lhs = new AndDescr();
        ruleDescr.setLhs(lhs);
        PatternDescr pattern = new PatternDescr(Cheese.class.getName(), "stilton");
        lhs.addDescr((BaseDescr)pattern);
        BindingDescr fieldBindingDescr = new BindingDescr("x", "price");
        pattern.addConstraint((BaseDescr)fieldBindingDescr);
        BindingDescr fieldBindingDescr2 = new BindingDescr("y", "price");
        pattern.addConstraint((BaseDescr)fieldBindingDescr2);
        packageDescr.addGlobal(new GlobalDescr("map", "java.util.Map"));
        pattern.addConstraint((BaseDescr)new ExprConstraintDescr(expression));
        ruleDescr.setConsequence((Object)"update(stilton);");
    }

    private void createEvalRule(PackageDescr packageDescr, String expression) {
        RuleDescr ruleDescr = new RuleDescr("rule-1");
        packageDescr.addRule(ruleDescr);
        AndDescr lhs = new AndDescr();
        ruleDescr.setLhs(lhs);
        packageDescr.addGlobal(new GlobalDescr("map", "java.util.Map"));
        EvalDescr evalDescr = new EvalDescr((Object)expression);
        lhs.addDescr((BaseDescr)evalDescr);
        ruleDescr.setConsequence((Object)"");
    }

    private void createLiteralRule(BaseDescr descr) {
        KnowledgeBuilderImpl builder = new KnowledgeBuilderImpl();
        PackageDescr packageDescr = new PackageDescr("p1");
        RuleDescr ruleDescr = new RuleDescr("rule-1");
        packageDescr.addRule(ruleDescr);
        AndDescr lhs = new AndDescr();
        ruleDescr.setLhs(lhs);
        PatternDescr pattern = new PatternDescr(Primitives.class.getName());
        lhs.addDescr((BaseDescr)pattern);
        pattern.addConstraint(descr);
        ruleDescr.setConsequence((Object)"");
        builder.addPackage(packageDescr);
        Assertions.assertThat((Object[])builder.getErrors().getErrors()).hasSize(0);
    }

    private RuleImpl createRule(ConditionalElementDescr ceDescr, KnowledgeBuilderImpl builder, String consequence) throws Exception {
        PackageDescr packageDescr = new PackageDescr("p1");
        RuleDescr ruleDescr = new RuleDescr("rule-1");
        packageDescr.addRule(ruleDescr);
        AndDescr lhs = new AndDescr();
        ruleDescr.setLhs(lhs);
        lhs.addDescr((BaseDescr)ceDescr);
        PatternDescr patternDescr = new PatternDescr(Cheese.class.getName(), "stilton");
        patternDescr.addConstraint((BaseDescr)new ExprConstraintDescr("type == \"stilton\" "));
        ceDescr.addDescr((BaseDescr)patternDescr);
        ruleDescr.setConsequence((Object)consequence);
        builder.addPackage(packageDescr);
        InternalKnowledgePackage pkg = builder.getPackage(packageDescr.getName());
        RuleImpl rule = pkg.getRule("rule-1");
        Assertions.assertThat((String)rule.getName()).isEqualTo("rule-1");
        return rule;
    }

    @Test
    public void testTimeWindowBehavior() throws Exception {
        KnowledgeBuilderImpl builder = new KnowledgeBuilderImpl();
        PackageDescr packageDescr = new PackageDescr("p1");
        TypeDeclarationDescr typeDeclDescr = new TypeDeclarationDescr(StockTick.class.getName());
        typeDeclDescr.addAnnotation("role", "event");
        packageDescr.addTypeDeclaration(typeDeclDescr);
        RuleDescr ruleDescr = new RuleDescr("rule-1");
        packageDescr.addRule(ruleDescr);
        AndDescr lhs = new AndDescr();
        ruleDescr.setLhs(lhs);
        PatternDescr patternDescr = new PatternDescr(StockTick.class.getName(), "$tick");
        BehaviorDescr windowDescr = new BehaviorDescr("window");
        windowDescr.setSubType("time");
        windowDescr.setParameters(Collections.singletonList("60000"));
        patternDescr.addBehavior(windowDescr);
        lhs.addDescr((BaseDescr)patternDescr);
        ruleDescr.setConsequence((Object)"System.out.println( $tick );");
        builder.addPackage(packageDescr);
        Assertions.assertThat((Object[])builder.getErrors().getErrors()).hasSize(0);
        InternalKnowledgePackage pkg = ((PackageRegistry)builder.getPackageRegistry().get("p1")).getPackage();
        RuleImpl rule = pkg.getRule("rule-1");
        Assertions.assertThat((Object)rule).isNotNull();
        Pattern pattern = (Pattern)rule.getLhs().getChildren().get(0);
        Assertions.assertThat((String)((ClassObjectType)pattern.getObjectType()).getClassType().getName()).isEqualTo(StockTick.class.getName());
        Behavior window = (Behavior)pattern.getBehaviors().get(0);
        Assertions.assertThat((Comparable)window.getType()).isEqualTo((Object)Behavior.BehaviorType.TIME_WINDOW);
        Assertions.assertThat((long)((SlidingTimeWindow)window).getSize()).isEqualTo(60000L);
    }

    @Test
    public void testDeclaredSuperTypeFields() throws Exception {
        String drl = "package foo \ndeclare Bean1 \nage: int \nname : String \nend \ndeclare Bean2 extends Bean1\ncheese : String \nend";
        KnowledgeBuilderImpl builder = new KnowledgeBuilderImpl();
        builder.addPackageFromDrl((Reader)new StringReader(drl));
        List fieldsBean1 = builder.getPackage("foo").getFactType("foo.Bean1").getFields();
        Assertions.assertThat((int)fieldsBean1.size()).isEqualTo(2);
        Assertions.assertThat((String)((FactField)fieldsBean1.get(0)).getName()).isEqualTo("age");
        Assertions.assertThat((Class)((FactField)fieldsBean1.get(0)).getType()).isEqualTo(Integer.TYPE);
        Assertions.assertThat((String)((FactField)fieldsBean1.get(1)).getName()).isEqualTo("name");
        Assertions.assertThat((Class)((FactField)fieldsBean1.get(1)).getType()).isEqualTo(String.class);
        List fieldsBean2 = builder.getPackage("foo").getFactType("foo.Bean2").getFields();
        Assertions.assertThat((int)fieldsBean2.size()).isEqualTo(3);
        Assertions.assertThat((String)((FactField)fieldsBean2.get(0)).getName()).isEqualTo("age");
        Assertions.assertThat((Class)((FactField)fieldsBean2.get(0)).getType()).isEqualTo(Integer.TYPE);
        Assertions.assertThat((String)((FactField)fieldsBean2.get(1)).getName()).isEqualTo("name");
        Assertions.assertThat((Class)((FactField)fieldsBean2.get(1)).getType()).isEqualTo(String.class);
        Assertions.assertThat((String)((FactField)fieldsBean2.get(2)).getName()).isEqualTo("cheese");
        Assertions.assertThat((Class)((FactField)fieldsBean2.get(2)).getType()).isEqualTo(String.class);
    }

    class MockTuple
    extends JoinNodeLeftTuple {
        private Map declarations;

        public MockTuple(Map declarations) {
            this.declarations = declarations;
        }

        public InternalFactHandle get(int patern) {
            return null;
        }

        public InternalFactHandle get(Declaration declaration) {
            return (InternalFactHandle)this.declarations.get(declaration);
        }

        public InternalFactHandle[] toFactHandles() {
            return (InternalFactHandle[])this.declarations.values().toArray(new FactHandle[0]);
        }

        public boolean dependsOn(FactHandle handle) {
            return false;
        }

        public void setActivation(InternalMatch internalMatch) {
        }

        public long getRecency() {
            return 0L;
        }

        public int size() {
            return 0;
        }
    }

    class MockInternalMatch
    implements InternalMatch {
        private RuleImpl rule;
        private int salience;
        private final GroupElement subrule;
        private LeftTuple tuple;

        public MockInternalMatch(RuleImpl rule, int salience, GroupElement subrule, LeftTuple tuple) {
            this.rule = rule;
            this.salience = salience;
            this.tuple = tuple;
            this.subrule = subrule;
        }

        public RuleImpl getRule() {
            return this.rule;
        }

        public Consequence getConsequence() {
            return this.getRule().getConsequence();
        }

        public int getSalience() {
            return this.salience;
        }

        public LeftTuple getTuple() {
            return this.tuple;
        }

        public PropagationContext getPropagationContext() {
            return null;
        }

        public long getActivationNumber() {
            return 0L;
        }

        public void remove() {
        }

        public boolean isQueued() {
            return false;
        }

        public void setQueued(boolean activated) {
        }

        public ActivationGroupNode getActivationGroupNode() {
            return null;
        }

        public void setActivationGroupNode(ActivationGroupNode activationGroupNode) {
        }

        public InternalAgendaGroup getAgendaGroup() {
            return null;
        }

        public InternalRuleFlowGroup getRuleFlowGroup() {
            return null;
        }

        public ActivationNode getActivationNode() {
            return null;
        }

        public void setActivationNode(ActivationNode ruleFlowGroupNode) {
        }

        public List<FactHandle> getFactHandles() {
            return null;
        }

        public List<Object> getObjects() {
            return null;
        }

        public Object getDeclarationValue(String variableName) {
            return null;
        }

        public List<String> getDeclarationIds() {
            return null;
        }

        public InternalFactHandle getActivationFactHandle() {
            return null;
        }

        public boolean isAdded() {
            return false;
        }

        public boolean isMatched() {
            return false;
        }

        public void setMatched(boolean matched) {
        }

        public boolean isActive() {
            return false;
        }

        public void setActive(boolean active) {
        }

        public boolean isRuleAgendaItem() {
            return false;
        }

        public void dequeue() {
        }

        public int getQueueIndex() {
            return 0;
        }

        public void setQueueIndex(int index) {
        }

        public RuleAgendaItem getRuleAgendaItem() {
            return null;
        }

        public void setActivationFactHandle(InternalFactHandle factHandle) {
        }

        public TerminalNode getTerminalNode() {
            return null;
        }

        public String toExternalForm() {
            return null;
        }

        public Runnable getCallback() {
            return null;
        }

        public void setCallback(Runnable callback) {
        }
    }
}

