/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.compiler.conf;

import org.assertj.core.api.Assertions;
import org.drools.core.runtime.rule.impl.DefaultConsequenceExceptionHandler;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.KieBaseConfiguration;
import org.kie.api.KieServices;
import org.kie.api.conf.BetaRangeIndexOption;
import org.kie.api.conf.EqualityBehaviorOption;
import org.kie.api.conf.EventProcessingOption;
import org.kie.api.conf.Option;
import org.kie.api.conf.RemoveIdentitiesOption;
import org.kie.api.conf.SequentialOption;
import org.kie.api.conf.SingleValueKieBaseOption;
import org.kie.api.conf.SingleValueRuleBaseOption;
import org.kie.internal.conf.AlphaRangeIndexThresholdOption;
import org.kie.internal.conf.AlphaThresholdOption;
import org.kie.internal.conf.CompositeKeyDepthOption;
import org.kie.internal.conf.ConsequenceExceptionHandlerOption;
import org.kie.internal.conf.IndexLeftBetaMemoryOption;
import org.kie.internal.conf.IndexPrecedenceOption;
import org.kie.internal.conf.IndexRightBetaMemoryOption;
import org.kie.internal.conf.MaxThreadsOption;
import org.kie.internal.conf.MultithreadEvaluationOption;
import org.kie.internal.conf.SequentialAgendaOption;
import org.kie.internal.conf.ShareAlphaNodesOption;
import org.kie.internal.conf.ShareBetaNodesOption;

public class KnowledgeBaseConfigurationTest {
    private KieBaseConfiguration config;

    @Before
    public void setUp() throws Exception {
        this.config = KieServices.Factory.get().newKieBaseConfiguration();
    }

    @Test
    public void testSequentialConfiguration() {
        this.config.setOption((Option)SequentialOption.YES);
        Assertions.assertThat((Comparable)((SequentialOption)this.config.getOption(SequentialOption.KEY))).isEqualTo((Object)SequentialOption.YES);
        Assertions.assertThat((String)this.config.getProperty("drools.sequential")).isEqualTo("true");
        this.config.setProperty("drools.sequential", "false");
        Assertions.assertThat((Comparable)((SequentialOption)this.config.getOption(SequentialOption.KEY))).isEqualTo((Object)SequentialOption.NO);
        Assertions.assertThat((String)this.config.getProperty("drools.sequential")).isEqualTo("false");
    }

    @Test
    public void testRemoveIdentitiesConfiguration() {
        this.config.setOption((Option)RemoveIdentitiesOption.YES);
        Assertions.assertThat((Object)((SingleValueKieBaseOption)this.config.getOption(RemoveIdentitiesOption.KEY))).isEqualTo((Object)RemoveIdentitiesOption.YES);
        Assertions.assertThat((String)this.config.getProperty("drools.removeIdentities")).isEqualTo("true");
        this.config.setProperty("drools.removeIdentities", "false");
        Assertions.assertThat((Object)((SingleValueKieBaseOption)this.config.getOption(RemoveIdentitiesOption.KEY))).isEqualTo((Object)RemoveIdentitiesOption.NO);
        Assertions.assertThat((String)this.config.getProperty("drools.removeIdentities")).isEqualTo("false");
    }

    @Test
    public void testShareAlphaNodesConfiguration() {
        this.config.setOption((Option)ShareAlphaNodesOption.YES);
        Assertions.assertThat((Comparable)((ShareAlphaNodesOption)this.config.getOption(ShareAlphaNodesOption.KEY))).isEqualTo((Object)ShareAlphaNodesOption.YES);
        Assertions.assertThat((String)this.config.getProperty("drools.shareAlphaNodes")).isEqualTo("true");
        this.config.setProperty("drools.shareAlphaNodes", "false");
        Assertions.assertThat((Comparable)((ShareAlphaNodesOption)this.config.getOption(ShareAlphaNodesOption.KEY))).isEqualTo((Object)ShareAlphaNodesOption.NO);
        Assertions.assertThat((String)this.config.getProperty("drools.shareAlphaNodes")).isEqualTo("false");
    }

    @Test
    public void testShareBetaNodesConfiguration() {
        this.config.setOption((Option)ShareBetaNodesOption.YES);
        Assertions.assertThat((Object)((SingleValueRuleBaseOption)this.config.getOption(ShareBetaNodesOption.KEY))).isEqualTo((Object)ShareBetaNodesOption.YES);
        Assertions.assertThat((String)this.config.getProperty("drools.shareBetaNodes")).isEqualTo("true");
        this.config.setProperty("drools.shareBetaNodes", "false");
        Assertions.assertThat((Object)((SingleValueRuleBaseOption)this.config.getOption(ShareBetaNodesOption.KEY))).isEqualTo((Object)ShareBetaNodesOption.NO);
        Assertions.assertThat((String)this.config.getProperty("drools.shareBetaNodes")).isEqualTo("false");
    }

    @Test
    public void testIndexLeftBetaMemoryConfiguration() {
        this.config.setOption((Option)IndexLeftBetaMemoryOption.YES);
        Assertions.assertThat((Comparable)((IndexLeftBetaMemoryOption)this.config.getOption(IndexLeftBetaMemoryOption.KEY))).isEqualTo((Object)IndexLeftBetaMemoryOption.YES);
        Assertions.assertThat((String)this.config.getProperty("drools.indexLeftBetaMemory")).isEqualTo("true");
        this.config.setProperty("drools.indexLeftBetaMemory", "false");
        Assertions.assertThat((Comparable)((IndexLeftBetaMemoryOption)this.config.getOption(IndexLeftBetaMemoryOption.KEY))).isEqualTo((Object)IndexLeftBetaMemoryOption.NO);
        Assertions.assertThat((String)this.config.getProperty("drools.indexLeftBetaMemory")).isEqualTo("false");
    }

    @Test
    public void testIndexRightBetaMemoryConfiguration() {
        this.config.setOption((Option)IndexRightBetaMemoryOption.YES);
        Assertions.assertThat((Comparable)((IndexRightBetaMemoryOption)this.config.getOption(IndexRightBetaMemoryOption.KEY))).isEqualTo((Object)IndexRightBetaMemoryOption.YES);
        Assertions.assertThat((String)this.config.getProperty("drools.indexRightBetaMemory")).isEqualTo("true");
        this.config.setProperty("drools.indexRightBetaMemory", "false");
        Assertions.assertThat((Comparable)((IndexRightBetaMemoryOption)this.config.getOption(IndexRightBetaMemoryOption.KEY))).isEqualTo((Object)IndexRightBetaMemoryOption.NO);
        Assertions.assertThat((String)this.config.getProperty("drools.indexRightBetaMemory")).isEqualTo("false");
    }

    @Test
    public void testIndexPrecedenceConfiguration() {
        this.config.setOption((Option)IndexPrecedenceOption.PATTERN_ORDER);
        Assertions.assertThat((Comparable)((IndexPrecedenceOption)this.config.getOption(IndexPrecedenceOption.KEY))).isEqualTo((Object)IndexPrecedenceOption.PATTERN_ORDER);
        Assertions.assertThat((String)this.config.getProperty("drools.indexPrecedence")).isEqualTo("pattern");
        this.config.setProperty("drools.indexPrecedence", "equality");
        Assertions.assertThat((Comparable)((IndexPrecedenceOption)this.config.getOption(IndexPrecedenceOption.KEY))).isEqualTo((Object)IndexPrecedenceOption.EQUALITY_PRIORITY);
        Assertions.assertThat((String)this.config.getProperty("drools.indexPrecedence")).isEqualTo("equality");
    }

    @Test
    public void testAssertBehaviorConfiguration() {
        this.config.setOption((Option)EqualityBehaviorOption.EQUALITY);
        Assertions.assertThat((Object)((SingleValueKieBaseOption)this.config.getOption(EqualityBehaviorOption.KEY))).isEqualTo((Object)EqualityBehaviorOption.EQUALITY);
        Assertions.assertThat((String)this.config.getProperty("drools.equalityBehavior")).isEqualTo("equality");
        this.config.setProperty("drools.equalityBehavior", "identity");
        Assertions.assertThat((Object)((SingleValueKieBaseOption)this.config.getOption(EqualityBehaviorOption.KEY))).isEqualTo((Object)EqualityBehaviorOption.IDENTITY);
        Assertions.assertThat((String)this.config.getProperty("drools.equalityBehavior")).isEqualTo("identity");
    }

    @Test
    public void testSequentialAgendaConfiguration() {
        this.config.setOption((Option)SequentialAgendaOption.DYNAMIC);
        Assertions.assertThat((Comparable)((SequentialAgendaOption)this.config.getOption(SequentialAgendaOption.KEY))).isEqualTo((Object)SequentialAgendaOption.DYNAMIC);
        Assertions.assertThat((String)this.config.getProperty("drools.sequential.agenda")).isEqualTo("dynamic");
        this.config.setProperty("drools.sequential.agenda", "sequential");
        Assertions.assertThat((Comparable)((SequentialAgendaOption)this.config.getOption(SequentialAgendaOption.KEY))).isEqualTo((Object)SequentialAgendaOption.SEQUENTIAL);
        Assertions.assertThat((String)this.config.getProperty("drools.sequential.agenda")).isEqualTo("sequential");
    }

    @Test
    public void testAlphaThresholdConfiguration() {
        this.config.setOption((Option)AlphaThresholdOption.get((int)5));
        Assertions.assertThat((Object)((AlphaThresholdOption)this.config.getOption(AlphaThresholdOption.KEY))).isEqualTo((Object)AlphaThresholdOption.get((int)5));
        Assertions.assertThat((String)this.config.getProperty("drools.alphaNodeHashingThreshold")).isEqualTo("5");
        this.config.setProperty("drools.alphaNodeHashingThreshold", "7");
        Assertions.assertThat((Object)((AlphaThresholdOption)this.config.getOption(AlphaThresholdOption.KEY))).isEqualTo((Object)AlphaThresholdOption.get((int)7));
        Assertions.assertThat((String)this.config.getProperty("drools.alphaNodeHashingThreshold")).isEqualTo("7");
    }

    @Test
    public void testAlphaRangeIndexThresholdConfiguration() {
        this.config.setOption((Option)AlphaRangeIndexThresholdOption.get((int)5));
        Assertions.assertThat((Object)((AlphaRangeIndexThresholdOption)this.config.getOption(AlphaRangeIndexThresholdOption.KEY))).isEqualTo((Object)AlphaRangeIndexThresholdOption.get((int)5));
        Assertions.assertThat((String)this.config.getProperty("drools.alphaNodeRangeIndexThreshold")).isEqualTo("5");
        this.config.setProperty("drools.alphaNodeRangeIndexThreshold", "7");
        Assertions.assertThat((Object)((AlphaRangeIndexThresholdOption)this.config.getOption(AlphaRangeIndexThresholdOption.KEY))).isEqualTo((Object)AlphaRangeIndexThresholdOption.get((int)7));
        Assertions.assertThat((String)this.config.getProperty("drools.alphaNodeRangeIndexThreshold")).isEqualTo("7");
        this.config.setProperty("drools.alphaNodeRangeIndexThreshold", "");
        Assertions.assertThat((Object)((AlphaRangeIndexThresholdOption)this.config.getOption(AlphaRangeIndexThresholdOption.KEY))).isEqualTo((Object)AlphaRangeIndexThresholdOption.get((int)9));
        Assertions.assertThat((String)this.config.getProperty("drools.alphaNodeRangeIndexThreshold")).isEqualTo(String.valueOf(9));
    }

    @Test
    public void testBetaRangeIndexenabledConfiguration() {
        this.config.setOption((Option)BetaRangeIndexOption.ENABLED);
        Assertions.assertThat((Comparable)((BetaRangeIndexOption)this.config.getOption(BetaRangeIndexOption.KEY))).isEqualTo((Object)BetaRangeIndexOption.ENABLED);
        Assertions.assertThat((String)this.config.getProperty("drools.betaNodeRangeIndexEnabled")).isEqualTo("true");
        this.config.setProperty("drools.betaNodeRangeIndexEnabled", "false");
        Assertions.assertThat((Comparable)((BetaRangeIndexOption)this.config.getOption(BetaRangeIndexOption.KEY))).isEqualTo((Object)BetaRangeIndexOption.DISABLED);
        Assertions.assertThat((String)this.config.getProperty("drools.betaNodeRangeIndexEnabled")).isEqualTo("false");
    }

    @Test
    public void testCompositeKeyDepthConfiguration() {
        this.config.setOption((Option)CompositeKeyDepthOption.get((int)1));
        Assertions.assertThat((Object)((CompositeKeyDepthOption)this.config.getOption(CompositeKeyDepthOption.KEY))).isEqualTo((Object)CompositeKeyDepthOption.get((int)1));
        Assertions.assertThat((String)this.config.getProperty("drools.compositeKeyDepth")).isEqualTo("1");
        this.config.setProperty("drools.compositeKeyDepth", "2");
        Assertions.assertThat((Object)((CompositeKeyDepthOption)this.config.getOption(CompositeKeyDepthOption.KEY))).isEqualTo((Object)CompositeKeyDepthOption.get((int)2));
        Assertions.assertThat((String)this.config.getProperty("drools.compositeKeyDepth")).isEqualTo("2");
    }

    @Test
    public void testConsequenceExceptionHandlerConfiguration() {
        Class<DefaultConsequenceExceptionHandler> handler = DefaultConsequenceExceptionHandler.class;
        this.config.setOption((Option)ConsequenceExceptionHandlerOption.get(handler));
        Assertions.assertThat((Object)((ConsequenceExceptionHandlerOption)this.config.getOption(ConsequenceExceptionHandlerOption.KEY))).isEqualTo((Object)ConsequenceExceptionHandlerOption.get(handler));
        Assertions.assertThat((String)this.config.getProperty("drools.consequenceExceptionHandler")).isEqualTo(handler.getName());
        this.config.setProperty("drools.consequenceExceptionHandler", handler.getName());
        Assertions.assertThat((String)((ConsequenceExceptionHandlerOption)this.config.getOption(ConsequenceExceptionHandlerOption.KEY)).getHandler().getName()).isEqualTo(handler.getName());
        Assertions.assertThat((String)this.config.getProperty("drools.consequenceExceptionHandler")).isEqualTo(handler.getName());
    }

    @Test
    public void testEventProcessingConfiguration() {
        this.config.setOption((Option)EventProcessingOption.STREAM);
        Assertions.assertThat((Object)((SingleValueKieBaseOption)this.config.getOption(EventProcessingOption.KEY))).isEqualTo((Object)EventProcessingOption.STREAM);
        Assertions.assertThat((String)this.config.getProperty("drools.eventProcessingMode")).isEqualTo("stream");
        this.config.setProperty("drools.eventProcessingMode", "cloud");
        Assertions.assertThat((Object)((SingleValueKieBaseOption)this.config.getOption(EventProcessingOption.KEY))).isEqualTo((Object)EventProcessingOption.CLOUD);
        Assertions.assertThat((String)this.config.getProperty("drools.eventProcessingMode")).isEqualTo("cloud");
    }

    @Test
    public void testMaxThreadsConfiguration() {
        this.config.setOption((Option)MaxThreadsOption.get((int)5));
        Assertions.assertThat((Object)((MaxThreadsOption)this.config.getOption(MaxThreadsOption.KEY))).isEqualTo((Object)MaxThreadsOption.get((int)5));
        Assertions.assertThat((String)this.config.getProperty("drools.maxThreads")).isEqualTo("5");
        this.config.setProperty("drools.maxThreads", "8");
        Assertions.assertThat((Object)((MaxThreadsOption)this.config.getOption(MaxThreadsOption.KEY))).isEqualTo((Object)MaxThreadsOption.get((int)8));
        Assertions.assertThat((String)this.config.getProperty("drools.maxThreads")).isEqualTo("8");
    }

    @Test
    public void testMultithreadEvaluationConfiguration() {
        this.config.setOption((Option)MultithreadEvaluationOption.YES);
        Assertions.assertThat((Comparable)((MultithreadEvaluationOption)this.config.getOption(MultithreadEvaluationOption.KEY))).isEqualTo((Object)MultithreadEvaluationOption.YES);
        Assertions.assertThat((String)this.config.getProperty("drools.multithreadEvaluation")).isEqualTo("true");
        this.config.setProperty("drools.multithreadEvaluation", "false");
        Assertions.assertThat((Comparable)((MultithreadEvaluationOption)this.config.getOption(MultithreadEvaluationOption.KEY))).isEqualTo((Object)MultithreadEvaluationOption.NO);
        Assertions.assertThat((String)this.config.getProperty("drools.multithreadEvaluation")).isEqualTo("false");
    }

    @Test
    public void testRulebaseSetUpdateHandler() {
        Assertions.assertThat((String)this.config.getProperty("drools.ruleBaseUpdateHandler")).isEqualTo("");
        this.config.setProperty("drools.ruleBaseUpdateHandler", "somethingElse");
        Assertions.assertThat((String)this.config.getProperty("drools.ruleBaseUpdateHandler")).isEqualTo("somethingElse");
        this.config.setProperty("drools.ruleBaseUpdateHandler", null);
        Assertions.assertThat((String)this.config.getProperty("drools.ruleBaseUpdateHandler")).isEqualTo("");
        this.config.setProperty("drools.ruleBaseUpdateHandler", "");
        Assertions.assertThat((String)this.config.getProperty("drools.ruleBaseUpdateHandler")).isEqualTo("");
    }
}

