/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.compiler.kproject;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.kie.api.KieServices;
import org.kie.api.builder.ReleaseId;
import org.kie.api.builder.ReleaseIdComparator;
import org.kie.util.maven.support.ReleaseIdImpl;

public class ReleaseIdTest {
    private static final ReleaseId gav0 = ReleaseIdTest.newReleaseId("abc.def:ghi:9.0.1.GA");
    private static final ReleaseId gav1 = ReleaseIdTest.newReleaseId("com.test:foo:1.0.0-SNAPSHOT");
    private static final ReleaseId gav2 = ReleaseIdTest.newReleaseId("com.test:foo:1.0.0.Final");
    private static final ReleaseId gav3 = ReleaseIdTest.newReleaseId("com.test:foo:2.0.0-SNAPSHOT");
    private static final ReleaseId gav4 = ReleaseIdTest.newReleaseId("com.test:foo:2.0.0.Alpha1");
    private static final ReleaseId gav5 = ReleaseIdTest.newReleaseId("com.test:foo:2.0.0.Beta2");
    private static final ReleaseId gav6 = ReleaseIdTest.newReleaseId("org.example:test:0.0.1-SNAPSHOT");
    private static final ReleaseId gav7 = ReleaseIdTest.newReleaseId("org.example:test:1.0");

    private static final ReleaseId newReleaseId(String releaseId) {
        String[] gav = releaseId.split(":");
        return KieServices.Factory.get().newReleaseId(gav[0], gav[1], gav[2]);
    }

    private List<ReleaseId> newUnsortedList() {
        ArrayList<ReleaseId> list = new ArrayList<ReleaseId>();
        list.add(gav4);
        list.add(gav2);
        list.add(gav6);
        list.add(gav3);
        list.add(gav7);
        list.add(gav1);
        list.add(gav0);
        list.add(gav5);
        return list;
    }

    @Test
    public void testDefaultSort() {
        List<ReleaseId> list = this.newUnsortedList();
        list.sort((Comparator<ReleaseId>)new ReleaseIdComparator());
        Assertions.assertThat((Comparable)list.get(0)).isSameAs((Object)gav0);
        Assertions.assertThat((Comparable)list.get(1)).isSameAs((Object)gav1);
        Assertions.assertThat((Comparable)list.get(2)).isSameAs((Object)gav2);
        Assertions.assertThat((Comparable)list.get(3)).isSameAs((Object)gav3);
        Assertions.assertThat((Comparable)list.get(4)).isSameAs((Object)gav4);
        Assertions.assertThat((Comparable)list.get(5)).isSameAs((Object)gav5);
        Assertions.assertThat((Comparable)list.get(6)).isSameAs((Object)gav6);
        Assertions.assertThat((Comparable)list.get(7)).isSameAs((Object)gav7);
    }

    @Test
    public void testAscendingSort() {
        List<ReleaseId> list = this.newUnsortedList();
        list.sort((Comparator<ReleaseId>)new ReleaseIdComparator(ReleaseIdComparator.SortDirection.ASCENDING));
        Assertions.assertThat((Comparable)list.get(0)).isSameAs((Object)gav0);
        Assertions.assertThat((Comparable)list.get(1)).isSameAs((Object)gav1);
        Assertions.assertThat((Comparable)list.get(2)).isSameAs((Object)gav2);
        Assertions.assertThat((Comparable)list.get(3)).isSameAs((Object)gav3);
        Assertions.assertThat((Comparable)list.get(4)).isSameAs((Object)gav4);
        Assertions.assertThat((Comparable)list.get(5)).isSameAs((Object)gav5);
        Assertions.assertThat((Comparable)list.get(6)).isSameAs((Object)gav6);
        Assertions.assertThat((Comparable)list.get(7)).isSameAs((Object)gav7);
    }

    @Test
    public void testDecendingSort() {
        List<ReleaseId> list = this.newUnsortedList();
        list.sort((Comparator<ReleaseId>)new ReleaseIdComparator(ReleaseIdComparator.SortDirection.DESCENDING));
        Assertions.assertThat((Comparable)list.get(0)).isSameAs((Object)gav7);
        Assertions.assertThat((Comparable)list.get(1)).isSameAs((Object)gav6);
        Assertions.assertThat((Comparable)list.get(2)).isSameAs((Object)gav5);
        Assertions.assertThat((Comparable)list.get(3)).isSameAs((Object)gav4);
        Assertions.assertThat((Comparable)list.get(4)).isSameAs((Object)gav3);
        Assertions.assertThat((Comparable)list.get(5)).isSameAs((Object)gav2);
        Assertions.assertThat((Comparable)list.get(6)).isSameAs((Object)gav1);
        Assertions.assertThat((Comparable)list.get(7)).isSameAs((Object)gav0);
    }

    @Test
    public void testGetEarliest() {
        List<ReleaseId> list = this.newUnsortedList();
        Assertions.assertThat((Comparable)ReleaseIdComparator.getEarliest(list)).isSameAs((Object)gav0);
    }

    @Test
    public void testGetLatest() {
        List<ReleaseId> list = this.newUnsortedList();
        Assertions.assertThat((Comparable)ReleaseIdComparator.getLatest(list)).isSameAs((Object)gav7);
    }

    @Test
    public void testResolveVersionPomModelNull() {
        ReleaseIdImpl releaseId = new ReleaseIdImpl("groupId", "artifactId", "${project.version}");
        Assertions.assertThat((String)releaseId.getVersion()).isEqualTo("${project.version}");
    }

    @Test
    public void testResolveVersionNoProperty() {
        ReleaseIdImpl releaseId = new ReleaseIdImpl("groupId", "artifactId", "1.0.0");
        Assertions.assertThat((String)releaseId.getVersion()).isEqualTo("1.0.0");
    }
}

