/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.extractors;

import org.assertj.core.api.Assertions;
import org.drools.core.base.ClassFieldAccessorCache;
import org.drools.core.common.DefaultFactHandle;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.reteoo.RightTupleImpl;
import org.drools.core.reteoo.Tuple;
import org.drools.core.rule.Declaration;
import org.drools.core.rule.accessor.ReadAccessor;
import org.drools.core.rule.accessor.TupleValueExtractor;
import org.drools.core.test.model.Cheese;
import org.drools.core.util.AbstractHashTable;
import org.drools.mvel.accessors.ClassFieldAccessorStore;
import org.drools.mvel.accessors.ClassFieldReader;
import org.junit.Before;
import org.junit.Test;

public class FieldIndexEntryTest {
    ClassFieldAccessorStore store = new ClassFieldAccessorStore();

    @Before
    public void setUp() throws Exception {
        this.store.setClassFieldAccessorCache(new ClassFieldAccessorCache(Thread.currentThread().getContextClassLoader()));
        this.store.setEagerWire(true);
    }

    @Test
    public void testSingleEntry() {
        ClassFieldReader extractor = this.store.getReader(Cheese.class, "type");
        AbstractHashTable.FieldIndex fieldIndex = new AbstractHashTable.FieldIndex((ReadAccessor)extractor, (TupleValueExtractor)new Declaration("id", (ReadAccessor)extractor, null));
        AbstractHashTable.SingleIndex singleIndex = new AbstractHashTable.SingleIndex(new AbstractHashTable.FieldIndex[]{fieldIndex}, 1);
        RightTupleImpl tuple = new RightTupleImpl((InternalFactHandle)new DefaultFactHandle(1L, (Object)new Cheese("stilton", 10)));
        AbstractHashTable.IndexTupleList index = new AbstractHashTable.IndexTupleList((AbstractHashTable.Index)singleIndex, (AbstractHashTable.HashEntry)new AbstractHashTable.SingleHashEntry("stilton".hashCode(), (Object)"stilton"));
        Assertions.assertThat((Object)index.getFirst()).isNull();
        Cheese stilton1 = new Cheese("stilton", 35);
        DefaultFactHandle h1 = new DefaultFactHandle(1L, (Object)stilton1);
        RightTupleImpl h1RightTuple = new RightTupleImpl((InternalFactHandle)h1, null);
        index.add((Tuple)h1RightTuple);
        Tuple entry1 = index.getFirst();
        Assertions.assertThat((Object)entry1.getFactHandle()).isSameAs((Object)h1);
        Assertions.assertThat((Object)((Tuple)entry1.getNext())).isNull();
        Assertions.assertThat((Object)index.get((InternalFactHandle)h1)).isSameAs((Object)entry1);
        Tuple entry2 = index.get((Tuple)new RightTupleImpl((InternalFactHandle)h1, null));
        Assertions.assertThat((Object)entry2).isSameAs((Object)entry1);
        index.remove((Tuple)h1RightTuple);
        Assertions.assertThat((Object)index.getFirst()).isNull();
    }

    @Test
    public void testTwoEntries() {
        ClassFieldReader extractor = this.store.getReader(Cheese.class, "type");
        AbstractHashTable.FieldIndex fieldIndex = new AbstractHashTable.FieldIndex((ReadAccessor)extractor, (TupleValueExtractor)new Declaration("id", (ReadAccessor)extractor, null));
        AbstractHashTable.SingleIndex singleIndex = new AbstractHashTable.SingleIndex(new AbstractHashTable.FieldIndex[]{fieldIndex}, 1);
        RightTupleImpl tuple = new RightTupleImpl((InternalFactHandle)new DefaultFactHandle(1L, (Object)new Cheese("stilton", 10)));
        AbstractHashTable.IndexTupleList index = new AbstractHashTable.IndexTupleList((AbstractHashTable.Index)singleIndex, (AbstractHashTable.HashEntry)new AbstractHashTable.SingleHashEntry("stilton".hashCode(), (Object)"stilton"));
        Cheese stilton1 = new Cheese("stilton", 35);
        DefaultFactHandle h1 = new DefaultFactHandle(1L, (Object)stilton1);
        Cheese stilton2 = new Cheese("stilton", 59);
        DefaultFactHandle h2 = new DefaultFactHandle(2L, (Object)stilton2);
        RightTupleImpl h1RightTuple = new RightTupleImpl((InternalFactHandle)h1, null);
        RightTupleImpl h2RightTuple = new RightTupleImpl((InternalFactHandle)h2, null);
        index.add((Tuple)h1RightTuple);
        index.add((Tuple)h2RightTuple);
        Assertions.assertThat((Object)index.getFirst().getFactHandle()).isEqualTo((Object)h1);
        Assertions.assertThat((Object)((Tuple)index.getFirst().getNext()).getFactHandle()).isEqualTo((Object)h2);
        Assertions.assertThat((Object)index.get((InternalFactHandle)h1).getFactHandle()).isEqualTo((Object)h1);
        Assertions.assertThat((Object)index.get((InternalFactHandle)h2).getFactHandle()).isEqualTo((Object)h2);
        index.remove((Tuple)h2RightTuple);
        Assertions.assertThat((Object)index.getFirst().getFactHandle()).isEqualTo((Object)h1RightTuple.getFactHandle());
        index.add((Tuple)h2RightTuple);
        index.remove((Tuple)h1RightTuple);
        Assertions.assertThat((Object)index.getFirst().getFactHandle()).isEqualTo((Object)h2RightTuple.getFactHandle());
        stilton1.setType("cheddar");
    }

    @Test
    public void testThreeEntries() {
        ClassFieldReader extractor = this.store.getReader(Cheese.class, "type");
        AbstractHashTable.FieldIndex fieldIndex = new AbstractHashTable.FieldIndex((ReadAccessor)extractor, (TupleValueExtractor)new Declaration("id", (ReadAccessor)extractor, null));
        AbstractHashTable.SingleIndex singleIndex = new AbstractHashTable.SingleIndex(new AbstractHashTable.FieldIndex[]{fieldIndex}, 1);
        RightTupleImpl tuple = new RightTupleImpl((InternalFactHandle)new DefaultFactHandle(1L, (Object)new Cheese("stilton", 10)));
        AbstractHashTable.IndexTupleList index = new AbstractHashTable.IndexTupleList((AbstractHashTable.Index)singleIndex, (AbstractHashTable.HashEntry)new AbstractHashTable.SingleHashEntry("stilton".hashCode(), (Object)"stilton"));
        Cheese stilton1 = new Cheese("stilton", 35);
        DefaultFactHandle h1 = new DefaultFactHandle(1L, (Object)stilton1);
        Cheese stilton2 = new Cheese("stilton", 59);
        DefaultFactHandle h2 = new DefaultFactHandle(2L, (Object)stilton2);
        Cheese stilton3 = new Cheese("stilton", 59);
        DefaultFactHandle h3 = new DefaultFactHandle(3L, (Object)stilton3);
        RightTupleImpl h1RightTuple = new RightTupleImpl((InternalFactHandle)h1, null);
        RightTupleImpl h2RightTuple = new RightTupleImpl((InternalFactHandle)h2, null);
        RightTupleImpl h3RightTuple = new RightTupleImpl((InternalFactHandle)h3, null);
        index.add((Tuple)h1RightTuple);
        index.add((Tuple)h2RightTuple);
        index.add((Tuple)h3RightTuple);
        Assertions.assertThat((Object)index.getFirst().getFactHandle()).isEqualTo((Object)h1);
        Assertions.assertThat((Object)((Tuple)index.getFirst().getNext()).getFactHandle()).isEqualTo((Object)h2);
        Assertions.assertThat((Object)((Tuple)((Tuple)index.getFirst().getNext()).getNext()).getFactHandle()).isEqualTo((Object)h3);
        Assertions.assertThat((Object)index.get((InternalFactHandle)h1).getFactHandle()).isEqualTo((Object)h1);
        Assertions.assertThat((Object)index.get((InternalFactHandle)h2).getFactHandle()).isEqualTo((Object)h2);
        Assertions.assertThat((Object)index.get((InternalFactHandle)h3).getFactHandle()).isEqualTo((Object)h3);
        index.remove((Tuple)h3RightTuple);
        Assertions.assertThat((Object)index.getFirst().getFactHandle()).isEqualTo((Object)h1);
        Assertions.assertThat((Object)((Tuple)index.getFirst().getNext()).getFactHandle()).isEqualTo((Object)h2);
        index.add((Tuple)h3RightTuple);
        index.remove((Tuple)h2RightTuple);
        Assertions.assertThat((Object)index.getFirst().getFactHandle()).isEqualTo((Object)h1);
        Assertions.assertThat((Object)((Tuple)index.getFirst().getNext()).getFactHandle()).isEqualTo((Object)h3);
        index.add((Tuple)h2RightTuple);
        index.remove((Tuple)h1RightTuple);
        Assertions.assertThat((Object)index.getFirst().getFactHandle()).isEqualTo((Object)h3);
        Assertions.assertThat((Object)((Tuple)index.getFirst().getNext()).getFactHandle()).isEqualTo((Object)h2);
        index.remove(index.getFirst());
        stilton2.setType("cheddar");
    }
}

