/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests;

import java.util.Collection;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.model.KieBaseModel;
import org.kie.api.builder.model.KieModuleModel;
import org.kie.api.conf.EventProcessingOption;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.conf.ClockTypeOption;
import org.kie.api.runtime.rule.EntryPoint;
import org.kie.api.runtime.rule.QueryResults;
import org.kie.api.time.SessionPseudoClock;
import org.kie.internal.io.ResourceFactory;

@RunWith(value=Parameterized.class)
public class QueryCepFireUntilHaltTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;
    private KieSession ksession;
    private SessionPseudoClock clock;
    private EntryPoint firstEntryPoint;
    private EntryPoint secondEntryPoint;
    private ExecutorService executorService;

    public QueryCepFireUntilHaltTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseStreamConfigurations((boolean)true);
    }

    @Before
    public void prepare() {
        String drl = "package org.drools.mvel.integrationtests\nimport " + TestEvent.class.getCanonicalName() + "\ndeclare TestEvent\n    @role( event )\nend\nquery EventsFromStream\n    $event : TestEvent() from entry-point FirstStream\nend\nquery ZeroToNineteenSeconds\n    $event : TestEvent() from entry-point FirstStream\n    $result : TestEvent ( this after [0s, 19s] $event) from entry-point SecondStream\nend\n";
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kfs = ks.newKieFileSystem();
        KieModuleModel kmodule = ks.newKieModuleModel();
        KieBaseModel baseModel = kmodule.newKieBaseModel("defaultKBase").setDefault(true).setEventProcessingMode(EventProcessingOption.STREAM);
        baseModel.newKieSessionModel("defaultKSession").setDefault(true).setClockType(ClockTypeOption.PSEUDO);
        kfs.writeKModuleXML(kmodule.toXML());
        kfs.write(ResourceFactory.newByteArrayResource((byte[])drl.getBytes()).setTargetPath("org/drools/compiler/integrationtests/queries.drl"));
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromKieFileSystem((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (KieFileSystem)kfs, (boolean)true);
        this.ksession = ks.newKieContainer(ks.getRepository().getDefaultReleaseId()).newKieSession();
        this.firstEntryPoint = this.ksession.getEntryPoint("FirstStream");
        this.secondEntryPoint = this.ksession.getEntryPoint("SecondStream");
        this.clock = (SessionPseudoClock)this.ksession.getSessionClock();
        this.startEngine();
    }

    private void startEngine() {
        this.executorService = Executors.newSingleThreadExecutor();
        this.executorService.submit(() -> ((KieSession)this.ksession).fireUntilHalt());
    }

    private void stopEngine() {
        this.ksession.halt();
        this.executorService.shutdownNow();
    }

    @Test(timeout=10000L)
    public void noResultTest() {
        QueryResults results = this.ksession.getQueryResults("EventsFromStream", new Object[0]);
        Assertions.assertThat((int)results.size()).isEqualTo(0);
    }

    @Test(timeout=10000L)
    public void withResultTest() {
        this.secondEntryPoint.insert((Object)new TestEvent("minusOne"));
        this.clock.advanceTime(5L, TimeUnit.SECONDS);
        this.firstEntryPoint.insert((Object)new TestEvent("zero"));
        this.secondEntryPoint.insert((Object)new TestEvent("one"));
        this.clock.advanceTime(10L, TimeUnit.SECONDS);
        this.secondEntryPoint.insert((Object)new TestEvent("two"));
        this.clock.advanceTime(5L, TimeUnit.SECONDS);
        this.secondEntryPoint.insert((Object)new TestEvent("three"));
        QueryResults results = this.ksession.getQueryResults("ZeroToNineteenSeconds", new Object[0]);
        Assertions.assertThat((int)results.size()).isEqualTo(1);
    }

    @Test(timeout=10000L)
    public void withNoResultTest() {
        this.secondEntryPoint.insert((Object)new TestEvent("minusOne"));
        this.clock.advanceTime(5L, TimeUnit.SECONDS);
        this.firstEntryPoint.insert((Object)new TestEvent("zero"));
        this.secondEntryPoint.insert((Object)new TestEvent("one"));
        this.clock.advanceTime(10L, TimeUnit.SECONDS);
        this.secondEntryPoint.insert((Object)new TestEvent("two"));
        this.clock.advanceTime(10L, TimeUnit.SECONDS);
        this.secondEntryPoint.insert((Object)new TestEvent("three"));
        QueryResults results = this.ksession.getQueryResults("ZeroToNineteenSeconds", new Object[0]);
        Assertions.assertThat((int)results.size()).isEqualTo(0);
    }

    @After
    public void cleanup() {
        this.stopEngine();
        if (this.ksession != null) {
            this.ksession.dispose();
        }
    }

    public static class TestEvent {
        private final String name;

        public TestEvent(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return "TestEvent[" + this.name + "]";
        }
    }
}

