/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests.phreak;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.drools.core.base.ClassObjectType;
import org.drools.core.common.BaseNode;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.Memory;
import org.drools.core.common.MemoryFactory;
import org.drools.core.common.NetworkNode;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.impl.RuleBase;
import org.drools.core.phreak.EagerPhreakBuilder;
import org.drools.core.phreak.PhreakBuilder;
import org.drools.core.reteoo.BetaMemory;
import org.drools.core.reteoo.BetaNode;
import org.drools.core.reteoo.EvalConditionNode;
import org.drools.core.reteoo.ExistsNode;
import org.drools.core.reteoo.JoinNode;
import org.drools.core.reteoo.LeftInputAdapterNode;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.LeftTupleNode;
import org.drools.core.reteoo.LeftTupleSource;
import org.drools.core.reteoo.ObjectSource;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.PathEndNode;
import org.drools.core.reteoo.PathMemory;
import org.drools.core.reteoo.Rete;
import org.drools.core.reteoo.RuleTerminalNode;
import org.drools.core.reteoo.SegmentMemory;
import org.drools.core.reteoo.TerminalNode;
import org.drools.core.reteoo.builder.BuildContext;
import org.drools.core.rule.GroupElement;
import org.drools.kiesession.rulebase.InternalKnowledgeBase;
import org.drools.mvel.integrationtests.phreak.A;
import org.drools.mvel.integrationtests.phreak.B;
import org.drools.mvel.integrationtests.phreak.BetaNodeBuilder;
import org.drools.mvel.integrationtests.phreak.C;
import org.drools.mvel.integrationtests.phreak.E;
import org.drools.mvel.integrationtests.phreak.F;
import org.drools.mvel.integrationtests.phreak.X;
import org.drools.mvel.integrationtests.phreak.Y;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.KieSessionTestConfiguration;
import org.drools.testcoverage.common.util.KieUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.KieServices;
import org.kie.api.builder.ReleaseId;
import org.kie.api.definition.KiePackage;
import org.kie.api.definition.rule.Rule;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.rule.Match;

@RunWith(value=Parameterized.class)
public class AddRuleTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public AddRuleTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    @Test
    public void testAddThenSplitProtoAllJoins() {
        if (!PhreakBuilder.isEagerSegmentCreation()) {
            return;
        }
        InternalKnowledgeBase kbase1 = this.buildKnowledgeBase("r1", "   a : A() B() C() X() E()\n");
        InternalWorkingMemory wm = (InternalWorkingMemory)kbase1.newKieSession();
        ObjectTypeNode aotn = this.getObjectTypeNode(kbase1.getRete(), A.class);
        ObjectTypeNode cotn = this.getObjectTypeNode(kbase1.getRete(), C.class);
        LeftInputAdapterNode lian = (LeftInputAdapterNode)aotn.getSinks()[0];
        BetaNode cbeta = (BetaNode)cotn.getSinks()[0];
        AddRuleTest.insertAndFlush(wm);
        SegmentMemory.SegmentPrototype smemProto0 = kbase1.getSegmentPrototype((LeftTupleNode)lian);
        PathEndNode endNode = smemProto0.getPathEndNodes()[0];
        AddRuleTest.assertSegmentsLengthAndPos(endNode, 1, wm);
        Assertions.assertThat((Object)endNode.getSegmentPrototypes()[0]).isSameAs((Object)smemProto0);
        Assertions.assertThat((int)endNode.getEagerSegmentPrototypes().length).isEqualTo(0);
        Assertions.assertThat((int)smemProto0.getNodesInSegment().length).isEqualTo(6);
        LeftTupleNode[] nodes = smemProto0.getNodesInSegment();
        Assertions.assertThat((long)smemProto0.getAllLinkedMaskTest()).isEqualTo(31L);
        Assertions.assertThat((long)smemProto0.getLinkedNodeMask()).isEqualTo(0L);
        Assertions.assertThat((int)smemProto0.getNodeTypesInSegment()).isEqualTo(2);
        SegmentMemory.SegmentPrototype[] oldSmemProtos = endNode.getSegmentPrototypes();
        SegmentMemory.SegmentPrototype smemProto1 = EagerPhreakBuilder.Add.processSplit((LeftTupleNode)cbeta, (RuleBase)kbase1, Collections.singletonList(wm), new HashSet());
        AddRuleTest.assertSegmentsLengthAndPos(endNode, 2, oldSmemProtos, smemProto1, wm);
        Assertions.assertThat((Object)endNode.getSegmentPrototypes()[0]).isSameAs((Object)smemProto0);
        Assertions.assertThat((Object)endNode.getSegmentPrototypes()[1]).isSameAs((Object)smemProto1);
        Assertions.assertThat((int)endNode.getEagerSegmentPrototypes().length).isEqualTo(0);
        Assertions.assertThat((long)smemProto0.getAllLinkedMaskTest()).isEqualTo(7L);
        Assertions.assertThat((long)smemProto0.getLinkedNodeMask()).isEqualTo(0L);
        Assertions.assertThat((int)smemProto0.getNodeTypesInSegment()).isEqualTo(2);
        Assertions.assertThat((int)smemProto0.getNodesInSegment().length).isEqualTo(3);
        Assertions.assertThat((Object)nodes[0]).isSameAs((Object)smemProto0.getNodesInSegment()[0]);
        Assertions.assertThat((Object)nodes[1]).isSameAs((Object)smemProto0.getNodesInSegment()[1]);
        Assertions.assertThat((Object)nodes[2]).isSameAs((Object)smemProto0.getNodesInSegment()[2]);
        Assertions.assertThat((Object)endNode).isSameAs((Object)smemProto1.getPathEndNodes()[0]);
        Assertions.assertThat((long)smemProto1.getAllLinkedMaskTest()).isEqualTo(3L);
        Assertions.assertThat((long)smemProto1.getLinkedNodeMask()).isEqualTo(0L);
        Assertions.assertThat((int)smemProto1.getNodeTypesInSegment()).isEqualTo(2);
        Assertions.assertThat((int)smemProto1.getNodesInSegment().length).isEqualTo(3);
        Assertions.assertThat((Object)nodes[3]).isSameAs((Object)smemProto1.getNodesInSegment()[0]);
        Assertions.assertThat((Object)nodes[4]).isSameAs((Object)smemProto1.getNodesInSegment()[1]);
        Assertions.assertThat((Object)nodes[5]).isSameAs((Object)smemProto1.getNodesInSegment()[2]);
    }

    @Test
    public void testAddThenSplitProtoWithNot() {
        if (!PhreakBuilder.isEagerSegmentCreation()) {
            return;
        }
        InternalKnowledgeBase kbase1 = this.buildKnowledgeBase("r1", "   a : A() not B() C() not X() E()\n");
        InternalWorkingMemory wm = (InternalWorkingMemory)kbase1.newKieSession();
        ObjectTypeNode aotn = this.getObjectTypeNode(kbase1.getRete(), A.class);
        ObjectTypeNode cotn = this.getObjectTypeNode(kbase1.getRete(), C.class);
        LeftInputAdapterNode lian = (LeftInputAdapterNode)aotn.getSinks()[0];
        BetaNode cbeta = (BetaNode)cotn.getSinks()[0];
        AddRuleTest.insertAndFlush(wm);
        SegmentMemory smemLian = ((LeftInputAdapterNode.LiaNodeMemory)wm.getNodeMemories().getNodeMemory((MemoryFactory)lian, (ReteEvaluator)wm)).getSegmentMemory();
        SegmentMemory.SegmentPrototype smemProto0 = kbase1.getSegmentPrototype((LeftTupleNode)lian);
        Assertions.assertThat((Object)smemLian.getSegmentPrototype()).isSameAs((Object)smemProto0);
        Assertions.assertThat((int)smemProto0.getNodesInSegment().length).isEqualTo(6);
        Assertions.assertThat((long)smemProto0.getAllLinkedMaskTest()).isEqualTo(31L);
        Assertions.assertThat((long)smemProto0.getLinkedNodeMask()).isEqualTo(10L);
        Assertions.assertThat((int)smemProto0.getNodeTypesInSegment()).isEqualTo(3);
        SegmentMemory.SegmentPrototype smemProto1 = EagerPhreakBuilder.Add.processSplit((LeftTupleNode)cbeta, (RuleBase)kbase1, Collections.singletonList(wm), new HashSet());
        Assertions.assertThat((long)smemProto0.getAllLinkedMaskTest()).isEqualTo(7L);
        Assertions.assertThat((long)smemProto0.getLinkedNodeMask()).isEqualTo(2L);
        Assertions.assertThat((int)smemProto0.getNodeTypesInSegment()).isEqualTo(3);
        Assertions.assertThat((long)smemProto1.getAllLinkedMaskTest()).isEqualTo(3L);
        Assertions.assertThat((long)smemProto1.getLinkedNodeMask()).isEqualTo(1L);
        Assertions.assertThat((int)smemProto1.getNodeTypesInSegment()).isEqualTo(3);
    }

    @Test
    public void testAddWithSplitThenCreateThirdSplit() {
        if (!PhreakBuilder.isEagerSegmentCreation()) {
            return;
        }
        InternalKnowledgeBase kbase1 = this.buildKnowledgeBase("r", "   a : A() B() C() E(1;) E(2;) E(3;) E(4;)\n", "   A() B() C() X()\n");
        InternalWorkingMemory wm = (InternalWorkingMemory)kbase1.newKieSession();
        ObjectTypeNode aotn = this.getObjectTypeNode(kbase1.getRete(), A.class);
        ObjectTypeNode eotn = this.getObjectTypeNode(kbase1.getRete(), E.class);
        ObjectTypeNode xotn = this.getObjectTypeNode(kbase1.getRete(), X.class);
        LeftInputAdapterNode lian = (LeftInputAdapterNode)aotn.getSinks()[0];
        BetaNode ebeta = (BetaNode)eotn.getSinks()[0].getSinks()[0];
        BetaNode ebeta3 = (BetaNode)eotn.getSinks()[2].getSinks()[0];
        BetaNode xbeta = (BetaNode)xotn.getSinks()[0];
        AddRuleTest.insertAndFlush(wm);
        SegmentMemory smem = ((LeftInputAdapterNode.LiaNodeMemory)wm.getNodeMemories().getNodeMemory((MemoryFactory)lian, (ReteEvaluator)wm)).getSegmentMemory();
        SegmentMemory.SegmentPrototype smemProto0 = kbase1.getSegmentPrototype((LeftTupleNode)lian);
        Assertions.assertThat((Object)smem.getSegmentPrototype()).isSameAs((Object)smemProto0);
        PathEndNode endNode0 = smemProto0.getPathEndNodes()[0];
        PathEndNode endNode1 = smemProto0.getPathEndNodes()[1];
        AddRuleTest.assertSegmentsLengthAndPos(endNode0, 2, wm);
        AddRuleTest.assertSegmentsLengthAndPos(endNode1, 2, wm);
        SegmentMemory.SegmentPrototype smemProtoE = kbase1.getSegmentPrototype((LeftTupleNode)ebeta);
        Assertions.assertThat((int)smemProtoE.getNodesInSegment().length).isEqualTo(5);
        Assertions.assertThat((int)smemProtoE.getPos()).isEqualTo(1);
        SegmentMemory.SegmentPrototype smemProtoX = kbase1.getSegmentPrototype((LeftTupleNode)xbeta);
        Assertions.assertThat((int)smemProtoX.getPos()).isEqualTo(1);
        SegmentMemory.SegmentPrototype[] oldSmemProtos = endNode1.getSegmentPrototypes();
        SegmentMemory.SegmentPrototype smemProtoE2 = EagerPhreakBuilder.Add.processSplit((LeftTupleNode)ebeta3, (RuleBase)kbase1, Collections.singletonList(wm), new HashSet());
        AddRuleTest.assertSegmentsLengthAndPos(endNode0, 3, wm);
        AddRuleTest.assertSegmentsLengthAndPos(endNode1, 2, oldSmemProtos, smemProtoE2, wm);
        Assertions.assertThat((Object)endNode0.getSegmentPrototypes()[0]).isSameAs((Object)smemProto0);
        Assertions.assertThat((Object)endNode0.getSegmentPrototypes()[1]).isSameAs((Object)smemProtoE);
        Assertions.assertThat((Object)endNode0.getSegmentPrototypes()[2]).isSameAs((Object)smemProtoE2);
        Assertions.assertThat((int)smemProtoE.getNodesInSegment().length).isEqualTo(3);
        Assertions.assertThat((int)smemProtoE2.getNodesInSegment().length).isEqualTo(2);
        Assertions.assertThat((int)smemProtoE.getPos()).isEqualTo(1);
        Assertions.assertThat((int)smemProtoE2.getPos()).isEqualTo(2);
        Assertions.assertThat((long)smemProtoE.getSegmentPosMaskBit()).isEqualTo(2L);
        Assertions.assertThat((long)smemProtoE2.getSegmentPosMaskBit()).isEqualTo(4L);
        Assertions.assertThat((long)smemProtoE.getAllLinkedMaskTest()).isEqualTo(7L);
        Assertions.assertThat((long)smemProtoE2.getAllLinkedMaskTest()).isEqualTo(1L);
    }

    @Test
    public void testAddWithSplitThenCreateThirdSplitInSamePos() {
        if (!PhreakBuilder.isEagerSegmentCreation()) {
            return;
        }
        InternalKnowledgeBase kbase1 = this.buildKnowledgeBase("r", "   a : A() B() C() E(1;) E(2;) E(3;) E(4;)\n", "   A() B() C() X() Y()\n");
        InternalWorkingMemory wm = (InternalWorkingMemory)kbase1.newKieSession();
        ObjectTypeNode aotn = this.getObjectTypeNode(kbase1.getRete(), A.class);
        ObjectTypeNode eotn = this.getObjectTypeNode(kbase1.getRete(), E.class);
        ObjectTypeNode cotn = this.getObjectTypeNode(kbase1.getRete(), C.class);
        ObjectTypeNode xotn = this.getObjectTypeNode(kbase1.getRete(), X.class);
        ObjectTypeNode yotn = this.getObjectTypeNode(kbase1.getRete(), Y.class);
        LeftInputAdapterNode lian = (LeftInputAdapterNode)aotn.getSinks()[0];
        BetaNode ebeta = (BetaNode)eotn.getSinks()[0].getSinks()[0];
        BetaNode cbeta = (BetaNode)cotn.getSinks()[0];
        BetaNode ebeta3 = (BetaNode)eotn.getSinks()[2].getSinks()[0];
        BetaNode xbeta = (BetaNode)xotn.getSinks()[0];
        AddRuleTest.insertAndFlush(wm);
        wm.fireAllRules();
        SegmentMemory smem = ((LeftInputAdapterNode.LiaNodeMemory)wm.getNodeMemories().getNodeMemory((MemoryFactory)lian, (ReteEvaluator)wm)).getSegmentMemory();
        SegmentMemory.SegmentPrototype smemProto0 = kbase1.getSegmentPrototype((LeftTupleNode)lian);
        Assertions.assertThat((Object)smem.getSegmentPrototype()).isSameAs((Object)smemProto0);
        PathEndNode endNode0 = smemProto0.getPathEndNodes()[0];
        PathEndNode endNode1 = smemProto0.getPathEndNodes()[1];
        AddRuleTest.assertSegmentsLengthAndPos(endNode0, 2, wm);
        AddRuleTest.assertSegmentsLengthAndPos(endNode1, 2, wm);
        Assertions.assertThat((Object)EagerPhreakBuilder.Add.processSplit((LeftTupleNode)cbeta, (RuleBase)kbase1, Collections.singletonList(wm), new HashSet())).isNull();
        AddRuleTest.addRuleAtGivenSplit(kbase1, wm, cbeta, yotn);
        BetaNode jbeta = (BetaNode)yotn.getSinks()[1];
        Assertions.assertThat((Class)((ClassObjectType)jbeta.getObjectTypeNode().getObjectType()).getClassType()).isSameAs(Y.class);
        Assertions.assertThat((Object)jbeta.getLeftTupleSource()).isSameAs((Object)cbeta);
        endNode0 = smemProto0.getPathEndNodes()[0];
        endNode1 = smemProto0.getPathEndNodes()[1];
        PathEndNode endNode2 = smemProto0.getPathEndNodes()[2];
        AddRuleTest.assertSegmentsLengthAndPos(endNode0, 2, wm);
        AddRuleTest.assertSegmentsLengthAndPos(endNode1, 2, wm);
        AddRuleTest.assertSegmentsLengthAndPos(endNode2, 2, wm);
    }

    private static void addRuleAtGivenSplit(InternalKnowledgeBase kbase1, InternalWorkingMemory wm, BetaNode cbeta, ObjectTypeNode yotn) {
        RuleImpl rule = new RuleImpl("newrule1");
        BuildContext buildContext = new BuildContext((RuleBase)kbase1, Collections.emptyList());
        JoinNode joinNode = (JoinNode)BetaNodeBuilder.create(181, buildContext).setLeftType(C.class).setBinding("object", "$object").setRightType(Y.class).setConstraint("object", "!=", "$object").build((LeftTupleSource)cbeta, (ObjectSource)yotn);
        joinNode.doAttach(buildContext);
        RuleTerminalNode rtn = new RuleTerminalNode(buildContext.getNextNodeId(), (LeftTupleSource)joinNode, rule, new GroupElement(), 0, buildContext);
        rtn.setPathEndNodes(new PathEndNode[]{rtn});
        rtn.doAttach(buildContext);
        Arrays.stream(rtn.getPathNodes()).forEach(n -> {
            n.addAssociatedTerminal((TerminalNode)rtn);
            ((BaseNode)n).addAssociation((Rule)rule);
        });
        new EagerPhreakBuilder().addRule((TerminalNode)rtn, Collections.singletonList(wm), (RuleBase)kbase1);
    }

    @Test
    public void testAddWithSplitAndEvalThenCreateThirdSplit() {
        if (!PhreakBuilder.isEagerSegmentCreation()) {
            return;
        }
        InternalKnowledgeBase kbase1 = this.buildKnowledgeBase("r", "   a : A() B() C() eval(1==1) eval(2==2) E(3;) E(4;)\n", "   A() B() C() X()\n");
        InternalWorkingMemory wm = (InternalWorkingMemory)kbase1.newKieSession();
        ObjectTypeNode aotn = this.getObjectTypeNode(kbase1.getRete(), A.class);
        ObjectTypeNode cotn = this.getObjectTypeNode(kbase1.getRete(), C.class);
        ObjectTypeNode eotn = this.getObjectTypeNode(kbase1.getRete(), E.class);
        LeftInputAdapterNode lian = (LeftInputAdapterNode)aotn.getSinks()[0];
        BetaNode cbeta = (BetaNode)cotn.getSinks()[0];
        BetaNode ebeta3 = (BetaNode)eotn.getSinks()[0].getSinks()[0];
        EvalConditionNode evnode = (EvalConditionNode)cbeta.getSinks()[0];
        AddRuleTest.insertAndFlush(wm);
        SegmentMemory smem = ((LeftInputAdapterNode.LiaNodeMemory)wm.getNodeMemories().getNodeMemory((MemoryFactory)lian, (ReteEvaluator)wm)).getSegmentMemory();
        SegmentMemory.SegmentPrototype smemProto0 = kbase1.getSegmentPrototype((LeftTupleNode)lian);
        PathEndNode endNode1 = smemProto0.getPathEndNodes()[1];
        AddRuleTest.assertSegmentsLengthAndPos(endNode1, 2, wm);
        SegmentMemory.SegmentPrototype smemProtoEV = kbase1.getSegmentPrototype((LeftTupleNode)evnode);
        Assertions.assertThat((int)smemProtoEV.getNodesInSegment().length).isEqualTo(5);
        Assertions.assertThat((int)smemProtoEV.getPos()).isEqualTo(1);
        Assertions.assertThat((long)smemProtoEV.getAllLinkedMaskTest()).isEqualTo(12L);
        SegmentMemory.SegmentPrototype[] oldSmemProtos = endNode1.getSegmentPrototypes();
        SegmentMemory.SegmentPrototype smemProtoE4 = EagerPhreakBuilder.Add.processSplit((LeftTupleNode)ebeta3, (RuleBase)kbase1, Collections.singletonList(wm), new HashSet());
        AddRuleTest.assertSegmentsLengthAndPos(endNode1, 2, oldSmemProtos, smemProtoE4, wm);
        Assertions.assertThat((long)smemProtoEV.getSegmentPosMaskBit()).isEqualTo(2L);
        Assertions.assertThat((long)smemProtoE4.getSegmentPosMaskBit()).isEqualTo(4L);
        Assertions.assertThat((long)smemProtoEV.getAllLinkedMaskTest()).isEqualTo(4L);
        Assertions.assertThat((long)smemProtoE4.getAllLinkedMaskTest()).isEqualTo(1L);
    }

    @Test
    public void testChildProtosPosAndEndNodeSegmentsUpdated() {
        if (!PhreakBuilder.isEagerSegmentCreation()) {
            return;
        }
        InternalKnowledgeBase kbase1 = this.buildKnowledgeBase("r", "   a : A() B() B(1;) C(1;) X() X(1;) X(2;) E()\n", "   a : A() B() B(1;) C(1;) X() X(1;) X(3;)\n", "   a : A() B() B(1;) C(2;)\n");
        InternalWorkingMemory wm = (InternalWorkingMemory)kbase1.newKieSession();
        ObjectTypeNode aotn = this.getObjectTypeNode(kbase1.getRete(), A.class);
        ObjectTypeNode botn = this.getObjectTypeNode(kbase1.getRete(), B.class);
        LeftInputAdapterNode lian = (LeftInputAdapterNode)aotn.getSinks()[0];
        BetaNode bbeta = (BetaNode)botn.getSinks()[0];
        AddRuleTest.insertAndFlush(wm);
        SegmentMemory.SegmentPrototype smemProto0 = kbase1.getSegmentPrototype((LeftTupleNode)lian);
        PathEndNode endNode0 = smemProto0.getPathEndNodes()[0];
        Assertions.assertThat((long)endNode0.getPathMemSpec().allLinkedTestMask()).isEqualTo(7L);
        Assertions.assertThat((int)endNode0.getPathMemSpec().smemCount()).isEqualTo(3);
        AddRuleTest.assertSegmentsLengthAndPos(endNode0, 3, wm);
        SegmentMemory.SegmentPrototype[] oldSmemProtos = endNode0.getSegmentPrototypes();
        SegmentMemory.SegmentPrototype smemProto1 = EagerPhreakBuilder.Add.processSplit((LeftTupleNode)bbeta, (RuleBase)kbase1, Collections.singletonList(wm), new HashSet());
        AddRuleTest.assertSegmentsLengthAndPos(endNode0, 4, oldSmemProtos, smemProto1, wm);
        Assertions.assertThat((long)endNode0.getPathMemSpec().allLinkedTestMask()).isEqualTo(15L);
        Assertions.assertThat((int)endNode0.getPathMemSpec().smemCount()).isEqualTo(4);
    }

    @Test
    public void testDataStructuresWithSubnetwork() {
        if (!PhreakBuilder.isEagerSegmentCreation()) {
            return;
        }
        InternalKnowledgeBase kbase1 = this.buildKnowledgeBase("r", "   a : A() B() exists ( C() and C(1;) ) E() X()\n");
        InternalWorkingMemory wm = (InternalWorkingMemory)kbase1.newKieSession();
        ObjectTypeNode aotn = this.getObjectTypeNode(kbase1.getRete(), A.class);
        ObjectTypeNode botn = this.getObjectTypeNode(kbase1.getRete(), B.class);
        LeftInputAdapterNode lian = (LeftInputAdapterNode)aotn.getSinks()[0];
        AddRuleTest.insertAndFlush(wm);
        SegmentMemory.SegmentPrototype smemProto0 = kbase1.getSegmentPrototype((LeftTupleNode)lian);
        PathEndNode endNode0 = smemProto0.getPathEndNodes()[0];
        Assertions.assertThat((short)endNode0.getType()).isEqualTo((short)71);
        Assertions.assertThat((long)endNode0.getPathMemSpec().allLinkedTestMask()).isEqualTo(2L);
        Assertions.assertThat((int)endNode0.getPathMemSpec().smemCount()).isEqualTo(2);
        PathEndNode endNode1 = smemProto0.getPathEndNodes()[1];
        Assertions.assertThat((short)endNode1.getType()).isEqualTo((short)101);
        Assertions.assertThat((long)endNode1.getPathMemSpec().allLinkedTestMask()).isEqualTo(3L);
        Assertions.assertThat((int)endNode1.getPathMemSpec().smemCount()).isEqualTo(2);
    }

    @Test
    public void testFindNewBrancheRootsSimple() {
        InternalKnowledgeBase kbase1 = this.buildKnowledgeBase("r", "   a : A() B() C() E()\n", "   a : A() B() X() E()\n");
        ObjectTypeNode cotn = this.getObjectTypeNode(kbase1.getRete(), C.class);
        ObjectTypeNode xotn = this.getObjectTypeNode(kbase1.getRete(), X.class);
        BetaNode cBeta = (BetaNode)cotn.getSinks()[0];
        BetaNode xBeta = (BetaNode)xotn.getSinks()[0];
        TerminalNode[] tns = kbase1.getReteooBuilder().getTerminalNodes("org.kie.r0");
        Assertions.assertThat((int)tns.length).isEqualTo(1);
        List branchRoots = EagerPhreakBuilder.getExclusiveBranchRoots((TerminalNode)tns[0]);
        Assertions.assertThat((int)branchRoots.size()).isEqualTo(1);
        Assertions.assertThat((Object)((EagerPhreakBuilder.Pair)branchRoots.toArray()[0]).child).isSameAs((Object)cBeta);
        tns = kbase1.getReteooBuilder().getTerminalNodes("org.kie.r1");
        Assertions.assertThat((int)tns.length).isEqualTo(1);
        branchRoots = EagerPhreakBuilder.getExclusiveBranchRoots((TerminalNode)tns[0]);
        Assertions.assertThat((int)branchRoots.size()).isEqualTo(1);
        Assertions.assertThat((Object)((EagerPhreakBuilder.Pair)branchRoots.toArray()[0]).child).isSameAs((Object)xBeta);
    }

    @Test
    public void testNewBrancheRootsWithSubnetwork() {
        InternalKnowledgeBase kbase1 = this.buildKnowledgeBase("r", "   a : A() B(1;) C() E() X()\n", "   a : A() B(1;) C() exists ( E() and F() ) B(2;)\n");
        ObjectTypeNode cotn = this.getObjectTypeNode(kbase1.getRete(), C.class);
        ObjectTypeNode fotn = this.getObjectTypeNode(kbase1.getRete(), F.class);
        ObjectTypeNode xotn = this.getObjectTypeNode(kbase1.getRete(), X.class);
        ObjectTypeNode botn = this.getObjectTypeNode(kbase1.getRete(), B.class);
        BetaNode fBeta = (BetaNode)fotn.getSinks()[0];
        BetaNode xBeta = (BetaNode)xotn.getSinks()[0];
        ExistsNode exists = (ExistsNode)((LeftTupleNode)botn.getSinks()[1].getSinks()[0]).getLeftTupleSource();
        TerminalNode[] tns = kbase1.getReteooBuilder().getTerminalNodes("org.kie.r0");
        Assertions.assertThat((int)tns.length).isEqualTo(1);
        List branchRoots = EagerPhreakBuilder.getExclusiveBranchRoots((TerminalNode)tns[0]);
        Assertions.assertThat((int)branchRoots.size()).isEqualTo(1);
        EagerPhreakBuilder.Pair[] pairs = branchRoots.toArray(new EagerPhreakBuilder.Pair[1]);
        Assertions.assertThat((Object)pairs[0].child).isSameAs((Object)xBeta);
        tns = kbase1.getReteooBuilder().getTerminalNodes("org.kie.r1");
        Assertions.assertThat((int)tns.length).isEqualTo(1);
        branchRoots = EagerPhreakBuilder.getExclusiveBranchRoots((TerminalNode)tns[0]);
        Assertions.assertThat((int)branchRoots.size()).isEqualTo(2);
        Assertions.assertThat((Object)((EagerPhreakBuilder.Pair)branchRoots.toArray()[0]).child).isSameAs((Object)exists);
        Assertions.assertThat((Object)((EagerPhreakBuilder.Pair)branchRoots.toArray()[1]).child).isSameAs((Object)fBeta);
    }

    private static void insertAndFlush(InternalWorkingMemory wm) {
        wm.insert((Object)new A(1));
        wm.insert((Object)new B(1));
        wm.insert((Object)new B(2));
        wm.insert((Object)new C(1));
        wm.insert((Object)new C(2));
        wm.insert((Object)new E(1));
        wm.insert((Object)new E(2));
        wm.insert((Object)new E(3));
        wm.insert((Object)new E(4));
        wm.insert((Object)new X(1));
        wm.insert((Object)new Y(1));
        wm.setGlobal("list", new ArrayList());
        wm.flushPropagations();
    }

    private static void assertSegmentsLengthAndPos(PathEndNode endNode, int s, InternalWorkingMemory wm) {
        AddRuleTest.assertSegmentsLengthAndPos(endNode, s, null, null, wm);
    }

    private static void assertSegmentsLengthAndPos(PathEndNode endNode, int s, SegmentMemory.SegmentPrototype[] oldProtos, SegmentMemory.SegmentPrototype newProto, InternalWorkingMemory wm) {
        SegmentMemory.SegmentPrototype proto;
        int i;
        int i2;
        Assertions.assertThat((int)endNode.getSegmentPrototypes().length).isEqualTo(s);
        int smemOffset = 0;
        int bitPos = 1;
        for (i2 = 0; i2 < endNode.getSegmentPrototypes().length; ++i2) {
            Assertions.assertThat((int)endNode.getSegmentPrototypes()[i2].getPos()).isEqualTo(i2);
            Assertions.assertThat((long)endNode.getSegmentPrototypes()[i2].getSegmentPosMaskBit()).isEqualTo((long)bitPos);
            bitPos <<= 1;
        }
        if (oldProtos != null) {
            for (i2 = 0; i2 < endNode.getSegmentPrototypes().length; ++i2) {
                if (i2 == newProto.getPos()) {
                    Assertions.assertThat((Object)newProto).isSameAs((Object)endNode.getSegmentPrototypes()[newProto.getPos()]);
                    smemOffset = 1;
                    continue;
                }
                Assertions.assertThat((Object)oldProtos[i2 - smemOffset]).isSameAs((Object)endNode.getSegmentPrototypes()[i2]);
            }
        }
        SegmentMemory.SegmentPrototype startProto = wm.getKnowledgeBase().getSegmentPrototype((LeftTupleNode)endNode.getStartTupleSource());
        for (i = 0; i < startProto.getPos(); ++i) {
            Assertions.assertThat((Object)endNode.getSegmentPrototypes()[i]).isNull();
        }
        for (i = 0; i < endNode.getSegmentPrototypes().length; ++i) {
            proto = endNode.getSegmentPrototypes()[i];
            if (proto == null) continue;
            Arrays.asList(proto.getPathEndNodes()).contains(endNode);
        }
        if (wm == null) {
            return;
        }
        for (i = 0; i < endNode.getSegmentPrototypes().length; ++i) {
            proto = endNode.getSegmentPrototypes()[i];
            Memory m = wm.getNodeMemories().peekNodeMemory((NetworkNode)proto.getRootNode());
            SegmentMemory sm = m.getSegmentMemory();
            Assertions.assertThat((Object)sm.getSegmentPrototype()).isSameAs((Object)proto);
            Assertions.assertThat((Object)sm.getRootNode()).isSameAs((Object)proto.getRootNode());
            Assertions.assertThat((Object)sm.getTipNode()).isSameAs((Object)proto.getTipNode());
            Assertions.assertThat((int)sm.getPos()).isEqualTo(proto.getPos());
            Assertions.assertThat((long)sm.getAllLinkedMaskTest()).isEqualTo(proto.getAllLinkedMaskTest());
            Assertions.assertThat((long)sm.getSegmentPosMaskBit()).isEqualTo(proto.getSegmentPosMaskBit());
        }
    }

    @Test
    public void testPopulatedSingleRuleNoSharing() {
        KieServices ks = KieServices.get();
        KieContainer kieContainer = KieUtil.getKieContainerFromDrls((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (KieSessionTestConfiguration)KieSessionTestConfiguration.STATEFUL_PSEUDO, (String[])new String[0]);
        InternalWorkingMemory wm = (InternalWorkingMemory)kieContainer.newKieSession();
        wm.insert((Object)new A(1));
        wm.insert((Object)new B(1));
        wm.insert((Object)new C(1));
        wm.insert((Object)new C(2));
        wm.insert((Object)new X(1));
        wm.insert((Object)new E(1));
        wm.fireAllRules();
        String rule = this.buildKnowledgePackageDrl("r1", "   A() B() C(object == 2) X() E()\n");
        ReleaseId releaseId2 = ks.newReleaseId("org.kie", "testPopulatedSingleRuleNoSharing", "2.0.0");
        KieUtil.getKieModuleFromDrls((ReleaseId)releaseId2, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (KieSessionTestConfiguration)KieSessionTestConfiguration.STATEFUL_PSEUDO, new HashMap(), (String[])new String[]{rule});
        kieContainer.updateToVersion(releaseId2);
        ArrayList list = new ArrayList();
        wm.setGlobal("list", list);
        ObjectTypeNode aotn = this.getObjectTypeNode(wm.getKnowledgeBase().getRete(), A.class);
        LeftInputAdapterNode liaNode = (LeftInputAdapterNode)aotn.getObjectSinkPropagator().getSinks()[0];
        LeftInputAdapterNode.LiaNodeMemory lm = (LeftInputAdapterNode.LiaNodeMemory)wm.getNodeMemory((MemoryFactory)liaNode);
        SegmentMemory sm = lm.getSegmentMemory();
        Assertions.assertThat((Object)((LeftTuple)sm.getStagedLeftTuples().getInsertFirst())).isNotNull();
        wm.fireAllRules();
        Assertions.assertThat((Object)((LeftTuple)sm.getStagedLeftTuples().getInsertFirst())).isNull();
        Assertions.assertThat((int)list.size()).isEqualTo(1);
        Assertions.assertThat((String)((Match)list.get(0)).getRule().getName()).isEqualTo("r1");
    }

    @Test
    public void testPopulatedSingleRuleNoSharingWithSubnetworkAtStart() throws Exception {
        KieServices ks = KieServices.get();
        KieContainer kieContainer = KieUtil.getKieContainerFromDrls((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (KieSessionTestConfiguration)KieSessionTestConfiguration.STATEFUL_PSEUDO, (String[])new String[0]);
        InternalWorkingMemory wm = (InternalWorkingMemory)kieContainer.newKieSession();
        wm.insert((Object)new A(1));
        wm.insert((Object)new A(2));
        wm.insert((Object)new X(1));
        wm.insert((Object)new E(1));
        wm.insert((Object)new C(2));
        wm.fireAllRules();
        String rule = this.buildKnowledgePackageDrl("r1", "   A() not( B() and C() ) X() E()\n");
        ReleaseId releaseId2 = ks.newReleaseId("org.kie", "testPopulatedSingleRuleNoSharingWithSubnetworkAtStart", "2.0.0");
        KieUtil.getKieModuleFromDrls((ReleaseId)releaseId2, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (KieSessionTestConfiguration)KieSessionTestConfiguration.STATEFUL_PSEUDO, new HashMap(), (String[])new String[]{rule});
        kieContainer.updateToVersion(releaseId2);
        ArrayList list = new ArrayList();
        wm.setGlobal("list", list);
        ObjectTypeNode aotn = this.getObjectTypeNode(wm.getKnowledgeBase().getRete(), A.class);
        LeftInputAdapterNode liaNode = (LeftInputAdapterNode)aotn.getObjectSinkPropagator().getSinks()[0];
        LeftInputAdapterNode.LiaNodeMemory lm = (LeftInputAdapterNode.LiaNodeMemory)wm.getNodeMemory((MemoryFactory)liaNode);
        SegmentMemory sm = lm.getSegmentMemory();
        Assertions.assertThat((Object)((LeftTuple)sm.getStagedLeftTuples().getInsertFirst())).isNull();
        SegmentMemory subSm = (SegmentMemory)sm.getFirst();
        SegmentMemory mainSm = subSm.getNext();
        Assertions.assertThat((Object)((LeftTuple)subSm.getStagedLeftTuples().getInsertFirst())).isNotNull();
        Assertions.assertThat((Object)((LeftTuple)subSm.getStagedLeftTuples().getInsertFirst()).getStagedNext()).isNotNull();
        Assertions.assertThat((Object)((LeftTuple)subSm.getStagedLeftTuples().getInsertFirst()).getStagedNext().getStagedNext()).isNull();
        Assertions.assertThat((Object)((LeftTuple)mainSm.getStagedLeftTuples().getInsertFirst())).isNotNull();
        Assertions.assertThat((Object)((LeftTuple)mainSm.getStagedLeftTuples().getInsertFirst()).getStagedNext()).isNotNull();
        Assertions.assertThat((Object)((LeftTuple)mainSm.getStagedLeftTuples().getInsertFirst()).getStagedNext().getStagedNext()).isNull();
        wm.fireAllRules();
        Assertions.assertThat((Object)((LeftTuple)subSm.getStagedLeftTuples().getInsertFirst())).isNull();
        Assertions.assertThat((Object)((LeftTuple)mainSm.getStagedLeftTuples().getInsertFirst())).isNull();
        Assertions.assertThat((int)list.size()).isEqualTo(2);
        Assertions.assertThat((String)((Match)list.get(0)).getRule().getName()).isEqualTo("r1");
    }

    @Test
    public void testPopulatedRuleMidwayShare() throws Exception {
        InternalKnowledgeBase kbase1 = this.buildKnowledgeBase("r1", "   a : A() B() C(1;) X() E()\n");
        InternalWorkingMemory wm = (InternalWorkingMemory)kbase1.newKieSession();
        ArrayList list = new ArrayList();
        wm.setGlobal("list", list);
        wm.insert((Object)new A(1));
        wm.insert((Object)new A(2));
        wm.insert((Object)new A(3));
        wm.insert((Object)new B(1));
        wm.insert((Object)new C(1));
        wm.insert((Object)new C(2));
        wm.insert((Object)new X(1));
        wm.insert((Object)new E(1));
        wm.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(3);
        kbase1.addPackages(this.buildKnowledgePackage("r2", "   a : A() B() C(2;) X() E()\n"));
        ObjectTypeNode aotn = this.getObjectTypeNode((KieBase)kbase1, A.class);
        LeftInputAdapterNode liaNode = (LeftInputAdapterNode)aotn.getObjectSinkPropagator().getSinks()[0];
        JoinNode bNode = (JoinNode)liaNode.getSinkPropagator().getFirstLeftTupleSink();
        JoinNode c1Node = (JoinNode)bNode.getSinkPropagator().getFirstLeftTupleSink();
        JoinNode c2Node = (JoinNode)bNode.getSinkPropagator().getLastLeftTupleSink();
        LeftInputAdapterNode.LiaNodeMemory lm = (LeftInputAdapterNode.LiaNodeMemory)wm.getNodeMemory((MemoryFactory)liaNode);
        SegmentMemory sm = lm.getSegmentMemory();
        BetaMemory c1Mem = (BetaMemory)wm.getNodeMemory((MemoryFactory)c1Node);
        Assertions.assertThat((Object)c1Mem.getSegmentMemory()).isSameAs((Object)sm.getFirst());
        Assertions.assertThat((int)c1Mem.getLeftTupleMemory().size()).isEqualTo(3);
        Assertions.assertThat((int)c1Mem.getRightTupleMemory().size()).isEqualTo(1);
        BetaMemory c2Mem = (BetaMemory)wm.getNodeMemory((MemoryFactory)c2Node);
        SegmentMemory c2Smem = ((SegmentMemory)sm.getFirst()).getNext();
        Assertions.assertThat((Object)c2Mem.getSegmentMemory()).isSameAs((Object)c2Smem);
        Assertions.assertThat((int)c2Mem.getLeftTupleMemory().size()).isEqualTo(0);
        Assertions.assertThat((int)c2Mem.getRightTupleMemory().size()).isEqualTo(0);
        Assertions.assertThat((Object)((LeftTuple)c2Smem.getStagedLeftTuples().getInsertFirst())).isNotNull();
        Assertions.assertThat((Object)((LeftTuple)c2Smem.getStagedLeftTuples().getInsertFirst()).getStagedNext()).isNotNull();
        Assertions.assertThat((Object)((LeftTuple)c2Smem.getStagedLeftTuples().getInsertFirst()).getStagedNext().getStagedNext()).isNotNull();
        Assertions.assertThat((Object)((LeftTuple)c2Smem.getStagedLeftTuples().getInsertFirst()).getStagedNext().getStagedNext().getStagedNext()).isNull();
        wm.fireAllRules();
        Assertions.assertThat((int)c2Mem.getLeftTupleMemory().size()).isEqualTo(3);
        Assertions.assertThat((int)c2Mem.getRightTupleMemory().size()).isEqualTo(1);
        Assertions.assertThat((Object)((LeftTuple)c2Smem.getStagedLeftTuples().getInsertFirst())).isNull();
        Assertions.assertThat((int)list.size()).isEqualTo(6);
        Assertions.assertThat((String)((Match)list.get(0)).getRule().getName()).isEqualTo("r1");
        Assertions.assertThat((String)((Match)list.get(1)).getRule().getName()).isEqualTo("r1");
        Assertions.assertThat((String)((Match)list.get(2)).getRule().getName()).isEqualTo("r1");
        Assertions.assertThat((String)((Match)list.get(3)).getRule().getName()).isEqualTo("r2");
        Assertions.assertThat((Object)((A)((Match)list.get(3)).getDeclarationValue("a")).getObject()).isEqualTo((Object)3);
        Assertions.assertThat((String)((Match)list.get(4)).getRule().getName()).isEqualTo("r2");
        Assertions.assertThat((Object)((A)((Match)list.get(4)).getDeclarationValue("a")).getObject()).isEqualTo((Object)2);
        Assertions.assertThat((String)((Match)list.get(5)).getRule().getName()).isEqualTo("r2");
        Assertions.assertThat((Object)((A)((Match)list.get(5)).getDeclarationValue("a")).getObject()).isEqualTo((Object)1);
    }

    @Test
    public void testPopulatedRuleWithEvals() throws Exception {
        InternalKnowledgeBase kbase1 = this.buildKnowledgeBase("r1", "   a:A() B() eval(1==1) eval(1==1) C(1;) \n");
        InternalWorkingMemory wm = (InternalWorkingMemory)kbase1.newKieSession();
        ArrayList list = new ArrayList();
        wm.setGlobal("list", list);
        wm.insert((Object)new A(1));
        wm.insert((Object)new A(2));
        wm.insert((Object)new A(3));
        wm.insert((Object)new B(1));
        wm.insert((Object)new C(1));
        wm.insert((Object)new C(2));
        wm.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(3);
        kbase1.addPackages(this.buildKnowledgePackage("r2", "   a:A() B() eval(1==1) eval(1==1) C(2;) \n"));
        ObjectTypeNode aotn = this.getObjectTypeNode((KieBase)kbase1, A.class);
        LeftInputAdapterNode liaNode = (LeftInputAdapterNode)aotn.getObjectSinkPropagator().getSinks()[0];
        JoinNode bNode = (JoinNode)liaNode.getSinkPropagator().getFirstLeftTupleSink();
        EvalConditionNode e1 = (EvalConditionNode)bNode.getSinkPropagator().getFirstLeftTupleSink();
        EvalConditionNode e2 = (EvalConditionNode)e1.getSinkPropagator().getFirstLeftTupleSink();
        JoinNode c1Node = (JoinNode)e2.getSinkPropagator().getFirstLeftTupleSink();
        JoinNode c2Node = (JoinNode)e2.getSinkPropagator().getLastLeftTupleSink();
        LeftInputAdapterNode.LiaNodeMemory lm = (LeftInputAdapterNode.LiaNodeMemory)wm.getNodeMemory((MemoryFactory)liaNode);
        SegmentMemory sm = lm.getSegmentMemory();
        BetaMemory c1Mem = (BetaMemory)wm.getNodeMemory((MemoryFactory)c1Node);
        Assertions.assertThat((Object)c1Mem.getSegmentMemory()).isSameAs((Object)sm.getFirst());
        Assertions.assertThat((int)c1Mem.getLeftTupleMemory().size()).isEqualTo(3);
        Assertions.assertThat((int)c1Mem.getRightTupleMemory().size()).isEqualTo(1);
        BetaMemory c2Mem = (BetaMemory)wm.getNodeMemory((MemoryFactory)c2Node);
        SegmentMemory c2Smem = ((SegmentMemory)sm.getFirst()).getNext();
        Assertions.assertThat((Object)c2Mem.getSegmentMemory()).isSameAs((Object)c2Smem);
        Assertions.assertThat((int)c2Mem.getLeftTupleMemory().size()).isEqualTo(0);
        Assertions.assertThat((int)c2Mem.getRightTupleMemory().size()).isEqualTo(0);
        Assertions.assertThat((Object)((LeftTuple)c2Smem.getStagedLeftTuples().getInsertFirst())).isNotNull();
        Assertions.assertThat((Object)((LeftTuple)c2Smem.getStagedLeftTuples().getInsertFirst()).getStagedNext()).isNotNull();
        Assertions.assertThat((Object)((LeftTuple)c2Smem.getStagedLeftTuples().getInsertFirst()).getStagedNext().getStagedNext()).isNotNull();
        Assertions.assertThat((Object)((LeftTuple)c2Smem.getStagedLeftTuples().getInsertFirst()).getStagedNext().getStagedNext().getStagedNext()).isNull();
        wm.fireAllRules();
        Assertions.assertThat((int)c2Mem.getLeftTupleMemory().size()).isEqualTo(3);
        Assertions.assertThat((int)c2Mem.getRightTupleMemory().size()).isEqualTo(1);
        Assertions.assertThat((Object)((LeftTuple)c2Smem.getStagedLeftTuples().getInsertFirst())).isNull();
        Assertions.assertThat((int)list.size()).isEqualTo(6);
        Assertions.assertThat((String)((Match)list.get(0)).getRule().getName()).isEqualTo("r1");
        Assertions.assertThat((String)((Match)list.get(1)).getRule().getName()).isEqualTo("r1");
        Assertions.assertThat((String)((Match)list.get(2)).getRule().getName()).isEqualTo("r1");
        Assertions.assertThat((String)((Match)list.get(3)).getRule().getName()).isEqualTo("r2");
        Assertions.assertThat((Object)((A)((Match)list.get(3)).getDeclarationValue("a")).getObject()).isEqualTo((Object)3);
        Assertions.assertThat((String)((Match)list.get(4)).getRule().getName()).isEqualTo("r2");
        Assertions.assertThat((Object)((A)((Match)list.get(4)).getDeclarationValue("a")).getObject()).isEqualTo((Object)2);
        Assertions.assertThat((String)((Match)list.get(5)).getRule().getName()).isEqualTo("r2");
        Assertions.assertThat((Object)((A)((Match)list.get(5)).getDeclarationValue("a")).getObject()).isEqualTo((Object)1);
    }

    @Test
    public void testPopulatedSharedLiaNode() throws Exception {
        InternalKnowledgeBase kbase1 = this.buildKnowledgeBase("r1", "   A() B(1;) C() X() E()\n");
        InternalWorkingMemory wm = (InternalWorkingMemory)kbase1.newKieSession();
        ArrayList list = new ArrayList();
        wm.setGlobal("list", list);
        wm.insert((Object)new A(1));
        wm.insert((Object)new A(2));
        wm.insert((Object)new A(3));
        wm.insert((Object)new B(1));
        wm.insert((Object)new B(2));
        wm.insert((Object)new C(1));
        wm.insert((Object)new X(1));
        wm.insert((Object)new E(1));
        wm.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(3);
        kbase1.addPackages(this.buildKnowledgePackage("r2", "   a : A() B(2;) C() X() E()\n"));
        ObjectTypeNode aotn = this.getObjectTypeNode((KieBase)kbase1, A.class);
        LeftInputAdapterNode liaNode = (LeftInputAdapterNode)aotn.getObjectSinkPropagator().getSinks()[0];
        JoinNode bNode1 = (JoinNode)liaNode.getSinkPropagator().getFirstLeftTupleSink();
        JoinNode bNode2 = (JoinNode)liaNode.getSinkPropagator().getLastLeftTupleSink();
        BetaMemory bm = (BetaMemory)wm.getNodeMemory((MemoryFactory)bNode2);
        SegmentMemory sm = bm.getSegmentMemory();
        Assertions.assertThat((Object)((LeftTuple)sm.getStagedLeftTuples().getInsertFirst())).isNotNull();
        Assertions.assertThat((Object)((LeftTuple)sm.getStagedLeftTuples().getInsertFirst()).getStagedNext()).isNotNull();
        Assertions.assertThat((Object)((LeftTuple)sm.getStagedLeftTuples().getInsertFirst()).getStagedNext().getStagedNext()).isNotNull();
        Assertions.assertThat((Object)((LeftTuple)sm.getStagedLeftTuples().getInsertFirst()).getStagedNext().getStagedNext().getStagedNext()).isNull();
        wm.fireAllRules();
        Assertions.assertThat((Object)((LeftTuple)sm.getStagedLeftTuples().getInsertFirst())).isNull();
        Assertions.assertThat((int)list.size()).isEqualTo(6);
        Assertions.assertThat((String)((Match)list.get(0)).getRule().getName()).isEqualTo("r1");
        Assertions.assertThat((String)((Match)list.get(1)).getRule().getName()).isEqualTo("r1");
        Assertions.assertThat((String)((Match)list.get(2)).getRule().getName()).isEqualTo("r1");
        Assertions.assertThat((String)((Match)list.get(3)).getRule().getName()).isEqualTo("r2");
        Assertions.assertThat((String)((Match)list.get(4)).getRule().getName()).isEqualTo("r2");
        Assertions.assertThat((String)((Match)list.get(5)).getRule().getName()).isEqualTo("r2");
        ArrayList<Object> results = new ArrayList<Object>();
        results.add(((A)((Match)list.get(3)).getDeclarationValue("a")).getObject());
        results.add(((A)((Match)list.get(4)).getDeclarationValue("a")).getObject());
        results.add(((A)((Match)list.get(5)).getDeclarationValue("a")).getObject());
        Assertions.assertThat((boolean)results.containsAll(Arrays.asList(1, 2, 3))).isTrue();
    }

    @Test
    public void testPopulatedSharedToRtn() throws Exception {
        InternalKnowledgeBase kbase1 = this.buildKnowledgeBase("r1", "   A() B() C() X() E()\n");
        InternalWorkingMemory wm = (InternalWorkingMemory)kbase1.newKieSession();
        ArrayList list = new ArrayList();
        wm.setGlobal("list", list);
        wm.insert((Object)new A(1));
        wm.insert((Object)new A(2));
        wm.insert((Object)new B(1));
        wm.insert((Object)new C(1));
        wm.insert((Object)new X(1));
        wm.insert((Object)new E(1));
        wm.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(2);
        kbase1.addPackages(this.buildKnowledgePackage("r2", "   A() B() C() X() E()\n"));
        ObjectTypeNode eotn = this.getObjectTypeNode((KieBase)kbase1, E.class);
        JoinNode eNode = (JoinNode)eotn.getObjectSinkPropagator().getSinks()[0];
        RuleTerminalNode rtn = (RuleTerminalNode)eNode.getSinkPropagator().getLastLeftTupleSink();
        PathMemory pm = (PathMemory)wm.getNodeMemory((MemoryFactory)rtn);
        SegmentMemory sm = pm.getSegmentMemory();
        Assertions.assertThat((Object)((LeftTuple)sm.getStagedLeftTuples().getInsertFirst())).isNotNull();
        Assertions.assertThat((Object)((LeftTuple)sm.getStagedLeftTuples().getInsertFirst()).getStagedNext()).isNotNull();
        Assertions.assertThat((Object)((LeftTuple)sm.getStagedLeftTuples().getInsertFirst()).getStagedNext().getStagedNext()).isNull();
        wm.fireAllRules();
        Assertions.assertThat((Object)((LeftTuple)sm.getStagedLeftTuples().getInsertFirst())).isNull();
        Assertions.assertThat((int)list.size()).isEqualTo(4);
        Assertions.assertThat((String)((Match)list.get(0)).getRule().getName()).isEqualTo("r1");
        Assertions.assertThat((String)((Match)list.get(1)).getRule().getName()).isEqualTo("r1");
        Assertions.assertThat((String)((Match)list.get(2)).getRule().getName()).isEqualTo("r2");
        Assertions.assertThat((String)((Match)list.get(3)).getRule().getName()).isEqualTo("r2");
    }

    @Test
    public void testPopulatedMultipleShares() throws Exception {
        InternalKnowledgeBase kbase1 = this.buildKnowledgeBase("r1", "   A(1;)  A(2;) B(1;) B(2;) C(1;) X() E()\n");
        InternalWorkingMemory wm = (InternalWorkingMemory)kbase1.newKieSession();
        ArrayList list = new ArrayList();
        wm.setGlobal("list", list);
        wm.insert((Object)new A(1));
        wm.insert((Object)new A(2));
        wm.insert((Object)new A(2));
        wm.insert((Object)new A(3));
        wm.insert((Object)new B(1));
        wm.insert((Object)new B(2));
        wm.insert((Object)new C(1));
        wm.insert((Object)new C(2));
        wm.insert((Object)new X(1));
        wm.insert((Object)new E(1));
        wm.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(2);
        kbase1.addPackages(this.buildKnowledgePackage("r2", "   A(1;)  A(2;) B(1;) B(2;) C(2;) X() E()\n"));
        kbase1.addPackages(this.buildKnowledgePackage("r3", "   A(1;)  A(3;) B(1;) B(2;) C(2;) X() E()\n"));
        wm.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(5);
        Assertions.assertThat((long)list.stream().filter(m -> m.getRule().getName().equals("r1")).count()).isEqualTo(2L);
        Assertions.assertThat((long)list.stream().filter(m -> m.getRule().getName().equals("r2")).count()).isEqualTo(2L);
        Assertions.assertThat((long)list.stream().filter(m -> m.getRule().getName().equals("r3")).count()).isEqualTo(1L);
    }

    @Test
    public void testSplitTwoBeforeCreatedSegment() throws Exception {
        InternalKnowledgeBase kbase1 = this.buildKnowledgeBase("r1", "   A(1;)  A(2;) B(1;) B(2;) C(1;) C(2;) X(1;) X(2;) E(1;) E(2;)\n");
        kbase1.addPackages(this.buildKnowledgePackage("r2", "   A(1;)  A(2;) B(1;) B(2;) C(1;) C(2;) X(1;) X(2;) E(1;) E(2;)\n"));
        kbase1.addPackages(this.buildKnowledgePackage("r3", "   A(1;)  A(2;) B(1;) B(2;) C(1;) C(2;) X(1;) X(2;)\n"));
        kbase1.addPackages(this.buildKnowledgePackage("r4", "   A(1;)  A(2;) B(1;) B(2;) C(1;) C(2;) \n"));
        InternalWorkingMemory wm = (InternalWorkingMemory)kbase1.newKieSession();
        ArrayList list = new ArrayList();
        wm.setGlobal("list", list);
        wm.insert((Object)new E(1));
        wm.insert((Object)new E(2));
        wm.fireAllRules();
        RuleTerminalNode rtn1 = this.getRtn("org.kie.r1", (KieBase)kbase1);
        RuleTerminalNode rtn2 = this.getRtn("org.kie.r2", (KieBase)kbase1);
        RuleTerminalNode rtn3 = this.getRtn("org.kie.r3", (KieBase)kbase1);
        RuleTerminalNode rtn4 = this.getRtn("org.kie.r4", (KieBase)kbase1);
        PathMemory pm1 = (PathMemory)wm.getNodeMemory((MemoryFactory)rtn1);
        SegmentMemory[] smems = pm1.getSegmentMemories();
        Assertions.assertThat((int)smems.length).isEqualTo(4);
        Assertions.assertThat((Object)smems[0]).isNull();
        Assertions.assertThat((Object)smems[1]).isNull();
        Assertions.assertThat((Object)smems[3]).isNull();
        SegmentMemory sm = smems[2];
        Assertions.assertThat((int)sm.getPos()).isEqualTo(2);
        Assertions.assertThat((long)sm.getSegmentPosMaskBit()).isEqualTo(4L);
        Assertions.assertThat((long)pm1.getLinkedSegmentMask()).isEqualTo(4L);
        kbase1.addPackages(this.buildKnowledgePackage("r5", "   A(1;)  A(2;) B(1;) B(2;) \n"));
        smems = pm1.getSegmentMemories();
        Assertions.assertThat((int)smems.length).isEqualTo(5);
        Assertions.assertThat((Object)smems[0]).isNull();
        Assertions.assertThat((Object)smems[1]).isNull();
        Assertions.assertThat((Object)smems[2]).isNull();
        sm = smems[3];
        Assertions.assertThat((int)sm.getPos()).isEqualTo(3);
        Assertions.assertThat((long)sm.getSegmentPosMaskBit()).isEqualTo(8L);
        Assertions.assertThat((long)pm1.getLinkedSegmentMask()).isEqualTo(8L);
        RuleTerminalNode rtn5 = this.getRtn("org.kie.r5", (KieBase)kbase1);
        if (PhreakBuilder.isEagerSegmentCreation()) {
            PathMemory pm5 = (PathMemory)wm.getNodeMemories().peekNodeMemory(rtn5.getMemoryId());
            Assertions.assertThat((Object)pm5).isNull();
            Assertions.assertThat((int)rtn5.getSegmentPrototypes().length).isEqualTo(2);
        } else {
            PathMemory pm5 = (PathMemory)wm.getNodeMemories().peekNodeMemory(rtn5.getMemoryId());
            smems = pm5.getSegmentMemories();
            Assertions.assertThat((int)smems.length).isEqualTo(2);
            Assertions.assertThat((Object)smems[0]).isNull();
            Assertions.assertThat((Object)smems[1]).isNull();
        }
    }

    @Test
    public void testSplitOneBeforeCreatedSegment() throws Exception {
        InternalKnowledgeBase kbase1 = this.buildKnowledgeBase("r1", "   A(1;)  A(2;) B(1;) B(2;) C(1;) C(2;) X(1;) X(2;) E(1;) E(2;)\n");
        kbase1.addPackages(this.buildKnowledgePackage("r2", "   A(1;)  A(2;) B(1;) B(2;) C(1;) C(2;) X(1;) X(2;) E(1;) E(2;)\n"));
        kbase1.addPackages(this.buildKnowledgePackage("r3", "   A(1;)  A(2;) B(1;) B(2;) C(1;) C(2;) X(1;) X(2;)\n"));
        kbase1.addPackages(this.buildKnowledgePackage("r4", "   A(1;)  A(2;) B(1;) B(2;) C(1;) C(2;) \n"));
        InternalWorkingMemory wm = (InternalWorkingMemory)kbase1.newKieSession();
        ArrayList list = new ArrayList();
        wm.setGlobal("list", list);
        wm.insert((Object)new X(1));
        wm.insert((Object)new X(2));
        wm.flushPropagations();
        RuleTerminalNode rtn1 = this.getRtn("org.kie.r1", (KieBase)kbase1);
        RuleTerminalNode rtn2 = this.getRtn("org.kie.r2", (KieBase)kbase1);
        RuleTerminalNode rtn3 = this.getRtn("org.kie.r3", (KieBase)kbase1);
        RuleTerminalNode rtn4 = this.getRtn("org.kie.r4", (KieBase)kbase1);
        PathMemory pm1 = (PathMemory)wm.getNodeMemory((MemoryFactory)rtn1);
        SegmentMemory[] smems = pm1.getSegmentMemories();
        Assertions.assertThat((int)smems.length).isEqualTo(4);
        Assertions.assertThat((Object)smems[0]).isNull();
        Assertions.assertThat((Object)smems[2]).isNull();
        Assertions.assertThat((Object)smems[3]).isNull();
        SegmentMemory sm = smems[1];
        Assertions.assertThat((int)sm.getPos()).isEqualTo(1);
        Assertions.assertThat((long)sm.getSegmentPosMaskBit()).isEqualTo(2L);
        Assertions.assertThat((long)pm1.getLinkedSegmentMask()).isEqualTo(2L);
        PathMemory pm3 = (PathMemory)wm.getNodeMemory((MemoryFactory)rtn3);
        SegmentMemory[] smemsP3 = pm3.getSegmentMemories();
        Assertions.assertThat((int)smemsP3.length).isEqualTo(3);
        Assertions.assertThat((Object)smemsP3[0]).isNull();
        Assertions.assertThat((Object)smemsP3[2]).isNull();
        sm = smems[1];
        Assertions.assertThat((int)sm.getPos()).isEqualTo(1);
        Assertions.assertThat((long)sm.getSegmentPosMaskBit()).isEqualTo(2L);
        Assertions.assertThat((long)pm1.getLinkedSegmentMask()).isEqualTo(2L);
        kbase1.addPackages(this.buildKnowledgePackage("r5", "   A(1;)  A(2;) B(1;) B(2;) \n"));
        smems = pm1.getSegmentMemories();
        Assertions.assertThat((int)smems.length).isEqualTo(5);
        Assertions.assertThat((Object)smems[0]).isNull();
        Assertions.assertThat((Object)smems[1]).isNull();
        Assertions.assertThat((Object)smems[3]).isNull();
        Assertions.assertThat((Object)smems[4]).isNull();
        sm = smems[2];
        Assertions.assertThat((int)sm.getPos()).isEqualTo(2);
        Assertions.assertThat((long)sm.getSegmentPosMaskBit()).isEqualTo(4L);
        Assertions.assertThat((long)pm1.getLinkedSegmentMask()).isEqualTo(4L);
        smems = pm3.getSegmentMemories();
        Assertions.assertThat((int)smems.length).isEqualTo(4);
        Assertions.assertThat((Object)smems[0]).isNull();
        Assertions.assertThat((Object)smems[1]).isNull();
        Assertions.assertThat((Object)smems[3]).isNull();
        sm = smems[2];
        Assertions.assertThat((int)sm.getPos()).isEqualTo(2);
        Assertions.assertThat((long)sm.getSegmentPosMaskBit()).isEqualTo(4L);
        Assertions.assertThat((long)pm1.getLinkedSegmentMask()).isEqualTo(4L);
        RuleTerminalNode rtn5 = this.getRtn("org.kie.r5", (KieBase)kbase1);
        if (PhreakBuilder.isEagerSegmentCreation()) {
            PathMemory pm5 = (PathMemory)wm.getNodeMemories().peekNodeMemory(rtn5.getMemoryId());
            Assertions.assertThat((Object)pm5).isNull();
            Assertions.assertThat((int)rtn5.getSegmentPrototypes().length).isEqualTo(2);
        } else {
            PathMemory pm5 = (PathMemory)wm.getNodeMemories().peekNodeMemory(rtn5.getMemoryId());
            smems = pm5.getSegmentMemories();
            Assertions.assertThat((int)smems.length).isEqualTo(2);
            Assertions.assertThat((Object)smems[0]).isNull();
            Assertions.assertThat((Object)smems[1]).isNull();
        }
    }

    @Test
    public void testSplitOnCreatedSegment() throws Exception {
        InternalKnowledgeBase kbase1 = this.buildKnowledgeBase("r1", "   A(1;)  A(2;) B(1;) B(2;) C(1;) C(2;) X(1;) X(2;) E(1;) E(2;)\n");
        kbase1.addPackages(this.buildKnowledgePackage("r2", "   A(1;)  A(2;) B(1;) B(2;) C(1;) C(2;) X(1;) X(2;) E(1;) E(2;)\n"));
        kbase1.addPackages(this.buildKnowledgePackage("r3", "   A(1;)  A(2;) B(1;) B(2;) C(1;) C(2;) X(1;) X(2;)\n"));
        kbase1.addPackages(this.buildKnowledgePackage("r4", "   A(1;)  A(2;) B(1;) B(2;) C(1;) C(2;) \n"));
        InternalWorkingMemory wm = (InternalWorkingMemory)kbase1.newKieSession();
        ArrayList list = new ArrayList();
        wm.setGlobal("list", list);
        wm.insert((Object)new X(1));
        wm.insert((Object)new X(2));
        wm.insert((Object)new X(3));
        wm.flushPropagations();
        RuleTerminalNode rtn1 = this.getRtn("org.kie.r1", (KieBase)kbase1);
        PathMemory pm1 = (PathMemory)wm.getNodeMemory((MemoryFactory)rtn1);
        Assertions.assertThat((long)pm1.getLinkedSegmentMask()).isEqualTo(2L);
        SegmentMemory[] smems = pm1.getSegmentMemories();
        Assertions.assertThat((int)smems.length).isEqualTo(4);
        Assertions.assertThat((Object)smems[0]).isNull();
        Assertions.assertThat((Object)smems[2]).isNull();
        Assertions.assertThat((Object)smems[3]).isNull();
        SegmentMemory sm = smems[1];
        Assertions.assertThat((int)sm.getPos()).isEqualTo(1);
        Assertions.assertThat((long)sm.getSegmentPosMaskBit()).isEqualTo(2L);
        kbase1.addPackages(this.buildKnowledgePackage("r5", "   A(1;)  A(2;) B(1;) B(2;) C(1;) C(2;) X(1;) X(3;)\n"));
        wm.fireAllRules();
        Assertions.assertThat((long)pm1.getLinkedSegmentMask()).isEqualTo(6L);
        smems = pm1.getSegmentMemories();
        Assertions.assertThat((int)smems.length).isEqualTo(5);
        Assertions.assertThat((Object)smems[0]).isNull();
        Assertions.assertThat((Object)smems[3]).isNull();
        Assertions.assertThat((Object)smems[4]).isNull();
        sm = smems[1];
        Assertions.assertThat((int)sm.getPos()).isEqualTo(1);
        Assertions.assertThat((long)sm.getSegmentPosMaskBit()).isEqualTo(2L);
        sm = smems[2];
        Assertions.assertThat((int)sm.getPos()).isEqualTo(2);
        Assertions.assertThat((long)sm.getSegmentPosMaskBit()).isEqualTo(4L);
        RuleTerminalNode rtn5 = this.getRtn("org.kie.r5", (KieBase)kbase1);
        PathMemory pm5 = (PathMemory)wm.getNodeMemory((MemoryFactory)rtn5);
        Assertions.assertThat((long)pm5.getLinkedSegmentMask()).isEqualTo(6L);
        smems = pm5.getSegmentMemories();
        Assertions.assertThat((int)smems.length).isEqualTo(3);
        Assertions.assertThat((Object)smems[0]).isNull();
        sm = smems[1];
        Assertions.assertThat((int)sm.getPos()).isEqualTo(1);
        Assertions.assertThat((long)sm.getSegmentPosMaskBit()).isEqualTo(2L);
        sm = smems[2];
        Assertions.assertThat((int)sm.getPos()).isEqualTo(2);
        Assertions.assertThat((long)sm.getSegmentPosMaskBit()).isEqualTo(4L);
    }

    private RuleTerminalNode getRtn(String ruleName, KieBase kbase) {
        return (RuleTerminalNode)((RuleBase)kbase).getReteooBuilder().getTerminalNodes(ruleName)[0];
    }

    private InternalKnowledgeBase buildKnowledgeBase(String ruleName, String ... rule) {
        return (InternalKnowledgeBase)KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{this.buildKnowledgePackageDrl(ruleName, rule)});
    }

    private String buildKnowledgePackageDrl(String ruleName, String ... rule) {
        Object str = "";
        str = (String)str + "package org.kie \n";
        str = (String)str + "import " + A.class.getCanonicalName() + "\n";
        str = (String)str + "import " + B.class.getCanonicalName() + "\n";
        str = (String)str + "import " + C.class.getCanonicalName() + "\n";
        str = (String)str + "import " + E.class.getCanonicalName() + "\n";
        str = (String)str + "import " + F.class.getCanonicalName() + "\n";
        str = (String)str + "import " + X.class.getCanonicalName() + "\n";
        str = (String)str + "import " + Y.class.getCanonicalName() + "\n";
        str = (String)str + "global java.util.List list \n";
        for (int i = 0; i < rule.length; ++i) {
            str = (String)str + "rule " + (String)(rule.length == 1 ? ruleName : ruleName + i) + "  when \n";
            str = (String)str + rule[i];
            str = (String)str + "then \n";
            str = (String)str + " list.add( kcontext.getMatch() );\n";
            str = (String)str + "end \n";
        }
        return str;
    }

    private Collection<KiePackage> buildKnowledgePackage(String ruleName, String rule) {
        return KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"tmp", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{this.buildKnowledgePackageDrl(ruleName, rule)}).getKiePackages();
    }

    public ObjectTypeNode getObjectTypeNode(KieBase kbase, Class<?> nodeClass) {
        return this.getObjectTypeNode(((RuleBase)kbase).getRete(), nodeClass);
    }

    public ObjectTypeNode getObjectTypeNode(Rete rete, Class<?> nodeClass) {
        List nodes = rete.getObjectTypeNodes();
        for (ObjectTypeNode n : nodes) {
            if (((ClassObjectType)n.getObjectType()).getClassType() != nodeClass) continue;
            return n;
        }
        return null;
    }
}

