/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.rule;

import org.assertj.core.api.Assertions;
import org.drools.core.base.ClassObjectType;
import org.drools.core.base.ObjectType;
import org.drools.core.definitions.InternalKnowledgePackage;
import org.drools.core.facttemplates.Fact;
import org.drools.core.facttemplates.FactTemplate;
import org.drools.core.facttemplates.FactTemplateImpl;
import org.drools.core.facttemplates.FactTemplateObjectType;
import org.drools.core.facttemplates.FieldTemplate;
import org.drools.core.facttemplates.FieldTemplateImpl;
import org.drools.core.reteoo.CoreComponentFactory;
import org.drools.core.rule.Declaration;
import org.drools.core.rule.Pattern;
import org.drools.core.rule.accessor.ReadAccessor;
import org.drools.core.test.model.Cheese;
import org.junit.Test;

public class PatternTest {
    @Test
    public void testDeclarationsObjectType() throws Exception {
        ClassObjectType type = new ClassObjectType(Cheese.class);
        Pattern col = new Pattern(0, (ObjectType)type, "foo");
        Declaration dec = col.getDeclaration();
        ReadAccessor ext = dec.getExtractor();
        Assertions.assertThat((Class)ext.getExtractToClass()).isEqualTo(Cheese.class);
        Cheese stilton = new Cheese("stilton", 42);
        Assertions.assertThat((Object)dec.getValue(null, (Object)stilton)).isEqualTo((Object)stilton);
    }

    @Test
    public void testDeclarationsFactTemplate() throws Exception {
        InternalKnowledgePackage pkg = CoreComponentFactory.get().createKnowledgePackage("org.store");
        FieldTemplateImpl cheeseName = new FieldTemplateImpl("name", String.class);
        FieldTemplateImpl cheesePrice = new FieldTemplateImpl("price", Integer.class);
        FieldTemplate[] fields = new FieldTemplate[]{cheeseName, cheesePrice};
        FactTemplateImpl cheese = new FactTemplateImpl(pkg, "Cheese", fields);
        FactTemplateObjectType type = new FactTemplateObjectType((FactTemplate)cheese);
        Pattern col = new Pattern(0, (ObjectType)type, "foo");
        Declaration dec = col.getDeclaration();
        ReadAccessor ext = dec.getExtractor();
        Assertions.assertThat((Class)ext.getExtractToClass()).isEqualTo(Fact.class);
        Fact stilton = cheese.createFact();
        stilton.set("name", (Object)"stilton");
        stilton.set("price", (Object)200);
        Assertions.assertThat((Object)dec.getValue(null, (Object)stilton)).isEqualTo((Object)stilton);
    }
}

