/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.workitem;

import java.util.Map;
import java.util.Properties;
import org.assertj.core.api.Assertions;
import org.drools.core.FlowSessionConfiguration;
import org.drools.core.impl.EnvironmentFactory;
import org.drools.core.impl.RuleBaseFactory;
import org.drools.kiesession.rulebase.InternalKnowledgeBase;
import org.drools.kiesession.rulebase.KnowledgeBaseFactory;
import org.junit.Test;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.api.runtime.process.WorkItemManager;
import org.kie.internal.utils.ChainedProperties;

public class CustomWorkItemHandlerTest {
    @Test
    public void testRegisterHandlerWithKsessionUsingConfiguration() {
        InternalKnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        Properties props = new Properties();
        props.setProperty("drools.workItemHandlers", "CustomWorkItemHandlers.conf");
        ClassLoader cl = kbase.getConfiguration().getClassLoader();
        KieSessionConfiguration config = RuleBaseFactory.newKnowledgeSessionConfiguration((ChainedProperties)ChainedProperties.getChainedProperties((ClassLoader)cl).addProperties(props), (ClassLoader)cl);
        KieSession ksession = kbase.newKieSession(config, EnvironmentFactory.newEnvironment());
        Assertions.assertThat((Object)ksession).isNotNull();
        WorkItemManager manager = ksession.getWorkItemManager();
        Assertions.assertThat((Object)manager).isNotNull();
        Map handlers = ((FlowSessionConfiguration)config.as(FlowSessionConfiguration.KEY)).getWorkItemHandlers();
        Assertions.assertThat((Map)handlers).isNotNull();
        Assertions.assertThat((int)handlers.size()).isEqualTo(1);
        Assertions.assertThat((boolean)handlers.containsKey("Custom")).isTrue();
    }
}

