/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.integrationtests;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.assertj.core.api.Assertions;
import org.drools.core.event.DefaultAgendaEventListener;
import org.drools.core.impl.RuleBaseFactory;
import org.drools.testcoverage.common.model.Alarm;
import org.drools.testcoverage.common.model.Person;
import org.drools.testcoverage.common.model.Sensor;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.conf.Option;
import org.kie.api.event.rule.AgendaEventListener;
import org.kie.api.event.rule.MatchCancelledEvent;
import org.kie.api.event.rule.MatchCreatedEvent;
import org.kie.api.runtime.ClassObjectFilter;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.api.runtime.ObjectFilter;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.internal.runtime.conf.ForceEagerActivationOption;

@RunWith(value=Parameterized.class)
public class ActivateAndDeleteOnListenerTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public ActivateAndDeleteOnListenerTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    @Test
    public void testActivateOnMatchAndDelete() {
        this.testActivateOnMatch((AgendaEventListener)new DefaultAgendaEventListener(){

            public void matchCreated(MatchCreatedEvent event) {
                Collection alarms = event.getKieRuntime().getFactHandles((ObjectFilter)new ClassObjectFilter(Alarm.class));
                for (FactHandle alarm : alarms) {
                    event.getKieRuntime().delete(alarm);
                }
            }
        });
    }

    @Test
    public void testActivateOnMatchAndUpdate() {
        this.testActivateOnMatch((AgendaEventListener)new DefaultAgendaEventListener(){

            public void matchCreated(MatchCreatedEvent event) {
                Collection alarms = event.getKieRuntime().getFactHandles((ObjectFilter)new ClassObjectFilter(Alarm.class));
                for (FactHandle alarm : alarms) {
                    event.getKieRuntime().update(alarm, (Object)new Alarm());
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testActivateOnMatch(AgendaEventListener listener) {
        String drl = "package org.drools.compiler.integrationtests \nimport " + Alarm.class.getCanonicalName() + " \nimport " + Sensor.class.getCanonicalName() + " \nrule StringRule  @Propagation(EAGER) ruleflow-group \"DROOLS_SYSTEM\"\n when \n $a : Alarm() \n $s : Sensor() \n then \nend \n";
        KieSession ksession = this.getSessionWithEagerActivation(drl);
        try {
            ksession.addEventListener(listener);
            Alarm alarm = new Alarm();
            alarm.setMessage("test");
            alarm.setNumber(123);
            ksession.insert((Object)alarm);
            Sensor sensor = new Sensor();
            sensor.setPressure(1);
            sensor.setTemperature(25);
            ksession.insert((Object)sensor);
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEagerEvaluationWith2Paths() {
        String drl = "package org.simple \nrule xxx \nwhen \n  $s : String()\n  $i : Integer()\nthen \nend  \nrule yyy \nwhen \n  $s : String()\n  $i : Integer()\nthen \nend  \n";
        KieSession ksession = this.getSessionWithEagerActivation("package org.simple \nrule xxx \nwhen \n  $s : String()\n  $i : Integer()\nthen \nend  \nrule yyy \nwhen \n  $s : String()\n  $i : Integer()\nthen \nend  \n");
        try {
            final ArrayList list = new ArrayList();
            org.kie.api.event.rule.DefaultAgendaEventListener agendaEventListener = new org.kie.api.event.rule.DefaultAgendaEventListener(){

                public void matchCreated(MatchCreatedEvent event) {
                    list.add("activated");
                }

                public void matchCancelled(MatchCancelledEvent event) {
                    list.add("cancelled");
                }
            };
            ksession.addEventListener((AgendaEventListener)agendaEventListener);
            ksession.insert((Object)"test");
            Assertions.assertThat((int)list.size()).isEqualTo(0);
            FactHandle fh = ksession.insert((Object)1);
            Assertions.assertThat((int)list.size()).isEqualTo(2);
            Assertions.assertThat((String)((String)list.get(0))).isEqualTo("activated");
            Assertions.assertThat((String)((String)list.get(1))).isEqualTo("activated");
            list.clear();
            ksession.delete(fh);
            Assertions.assertThat((int)list.size()).isEqualTo(2);
            Assertions.assertThat((String)((String)list.get(0))).isEqualTo("cancelled");
            Assertions.assertThat((String)((String)list.get(1))).isEqualTo("cancelled");
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEagerEvaluationWith2SubPaths() {
        String drl = "package org.simple \nrule xxx \nwhen \n  $s : String()\n  exists( Integer() or Long() )\nthen \nend  \nrule yyy \nwhen \n  $s : String()\n  exists( Integer() or Long() )\nthen \nend  \n";
        KieSession ksession = this.getSessionWithEagerActivation("package org.simple \nrule xxx \nwhen \n  $s : String()\n  exists( Integer() or Long() )\nthen \nend  \nrule yyy \nwhen \n  $s : String()\n  exists( Integer() or Long() )\nthen \nend  \n");
        try {
            final ArrayList list = new ArrayList();
            org.kie.api.event.rule.DefaultAgendaEventListener agendaEventListener = new org.kie.api.event.rule.DefaultAgendaEventListener(){

                public void matchCreated(MatchCreatedEvent event) {
                    list.add("activated");
                }
            };
            ksession.addEventListener((AgendaEventListener)agendaEventListener);
            ksession.insert((Object)"test");
            Assertions.assertThat((int)list.size()).isEqualTo(0);
            ksession.insert((Object)1);
            Assertions.assertThat((int)list.size()).isEqualTo(2);
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOneLinkedAndOneUnlinkedPath() {
        String drl = "package org.simple \nrule xxx \nwhen \n  String()\n  Integer()\n  Long()\nthen \nend  \nrule yyy \nwhen \n  String()\n  Integer()\n  Boolean()\nthen \nend  \n";
        KieSession ksession = this.getSessionWithEagerActivation("package org.simple \nrule xxx \nwhen \n  String()\n  Integer()\n  Long()\nthen \nend  \nrule yyy \nwhen \n  String()\n  Integer()\n  Boolean()\nthen \nend  \n");
        try {
            final ArrayList list = new ArrayList();
            org.kie.api.event.rule.DefaultAgendaEventListener agendaEventListener = new org.kie.api.event.rule.DefaultAgendaEventListener(){

                public void matchCreated(MatchCreatedEvent event) {
                    list.add(event.getMatch().getRule().getName());
                }
            };
            ksession.addEventListener((AgendaEventListener)agendaEventListener);
            ksession.insert((Object)"test");
            Assertions.assertThat((int)list.size()).isEqualTo(0);
            ksession.insert((Object)Boolean.TRUE);
            Assertions.assertThat((int)list.size()).isEqualTo(0);
            ksession.insert((Object)1);
            Assertions.assertThat((int)list.size()).isEqualTo(1);
            Assertions.assertThat((String)((String)list.get(0))).isEqualTo("yyy");
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOneLazyAndOneImmediateSubPathFromLia() {
        String drl = "package org.simple \nrule xxx \nwhen \n  $s : String()\n  exists( Integer() or Long() )\nthen \nend  \nrule yyy \nwhen \n  $s : String()\n  exists( Integer() or Long() )\nthen \nend  \n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"activate-delete-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"package org.simple \nrule xxx \nwhen \n  $s : String()\n  exists( Integer() or Long() )\nthen \nend  \nrule yyy \nwhen \n  $s : String()\n  exists( Integer() or Long() )\nthen \nend  \n"});
        KieSessionConfiguration conf = RuleBaseFactory.newKnowledgeSessionConfiguration();
        conf.setOption((Option)new ForceEagerActivationOption.FILTERED(rule -> rule.getName().equals("yyy")));
        final ArrayList list = new ArrayList();
        org.kie.api.event.rule.DefaultAgendaEventListener agendaEventListener = new org.kie.api.event.rule.DefaultAgendaEventListener(){

            public void matchCreated(MatchCreatedEvent event) {
                list.add(event.getMatch().getRule().getName());
            }
        };
        KieSession ksession = kbase.newKieSession(conf, null);
        try {
            list.clear();
            ksession.addEventListener((AgendaEventListener)agendaEventListener);
            ksession.insert((Object)"test");
            Assertions.assertThat((int)list.size()).isEqualTo(0);
            ksession.insert((Object)1);
            Assertions.assertThat((int)list.size()).isEqualTo(1);
            Assertions.assertThat((String)((String)list.get(0))).isEqualTo("yyy");
            list.clear();
            ksession.fireAllRules();
            Assertions.assertThat((int)list.size()).isEqualTo(1);
            Assertions.assertThat((String)((String)list.get(0))).isEqualTo("xxx");
        }
        finally {
            ksession.dispose();
        }
        ksession = kbase.newKieSession(conf, null);
        try {
            list.clear();
            ksession.addEventListener((AgendaEventListener)agendaEventListener);
            ksession.insert((Object)"test");
            Assertions.assertThat((int)list.size()).isEqualTo(0);
            ksession.insert((Object)1L);
            Assertions.assertThat((int)list.size()).isEqualTo(1);
            Assertions.assertThat((String)((String)list.get(0))).isEqualTo("yyy");
            list.clear();
            ksession.fireAllRules();
            Assertions.assertThat((int)list.size()).isEqualTo(1);
            Assertions.assertThat((String)((String)list.get(0))).isEqualTo("xxx");
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOneLazyAndOneImmediateSubPathAfterLia() {
        String drl = "package org.simple \nglobal java.util.List list; \nrule xxx \nwhen \n  Integer(this == 0)\n  $s : String()\n  exists( ( Integer(this == 3) and eval(list.add(\"e1\"))) or (Long(this == 1) and eval(list.add(\"e2\"))) )\nthen \nend  \nrule yyy \nwhen \n  Integer(this == 0)\n  $s : String()\n  exists( ( Integer(this == 3) and eval(list.add(\"e1\"))) or (Long(this == 1) and eval(list.add(\"e2\"))) )\nthen \nend  \nrule zzz \nwhen \n  Integer(this == 0)\n  $s : String()\n  eval(1==1)\nthen \nend  \n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"activate-delete-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"package org.simple \nglobal java.util.List list; \nrule xxx \nwhen \n  Integer(this == 0)\n  $s : String()\n  exists( ( Integer(this == 3) and eval(list.add(\"e1\"))) or (Long(this == 1) and eval(list.add(\"e2\"))) )\nthen \nend  \nrule yyy \nwhen \n  Integer(this == 0)\n  $s : String()\n  exists( ( Integer(this == 3) and eval(list.add(\"e1\"))) or (Long(this == 1) and eval(list.add(\"e2\"))) )\nthen \nend  \nrule zzz \nwhen \n  Integer(this == 0)\n  $s : String()\n  eval(1==1)\nthen \nend  \n"});
        KieSessionConfiguration conf = RuleBaseFactory.newKnowledgeSessionConfiguration();
        conf.setOption((Option)new ForceEagerActivationOption.FILTERED(rule -> rule.getName().equals("yyy")));
        final ArrayList list = new ArrayList();
        org.kie.api.event.rule.DefaultAgendaEventListener agendaEventListener = new org.kie.api.event.rule.DefaultAgendaEventListener(){

            public void matchCreated(MatchCreatedEvent event) {
                list.add(event.getMatch().getRule().getName());
            }
        };
        KieSession ksession = kbase.newKieSession(conf, null);
        try {
            list.clear();
            ksession.setGlobal("list", list);
            ksession.addEventListener((AgendaEventListener)agendaEventListener);
            ksession.insert((Object)"test");
            Assertions.assertThat((int)list.size()).isEqualTo(0);
            ksession.insert((Object)0);
            ksession.insert((Object)3);
            Assertions.assertThat((String)((Object)list).toString()).isEqualTo("[e1, yyy]");
            list.clear();
            ksession.fireAllRules();
            Assertions.assertThat((String)((Object)list).toString()).isEqualTo("[xxx, zzz]");
        }
        finally {
            ksession.dispose();
        }
        ksession = kbase.newKieSession(conf, null);
        try {
            list.clear();
            ksession.setGlobal("list", list);
            ksession.addEventListener((AgendaEventListener)agendaEventListener);
            ksession.insert((Object)"test");
            Assertions.assertThat((int)list.size()).isEqualTo(0);
            ksession.insert((Object)0);
            ksession.insert((Object)1L);
            Assertions.assertThat((String)((Object)list).toString()).isEqualTo("[e2, yyy]");
            list.clear();
            ksession.fireAllRules();
            Assertions.assertThat((String)((Object)list).toString()).isEqualTo("[xxx, zzz]");
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOrPropagatesThroughSubnetwork() {
        String drl = "package org.simple \nglobal java.util.List list; \nrule yyy \nwhen \n  Integer(this==1)\n  String()\n  exists( ( Integer(this == 3) and eval(list.add(\"e1\"))) or (Long(this == 4) and eval(list.add(\"e2\"))) )\nthen \nend  \n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"activate-delete-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"package org.simple \nglobal java.util.List list; \nrule yyy \nwhen \n  Integer(this==1)\n  String()\n  exists( ( Integer(this == 3) and eval(list.add(\"e1\"))) or (Long(this == 4) and eval(list.add(\"e2\"))) )\nthen \nend  \n"});
        KieSessionConfiguration conf = RuleBaseFactory.newKnowledgeSessionConfiguration();
        conf.setOption((Option)new ForceEagerActivationOption.FILTERED(rule -> rule.getName().equals("yyy")));
        final ArrayList list = new ArrayList();
        org.kie.api.event.rule.DefaultAgendaEventListener agendaEventListener = new org.kie.api.event.rule.DefaultAgendaEventListener(){

            public void matchCreated(MatchCreatedEvent event) {
                list.add("add:" + event.getMatch().getRule().getName());
            }

            public void matchCancelled(MatchCancelledEvent event) {
                list.add("rem:" + event.getMatch().getRule().getName());
            }
        };
        KieSession ksession = kbase.newKieSession(conf, null);
        try {
            ksession.addEventListener((AgendaEventListener)agendaEventListener);
            list.clear();
            ksession.setGlobal("list", list);
            ksession.insert((Object)"test");
            ksession.insert((Object)1);
            Assertions.assertThat((int)list.size()).isEqualTo(0);
            FactHandle fhInt3 = ksession.insert((Object)3);
            Assertions.assertThat((String)((Object)list).toString()).isEqualTo("[e1, add:yyy]");
            list.clear();
            FactHandle fhLong4 = ksession.insert((Object)4L);
            Assertions.assertThat((int)list.size()).isEqualTo(0);
            ksession.delete(fhInt3);
            Assertions.assertThat((String)((Object)list).toString()).isEqualTo("[e2]");
            list.clear();
            ksession.delete(fhLong4);
            Assertions.assertThat((String)((Object)list).toString()).isEqualTo("[rem:yyy]");
        }
        finally {
            ksession.dispose();
        }
        ksession = kbase.newKieSession(conf, null);
        try {
            ksession.addEventListener((AgendaEventListener)agendaEventListener);
            list.clear();
            ksession.setGlobal("list", list);
            ksession.insert((Object)"test");
            ksession.insert((Object)1);
            Assertions.assertThat((int)list.size()).isEqualTo(0);
            FactHandle fhLong4 = ksession.insert((Object)4L);
            Assertions.assertThat((String)((Object)list).toString()).isEqualTo("[e2, add:yyy]");
            list.clear();
            FactHandle fhInt3 = ksession.insert((Object)3);
            Assertions.assertThat((String)((Object)list).toString()).isEqualTo("[e1]");
            list.clear();
            ksession.delete(fhLong4);
            Assertions.assertThat((int)list.size()).isEqualTo(0);
            list.clear();
            ksession.delete(fhInt3);
            Assertions.assertThat((String)((Object)list).toString()).isEqualTo("[rem:yyy]");
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEagerEvaluationWithSubSubPath() {
        String drl = "package org.simple \nrule xxx \nwhen \n  $s : String()\n  exists( Boolean() and not(not(Integer()) and not(Double())) )\nthen \nend  \n";
        KieSession ksession = this.getSessionWithEagerActivation("package org.simple \nrule xxx \nwhen \n  $s : String()\n  exists( Boolean() and not(not(Integer()) and not(Double())) )\nthen \nend  \n");
        try {
            final ArrayList list = new ArrayList();
            org.kie.api.event.rule.DefaultAgendaEventListener agendaEventListener = new org.kie.api.event.rule.DefaultAgendaEventListener(){

                public void matchCreated(MatchCreatedEvent event) {
                    list.add("activated");
                }
            };
            ksession.addEventListener((AgendaEventListener)agendaEventListener);
            ksession.insert((Object)Boolean.TRUE);
            Assertions.assertThat((int)list.size()).isEqualTo(0);
            ksession.insert((Object)"test");
            Assertions.assertThat((int)list.size()).isEqualTo(0);
            ksession.insert((Object)1);
            Assertions.assertThat((int)list.size()).isEqualTo(1);
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testSegMemInitializationWithForceEagerActivation() {
        String drl = "global java.util.List list\ndeclare  SimpleFact end\ndeclare  AnotherFact end\n\nrule Init when\n    not (SimpleFact())\n    not (AnotherFact())\nthen\n    insert(new SimpleFact());\n    insert(new AnotherFact());\nend\n\nrule R1 no-loop when\n    $f : SimpleFact()  \n    $h : AnotherFact() \n    $s : String() \n    eval(true)\nthen\n    list.add(\"1\");\nend\n\nrule R2 no-loop when\n    $f : SimpleFact()  \n    $h : AnotherFact()  \n    $s : String() \nthen\n    list.add(\"2\");\nend";
        KieSession ksession = this.getSessionWithEagerActivation("global java.util.List list\ndeclare  SimpleFact end\ndeclare  AnotherFact end\n\nrule Init when\n    not (SimpleFact())\n    not (AnotherFact())\nthen\n    insert(new SimpleFact());\n    insert(new AnotherFact());\nend\n\nrule R1 no-loop when\n    $f : SimpleFact()  \n    $h : AnotherFact() \n    $s : String() \n    eval(true)\nthen\n    list.add(\"1\");\nend\n\nrule R2 no-loop when\n    $f : SimpleFact()  \n    $h : AnotherFact()  \n    $s : String() \nthen\n    list.add(\"2\");\nend");
        try {
            ArrayList list = new ArrayList();
            ksession.setGlobal("list", list);
            ksession.insert((Object)"test");
            ksession.fireAllRules();
            Assertions.assertThat((int)list.size()).isEqualTo(2);
            Assertions.assertThat((boolean)list.containsAll(Arrays.asList("1", "2"))).isTrue();
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testSegMemInitializationWithForceEagerActivationAndAcc() {
        String drl = "global java.util.List list\ndeclare  SimpleFact end\ndeclare  AnotherFact end\n\nrule Init when\n    not (SimpleFact())\n    not (AnotherFact())\nthen\n    insert(new SimpleFact());\n    insert(new AnotherFact());\nend\n\nrule R1 no-loop when\n    $f : SimpleFact()  \n    $h : AnotherFact() \n    $s : String() \n    accumulate($i: Integer(), $res : count($i))\nthen\n    list.add(\"1\");\nend\n\nrule R2 no-loop when\n    $f : SimpleFact()  \n    $h : AnotherFact()  \n    $s : String() \nthen\n    list.add(\"2\");\nend";
        KieSession ksession = this.getSessionWithEagerActivation("global java.util.List list\ndeclare  SimpleFact end\ndeclare  AnotherFact end\n\nrule Init when\n    not (SimpleFact())\n    not (AnotherFact())\nthen\n    insert(new SimpleFact());\n    insert(new AnotherFact());\nend\n\nrule R1 no-loop when\n    $f : SimpleFact()  \n    $h : AnotherFact() \n    $s : String() \n    accumulate($i: Integer(), $res : count($i))\nthen\n    list.add(\"1\");\nend\n\nrule R2 no-loop when\n    $f : SimpleFact()  \n    $h : AnotherFact()  \n    $s : String() \nthen\n    list.add(\"2\");\nend");
        try {
            ArrayList list = new ArrayList();
            ksession.setGlobal("list", list);
            ksession.insert((Object)"test");
            ksession.fireAllRules();
            Assertions.assertThat((int)list.size()).isEqualTo(2);
            Assertions.assertThat((boolean)list.containsAll(Arrays.asList("1", "2"))).isTrue();
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testSegMemInitializationWithForceEagerActivationAndExistsWithNots() {
        String drl = "global java.util.List list\ndeclare  SimpleFact end\ndeclare  AnotherFact end\n\nrule Init when\n    not (SimpleFact())\n    not (AnotherFact())\nthen\n    insert(new SimpleFact());\n    insert(new AnotherFact());\nend\n\nrule R1 no-loop when\n    $f : SimpleFact()  \n    $h : AnotherFact() \n    $s : String() \n    exists(not(Integer()) or not(Double()))\nthen\n    list.add(\"1\");\nend\n\nrule R2 no-loop when\n    $f : SimpleFact()  \n    $h : AnotherFact()  \n    $s : String() \nthen\n    list.add(\"2\");\nend";
        KieSession ksession = this.getSessionWithEagerActivation("global java.util.List list\ndeclare  SimpleFact end\ndeclare  AnotherFact end\n\nrule Init when\n    not (SimpleFact())\n    not (AnotherFact())\nthen\n    insert(new SimpleFact());\n    insert(new AnotherFact());\nend\n\nrule R1 no-loop when\n    $f : SimpleFact()  \n    $h : AnotherFact() \n    $s : String() \n    exists(not(Integer()) or not(Double()))\nthen\n    list.add(\"1\");\nend\n\nrule R2 no-loop when\n    $f : SimpleFact()  \n    $h : AnotherFact()  \n    $s : String() \nthen\n    list.add(\"2\");\nend");
        try {
            ArrayList list = new ArrayList();
            ksession.setGlobal("list", list);
            ksession.insert((Object)"test");
            ksession.fireAllRules();
            Assertions.assertThat((int)list.size()).isEqualTo(2);
            Assertions.assertThat((boolean)list.containsAll(Arrays.asList("1", "2"))).isTrue();
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testNoLoopWithForceEagerActivation() {
        String drl = "import " + Person.class.getCanonicalName() + "\n\nrule Birthday no-loop when\n    $p: Person()\nthen\n    modify($p) { setAge($p.getAge()+1) };\nend";
        KieSession ksession = this.getSessionWithEagerActivation(drl);
        try {
            Person mario = new Person("mario", 42);
            ksession.insert((Object)mario);
            ksession.fireAllRules();
            Assertions.assertThat((int)mario.getAge()).isEqualTo(43);
        }
        finally {
            ksession.dispose();
        }
    }

    private KieSession getSessionWithEagerActivation(String drl) {
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"activate-delete-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSessionConfiguration conf = RuleBaseFactory.newKnowledgeSessionConfiguration();
        conf.setOption((Option)ForceEagerActivationOption.YES);
        return kbase.newKieSession(conf, null);
    }
}

