/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.integrationtests;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.KieUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.builder.KieBuilder;
import org.kie.api.definition.type.FactType;
import org.kie.api.definition.type.Key;
import org.kie.api.definition.type.Position;
import org.kie.api.definition.type.Role;

@RunWith(value=Parameterized.class)
public class AnnotationsTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public AnnotationsTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    @Test
    public void annotationTest() {
        String drl = "package org.drools.compiler.test;\n import " + AnnPropEnum.class.getCanonicalName() + "; \n import " + Position.class.getCanonicalName() + "; \n import " + AnnotationsTest.class.getCanonicalName() + "; \nimport " + Annot.class.getCanonicalName() + "; \ndeclare AnnotatedBean \n @Deprecated \n @Annot( intProp=7          ,typeProp=String.class          ,strProp=\"hello world\"          ,enumProp=AnnPropEnum.THREE          ,dblArrProp={1.0,2.0}          ,typeArrProp={String.class, AnnotationsTest.class}          ,strArrProp={\"x1\",\"x2\"}          ,enumArrProp={AnnPropEnum.ONE, AnnPropEnum.THREE}          ) \n  \n  @role(event) \n   age : int \n name : String      @key    @Position(0)    @Deprecated \n end \n   \n\n declare SecondBean \n  @NonexistingAnnotation  \n field : String @Annot \nend \n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"annotations-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        Class clazz = kbase.getFactType("org.drools.compiler.test", "AnnotatedBean").getFactClass();
        Assertions.assertThat((Class)clazz).isNotNull();
        try {
            Field fld = clazz.getDeclaredField("name");
            Assertions.assertThat((int)fld.getAnnotations().length).isEqualTo(3);
            Assertions.assertThat((Object)fld.getAnnotation(Deprecated.class)).isNotNull();
            Assertions.assertThat((Object)fld.getAnnotation(Position.class)).isNotNull();
            Assertions.assertThat((Object)fld.getAnnotation(Key.class)).isNotNull();
            Position pos = fld.getAnnotation(Position.class);
            Assertions.assertThat((int)pos.value()).isEqualTo(0);
        }
        catch (NoSuchFieldException nsfe) {
            Assertions.fail((String)("field name has not been generated correctly : " + nsfe.getMessage()));
        }
        Annotation[] anns = clazz.getAnnotations();
        Assertions.assertThat((int)anns.length).isEqualTo(3);
        Assertions.assertThat((Object)clazz.getAnnotation(Deprecated.class)).isNotNull();
        Assertions.assertThat((Object)clazz.getAnnotation(Annot.class)).isNotNull();
        Assertions.assertThat((Object)clazz.getAnnotation(Role.class)).isNotNull();
        Annot ann = clazz.getAnnotation(Annot.class);
        Assertions.assertThat((int)ann.intProp()).isEqualTo(7);
        Assertions.assertThat((Class)ann.typeProp()).isEqualTo(String.class);
        Assertions.assertThat((String)ann.strProp()).isEqualTo("hello world");
        Assertions.assertThat((Comparable)((Object)ann.enumProp())).isEqualTo((Object)AnnPropEnum.THREE);
        Assertions.assertThat((double[])ann.dblArrProp()).isEqualTo((Object)new double[]{1.0, 2.0});
        Assertions.assertThat((Object[])ann.typeArrProp()).isEqualTo((Object)new Class[]{String.class, AnnotationsTest.class});
        Assertions.assertThat((Object[])ann.strArrProp()).isEqualTo((Object)new String[]{"x1", "x2"});
        Assertions.assertThat((Object[])ann.enumArrProp()).isEqualTo((Object)new AnnPropEnum[]{AnnPropEnum.ONE, AnnPropEnum.THREE});
        Class clazz2 = kbase.getFactType("org.drools.compiler.test", "SecondBean").getFactClass();
        Assertions.assertThat((Class)clazz2).isNotNull();
        Annotation[] anns2 = clazz2.getAnnotations();
        Assertions.assertThat((int)anns2.length).isEqualTo(0);
        Annot ann2 = null;
        try {
            Field fld2 = clazz2.getDeclaredField("field");
            Assertions.assertThat((Object)fld2.getAnnotation(Annot.class)).isNotNull();
            ann2 = fld2.getAnnotation(Annot.class);
        }
        catch (NoSuchFieldException nsfe) {
            Assertions.fail((String)("field name has not been generated correctly : " + nsfe.getMessage()));
        }
        Assertions.assertThat(ann2).isNotNull();
        Assertions.assertThat((int)ann2.intProp()).isEqualTo(0);
        Assertions.assertThat((String)ann2.strProp()).isEqualTo("foo");
        Assertions.assertThat((Comparable)((Object)ann2.enumProp())).isEqualTo((Object)AnnPropEnum.ONE);
        Assertions.assertThat((double[])ann2.dblArrProp()).isEqualTo((Object)new double[]{0.4, 0.5});
        Assertions.assertThat((Object[])ann2.strArrProp()).isEqualTo((Object)new String[]{"a", "b", "c"});
        Assertions.assertThat((Object[])ann2.enumArrProp()).isEqualTo((Object)new AnnPropEnum[]{AnnPropEnum.TWO, AnnPropEnum.THREE});
    }

    @Test
    public void annotationErrorTest() {
        String drl = "package org.drools.compiler.test;\n declare MissingAnnotationBean \n @IgnoreMissingAnnotation1 \n name : String      @IgnoreMissingAnnotation2( noProp = 999 ) \n end \n ";
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromDrls((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (boolean)false, (String[])new String[]{"package org.drools.compiler.test;\n declare MissingAnnotationBean \n @IgnoreMissingAnnotation1 \n name : String      @IgnoreMissingAnnotation2( noProp = 999 ) \n end \n "});
        Assertions.assertThat((List)kieBuilder.getResults().getMessages()).isEmpty();
        String drl2 = "package org.drools.compiler.test;\n import " + Annot.class.getCanonicalName() + "; \ndeclare MissingAnnotationBean \n @Annot( wrongProp1 = 1 ) \n name : String      @Annot( wrongProp2 = 2, wrongProp3 = 3 ) \n end \n ";
        KieBuilder kieBuilder2 = KieUtil.getKieBuilderFromDrls((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (boolean)false, (String[])new String[]{drl2});
        Assertions.assertThat((List)kieBuilder2.getResults().getMessages()).hasSize(3);
    }

    @Test
    public void testAnnotationNameClash() {
        String drl = "package org.drools.test\ndeclare Annot\n id : int  @" + Annot.class.getCanonicalName() + "( intProp = 3, typeProp = String.class, typeArrProp = {} ) \n end\nrule X\nwhen\n \nthen\n insert( new Annot( 22 ) ); end";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"annotations-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        FactType ft = kbase.getFactType("org.drools.test", "Annot");
        try {
            Object o = ft.newInstance();
            Annot a = o.getClass().getDeclaredField("id").getAnnotation(Annot.class);
            Assertions.assertThat((int)a.intProp()).isEqualTo(3);
            Assertions.assertThat((Class)a.typeProp()).isEqualTo(String.class);
            Assertions.assertThat((int)a.typeArrProp().length).isEqualTo(0);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assertions.fail((String)e.getMessage());
        }
    }

    @Test
    public void testAnnotationNameClashWithRegularClass() {
        String drl = "package org.drools.test\nimport " + Duration.class.getCanonicalName() + "; declare Annot   @role( event )  @duration( durat )   durat : long end\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"annotations-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        FactType ft = kbase.getFactType("org.drools.test", "Annot");
        Assertions.assertThat((Object)ft).isNotNull();
    }

    @Test
    public void testAnnotationOnLHSAndMerging() {
        String drl = "package org.drools.compiler;  import " + Annot.class.getCanonicalName() + ";  rule \"test collect with annotation\"     when        ( and @Annot          String()          Integer() )     then end ";
        KieUtil.getKieBuilderFromDrls((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (boolean)true, (String[])new String[]{drl});
    }

    public static @interface Simple {
        public int[] numbers();
    }

    public static class Duration {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE, ElementType.FIELD})
    public static @interface Annot {
        public int intProp() default 0;

        public Class typeProp() default Object.class;

        public String strProp() default "foo";

        public AnnPropEnum enumProp() default AnnPropEnum.ONE;

        public double[] dblArrProp() default {0.4, 0.5};

        public Class[] typeArrProp() default {};

        public String[] strArrProp() default {"a", "b", "c"};

        public AnnPropEnum[] enumArrProp() default {AnnPropEnum.TWO, AnnPropEnum.THREE};
    }

    public static enum AnnPropEnum {
        ONE("one"),
        TWO("two"),
        THREE("three");

        private final String value;

        private AnnPropEnum(String s) {
            this.value = s;
        }

        public String getValue() {
            return this.value;
        }
    }
}

