/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.integrationtests.concurrency;

import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.drools.testcoverage.common.model.Person;
import org.drools.testcoverage.common.model.Result;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.runtime.KieSession;
import org.kie.test.testcategory.TurtleTestCategory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
@Category(value={TurtleTestCategory.class})
public class GlobalConcurrencyTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(GlobalConcurrencyTest.class);
    protected static int LOOP = 3000;
    protected static int MAX_THREAD = 30;
    protected final KieBaseTestConfiguration kieBaseTestConfiguration;

    public GlobalConcurrencyTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        ArrayList<Object[]> parameters = new ArrayList<Object[]>();
        parameters.add(new Object[]{KieBaseTestConfiguration.CLOUD_IDENTITY_MODEL_PATTERN});
        return parameters;
    }

    @Test
    public void testGlobalConcurrency() {
        String str = "package org.mypkg;import " + Person.class.getCanonicalName() + ";import " + Result.class.getCanonicalName() + ";global Result globalResult;rule R1 when\n  $p1 : Person(name == \"Mark\")\nthen\n  globalResult.setValue($p1.getName() + \" is \" + $p1.getAge());\nend\nrule R2 when\n  $p1 : Person(name == \"Edson\")\nthen\n  globalResult.setValue($p1.getName() + \" is \" + $p1.getAge());\nend";
        final ArrayList exceptionList = new ArrayList();
        for (int i = 0; i < LOOP; ++i) {
            if (i % 100 == 0) {
                System.out.println("loop : " + i);
            }
            final KieBase kieBase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"global-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
            ExecutorService executor = Executors.newFixedThreadPool(MAX_THREAD);
            final CountDownLatch latch = new CountDownLatch(MAX_THREAD);
            for (int n = 0; n < MAX_THREAD; ++n) {
                executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        KieSession ksession = kieBase.newKieSession();
                        Result result = new Result();
                        ksession.setGlobal("globalResult", (Object)result);
                        ksession.insert((Object)new Person("Mark", 37));
                        ksession.insert((Object)new Person("Edson", 35));
                        ksession.insert((Object)new Person("Mario", 40));
                        latch.countDown();
                        try {
                            latch.await();
                        }
                        catch (InterruptedException e) {
                            LOGGER.error(e.getMessage(), (Throwable)e);
                        }
                        try {
                            ksession.fireAllRules();
                        }
                        catch (Exception e) {
                            exceptionList.add(e);
                        }
                        ksession.dispose();
                    }
                });
            }
            executor.shutdown();
            try {
                executor.awaitTermination(100L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
            if (!exceptionList.isEmpty()) break;
        }
        if (exceptionList.size() > 0) {
            LOGGER.error(((Exception)exceptionList.get(0)).getMessage(), (Throwable)exceptionList.get(0));
        }
        Assertions.assertThat(exceptionList).isEmpty();
    }
}

