/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.integrationtests.drl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.drools.compiler.integrationtests.drl.AbstractDeclareTest;
import org.drools.testcoverage.common.model.ClassB;
import org.drools.testcoverage.common.model.InterfaceB;
import org.drools.testcoverage.common.model.Person;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.definition.type.FactType;
import org.kie.api.runtime.KieSession;

@RunWith(value=Parameterized.class)
public class DeclareTest
extends AbstractDeclareTest {
    public DeclareTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        super(kieBaseTestConfiguration);
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeclaredTypesDefaultHashCode() {
        String str = "package org.drools.compiler.integrationtests.drl;\n\nglobal java.util.List list; \ndeclare Bean\n id : int \nend\n\ndeclare KeyedBean\n id : int @key \nend\n\n\nrule Create\nwhen\nthen\n list.add( new Bean(1) ); \n list.add( new Bean(2) ); \n list.add( new KeyedBean(1) ); \n list.add( new KeyedBean(1) ); \nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"declare-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"package org.drools.compiler.integrationtests.drl;\n\nglobal java.util.List list; \ndeclare Bean\n id : int \nend\n\ndeclare KeyedBean\n id : int @key \nend\n\n\nrule Create\nwhen\nthen\n list.add( new Bean(1) ); \n list.add( new Bean(2) ); \n list.add( new KeyedBean(1) ); \n list.add( new KeyedBean(1) ); \nend\n"});
        KieSession ksession = kbase.newKieSession();
        try {
            ArrayList list = new ArrayList();
            ksession.setGlobal("list", list);
            ksession.fireAllRules();
            ksession.dispose();
            Assertions.assertThat((int)list.get(0).hashCode()).isNotEqualTo(34);
            Assertions.assertThat((int)list.get(1).hashCode()).isNotEqualTo(34);
            Assertions.assertThat((int)list.get(0).hashCode()).isNotEqualTo(list.get(1).hashCode());
            Assertions.assertThat(list.get(0)).isNotSameAs(list.get(1));
            Assertions.assertThat(list.get(0)).isNotEqualTo(list.get(1));
            Assertions.assertThat(list.get(2)).isNotSameAs(list.get(3));
            Assertions.assertThat(list.get(3)).isEqualTo(list.get(2));
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeclareAndFrom() throws Exception {
        String drl = "package org.drools.compiler.integrationtests.drl\n\ndeclare Profile\n    pageFreq : java.util.Map\nend\n\nrule \"Testing out UdayCompare Custom Operator\"\n    ruleflow-group \"udaytesting\"\nwhen\n    $profile : Profile( $pg : pageFreq )\n    Integer( this > 1 ) from $profile.pageFreq[\"internet\"]\nthen\n    System.out.println(\"Yippie it works!!\");\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"declare-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"package org.drools.compiler.integrationtests.drl\n\ndeclare Profile\n    pageFreq : java.util.Map\nend\n\nrule \"Testing out UdayCompare Custom Operator\"\n    ruleflow-group \"udaytesting\"\nwhen\n    $profile : Profile( $pg : pageFreq )\n    Integer( this > 1 ) from $profile.pageFreq[\"internet\"]\nthen\n    System.out.println(\"Yippie it works!!\");\nend"});
        KieSession ksession = kbase.newKieSession();
        try {
            FactType profileType = kbase.getFactType("org.drools.compiler.integrationtests.drl", "Profile");
            Object profile = profileType.newInstance();
            HashMap<String, Integer> map = new HashMap<String, Integer>();
            map.put("internet", 2);
            profileType.set(profile, "pageFreq", map);
            ksession.insert(profile);
            ksession.fireAllRules();
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeclaredFactAndFunction() throws Exception {
        String drl = "package org.drools.compiler.integrationtests.drl;\nglobal java.util.List list\ndeclare Address\n    street: String\nend\nfunction void myFunction() {\n}\nrule \"r1\"\n    dialect \"mvel\"\nwhen\n    Address()\nthen\n    list.add(\"r1\");\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"declare-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"package org.drools.compiler.integrationtests.drl;\nglobal java.util.List list\ndeclare Address\n    street: String\nend\nfunction void myFunction() {\n}\nrule \"r1\"\n    dialect \"mvel\"\nwhen\n    Address()\nthen\n    list.add(\"r1\");\nend\n"});
        KieSession session = kbase.newKieSession();
        try {
            List list = new ArrayList();
            session.setGlobal("list", list);
            FactType addressFact = kbase.getFactType("org.drools.compiler.integrationtests.drl", "Address");
            Object address = addressFact.newInstance();
            session.insert(address);
            session.fireAllRules();
            list = (List)session.getGlobal("list");
            Assertions.assertThat((int)list.size()).isEqualTo(1);
            Assertions.assertThat(list.get(0)).isEqualTo((Object)"r1");
        }
        finally {
            session.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTypeDeclarationOnSeparateResource() {
        String drl1 = "package a.b.c\ndeclare SomePerson\n    weight : double\n    height : double\nend\n";
        String drl2 = "package a.b.c\nimport " + Person.class.getCanonicalName() + ";\ndeclare Holder\n    person : Person\nend\nrule \"create holder\"\n    when\n        person : Person( )\n        not (\n            Holder( person; )\n        )\n    then\n        insert(new Holder(person));\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"declare-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"package a.b.c\ndeclare SomePerson\n    weight : double\n    height : double\nend\n", drl2});
        KieSession ksession = kbase.newKieSession();
        try {
            Assertions.assertThat((int)ksession.fireAllRules()).isEqualTo(0);
            ksession.insert((Object)new Person("Bob"));
            Assertions.assertThat((int)ksession.fireAllRules()).isEqualTo(1);
            Assertions.assertThat((int)ksession.fireAllRules()).isEqualTo(0);
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeclaredTypeAsFieldForAnotherDeclaredType() {
        String drl = "package com.sample\n\nimport com.sample.*;\n\ndeclare Item\n        id : int;\nend\n\ndeclare Priority\n        name : String;\n        priority : int;\nend\n\ndeclare Cap\n        item : Item;\n        name : String\nend\n\nrule \"split cart into items\"\nwhen\nthen\n        insert(new Item(1));\n        insert(new Item(2));\n        insert(new Item(3));\nend\n\nrule \"Priorities\"\nwhen\nthen\n        insert(new Priority(\"A\", 3));\n        insert(new Priority(\"B\", 2));\n        insert(new Priority(\"C\", 5));\nend\n\nrule \"Caps\"\nwhen\n        $i : Item()\n        $p : Priority($name : name)\nthen\n        insert(new Cap($i, $name));\nend\n\nrule \"test\"\nwhen\n        $i : Item()\n        Cap(item.id == $i.id)\nthen\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"declare-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"package com.sample\n\nimport com.sample.*;\n\ndeclare Item\n        id : int;\nend\n\ndeclare Priority\n        name : String;\n        priority : int;\nend\n\ndeclare Cap\n        item : Item;\n        name : String\nend\n\nrule \"split cart into items\"\nwhen\nthen\n        insert(new Item(1));\n        insert(new Item(2));\n        insert(new Item(3));\nend\n\nrule \"Priorities\"\nwhen\nthen\n        insert(new Priority(\"A\", 3));\n        insert(new Priority(\"B\", 2));\n        insert(new Priority(\"C\", 5));\nend\n\nrule \"Caps\"\nwhen\n        $i : Item()\n        $p : Priority($name : name)\nthen\n        insert(new Cap($i, $name));\nend\n\nrule \"test\"\nwhen\n        $i : Item()\n        Cap(item.id == $i.id)\nthen\nend"});
        KieSession ksession = kbase.newKieSession();
        try {
            Assertions.assertThat((int)ksession.fireAllRules()).isEqualTo(20);
        }
        finally {
            ksession.dispose();
        }
    }

    @Test
    public void testDeclaredTypeWithHundredsProps() {
        StringBuilder sb = new StringBuilder("declare MyType\n");
        for (int i = 0; i < 300; ++i) {
            sb.append("i").append(i).append(" : int\n");
        }
        sb.append("end");
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"declare-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{sb.toString()});
        KieSession ksession = kbase.newKieSession();
        ksession.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMvelFunctionWithDeclaredTypeArg() {
        String drl = "package org.drools.compiler.integrationtests.drl; \ndialect \"mvel\"\nglobal java.lang.StringBuilder value;\nfunction String getFieldValue(Bean bean) {   return bean.getField();}declare Bean \n   field : String \nend \n\nrule R1 \nwhen \nthen \n   insert( new Bean( \"mario\" ) ); \nend \n\nrule R2 \nwhen \n   $bean : Bean( ) \nthen \n   value.append( getFieldValue($bean) ); \nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"declare-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"package org.drools.compiler.integrationtests.drl; \ndialect \"mvel\"\nglobal java.lang.StringBuilder value;\nfunction String getFieldValue(Bean bean) {   return bean.getField();}declare Bean \n   field : String \nend \n\nrule R1 \nwhen \nthen \n   insert( new Bean( \"mario\" ) ); \nend \n\nrule R2 \nwhen \n   $bean : Bean( ) \nthen \n   value.append( getFieldValue($bean) ); \nend"});
        KieSession ksession = kbase.newKieSession();
        try {
            StringBuilder sb = new StringBuilder();
            ksession.setGlobal("value", (Object)sb);
            ksession.fireAllRules();
            Assertions.assertThat((String)sb.toString()).isEqualTo("mario");
        }
        finally {
            ksession.dispose();
        }
    }

    @Test
    public void testMvelFunctionWithDeclaredTypeArgForGuvnor() {
        String function = "function String getFieldValue(Bean bean) { return bean.getField();}\n";
        String declaredFactType = "declare Bean \n field : String \nend \n";
        String rule = "rule R2 \ndialect 'mvel'\nwhen \n $bean : Bean( ) \nthen \n System.out.println( getFieldValue($bean) ); \nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"declare-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"declare Bean \n field : String \nend \n", "function String getFieldValue(Bean bean) { return bean.getField();}\n", "rule R2 \ndialect 'mvel'\nwhen \n $bean : Bean( ) \nthen \n System.out.println( getFieldValue($bean) ); \nend\n"});
        KieSession ksession = kbase.newKieSession();
        ksession.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConstructorWithOtherDefaults() {
        String drl = "global java.util.List list;\ndeclare Bean\n   kField : String     @key\n   sField : String     = \"a\"\n   iField : int        = 10\n   dField : double     = 4.32\n   aField : Long[]     = new Long[] { 100L, 1000L }\nend\nrule \"Trig\"\nwhen\n    Bean( kField == \"key\", sField == \"a\", iField == 10, dField == 4.32, aField[1] == 1000L ) \nthen\n    list.add( \"OK\" );\nend\n\nrule \"Exec\"\nwhen\nthen\n    insert( new Bean( \"key\") ); \nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"declare-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"global java.util.List list;\ndeclare Bean\n   kField : String     @key\n   sField : String     = \"a\"\n   iField : int        = 10\n   dField : double     = 4.32\n   aField : Long[]     = new Long[] { 100L, 1000L }\nend\nrule \"Trig\"\nwhen\n    Bean( kField == \"key\", sField == \"a\", iField == 10, dField == 4.32, aField[1] == 1000L ) \nthen\n    list.add( \"OK\" );\nend\n\nrule \"Exec\"\nwhen\nthen\n    insert( new Bean( \"key\") ); \nend"});
        KieSession ksession = kbase.newKieSession();
        try {
            ArrayList list = new ArrayList();
            ksession.setGlobal("list", list);
            ksession.fireAllRules();
            Assertions.assertThat((boolean)list.contains("OK")).isTrue();
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testKeyedInterfaceField() {
        String drl = "package org.drools.compiler.integrationtests.drl; \n\nimport " + ClassB.class.getCanonicalName() + "; \nimport " + InterfaceB.class.getCanonicalName() + "; \nglobal java.util.List list;declare Bean\n  id    : InterfaceB @key\nend\n\n\nrule \"Init\"\nwhen  \nthen\n  insert( new Bean( new ClassB() ) );\nend\n\nrule \"Check\"\nwhen\n  $b : Bean( )\nthen\n  list.add( $b.equals( new Bean( new ClassB() ) ) ); \nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"declare-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        try {
            ArrayList list = new ArrayList();
            ksession.setGlobal("list", list);
            ksession.fireAllRules();
            Assertions.assertThat((boolean)list.contains(true)).isTrue();
        }
        finally {
            ksession.dispose();
        }
    }
}

