/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.integrationtests.drl;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.drools.testcoverage.common.model.Cheese;
import org.drools.testcoverage.common.model.Cheesery;
import org.drools.testcoverage.common.model.Person;
import org.drools.testcoverage.common.model.Primitives;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.runtime.KieSession;

@RunWith(value=Parameterized.class)
public class LiteralTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public LiteralTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLiteral() {
        String drl = "package org.drools.compiler.integrationtests.drl;\n\nimport " + Cheese.class.getCanonicalName() + ";\nimport " + Cheesery.class.getCanonicalName() + ";\n\nglobal java.util.List list;\nglobal Cheesery cheesery;\n\nrule \"literal test rule\"\n    when\n        Cheese( $x: type, type == \"stilton\" )\n    then\n        list.add( $x );\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"literal-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession session = kbase.newKieSession();
        try {
            ArrayList list = new ArrayList();
            session.setGlobal("list", list);
            Cheese stilton = new Cheese("stilton", 5);
            session.insert((Object)stilton);
            session.fireAllRules();
            Assertions.assertThat(((List)session.getGlobal("list")).get(0)).isEqualTo((Object)"stilton");
        }
        finally {
            session.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLiteralWithEscapes() {
        String drl = "package org.drools.compiler.integrationtests.drl;\nimport " + Cheese.class.getCanonicalName() + ";\nglobal java.util.List list;\n\nrule \"literal test rule\"\n    when\n        Cheese( $x: type, type == \"s\\tti\\\"lto\\nn\" )\n    then\n        list.add( $x );\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"literal-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession session = kbase.newKieSession();
        try {
            ArrayList list = new ArrayList();
            session.setGlobal("list", list);
            String expected = "s\tti\"lto\nn";
            Cheese stilton = new Cheese("s\tti\"lto\nn", 5);
            session.insert((Object)stilton);
            int fired = session.fireAllRules();
            Assertions.assertThat((int)fired).isEqualTo(1);
            Assertions.assertThat(((List)session.getGlobal("list")).get(0)).isEqualTo((Object)"s\tti\"lto\nn");
        }
        finally {
            session.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLiteralWithBoolean() {
        String drl = "package org.drools.compiler.integrationtests.drl;\nimport " + Person.class.getCanonicalName() + ";\nglobal java.util.List list;\n\nrule \"Literal with boolean\"\n\n    when\n        // conditions\n        alivePerson : Person(alive ==  true)\n    then\n        list.add( alivePerson );\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"literal-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession session = kbase.newKieSession();
        try {
            ArrayList list = new ArrayList();
            session.setGlobal("list", list);
            Person bill = new Person("bill", null, 12);
            bill.setAlive(true);
            session.insert((Object)bill);
            session.fireAllRules();
            Assertions.assertThat(((List)session.getGlobal("list")).get(0)).isEqualTo((Object)bill);
        }
        finally {
            session.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBigLiterals() {
        String drl = "package org.drools.compiler.integrationtests.drl;\nimport " + Primitives.class.getCanonicalName() + ";\nrule X\nwhen\n    Primitives( bigInteger == 10I, bigInteger < (50I), bigDecimal == 10B, bigDecimal < (50B) )\nthen\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"literal-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession session = kbase.newKieSession();
        try {
            Primitives p = new Primitives();
            p.setBigDecimal(BigDecimal.valueOf(10L));
            p.setBigInteger(BigInteger.valueOf(10L));
            session.insert((Object)p);
            int rulesFired = session.fireAllRules();
            Assertions.assertThat((int)rulesFired).isEqualTo(1);
        }
        finally {
            session.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBigDecimalIntegerLiteral() {
        String drl = "package org.drools.compiler.integrationtests.drl\n\nimport " + Primitives.class.getCanonicalName() + ";\nimport java.math.BigDecimal;\n\nglobal java.util.List list;\n\nrule \"BigDec\"\n\n    when\n        p: Primitives(bigDecimal < 100.01)\n    then\n        System.err.println(\"rule1\");\n        list.add( p );\nend\n\nrule \"BigInt\"\n    when\n        p: Primitives(bigInteger < 100.1)\n    then\n    System.err.println(\"rule2\");\n        list.add( p );\nend\n\nrule \"BigDec2\"\n\n    when\n        p: Primitives(bigDecimal == 42)\n    then\n    System.err.println(\"rule3\");\n        list.add( p );\nend\n\nrule \"BigInt2\"\n    when\n        p: Primitives(bigInteger == 42)\n    then\n    System.err.println(\"rule4\");\n        list.add( p );\nend\n\nrule \"BigDec3\"\n\n    when\n        p: Primitives(bigDecimal != 100)\n    then\n    System.err.println(\"rule5\");\n        list.add( p );\nend\n\nrule \"BigInt3\"\n    when\n        p: Primitives(bigInteger != 100)\n    then\n    System.err.println(\"rule6\");\n        list.add( p );\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"literal-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession session = kbase.newKieSession();
        try {
            ArrayList list = new ArrayList();
            session.setGlobal("list", list);
            Primitives bill = new Primitives();
            bill.setBigDecimal(new BigDecimal("42"));
            bill.setBigInteger(new BigInteger("42"));
            session.insert((Object)bill);
            session.fireAllRules();
            Assertions.assertThat((int)((List)session.getGlobal("list")).size()).isEqualTo(6);
        }
        finally {
            session.dispose();
        }
    }
}

