/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.integrationtests.incrementalcompilation;

import java.util.Collection;
import org.assertj.core.api.Assertions;
import org.drools.testcoverage.common.model.Message;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.ReleaseId;
import org.kie.api.definition.type.FactType;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.KieSession;
import org.kie.internal.builder.IncrementalResults;
import org.kie.internal.builder.InternalKieBuilder;

@RunWith(value=Parameterized.class)
public class IncrementalCompilationNonExecModelTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;
    private static final String DRL2_COMMON_SRC = "package myPkg\nimport " + Message.class.getCanonicalName() + ";\ndeclare DummyDecl\n  i : Integer\nend\nrule R1\nwhen\nthen\n  insert(new DummyDecl());\nend\nrule R2_A\nwhen\n  $s : StringWrapper( s == \"ABC\" )\nthen\nend\nrule R2_B\nwhen\n  $s : StringWrapper( s == \"DEF\" )\nthen\nend\n";

    public IncrementalCompilationNonExecModelTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)false);
    }

    @Test
    public void testCreateFileSetWithDeclaredModel() throws InstantiationException, IllegalAccessException {
        String drl1 = "package myPkg\ndeclare StringWrapper\n s : String\nend\n";
        String drl2_1 = DRL2_COMMON_SRC + "rule R2_C\nwhen\n  $s : StringWrapper( s == \"Hi Universe\" )\nthen\nend\n";
        String drl2_2 = DRL2_COMMON_SRC + "rule R2_C when\n  $s : StringWrapper( s == \"Hello World\" )\nthen\n  System.out.println(\"HIT\");\nend\n";
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kfs = ks.newKieFileSystem().write("src/main/resources/myPkg/r1.drl", "package myPkg\ndeclare StringWrapper\n s : String\nend\n").write("src/main/resources/myPkg/r2.drl", drl2_1);
        ReleaseId releaseId1 = ks.newReleaseId("org.default", "artifact", "1.1.0");
        kfs.generateAndWritePomXML(releaseId1);
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromKieFileSystem((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (KieFileSystem)kfs, (boolean)true);
        KieContainer kieContainer = ks.newKieContainer(releaseId1);
        this.runRules(kieContainer, 1);
        kfs.delete(new String[]{"src/main/resources/myPkg/r2.drl"});
        kfs.write("src/main/resources/myPkg/r2.drl", drl2_2);
        ReleaseId releaseId2 = ks.newReleaseId("org.default", "artifact", "1.2.0");
        kfs.generateAndWritePomXML(releaseId2);
        IncrementalResults results = ((InternalKieBuilder)kieBuilder).createFileSet(new String[]{"src/main/resources/myPkg/r2.drl"}).build();
        Assertions.assertThat((int)results.getAddedMessages().size()).isEqualTo(0);
        Assertions.assertThat((int)results.getRemovedMessages().size()).isEqualTo(0);
        kieContainer.updateToVersion(releaseId2);
        this.runRules(kieContainer, 2);
    }

    private void runRules(KieContainer kieContainer, int expectedfireCount) throws InstantiationException, IllegalAccessException {
        KieSession ksession = kieContainer.newKieSession();
        FactType factType = ksession.getKieBase().getFactType("myPkg", "StringWrapper");
        Object fact = factType.newInstance();
        factType.set(fact, "s", (Object)"Hello World");
        ksession.insert(fact);
        Assertions.assertThat((int)ksession.fireAllRules()).isEqualTo(expectedfireCount);
        ksession.dispose();
    }
}

