/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.integrationtests.operators;

import java.util.Collection;
import org.assertj.core.api.Assertions;
import org.drools.testcoverage.common.model.Person;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.runtime.KieSession;

@RunWith(value=Parameterized.class)
public class InTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public InTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInOperator() {
        String drl = "package org.drools.compiler.integrationtests.operators;\nimport " + Person.class.getCanonicalName() + ";\nrule \"test in\"\nwhen\n    Person( $name : name in (\"bob\", \"mark\") )\nthen\n    boolean test = $name != null;end\nrule \"test not in\"\nwhen\n    Person( $name : name not in (\"joe\", \"doe\") )\nthen\n    boolean test = $name != null;end\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"in-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        try {
            Person person = new Person("bob");
            ksession.insert((Object)person);
            int rules = ksession.fireAllRules();
            Assertions.assertThat((int)rules).isEqualTo(2);
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNegatedIn() {
        String drl = "package org.drools.compiler.integrationtests.operators;\nimport " + Person.class.getCanonicalName() + ";\nrule \"test negated in\"\nwhen\n    Person( !(name in (\"joe\", \"doe\")) )\nthen\nend\nrule \"test not negated in\"\nwhen\n    Person( !(name not in (\"bob\", \"mark\")) )\nthen\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"in-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        try {
            Person person = new Person("bob");
            ksession.insert((Object)person);
            int rules = ksession.fireAllRules();
            Assertions.assertThat((int)rules).isEqualTo(2);
        }
        finally {
            ksession.dispose();
        }
    }
}

