/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import org.assertj.core.api.Assertions;
import org.drools.core.base.ClassFieldAccessorCache;
import org.drools.core.base.ClassObjectType;
import org.drools.core.base.ObjectType;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.reteoo.JoinNodeLeftTuple;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.RightTuple;
import org.drools.core.reteoo.RightTupleImpl;
import org.drools.core.reteoo.Tuple;
import org.drools.core.rule.ContextEntry;
import org.drools.core.rule.Declaration;
import org.drools.core.rule.Pattern;
import org.drools.core.rule.PredicateConstraint;
import org.drools.core.rule.accessor.PredicateExpression;
import org.drools.core.rule.accessor.ReadAccessor;
import org.drools.core.rule.constraint.AlphaNodeFieldConstraint;
import org.drools.kiesession.rulebase.InternalKnowledgeBase;
import org.drools.kiesession.rulebase.KnowledgeBaseFactory;
import org.drools.kiesession.session.StatefulKnowledgeSessionImpl;
import org.drools.mvel.ConstraintTestUtil;
import org.drools.mvel.accessors.ClassFieldAccessorStore;
import org.drools.mvel.accessors.ClassFieldReader;
import org.drools.mvel.model.Cheese;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class FieldConstraintTest {
    ClassFieldAccessorStore store = new ClassFieldAccessorStore();
    private final boolean useLambdaConstraint;

    public FieldConstraintTest(boolean useLambdaConstraint) {
        this.useLambdaConstraint = useLambdaConstraint;
    }

    @Parameterized.Parameters(name="useLambdaConstraint={0}")
    public static Collection<Object[]> getParameters() {
        ArrayList<Object[]> parameters = new ArrayList<Object[]>();
        parameters.add(new Object[]{false});
        parameters.add(new Object[]{true});
        return parameters;
    }

    @Before
    public void setUp() throws Exception {
        this.store.setClassFieldAccessorCache(new ClassFieldAccessorCache(Thread.currentThread().getContextClassLoader()));
        this.store.setEagerWire(true);
    }

    @Test
    public void testLiteralConstraint() {
        InternalKnowledgeBase kBase = KnowledgeBaseFactory.newKnowledgeBase();
        StatefulKnowledgeSessionImpl ksession = (StatefulKnowledgeSessionImpl)kBase.newKieSession();
        ClassFieldReader extractor = this.store.getReader(Cheese.class, "type");
        AlphaNodeFieldConstraint constraint = ConstraintTestUtil.createCheeseTypeEqualsConstraint((ReadAccessor)extractor, "cheddar", this.useLambdaConstraint);
        Cheese cheddar = new Cheese("cheddar", 5);
        InternalFactHandle cheddarHandle = (InternalFactHandle)ksession.insert((Object)cheddar);
        Assertions.assertThat((boolean)constraint.isAllowed(cheddarHandle, (ReteEvaluator)ksession)).isTrue();
        Cheese stilton = new Cheese("stilton", 5);
        InternalFactHandle stiltonHandle = (InternalFactHandle)ksession.insert((Object)stilton);
        Assertions.assertThat((boolean)constraint.isAllowed(stiltonHandle, (ReteEvaluator)ksession)).isFalse();
    }

    @Test
    public void testPrimitiveLiteralConstraint() {
        InternalKnowledgeBase kBase = KnowledgeBaseFactory.newKnowledgeBase();
        StatefulKnowledgeSessionImpl ksession = (StatefulKnowledgeSessionImpl)kBase.newKieSession();
        ClassFieldReader extractor = this.store.getReader(Cheese.class, "price");
        AlphaNodeFieldConstraint constraint = ConstraintTestUtil.createCheesePriceEqualsConstraint((ReadAccessor)extractor, 5, this.useLambdaConstraint);
        Cheese cheddar = new Cheese("cheddar", 5);
        InternalFactHandle cheddarHandle = (InternalFactHandle)ksession.insert((Object)cheddar);
        Assertions.assertThat((boolean)constraint.isAllowed(cheddarHandle, (ReteEvaluator)ksession)).isTrue();
        Cheese stilton = new Cheese("stilton", 10);
        InternalFactHandle stiltonHandle = (InternalFactHandle)ksession.insert((Object)stilton);
        Assertions.assertThat((boolean)constraint.isAllowed(stiltonHandle, (ReteEvaluator)ksession)).isFalse();
    }

    @Test
    public void testPredicateConstraint() {
        InternalKnowledgeBase kBase = KnowledgeBaseFactory.newKnowledgeBase();
        StatefulKnowledgeSessionImpl ksession = (StatefulKnowledgeSessionImpl)kBase.newKieSession();
        ClassFieldReader priceExtractor = this.store.getReader(Cheese.class, "price");
        Pattern pattern = new Pattern(0, (ObjectType)new ClassObjectType(Cheese.class));
        Declaration price1Declaration = new Declaration("price1", (ReadAccessor)priceExtractor, pattern);
        pattern = new Pattern(1, (ObjectType)new ClassObjectType(Cheese.class));
        Declaration price2Declaration = new Declaration("price2", (ReadAccessor)priceExtractor, pattern);
        PredicateExpression evaluator = new PredicateExpression(){
            private static final long serialVersionUID = 510L;

            public boolean evaluate(InternalFactHandle handle, Tuple tuple, Declaration[] previousDeclarations, Declaration[] localDeclarations, ReteEvaluator reteEvaluator, Object context) {
                int price1 = previousDeclarations[0].getIntValue(reteEvaluator, tuple.getObject(previousDeclarations[0]));
                int price2 = localDeclarations[0].getIntValue(reteEvaluator, handle.getObject());
                return price2 == price1 * 2;
            }

            public Object createContext() {
                return null;
            }

            public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            }

            public void writeExternal(ObjectOutput out) throws IOException {
            }
        };
        PredicateConstraint constraint1 = new PredicateConstraint(evaluator, new Declaration[]{price1Declaration}, new Declaration[]{price2Declaration});
        Cheese cheddar0 = new Cheese("cheddar", 5);
        InternalFactHandle f0 = (InternalFactHandle)ksession.insert((Object)cheddar0);
        JoinNodeLeftTuple tuple = new JoinNodeLeftTuple(f0, null, true);
        Cheese cheddar1 = new Cheese("cheddar", 10);
        InternalFactHandle f1 = (InternalFactHandle)ksession.insert((Object)cheddar1);
        tuple = new JoinNodeLeftTuple((LeftTuple)tuple, (RightTuple)new RightTupleImpl(f1, null), null, true);
        PredicateConstraint.PredicateContextEntry context = (PredicateConstraint.PredicateContextEntry)constraint1.createContextEntry();
        context.updateFromTuple((ReteEvaluator)ksession, (Tuple)tuple);
        Assertions.assertThat((boolean)constraint1.isAllowedCachedLeft((ContextEntry)context, f1)).isTrue();
    }
}

