/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel;

import java.util.ArrayList;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.drools.core.RuleBaseConfiguration;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.SingleBetaConstraints;
import org.drools.core.impl.RuleBaseFactory;
import org.drools.core.reteoo.BetaMemory;
import org.drools.core.reteoo.JoinNodeLeftTuple;
import org.drools.core.reteoo.Tuple;
import org.drools.core.rule.constraint.BetaNodeFieldConstraint;
import org.drools.core.util.AbstractHashTable;
import org.drools.core.util.Iterator;
import org.drools.core.util.index.TupleIndexHashTable;
import org.drools.core.util.index.TupleList;
import org.drools.kiesession.rulebase.InternalKnowledgeBase;
import org.drools.kiesession.rulebase.KnowledgeBaseFactory;
import org.drools.mvel.BaseTupleIndexHashTableIteratorTest;
import org.junit.Test;
import org.kie.api.runtime.KieSession;
import org.mockito.Mockito;

public class LeftTupleIndexHashTableIteratorTest
extends BaseTupleIndexHashTableIteratorTest {
    public LeftTupleIndexHashTableIteratorTest(boolean useLambdaConstraint) {
        this.useLambdaConstraint = useLambdaConstraint;
    }

    @Test
    public void test1() {
        BetaNodeFieldConstraint constraint0 = LeftTupleIndexHashTableIteratorTest.createFooThisEqualsDBetaConstraint(this.useLambdaConstraint);
        BetaNodeFieldConstraint[] constraints = new BetaNodeFieldConstraint[]{constraint0};
        RuleBaseConfiguration config = (RuleBaseConfiguration)RuleBaseFactory.newKnowledgeBaseConfiguration().as(RuleBaseConfiguration.KEY);
        SingleBetaConstraints betaConstraints = new SingleBetaConstraints(constraints, config);
        BetaMemory betaMemory = betaConstraints.createBetaMemory(config, (short)181);
        InternalKnowledgeBase kBase = KnowledgeBaseFactory.newKnowledgeBase();
        KieSession ss = kBase.newKieSession();
        InternalFactHandle fh1 = (InternalFactHandle)ss.insert((Object)new BaseTupleIndexHashTableIteratorTest.Foo("brie", 1));
        InternalFactHandle fh2 = (InternalFactHandle)ss.insert((Object)new BaseTupleIndexHashTableIteratorTest.Foo("brie", 1));
        InternalFactHandle fh3 = (InternalFactHandle)ss.insert((Object)new BaseTupleIndexHashTableIteratorTest.Foo("soda", 1));
        InternalFactHandle fh4 = (InternalFactHandle)ss.insert((Object)new BaseTupleIndexHashTableIteratorTest.Foo("soda", 1));
        InternalFactHandle fh5 = (InternalFactHandle)ss.insert((Object)new BaseTupleIndexHashTableIteratorTest.Foo("bread", 3));
        InternalFactHandle fh6 = (InternalFactHandle)ss.insert((Object)new BaseTupleIndexHashTableIteratorTest.Foo("bread", 3));
        InternalFactHandle fh7 = (InternalFactHandle)ss.insert((Object)new BaseTupleIndexHashTableIteratorTest.Foo("cream", 3));
        InternalFactHandle fh8 = (InternalFactHandle)ss.insert((Object)new BaseTupleIndexHashTableIteratorTest.Foo("gorda", 15));
        InternalFactHandle fh9 = (InternalFactHandle)ss.insert((Object)new BaseTupleIndexHashTableIteratorTest.Foo("beer", 16));
        InternalFactHandle fh10 = (InternalFactHandle)ss.insert((Object)new BaseTupleIndexHashTableIteratorTest.Foo("mars", 0));
        InternalFactHandle fh11 = (InternalFactHandle)ss.insert((Object)new BaseTupleIndexHashTableIteratorTest.Foo("snicker", 0));
        InternalFactHandle fh12 = (InternalFactHandle)ss.insert((Object)new BaseTupleIndexHashTableIteratorTest.Foo("snicker", 0));
        InternalFactHandle fh13 = (InternalFactHandle)ss.insert((Object)new BaseTupleIndexHashTableIteratorTest.Foo("snicker", 0));
        betaMemory.getLeftTupleMemory().add((Tuple)new JoinNodeLeftTuple(fh1, null, true));
        betaMemory.getLeftTupleMemory().add((Tuple)new JoinNodeLeftTuple(fh2, null, true));
        betaMemory.getLeftTupleMemory().add((Tuple)new JoinNodeLeftTuple(fh3, null, true));
        betaMemory.getLeftTupleMemory().add((Tuple)new JoinNodeLeftTuple(fh4, null, true));
        betaMemory.getLeftTupleMemory().add((Tuple)new JoinNodeLeftTuple(fh5, null, true));
        betaMemory.getLeftTupleMemory().add((Tuple)new JoinNodeLeftTuple(fh6, null, true));
        betaMemory.getLeftTupleMemory().add((Tuple)new JoinNodeLeftTuple(fh7, null, true));
        betaMemory.getLeftTupleMemory().add((Tuple)new JoinNodeLeftTuple(fh8, null, true));
        betaMemory.getLeftTupleMemory().add((Tuple)new JoinNodeLeftTuple(fh9, null, true));
        TupleIndexHashTable hashTable = (TupleIndexHashTable)betaMemory.getLeftTupleMemory();
        TupleList leftTupleList = new TupleList();
        leftTupleList.add((Tuple)new JoinNodeLeftTuple(fh10, null, true));
        hashTable.getTable()[0] = leftTupleList;
        leftTupleList = new TupleList();
        leftTupleList.add((Tuple)new JoinNodeLeftTuple(fh11, null, true));
        leftTupleList.add((Tuple)new JoinNodeLeftTuple(fh12, null, true));
        leftTupleList.add((Tuple)new JoinNodeLeftTuple(fh13, null, true));
        hashTable.getTable()[0].setNext(leftTupleList);
        List tableIndexList = this.createTableIndexListForAssertion(hashTable);
        Assertions.assertThat((int)tableIndexList.size()).isEqualTo(5);
        ArrayList<JoinNodeLeftTuple> resultList = new ArrayList<JoinNodeLeftTuple>();
        Iterator it = betaMemory.getLeftTupleMemory().iterator();
        JoinNodeLeftTuple leftTuple = (JoinNodeLeftTuple)it.next();
        while (leftTuple != null) {
            resultList.add(leftTuple);
            leftTuple = (JoinNodeLeftTuple)it.next();
        }
        Assertions.assertThat((int)resultList.size()).isEqualTo(13);
    }

    @Test
    public void testLastBucketInTheTable() {
        TupleList[] entries = new TupleList[10];
        entries[0] = (TupleList)Mockito.mock(TupleList.class);
        entries[5] = (TupleList)Mockito.mock(TupleList.class);
        entries[9] = (TupleList)Mockito.mock(TupleList.class);
        JoinNodeLeftTuple[] tuples = new JoinNodeLeftTuple[]{(JoinNodeLeftTuple)Mockito.mock(JoinNodeLeftTuple.class), (JoinNodeLeftTuple)Mockito.mock(JoinNodeLeftTuple.class), (JoinNodeLeftTuple)Mockito.mock(JoinNodeLeftTuple.class)};
        Mockito.when((Object)entries[0].getNext()).thenReturn(null);
        Mockito.when((Object)entries[0].getFirst()).thenReturn((Object)tuples[0]);
        Mockito.when((Object)entries[5].getNext()).thenReturn(null);
        Mockito.when((Object)entries[5].getFirst()).thenReturn((Object)tuples[1]);
        Mockito.when((Object)entries[9].getNext()).thenReturn(null);
        Mockito.when((Object)entries[9].getFirst()).thenReturn((Object)tuples[2]);
        AbstractHashTable table = (AbstractHashTable)Mockito.mock(AbstractHashTable.class);
        Mockito.when((Object)table.getTable()).thenReturn((Object)entries);
        TupleIndexHashTable.FieldIndexHashTableFullIterator iterator = new TupleIndexHashTable.FieldIndexHashTableFullIterator(table);
        Assertions.assertThat((Object)iterator.next()).isSameAs((Object)tuples[0]);
        Assertions.assertThat((Object)iterator.next()).isSameAs((Object)tuples[1]);
        Assertions.assertThat((Object)iterator.next()).isSameAs((Object)tuples[2]);
        Assertions.assertThat((Object)iterator.next()).isNull();
    }
}

