/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.compiler;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import org.assertj.core.api.Assertions;
import org.drools.mvel.compiler.Person;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.runtime.KieSession;

@RunWith(value=Parameterized.class)
public class NodeHashingTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public NodeHashingTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    @Test
    public void testNodeHashTypeMismatch() throws Exception {
        String drl1 = "import " + Person.class.getCanonicalName() + ";\nrule \"rule1\"\nwhen\n    Person( status == 1 )\nthen\nend\nrule \"rule2\"\nwhen\n    Person( status == 2 )\nthen\nend\n";
        KieBase kbase1 = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl1});
        KieSession ksession1 = kbase1.newKieSession();
        Person p1 = new Person();
        p1.setStatus("1");
        ksession1.insert((Object)p1);
        Assertions.assertThat((int)ksession1.fireAllRules()).isEqualTo(1);
        ksession1.dispose();
        String drl2 = "import " + Person.class.getCanonicalName() + ";\nrule \"rule1\"\nwhen\n    Person( status == 1 )\nthen\nend\nrule \"rule2\"\nwhen\n    Person( status == 2 )\nthen\nend\nrule \"rule3\"\nwhen\n    Person( status == 3 )\nthen\nend\n";
        KieBase kbase2 = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl2});
        KieSession ksession2 = kbase2.newKieSession();
        Person p2 = new Person();
        p2.setStatus("1");
        ksession2.insert((Object)p2);
        Assertions.assertThat((int)ksession2.fireAllRules()).isEqualTo(1);
        ksession2.dispose();
    }

    @Test
    public void testNodeHashTypeMismatchWithBigInteger() throws Exception {
        String drl1 = "import " + Person.class.getCanonicalName() + ";\nrule \"rule1\"\nwhen\n    Person( bigInteger == \"1\" )\nthen\nend\nrule \"rule2\"\nwhen\n    Person( bigInteger == \"2\" )\nthen\nend\n";
        KieBase kbase1 = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl1});
        KieSession ksession1 = kbase1.newKieSession();
        Person p1 = new Person();
        p1.setBigInteger(new BigInteger("1"));
        ksession1.insert((Object)p1);
        Assertions.assertThat((int)ksession1.fireAllRules()).isEqualTo(1);
        ksession1.dispose();
        String drl2 = "import " + Person.class.getCanonicalName() + ";\nrule \"rule1\"\nwhen\n    Person( bigInteger == \"1\" )\nthen\nend\nrule \"rule2\"\nwhen\n    Person( bigInteger == \"2\" )\nthen\nend\nrule \"rule3\"\nwhen\n    Person( bigInteger == \"3\" )\nthen\nend\n";
        KieBase kbase2 = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl2});
        KieSession ksession2 = kbase2.newKieSession();
        Person p2 = new Person();
        p2.setBigInteger(new BigInteger("1"));
        ksession2.insert((Object)p2);
        Assertions.assertThat((int)ksession2.fireAllRules()).isEqualTo(1);
        ksession2.dispose();
    }

    @Test
    public void testNodeHashTypeMismatchWithBigDecimal() throws Exception {
        String drl1 = "import " + Person.class.getCanonicalName() + ";\nrule \"rule1\"\nwhen\n    Person( bigDecimal == \"1.00\" )\nthen\nend\nrule \"rule2\"\nwhen\n    Person( bigDecimal == \"2.00\" )\nthen\nend\n";
        KieBase kbase1 = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl1});
        KieSession ksession1 = kbase1.newKieSession();
        Person p1 = new Person();
        p1.setBigDecimal(new BigDecimal("1.00"));
        ksession1.insert((Object)p1);
        Assertions.assertThat((int)ksession1.fireAllRules()).isEqualTo(1);
        ksession1.dispose();
        String drl2 = "import " + Person.class.getCanonicalName() + ";\nrule \"rule1\"\nwhen\n    Person( bigDecimal == \"1.00\" )\nthen\nend\nrule \"rule2\"\nwhen\n    Person( bigDecimal == \"2.00\" )\nthen\nend\nrule \"rule3\"\nwhen\n    Person( bigDecimal == \"3.00\" )\nthen\nend\n";
        KieBase kbase2 = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl2});
        KieSession ksession2 = kbase2.newKieSession();
        Person p2 = new Person();
        p2.setBigDecimal(new BigDecimal("1.00"));
        ksession2.insert((Object)p2);
        Assertions.assertThat((int)ksession2.fireAllRules()).isEqualTo(1);
        ksession2.dispose();
    }

    @Test
    public void testNodeHashTypeMismatchFromBigDecimal() throws Exception {
        String drl1 = "import " + Person.class.getCanonicalName() + ";\nimport " + BigDecimal.class.getCanonicalName() + ";\nrule \"rule1\"\nwhen\n    Person( age == new BigDecimal( 1 ) )\nthen\nend\nrule \"rule2\"\nwhen\n    Person( age == new BigDecimal( 2 ) )\nthen\nend\n";
        KieBase kbase1 = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl1});
        KieSession ksession1 = kbase1.newKieSession();
        Person p1 = new Person();
        p1.setAge(1);
        ksession1.insert((Object)p1);
        Assertions.assertThat((int)ksession1.fireAllRules()).isEqualTo(1);
        ksession1.dispose();
        String drl2 = "import " + Person.class.getCanonicalName() + ";\nimport " + BigDecimal.class.getCanonicalName() + ";\nrule \"rule1\"\nwhen\n    Person( age == new BigDecimal( 1 ) )\nthen\nend\nrule \"rule2\"\nwhen\n    Person( age == new BigDecimal( 2 ) )\nthen\nend\nrule \"rule3\"\nwhen\n    Person( age == new BigDecimal( 3 ) )\nthen\nend\n";
        KieBase kbase2 = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl2});
        KieSession ksession2 = kbase2.newKieSession();
        Person p2 = new Person();
        p2.setAge(1);
        ksession2.insert((Object)p2);
        Assertions.assertThat((int)ksession2.fireAllRules()).isEqualTo(1);
        ksession2.dispose();
    }

    @Test
    public void testNodeHashTypeMismatchWithPrimitiveDouble() throws Exception {
        String drl1 = "import " + Person.class.getCanonicalName() + ";\nimport " + BigDecimal.class.getCanonicalName() + ";\nrule \"rule1\"\nwhen\n    Person( age == 1.0 )\nthen\nend\nrule \"rule2\"\nwhen\n    Person( age == 2.0 )\nthen\nend\n";
        KieBase kbase1 = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl1});
        KieSession ksession1 = kbase1.newKieSession();
        Person p1 = new Person();
        p1.setAge(1);
        ksession1.insert((Object)p1);
        Assertions.assertThat((int)ksession1.fireAllRules()).isEqualTo(1);
        ksession1.dispose();
        String drl2 = "import " + Person.class.getCanonicalName() + ";\nimport " + BigDecimal.class.getCanonicalName() + ";\nrule \"rule1\"\nwhen\n    Person( age == 1.0 )\nthen\nend\nrule \"rule2\"\nwhen\n    Person( age == 2.0 )\nthen\nend\nrule \"rule3\"\nwhen\n    Person( age == 3.0 )\nthen\nend\n";
        KieBase kbase2 = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl2});
        KieSession ksession2 = kbase2.newKieSession();
        Person p2 = new Person();
        p2.setAge(1);
        ksession2.insert((Object)p2);
        Assertions.assertThat((int)ksession2.fireAllRules()).isEqualTo(1);
        ksession2.dispose();
    }

    @Test
    public void testNodeHashTypeMismatchWithBigIntegerAndDecimal() throws Exception {
        String drl1 = "import " + Person.class.getCanonicalName() + ";\nimport " + BigInteger.class.getCanonicalName() + ";\nrule \"rule1\"\nwhen\n    Person( bigDecimal == new BigInteger( \"1\" ) )\nthen\nend\nrule \"rule2\"\nwhen\n    Person( bigDecimal == new BigInteger( \"2\" ) )\nthen\nend\n";
        KieBase kbase1 = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl1});
        KieSession ksession1 = kbase1.newKieSession();
        Person p1 = new Person();
        p1.setBigDecimal(new BigDecimal(1));
        ksession1.insert((Object)p1);
        Assertions.assertThat((int)ksession1.fireAllRules()).isEqualTo(1);
        ksession1.dispose();
        String drl2 = "import " + Person.class.getCanonicalName() + ";\nimport " + BigInteger.class.getCanonicalName() + ";\nrule \"rule1\"\nwhen\n    Person( bigDecimal == new BigInteger( \"1\" ) )\nthen\nend\nrule \"rule2\"\nwhen\n    Person( bigDecimal == new BigInteger( \"2\" ) )\nthen\nend\nrule \"rule3\"\nwhen\n    Person( bigDecimal == new BigInteger( \"3\" ) )\nthen\nend\n";
        KieBase kbase2 = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl2});
        KieSession ksession2 = kbase2.newKieSession();
        Person p2 = new Person();
        p2.setBigDecimal(new BigDecimal(1));
        ksession2.insert((Object)p2);
        Assertions.assertThat((int)ksession2.fireAllRules()).isEqualTo(1);
        ksession2.dispose();
    }

    @Test
    public void testNodeHashTypeMismatchWithDouble() throws Exception {
        String drl1 = "import " + DoubleValue.class.getCanonicalName() + ";\nrule \"rule1\"\nwhen\n    DoubleValue( value == \"1.00\" )\nthen\nend\nrule \"rule2\"\nwhen\n    DoubleValue( value == \"2.00\" )\nthen\nend\n";
        KieBase kbase1 = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl1});
        KieSession ksession1 = kbase1.newKieSession();
        ksession1.insert((Object)new DoubleValue(1.0));
        Assertions.assertThat((int)ksession1.fireAllRules()).isEqualTo(1);
        ksession1.dispose();
        String drl2 = "import " + DoubleValue.class.getCanonicalName() + ";\nrule \"rule1\"\nwhen\n    DoubleValue( value == \"1.00\" )\nthen\nend\nrule \"rule2\"\nwhen\n    DoubleValue( value == \"2.00\" )\nthen\nend\nrule \"rule3\"\nwhen\n    DoubleValue( value == \"3.00\" )\nthen\nend\n";
        KieBase kbase2 = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl2});
        KieSession ksession2 = kbase2.newKieSession();
        ksession2.insert((Object)new DoubleValue(1.0));
        Assertions.assertThat((int)ksession2.fireAllRules()).isEqualTo(1);
        ksession2.dispose();
    }

    @Test
    public void testHashingOnClassConstraint() {
        String drl = "import " + A.class.getCanonicalName() + "\nrule R1 when\n    A( configClass == String.class );\nthen\nend\n\nrule R2 when\n    A( configClass == String.class );\nthen\nend\n\nrule R3 when\n    A( configClass == String.class );\nthen\nend\n\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession kieSession = kbase.newKieSession();
        kieSession.insert((Object)new A());
        Assertions.assertThat((int)kieSession.fireAllRules()).isEqualTo(3);
    }

    public static class A {
        public Class<?> getConfigClass() {
            return String.class;
        }
    }

    public static class DoubleValue {
        private final Double value;

        public DoubleValue(Double value) {
            this.value = value;
        }

        public Double getValue() {
            return this.value;
        }
    }
}

