/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.compiler.common;

import java.util.ArrayList;
import java.util.Collection;
import org.assertj.core.api.Assertions;
import org.drools.core.reteoo.TerminalNode;
import org.drools.core.util.Iterator;
import org.drools.serialization.protobuf.iterators.TerminalNodeIterator;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;

@RunWith(value=Parameterized.class)
public class TerminalNodeIteratorTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public TerminalNodeIteratorTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    @Test
    public void testTerminalNodeListener() {
        String str = "package org.kie.test \n\nrule rule1 when\nthen\nend\nrule rule2 when\nthen\nend\nrule rule3 when\n    Object()then\nend\nrule rule4 when\n    Object()then\nend\nrule rule5 when\n    Object() or\n    Object()\nthen\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        ArrayList<String> nodes = new ArrayList<String>();
        Iterator it = TerminalNodeIterator.iterator((KieBase)kbase);
        TerminalNode node = (TerminalNode)it.next();
        while (node != null) {
            nodes.add(node.getRule().getName());
            node = (TerminalNode)it.next();
        }
        Assertions.assertThat((int)nodes.size()).isEqualTo(6);
        Assertions.assertThat((boolean)nodes.contains("rule1")).isTrue();
        Assertions.assertThat((boolean)nodes.contains("rule2")).isTrue();
        Assertions.assertThat((boolean)nodes.contains("rule3")).isTrue();
        Assertions.assertThat((boolean)nodes.contains("rule4")).isTrue();
        Assertions.assertThat((boolean)nodes.contains("rule5")).isTrue();
        int first = nodes.indexOf("rule5");
        int second = nodes.lastIndexOf("rule5");
        Assertions.assertThat((first != second ? 1 : 0) != 0).isTrue();
    }
}

