/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.compiler.definitions;

import java.util.Collection;
import org.assertj.core.api.Assertions;
import org.drools.core.definitions.rule.impl.GlobalImpl;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.definition.KiePackage;
import org.kie.api.definition.rule.Query;
import org.kie.api.definition.type.FactField;
import org.kie.api.definition.type.FactType;

@RunWith(value=Parameterized.class)
public class KnowledgePackageMetaDataTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;
    private String drl = "package org.drools.mvel.compiler.test.definitions \nimport java.util.List; \n\nglobal Integer N; \nglobal List list; \n\nfunction void fun1() {}\n\nfunction String fun2( int j ) { return null; } \n\ndeclare Person\n  name : String\n  age  : int\nend\n\ndeclare Foo extends Person\n   bar : String\nend \n\nquery qry1() \n  Foo()\nend\n\nquery qry2( String x )\n  x := String()\nend\n\nrule \"rule1\"\nwhen\nthen\nend\n\nrule \"rule2\"\nwhen\nthen\nend";

    public KnowledgePackageMetaDataTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    @Test
    public void testMetaData() {
        KieBase kBase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{this.drl});
        KiePackage pack = kBase.getKiePackage("org.drools.mvel.compiler.test.definitions");
        Assertions.assertThat((Object)pack).isNotNull();
        if (!this.kieBaseTestConfiguration.isExecutableModel()) {
            Assertions.assertThat((int)pack.getFunctionNames().size()).isEqualTo(2);
            Assertions.assertThat((boolean)pack.getFunctionNames().contains("fun1")).isTrue();
            Assertions.assertThat((boolean)pack.getFunctionNames().contains("fun2")).isTrue();
        }
        Assertions.assertThat((int)pack.getGlobalVariables().size()).isEqualTo(2);
        GlobalImpl g1 = new GlobalImpl("N", "java.lang.Integer");
        GlobalImpl g2 = new GlobalImpl("list", "java.util.List");
        Assertions.assertThat((boolean)pack.getGlobalVariables().contains(g1)).isTrue();
        Assertions.assertThat((boolean)pack.getGlobalVariables().contains(g2)).isTrue();
        Assertions.assertThat((int)pack.getFactTypes().size()).isEqualTo(2);
        for (int j = 0; j < 2; ++j) {
            FactType type = (FactType)pack.getFactTypes().iterator().next();
            if (type.getName().equals("org.drools.mvel.compiler.test.definitions.Person")) {
                Assertions.assertThat((int)type.getFields().size()).isEqualTo(2);
                continue;
            }
            if (type.getName().equals("org.drools.mvel.compiler.test.definitions.Foo")) {
                Assertions.assertThat((String)type.getSuperClass()).isEqualTo("org.drools.mvel.compiler.test.definitions.Person");
                FactField fld = type.getField("bar");
                Assertions.assertThat((int)fld.getIndex()).isEqualTo(2);
                Assertions.assertThat((Class)fld.getType()).isEqualTo(String.class);
                continue;
            }
            Assertions.fail((String)("Unexpected fact type " + type));
        }
        Assertions.assertThat((int)pack.getQueries().size()).isEqualTo(2);
        for (Query q : pack.getQueries()) {
            Assertions.assertThat((q.getName().equals("qry1") || q.getName().equals("qry2") ? 1 : 0) != 0).isTrue();
        }
        Assertions.assertThat((int)pack.getRules().size()).isEqualTo(4);
        Assertions.assertThat((boolean)pack.getRules().containsAll(pack.getQueries())).isTrue();
    }
}

