/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.compiler.kie.builder.impl;

import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import org.assertj.core.api.Assertions;
import org.drools.compiler.kie.builder.impl.ClasspathKieProject;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ClasspathKieProjectTransformUrlToFileSystemPathTest {
    @Parameterized.Parameter(value=0)
    public URL url;
    @Parameterized.Parameter(value=1)
    public String expectedPath;

    @Parameterized.Parameters(name="URL={0}, expectedPath={1}")
    public static Collection<Object[]> data() throws Exception {
        return Arrays.asList({new URL("file:/some-path-to-the-module/target/test-classes"), "/some-path-to-the-module/target/test-classes"}, {new URL("file:/some-path-to-the-module/target/test-classes/META-INF/kmodule.xml"), "/some-path-to-the-module/target/test-classes"}, {new URL("jar:file:/C:/proj/parser/jar/parser.jar!/test.xml"), "/C:/proj/parser/jar/parser.jar"});
    }

    @Test
    public void testTransformUrl() {
        String actualPath = ClasspathKieProject.fixURLFromKProjectPath((URL)this.url);
        Assertions.assertThat((String)actualPath).isEqualTo(this.expectedPath);
    }
}

