/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.compiler.lang;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.drools.drl.parser.DRLFactory;
import org.drools.drl.parser.DroolsParserException;
import org.drools.drl.parser.lang.DRLParser;
import org.drools.drl.parser.lang.dsl.DefaultExpander;
import org.junit.Test;
import org.kie.internal.builder.conf.LanguageLevelOption;

public class ErrorsParserTest {
    @Test
    public void testNotBindindShouldBarf() throws Exception {
        DRLParser parser = this.parseResource("not_with_binding_error.drl");
        parser.compilationUnit();
        Assertions.assertThat((boolean)parser.hasErrors()).isTrue();
    }

    @Test
    public void testExpanderErrorsAfterExpansion() throws Exception {
        String name = "expander_post_errors.dslr";
        DefaultExpander expander = new DefaultExpander();
        String expanded = expander.expand(this.getReader(name));
        DRLParser parser = this.parse(name, expanded);
        parser.compilationUnit();
        Assertions.assertThat((boolean)parser.hasErrors()).isTrue();
        Assertions.assertThat((int)parser.getErrors().size()).isEqualTo(1);
        DroolsParserException err = (DroolsParserException)((Object)parser.getErrors().get(0));
        Assertions.assertThat((int)err.getLineNumber()).isEqualTo(6);
    }

    @Test
    public void testInvalidSyntax_Catches() throws Exception {
        DRLParser parser = this.parseResource("invalid_syntax.drl");
        parser.compilationUnit();
        Assertions.assertThat((boolean)parser.hasErrors()).isTrue();
    }

    @Test
    public void testMultipleErrors() throws Exception {
        DRLParser parser = this.parseResource("multiple_errors.drl");
        parser.compilationUnit();
        Assertions.assertThat((boolean)parser.hasErrors()).isTrue();
        Assertions.assertThat((int)parser.getErrors().size()).isEqualTo(2);
    }

    @Test
    public void testPackageGarbage() throws Exception {
        DRLParser parser = this.parseResource("package_garbage.drl");
        parser.compilationUnit();
        Assertions.assertThat((boolean)parser.hasErrors()).isTrue();
    }

    @Test
    public void testEvalWithSemicolon() throws Exception {
        DRLParser parser = this.parseResource("eval_with_semicolon.drl");
        parser.compilationUnit();
        Assertions.assertThat((boolean)parser.hasErrors()).isTrue();
        Assertions.assertThat((int)parser.getErrorMessages().size()).isEqualTo(1);
        Assertions.assertThat((String)((DroolsParserException)((Object)parser.getErrors().get(0))).getErrorCode()).isEqualTo("ERR 102");
    }

    @Test
    public void testLexicalError() throws Exception {
        DRLParser parser = this.parseResource("lex_error.drl");
        parser.compilationUnit();
        Assertions.assertThat((boolean)parser.hasErrors()).isTrue();
    }

    @Test
    public void testTempleteError() throws Exception {
        DRLParser parser = this.parseResource("template_test_error.drl");
        parser.compilationUnit();
        Assertions.assertThat((boolean)parser.hasErrors()).isTrue();
    }

    @Test
    public void testErrorMessageForMisplacedParenthesis() throws Exception {
        DRLParser parser = this.parseResource("misplaced_parenthesis.drl");
        parser.compilationUnit();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)parser.hasErrors()).as("Parser should have raised errors", new Object[0])).isTrue();
        Assertions.assertThat((int)parser.getErrors().size()).isEqualTo(1);
        Assertions.assertThat((String)((DroolsParserException)((Object)parser.getErrors().get(0))).getErrorCode()).isEqualTo("ERR 102");
    }

    @Test
    public void testNPEOnParser() throws Exception {
        DRLParser parser = this.parseResource("npe_on_parser.drl");
        parser.compilationUnit();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)parser.hasErrors()).as("Parser should have raised errors", new Object[0])).isTrue();
        Assertions.assertThat((int)parser.getErrors().size()).isEqualTo(1);
        Assertions.assertThat((boolean)((DroolsParserException)((Object)parser.getErrors().get(0))).getErrorCode().equals("ERR 102")).isTrue();
    }

    @Test
    public void testCommaMisuse() throws Exception {
        DRLParser parser = this.parseResource("comma_misuse.drl");
        try {
            parser.compilationUnit();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)parser.hasErrors()).as("Parser should have raised errors", new Object[0])).isTrue();
        }
        catch (NullPointerException npe) {
            Assertions.fail((String)"Should not raise NPE");
        }
    }

    private DRLParser parse(String source, String text) throws Exception {
        return DRLFactory.buildParser((String)text, (LanguageLevelOption)LanguageLevelOption.DRL5);
    }

    private Reader getReader(String name) throws Exception {
        InputStream in = this.getClass().getResourceAsStream(name);
        return new InputStreamReader(in);
    }

    private DRLParser parseResource(String name) throws Exception {
        int len;
        Reader reader = this.getReader(name);
        StringBuilder text = new StringBuilder();
        char[] buf = new char[1024];
        while ((len = reader.read(buf)) >= 0) {
            text.append(buf, 0, len);
        }
        return this.parse(name, text.toString());
    }
}

