/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.definition.type.FactType;
import org.kie.api.runtime.KieSession;

@RunWith(value=Parameterized.class)
public class GeneratedBeansTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public GeneratedBeansTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    @Test
    public void testGeneratedBeans1() throws Exception {
        KieBase kbase = KieBaseUtil.getKieBaseFromClasspathResources(this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"test_GeneratedBeans.drl"});
        FactType cheeseFact = kbase.getFactType("org.drools.generatedbeans", "Cheese");
        Object cheese = cheeseFact.newInstance();
        cheeseFact.set(cheese, "type", (Object)"stilton");
        Assertions.assertThat((Object)cheeseFact.get(cheese, "type")).isEqualTo((Object)"stilton");
        FactType personType = kbase.getFactType("org.drools.generatedbeans", "Person");
        Object ps = personType.newInstance();
        personType.set(ps, "age", (Object)42);
        Map personMap = personType.getAsMap(ps);
        Assertions.assertThat(personMap.get("age")).isEqualTo((Object)42);
        personMap.put("age", 43);
        personType.setFromMap(ps, personMap);
        Assertions.assertThat((Object)personType.get(ps, "age")).isEqualTo((Object)43);
        Assertions.assertThat((Object)cheeseFact.getField("type").get(cheese)).isEqualTo((Object)"stilton");
        KieSession ksession = kbase.newKieSession();
        Object cg = cheeseFact.newInstance();
        ksession.setGlobal("cg", cg);
        ArrayList result = new ArrayList();
        ksession.setGlobal("list", result);
        ksession.insert(cheese);
        ksession.fireAllRules();
        Assertions.assertThat((int)result.size()).isEqualTo(1);
        Assertions.assertThat(result.get(0)).isEqualTo((Object)5);
        FactType personFact = kbase.getFactType("org.drools.generatedbeans", "Person");
        Object person = personFact.newInstance();
        personFact.getField("likes").set(person, cheese);
        personFact.getField("age").set(person, (Object)7);
        ksession.insert(person);
        ksession.fireAllRules();
        Assertions.assertThat((int)result.size()).isEqualTo(2);
        Assertions.assertThat(result.get(1)).isEqualTo(person);
    }

    @Test
    public void testGeneratedBeans2() throws Exception {
        KieBase kbase = KieBaseUtil.getKieBaseFromClasspathResources(this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"test_GeneratedBeans2.drl"});
        FactType cheeseFact = kbase.getFactType("org.drools.generatedbeans", "Cheese");
        Object cheese = cheeseFact.newInstance();
        cheeseFact.set(cheese, "type", (Object)"stilton");
        Assertions.assertThat((Object)cheeseFact.get(cheese, "type")).isEqualTo((Object)"stilton");
        Object cheese2 = cheeseFact.newInstance();
        cheeseFact.set(cheese2, "type", (Object)"stilton");
        Assertions.assertThat((Object)cheese2).isEqualTo(cheese);
        FactType personType = kbase.getFactType("org.drools.generatedbeans", "Person");
        Object ps = personType.newInstance();
        personType.set(ps, "name", (Object)"mark");
        personType.set(ps, "last", (Object)"proctor");
        personType.set(ps, "age", (Object)42);
        Object ps2 = personType.newInstance();
        personType.set(ps2, "name", (Object)"mark");
        personType.set(ps2, "last", (Object)"proctor");
        personType.set(ps2, "age", (Object)30);
        Assertions.assertThat((Object)ps2).isEqualTo(ps);
        personType.set(ps2, "last", (Object)"little");
        Assertions.assertThat((boolean)ps.equals(ps2)).isFalse();
        KieSession wm = kbase.newKieSession();
        Object cg = cheeseFact.newInstance();
        wm.setGlobal("cg", cg);
        ArrayList result = new ArrayList();
        wm.setGlobal("list", result);
        wm.insert(cheese);
        wm.fireAllRules();
        Assertions.assertThat((int)result.size()).isEqualTo(1);
        Assertions.assertThat(result.get(0)).isEqualTo((Object)5);
        FactType personFact = kbase.getFactType("org.drools.generatedbeans", "Person");
        Object person = personFact.newInstance();
        personFact.getField("likes").set(person, cheese);
        personFact.getField("age").set(person, (Object)7);
        wm.insert(person);
        wm.fireAllRules();
        Assertions.assertThat((int)result.size()).isEqualTo(2);
        Assertions.assertThat(result.get(1)).isEqualTo(person);
    }

    @Test
    public void testGeneratedBeansSerializable() throws Exception {
        KieBase kbase = KieBaseUtil.getKieBaseFromClasspathResources(this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"test_GeneratedBeansSerializable.drl"});
        FactType cheeseFact = kbase.getFactType("org.drools.generatedbeans", "Cheese");
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)Serializable.class.isAssignableFrom(cheeseFact.getFactClass())).as("Generated beans must be serializable", new Object[0])).isTrue();
        Object cheese = cheeseFact.newInstance();
        cheeseFact.set(cheese, "type", (Object)"stilton");
        Object cheese2 = cheeseFact.newInstance();
        cheeseFact.set(cheese2, "type", (Object)"brie");
        KieSession ksession = kbase.newKieSession();
        ArrayList results = new ArrayList();
        ksession.setGlobal("results", results);
        ksession.insert(cheese);
        ksession.insert(cheese2);
        ksession.fireAllRules();
        Assertions.assertThat((int)results.size()).isEqualTo(1);
        Assertions.assertThat((int)((Number)results.get(0)).intValue()).isEqualTo(2);
    }
}

