/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.drools.mvel.compiler.Cheese;
import org.drools.mvel.integrationtests.SerializationHelper;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.runtime.Channel;
import org.kie.api.runtime.KieSession;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=Parameterized.class)
public class IntegrationInterfacesTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public IntegrationInterfacesTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    private KieBase getKnowledgeBase(String resourceName) {
        return KieBaseUtil.getKieBaseFromClasspathResources(this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{resourceName});
    }

    @Test
    public void testGlobals() throws Exception {
        KieBase kbase = this.getKnowledgeBase("globals_rule_test.drl");
        KieSession ksession = kbase.newKieSession();
        List list = (List)Mockito.mock(List.class);
        ksession.setGlobal("list", (Object)list);
        ksession.setGlobal("string", (Object)"stilton");
        Cheese stilton = new Cheese("stilton", 5);
        ksession.insert((Object)stilton);
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
        ksession.fireAllRules();
        ((List)Mockito.verify((Object)list, (VerificationMode)Mockito.times((int)1))).add(new Integer(5));
    }

    @Test
    public void testGlobals2() throws Exception {
        KieBase kbase = this.getKnowledgeBase("test_globalsAsConstraints.drl");
        KieSession ksession = kbase.newKieSession();
        List results = (List)Mockito.mock(List.class);
        ksession.setGlobal("results", (Object)results);
        List cheeseTypes = (List)Mockito.mock(List.class);
        ksession.setGlobal("cheeseTypes", (Object)cheeseTypes);
        Mockito.when((Object)cheeseTypes.contains("stilton")).thenReturn((Object)Boolean.TRUE);
        Mockito.when((Object)cheeseTypes.contains("muzzarela")).thenReturn((Object)Boolean.TRUE);
        Cheese stilton = new Cheese("stilton", 5);
        ksession.insert((Object)stilton);
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
        ksession.fireAllRules();
        ((List)Mockito.verify((Object)results, (VerificationMode)Mockito.times((int)1))).add("memberOf");
        Cheese brie = new Cheese("brie", 5);
        ksession.insert((Object)brie);
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
        ksession.fireAllRules();
        ((List)Mockito.verify((Object)results, (VerificationMode)Mockito.times((int)1))).add("not memberOf");
    }

    @Test
    public void testGlobalMerge() throws Exception {
        String rule1 = "package com.sample\nrule \"rule 1\"\n    salience 10\n    when\n        l : java.util.List()\n    then\n        l.add( \"rule 1 executed\" );\nend\n";
        String rule2 = "package com.sample\nglobal String str;\nrule \"rule 2\"\n    when\n        l : java.util.List()\n    then\n        l.add( \"rule 2 executed \" + str);\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{rule1, rule2});
        KieSession ksession = kbase.newKieSession();
        ksession.setGlobal("str", (Object)"boo");
        ArrayList list = new ArrayList();
        ksession.insert(list);
        ksession.fireAllRules();
        Assertions.assertThat((String)((String)list.get(0))).isEqualTo("rule 1 executed");
        Assertions.assertThat((String)((String)list.get(1))).isEqualTo("rule 2 executed boo");
    }

    @Test
    public void testChannels() throws IOException, ClassNotFoundException {
        KieBase kbase = this.getKnowledgeBase("test_Channels.drl");
        KieSession ksession = kbase.newKieSession();
        Channel someChannel = (Channel)Mockito.mock(Channel.class);
        ksession.registerChannel("someChannel", someChannel);
        ksession.insert((Object)new Cheese("brie", 30));
        ksession.insert((Object)new Cheese("stilton", 5));
        ksession.fireAllRules();
        ((Channel)Mockito.verify((Object)someChannel)).send((Object)"brie");
        ((Channel)Mockito.verify((Object)someChannel, (VerificationMode)Mockito.never())).send((Object)"stilton");
    }
}

