/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.drools.mvel.compiler.Attribute;
import org.drools.mvel.compiler.Cheese;
import org.drools.mvel.compiler.Message;
import org.drools.mvel.compiler.Person;
import org.drools.mvel.compiler.Primitives;
import org.drools.mvel.integrationtests.SerializationHelper;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.runtime.KieSession;

@RunWith(value=Parameterized.class)
public class NullTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public NullTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)false);
    }

    @Test
    public void testNullValuesIndexing() throws Exception {
        KieBase kbase = KieBaseUtil.getKieBaseFromClasspathResources(this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"test_NullValuesIndexing.drl"});
        KieSession ksession = kbase.newKieSession();
        Person bob = new Person(null, null);
        bob.setStatus("P1");
        Person pete = new Person(null, null);
        bob.setStatus("P2");
        ksession.insert((Object)bob);
        ksession.insert((Object)pete);
        ksession.fireAllRules();
        ((AbstractStringAssert)Assertions.assertThat((String)bob.getStatus()).as("Indexing with null values is not working correctly.", new Object[0])).isEqualTo("OK");
        ((AbstractStringAssert)Assertions.assertThat((String)pete.getStatus()).as("Indexing with null values is not working correctly.", new Object[0])).isEqualTo("OK");
    }

    @Test
    public void testNullBehaviour() throws Exception {
        KieBase kbase = KieBaseUtil.getKieBaseFromClasspathResources(this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"null_behaviour.drl"});
        KieSession session = kbase.newKieSession();
        Person p1 = new Person("michael", "food", 40);
        Person p2 = new Person(null, "drink", 30);
        session.insert((Object)p1);
        session.insert((Object)p2);
        session = SerializationHelper.getSerialisedStatefulKnowledgeSession(session, true);
        session.fireAllRules();
    }

    @Test
    public void testNullConstraint() throws Exception {
        KieBase kbase = KieBaseUtil.getKieBaseFromClasspathResources(this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"null_constraint.drl"});
        KieSession session = kbase.newKieSession();
        ArrayList foo = new ArrayList();
        session.setGlobal("messages", foo);
        Person p1 = new Person(null, "food", 40);
        Primitives p2 = new Primitives();
        p2.setArrayAttribute(null);
        session.insert((Object)p1);
        session.insert((Object)p2);
        session = SerializationHelper.getSerialisedStatefulKnowledgeSession(session, true);
        session.fireAllRules();
        Assertions.assertThat((int)((List)session.getGlobal("messages")).size()).isEqualTo(2);
    }

    @Test
    public void testNullBinding() throws Exception {
        KieBase kbase = KieBaseUtil.getKieBaseFromClasspathResources(this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"test_nullBindings.drl"});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("results", list);
        ksession.insert((Object)new Person("bob"));
        ksession.insert((Object)new Person(null));
        ksession.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(1);
        Assertions.assertThat(list.get(0)).isEqualTo((Object)"OK");
    }

    @Test
    public void testNullConstantLeft() {
        String str = "import org.drools.mvel.compiler.*;\nrule R1 when\n   $p : Person( null == name )\nthen\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"import org.drools.mvel.compiler.*;\nrule R1 when\n   $p : Person( null == name )\nthen\nend"});
        KieSession ksession = kbase.newKieSession();
        ksession.insert((Object)new Person(null));
        ksession.insert((Object)new Person("Mark"));
        Assertions.assertThat((int)ksession.fireAllRules()).isEqualTo(1);
        ksession.dispose();
    }

    @Test
    public void testNullFieldOnCompositeSink() throws Exception {
        KieBase kbase = KieBaseUtil.getKieBaseFromClasspathResources(this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"test_NullFieldOnCompositeSink.drl"});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)new Attribute());
        ksession.insert((Object)new Message());
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
        ksession.fireAllRules();
        Assertions.assertThat((int)((List)ksession.getGlobal("list")).size()).isEqualTo(1);
        Assertions.assertThat(((List)ksession.getGlobal("list")).get(0)).isEqualTo((Object)"X");
    }

    @Test
    public void testNullHandling() throws Exception {
        KieBase kbase = KieBaseUtil.getKieBaseFromClasspathResources(this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"test_NullHandling.drl"});
        KieSession session = kbase.newKieSession();
        ArrayList list = new ArrayList();
        session.setGlobal("list", list);
        Cheese nullCheese = new Cheese(null, 2);
        session.insert((Object)nullCheese);
        Person notNullPerson = new Person("shoes butt back");
        notNullPerson.setBigDecimal(new BigDecimal("42.42"));
        session.insert((Object)notNullPerson);
        Person nullPerson = new Person("whee");
        nullPerson.setBigDecimal(null);
        session.insert((Object)nullPerson);
        session = SerializationHelper.getSerialisedStatefulKnowledgeSession(session, true);
        session.fireAllRules();
        Assertions.assertThat((int)((List)session.getGlobal("list")).size()).isEqualTo(3);
        nullPerson = new Person(null);
        session.insert((Object)nullPerson);
        session.fireAllRules();
        Assertions.assertThat((int)((List)session.getGlobal("list")).size()).isEqualTo(4);
    }

    @Test
    public void testNullHashing() throws Exception {
        KieBase kbase = KieBaseUtil.getKieBaseFromClasspathResources(this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"test_NullHashing.drl"});
        KieSession ksession = kbase.newKieSession();
        ArrayList results = new ArrayList();
        ksession.setGlobal("results", results);
        ksession.insert((Object)new Cheese("stilton", 15));
        ksession.insert((Object)new Cheese("", 10));
        ksession.insert((Object)new Cheese(null, 8));
        ksession.fireAllRules();
        Assertions.assertThat((int)results.size()).isEqualTo(3);
    }

    @Test
    public void testBindingToNullFieldWithEquality() {
        String str = "package org.drools.mvel.compiler.test; \n\nglobal java.util.List list;\ndeclare Bean\n  id    : String @key\n  field : String\nend\n\n\nrule \"Init\"\nwhen  \nthen\n  insert( new Bean( \"x\" ) );\nend\n\nrule \"Check\"\nwhen\n  $b : Bean( $fld : field )\nthen\n  System.out.println( $fld );\n  list.add( \"OK\" ); \nend";
        KieBaseTestConfiguration equalityConfig = TestParametersUtil.getEqualityInstanceOf((KieBaseTestConfiguration)this.kieBaseTestConfiguration);
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)equalityConfig, (String[])new String[]{"package org.drools.mvel.compiler.test; \n\nglobal java.util.List list;\ndeclare Bean\n  id    : String @key\n  field : String\nend\n\n\nrule \"Init\"\nwhen  \nthen\n  insert( new Bean( \"x\" ) );\nend\n\nrule \"Check\"\nwhen\n  $b : Bean( $fld : field )\nthen\n  System.out.println( $fld );\n  list.add( \"OK\" ); \nend"});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        Assertions.assertThat((boolean)list.contains("OK")).isTrue();
        ksession.dispose();
    }

    @Test
    public void testArithmeticExpressionWithNull() {
        String str = "import " + PrimitiveBean.class.getCanonicalName() + ";\nrule R when\n   PrimitiveBean(primitive/typed > 0.7)\nthen\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        ksession.insert((Object)new PrimitiveBean(0.9, 1.1));
        ksession.insert((Object)new PrimitiveBean(0.9, null));
        Assertions.assertThat((int)ksession.fireAllRules()).isEqualTo(1);
        ksession.dispose();
    }

    public static class PrimitiveBean {
        public final double primitive;
        public final Double typed;

        public PrimitiveBean(double primitive, Double typed) {
            this.primitive = primitive;
            this.typed = typed;
        }

        public double getPrimitive() {
            return this.primitive;
        }

        public Double getTyped() {
            return this.typed;
        }
    }
}

