/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.assertj.core.api.Assertions;
import org.drools.core.event.DebugAgendaEventListener;
import org.drools.core.reteoo.ReteDumper;
import org.drools.mvel.compiler.Cell;
import org.drools.mvel.compiler.Neighbor;
import org.drools.mvel.compiler.Person;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.event.rule.AgendaEventListener;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.FactHandle;

@RunWith(value=Parameterized.class)
public class PropertyReactivityBlockerTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public PropertyReactivityBlockerTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    @Test
    public void testA_NotWorking() {
        String drl = "import " + Person.class.getCanonicalName() + ";\nglobal java.util.List list;\nrule R when\n    $p1 : Person( name == \"Mario\" ) \n    $p2 : Person( age > $p1.age ) \nthen\n    list.add(\"t0\");\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        ReteDumper.dumpRete((KieSession)ksession);
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        Person mario = new Person("Mario", 40);
        Person mark = new Person("Mark", 37);
        FactHandle fh_mario = ksession.insert((Object)mario);
        ksession.insert((Object)mark);
        ksession.fireAllRules();
        mario.setAge(35);
        ksession.update(fh_mario, (Object)mario, new String[]{"age"});
        int x = ksession.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(1);
        Assertions.assertThat((String)((String)list.get(0))).isEqualTo("t0");
    }

    @Test
    public void testAbis_NotWorking() {
        String drl = "import " + Person.class.getCanonicalName() + ";\nglobal java.util.List list;\nrule R when\n    $p1 : Person( name == \"Mario\" ) \n    $p2 : Person( age > $p1.age ) \nthen\n    list.add(\"t0\");\nend\nrule Z when\n    $p1 : Person( name == \"Mario\" ) \nthen\n    modify($p1) { setAge(35); } \nend\n";
        HashMap<String, String> kieModuleConfigurationProperties = new HashMap<String, String>();
        kieModuleConfigurationProperties.put("drools.propertySpecific", "ALWAYS");
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, kieModuleConfigurationProperties, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        ksession.addEventListener((AgendaEventListener)new DebugAgendaEventListener());
        System.out.println(drl);
        ReteDumper.dumpRete((KieSession)ksession);
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        Person mario = new Person("Mario", 40);
        Person mark = new Person("Mark", 37);
        FactHandle fh_mario = ksession.insert((Object)mario);
        ksession.insert((Object)mark);
        int x = ksession.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(1);
        Assertions.assertThat((String)((String)list.get(0))).isEqualTo("t0");
    }

    @Test
    public void testA_Working() {
        String drl = "import " + Person.class.getCanonicalName() + ";\nglobal java.util.List list;\nrule R when\n    $p1 : Person( name == \"Mario\", $a1: age ) \n    $p2 : Person( age > $a1 ) \nthen\n    list.add(\"t0\");\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        ReteDumper.dumpRete((KieSession)ksession);
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        Person mario = new Person("Mario", 40);
        Person mark = new Person("Mark", 37);
        FactHandle fh_mario = ksession.insert((Object)mario);
        ksession.insert((Object)mark);
        ksession.fireAllRules();
        mario.setAge(35);
        ksession.update(fh_mario, (Object)mario, new String[]{"age"});
        int x = ksession.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(1);
        Assertions.assertThat((String)((String)list.get(0))).isEqualTo("t0");
    }

    @Test
    public void testAbis_Working() {
        String drl = "import " + Person.class.getCanonicalName() + ";\nglobal java.util.List list;\nrule R when\n    $p1 : Person( name == \"Mario\", $a1: age) \n    $p2 : Person( age > $a1 ) \nthen\n    list.add(\"t0\");\nend\nrule Z when\n    $p1 : Person( name == \"Mario\" ) \nthen\n    modify($p1) { setAge(35); } \nend\n";
        HashMap<String, String> kieModuleConfigurationProperties = new HashMap<String, String>();
        kieModuleConfigurationProperties.put("drools.propertySpecific", "ALWAYS");
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, kieModuleConfigurationProperties, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        System.out.println(drl);
        ReteDumper.dumpRete((KieSession)ksession);
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        Person mario = new Person("Mario", 40);
        Person mark = new Person("Mark", 37);
        FactHandle fh_mario = ksession.insert((Object)mario);
        ksession.insert((Object)mark);
        int x = ksession.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(1);
        Assertions.assertThat((String)((String)list.get(0))).isEqualTo("t0");
    }

    @Test
    public void testUpdateRewrittenWithCorrectBitMaskAndCorrectClass() {
        String drl = "import " + Cell.class.getCanonicalName() + ";\nimport " + Neighbor.class.getCanonicalName() + ";\nglobal java.util.List list;\nrule R when\n    Neighbor( $n : neighbor ) \nthen\n    modify( $n ) {\n        setValue( $n.getValue() + 1 )\n    }\nend\nrule C when\n    $c: Cell( value > 0 ) \nthen\n   list.add(\"C\"); \nend\n";
        HashMap<String, String> kieModuleConfigurationProperties = new HashMap<String, String>();
        kieModuleConfigurationProperties.put("drools.propertySpecific", "ALWAYS");
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, kieModuleConfigurationProperties, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        System.out.println(drl);
        ReteDumper.dumpRete((KieSession)ksession);
        ksession.addEventListener((AgendaEventListener)new DebugAgendaEventListener());
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        Cell c0 = new Cell(0);
        Cell c1 = new Cell(0);
        Neighbor n = new Neighbor(c0, c1);
        System.out.println("c0: " + c0);
        System.out.println("c1: " + c1);
        System.out.println("n:" + n);
        ksession.insert((Object)c0);
        ksession.insert((Object)c1);
        ksession.insert((Object)n);
        int x = ksession.fireAllRules();
        System.out.println("from outside:");
        System.out.println("c0: " + c0);
        System.out.println("c1: " + c1);
        System.out.println("n:" + n);
        Assertions.assertThat((int)list.size()).isEqualTo(1);
        Assertions.assertThat((String)((String)list.get(0))).isEqualTo("C");
    }
}

