/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests.eventgenerator.example;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Status {
    public static final String[] STATUS_NAMES = new String[]{"Operational status"};
    public static final int OPERATIONAL = 0;
    private int id;
    private String resourceId;
    private List<String> valueList;
    private int currentValue;
    private long hasValueSince;

    public Status(int id, String resourceId) {
        this.id = id;
        this.resourceId = resourceId;
        this.valueList = new ArrayList<String>();
        this.hasValueSince = 0L;
    }

    public Status(int id, String resourceId, int currentValue) {
        this(id, resourceId);
        this.currentValue = currentValue;
    }

    public Status(int id, String resourceId, String[] valueList, int currentValue) {
        this(id, resourceId, currentValue);
        this.addValues(valueList);
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    public int getCurrentValue() {
        return this.currentValue;
    }

    public void setCurrentValue(int currentValue, long sinceWhen) {
        this.currentValue = currentValue;
        this.hasValueSince = sinceWhen;
    }

    public void switchCurrentValue(int oldValue, int newValue, long sinceWhen) {
        if (this.currentValue == oldValue) {
            this.setCurrentValue(newValue, sinceWhen);
        }
    }

    public void switchCurrentValue(String oldValue, String newValue, long sinceWhen) {
        this.switchCurrentValue(Integer.parseInt(oldValue), Integer.parseInt(newValue), sinceWhen);
    }

    public String[] getValueList() {
        return (String[])this.valueList.toArray();
    }

    public void addValues(String[] valueList) {
        this.valueList.addAll(Arrays.asList(valueList));
    }

    public long getHasValueSince() {
        return this.hasValueSince;
    }
}

