/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests.session;

import java.util.ArrayList;
import java.util.Collection;
import org.assertj.core.api.Assertions;
import org.drools.mvel.compiler.Move;
import org.drools.mvel.compiler.Person;
import org.drools.mvel.compiler.PersonFinal;
import org.drools.mvel.compiler.Pet;
import org.drools.mvel.compiler.Win;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.runtime.KieSession;

@RunWith(value=Parameterized.class)
public class InsertTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public InsertTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    @Test
    public void testInsert() throws Exception {
        Object drl = "";
        drl = (String)drl + "package test\n";
        drl = (String)drl + "import org.drools.mvel.compiler.Person\n";
        drl = (String)drl + "import org.drools.mvel.compiler.Pet\n";
        drl = (String)drl + "import java.util.ArrayList\n";
        drl = (String)drl + "global java.util.List list\n";
        drl = (String)drl + "rule test\n";
        drl = (String)drl + "when\n";
        drl = (String)drl + "$person:Person()\n";
        drl = (String)drl + "$pets : ArrayList()\n";
        drl = (String)drl + "   from collect( \n";
        drl = (String)drl + "      Pet(\n";
        drl = (String)drl + "         ownerName == $person.name\n";
        drl = (String)drl + "      )\n";
        drl = (String)drl + "   )\n";
        drl = (String)drl + "then\n";
        drl = (String)drl + "  list.add( $person );\n";
        drl = (String)drl + "end\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        Person p = new Person("Toni");
        ksession.insert((Object)p);
        ksession.insert((Object)new Pet("Toni"));
        ksession.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(1);
        Assertions.assertThat(list.get(0)).isSameAs((Object)p);
    }

    @Test
    public void testInsertionOrder() {
        KieBase kbase = KieBaseUtil.getKieBaseFromClasspathResources(this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"test_InsertionOrder.drl"});
        KieSession ksession = kbase.newKieSession();
        ArrayList results = new ArrayList();
        ksession.setGlobal("results", results);
        ksession.insert((Object)new Move(1, 2));
        ksession.insert((Object)new Move(2, 3));
        Win win2 = new Win(2);
        Win win3 = new Win(3);
        ksession.fireAllRules();
        Assertions.assertThat((int)results.size()).isEqualTo(2);
        Assertions.assertThat((boolean)results.contains(win2)).isTrue();
        Assertions.assertThat((boolean)results.contains(win3)).isTrue();
        ksession.dispose();
        ksession = kbase.newKieSession();
        results = new ArrayList();
        ksession.setGlobal("results", results);
        ksession.insert((Object)new Move(2, 3));
        ksession.insert((Object)new Move(1, 2));
        ksession.fireAllRules();
        Assertions.assertThat((int)results.size()).isEqualTo(2);
        Assertions.assertThat((boolean)results.contains(win2)).isTrue();
        Assertions.assertThat((boolean)results.contains(win3)).isTrue();
    }

    @Test
    public void testInsertFinalClassInstance() throws Exception {
        KieBase kbase = KieBaseUtil.getKieBaseFromClasspathResources(this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"test_FinalClass.drl"});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("results", list);
        PersonFinal bob = new PersonFinal();
        bob.setName("bob");
        bob.setStatus(null);
        ksession.insert((Object)bob);
        ksession.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(1);
    }
}

