/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.integrationtests;

import java.util.Collection;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.drools.base.base.ClassObjectType;
import org.drools.core.impl.InternalRuleBase;
import org.drools.core.reteoo.LeftInputAdapterNode;
import org.drools.core.reteoo.LeftTupleSink;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.testcoverage.common.model.Cheese;
import org.drools.testcoverage.common.model.Person;
import org.drools.testcoverage.common.model.Pet;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.runtime.KieSession;

@RunWith(value=Parameterized.class)
public class AlphaNetworkModifyTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public AlphaNetworkModifyTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    private ObjectTypeNode getObjectTypeNode(KieBase kbase, String nodeName) {
        List nodes = ((InternalRuleBase)kbase).getRete().getObjectTypeNodes();
        for (ObjectTypeNode n : nodes) {
            if (!((ClassObjectType)n.getObjectType()).getClassType().getSimpleName().equals(nodeName)) continue;
            return n;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testModifyWithLiaToEval() {
        String drl = "package org.simple \nimport " + Person.class.getCanonicalName() + "\nimport " + Cheese.class.getCanonicalName() + "\nimport " + Pet.class.getCanonicalName() + "\nglobal java.util.List list \nrule x1 \nwhen \n    $pe : Person() \n    $ch : Cheese() \n    $ca : Pet() \nthen \nend  \nrule x2 \nwhen \n    $ch : Cheese() \n    $ca : Pet() \n    $pe : Person() \nthen \nend  \nrule x3 \nwhen \n    $ch : Cheese() \nthen \nend  \nrule x4 \nwhen \n    $ch : Cheese() \n    eval( $ch != null ) \nthen \nend  \n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"alpha-network-modify-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession wm = kbase.newKieSession();
        try {
            ObjectTypeNode otnPerson = this.getObjectTypeNode(kbase, "Person");
            ObjectTypeNode otnCheese = this.getObjectTypeNode(kbase, "Cheese");
            ObjectTypeNode otnPet = this.getObjectTypeNode(kbase, "Pet");
            Assertions.assertThat((Object)otnPerson).isNotNull();
            Assertions.assertThat((Object)otnCheese).isNotNull();
            Assertions.assertThat((Object)otnPet).isNotNull();
            Assertions.assertThat((int)otnPerson.getOtnIdCounter()).isEqualTo(0);
            Assertions.assertThat((int)otnCheese.getOtnIdCounter()).isEqualTo(0);
            Assertions.assertThat((int)otnPet.getOtnIdCounter()).isEqualTo(0);
            wm.insert((Object)new Person());
            wm.insert((Object)new Pet("yyy"));
            wm.insert((Object)new Cheese());
            wm.fireAllRules();
            Assertions.assertThat((int)otnPerson.getOtnIdCounter()).isEqualTo(2);
            Assertions.assertThat((int)otnCheese.getOtnIdCounter()).isEqualTo(4);
            Assertions.assertThat((int)otnPet.getOtnIdCounter()).isEqualTo(2);
        }
        finally {
            wm.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testModifyWithLiaToFrom() {
        String drl = "package org.simple \nimport " + Person.class.getCanonicalName() + "\nimport " + Cheese.class.getCanonicalName() + "\nimport " + Pet.class.getCanonicalName() + "\nglobal java.util.List list \nrule x1 \nwhen \n    $pe : Person() from list\nthen \nend  \nrule x2 \nwhen \n    $ch : Cheese() from list\nthen \nend  \nrule x3 \nwhen \n    $ch : Cheese() from list\nthen \nend  \nrule x4 \nwhen \n    $ch : Cheese() from list\nthen \nend  \n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"alpha-network-modify-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession wm = kbase.newKieSession();
        try {
            wm.fireAllRules();
            ObjectTypeNode otnInit = this.getObjectTypeNode(kbase, "InitialFactImpl");
            Assertions.assertThat((Object)otnInit).isNotNull();
            LeftInputAdapterNode liaNode = (LeftInputAdapterNode)otnInit.getObjectSinkPropagator().getSinks()[0];
            LeftTupleSink[] sinks = liaNode.getSinkPropagator().getSinks();
            Assertions.assertThat((int)sinks.length).isEqualTo(2);
            Assertions.assertThat((int)sinks[0].getLeftInputOtnId().getId()).isEqualTo(0);
            Assertions.assertThat((int)sinks[1].getLeftInputOtnId().getId()).isEqualTo(1);
        }
        finally {
            wm.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testModifyWithLiaToAcc() {
        String drl = "package org.simple \nimport " + Person.class.getCanonicalName() + "\nimport " + Cheese.class.getCanonicalName() + "\nimport " + Pet.class.getCanonicalName() + "\nglobal java.util.List list \nrule x1 \nwhen \n    Object() from accumulate( $p : Person() and Cheese(), collectList( $p ) )\n    Person() \nthen \nend  \nrule x2 \nwhen \n    Object() from accumulate( $ch : Cheese(), collectList( $ch ) )\n    Person() \nthen \nend  \nrule x3 \nwhen \n    Object() from accumulate( $ch : Cheese(), collectList( $ch ) )\n    Person() \nthen \nend  \nrule x4 \nwhen \n    Object() from accumulate( $ch : Cheese(), collectList( $ch ) )\n    Person() \nthen \nend  \n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"alpha-network-modify-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession wm = kbase.newKieSession();
        try {
            wm.fireAllRules();
            ObjectTypeNode otnInit = this.getObjectTypeNode(kbase, "InitialFactImpl");
            Assertions.assertThat((Object)otnInit).isNotNull();
            LeftInputAdapterNode liaNode = (LeftInputAdapterNode)otnInit.getObjectSinkPropagator().getSinks()[0];
            LeftTupleSink[] sinks = liaNode.getSinkPropagator().getSinks();
            Assertions.assertThat((int)sinks[0].getLeftInputOtnId().getId()).isEqualTo(0);
            Assertions.assertThat((int)sinks[1].getLeftInputOtnId().getId()).isEqualTo(1);
            Assertions.assertThat((int)sinks[2].getLeftInputOtnId().getId()).isEqualTo(2);
            ObjectTypeNode otnPerson = this.getObjectTypeNode(kbase, "Person");
            ObjectTypeNode otnCheese = this.getObjectTypeNode(kbase, "Cheese");
            Assertions.assertThat((Object)otnPerson).isNotNull();
            Assertions.assertThat((Object)otnCheese).isNotNull();
            Assertions.assertThat((int)otnPerson.getOtnIdCounter()).isEqualTo(0);
            Assertions.assertThat((int)otnCheese.getOtnIdCounter()).isEqualTo(0);
            wm.insert((Object)new Person());
            wm.insert((Object)new Cheese());
            wm.fireAllRules();
            Assertions.assertThat((int)otnPerson.getOtnIdCounter()).isEqualTo(3);
            Assertions.assertThat((int)otnCheese.getOtnIdCounter()).isEqualTo(2);
        }
        finally {
            wm.dispose();
        }
    }
}

