/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.integrationtests.drl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.drools.testcoverage.common.model.Address;
import org.drools.testcoverage.common.model.Person;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.KieUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.Message;
import org.kie.api.runtime.KieSession;

@RunWith(value=Parameterized.class)
public class DrlSpecificFeaturesTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public DrlSpecificFeaturesTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)false);
    }

    @Test
    public void testMVELConsequenceUsingFactConstructors() {
        String drl = "package org.drools.compiler.integrationtests.drl;\nimport " + Person.class.getCanonicalName() + ";\nglobal " + KieSession.class.getCanonicalName() + " ksession\nrule test dialect 'mvel'\nwhen\n    $person:Person( name == 'mark' )\nthen\n    // below constructor for Person does not exist\n    Person p = new Person( 'bob', 30, 555 )\n    ksession.update(ksession.getFactHandle($person), new Person('bob', 30, 999, 453, 534, 534, 32))\nend\n";
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromDrls((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (boolean)false, (String[])new String[]{drl});
        Assertions.assertThat((List)kieBuilder.getResults().getMessages()).isNotEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTypeUnsafe() throws Exception {
        String drl = "import " + DrlSpecificFeaturesTest.class.getName() + ".*\ndeclare\n   Parent @typesafe(false)\nend\nrule R1\nwhen\n   $a : Parent( x == 1 )\nthen\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"declare-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        try {
            for (int i = 0; i < 20; ++i) {
                ksession.insert((Object)new ChildA(i % 10));
                ksession.insert((Object)new ChildB(i % 10));
            }
            Assertions.assertThat((int)ksession.fireAllRules()).isEqualTo(4);
            Thread.sleep(100L);
            ksession.insert((Object)new ChildA(1));
            ksession.insert((Object)new ChildB(1));
            Assertions.assertThat((int)ksession.fireAllRules()).isEqualTo(2);
        }
        finally {
            ksession.dispose();
        }
    }

    @Test
    public void testNoneTypeSafeDeclarations() {
        String str = "package " + Person.class.getPackage().getName() + ";\nglobal java.util.List list\ndeclare Person\n    @typesafe(false)\nend\nrule testTypeSafe\n dialect \"mvel\" when\n   $p : Person( object.street == 's1' )\nthen\n   list.add( $p );\nend\n";
        this.executeTypeSafeDeclarations(str, true);
        str = "package org.drools.compiler.integrationtests.drl;\nimport " + Person.class.getCanonicalName() + ";\nglobal java.util.List list\ndeclare Person\n    @typesafe(false)\nend\nrule testTypeSafe\n dialect \"mvel\" when\n   $p : Person( object.street == 's1' )\nthen\n   list.add( $p );\nend\n";
        this.executeTypeSafeDeclarations(str, true);
        str = "package org.drools.compiler.integrationtests.drl;\nglobal java.util.List list\ndeclare " + Person.class.getCanonicalName() + "\n    @typesafe(false)\nend\nrule testTypeSafe\n dialect \"mvel\" when\n   $p : " + Person.class.getCanonicalName() + "( object.street == 's1' )\nthen\n   list.add( $p );\nend\n";
        this.executeTypeSafeDeclarations(str, true);
        str = "package org.drools.compiler.integrationtests.drl;\nglobal java.util.List list\ndeclare " + Person.class.getCanonicalName() + "\n    @typesafe(true)\nend\nrule testTypeSafe\n dialect \"mvel\" when\n   $p : " + Person.class.getCanonicalName() + "( object.street == 's1' )\nthen\n   list.add( $p );\nend\n";
        this.executeTypeSafeDeclarations(str, false);
    }

    private void executeTypeSafeDeclarations(String drl, boolean mustSucceed) {
        if (!mustSucceed) {
            Assertions.assertThatThrownBy(() -> KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"declare-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl})).isInstanceOf(Throwable.class);
        } else {
            Assertions.assertThatCode(() -> {
                KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"declare-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
                KieSession ksession = kbase.newKieSession();
                try {
                    ArrayList list = new ArrayList();
                    ksession.setGlobal("list", list);
                    Address a = new Address("s1", 10, "city");
                    Person p = new Person("yoda");
                    p.setObject((Object)a);
                    ksession.insert((Object)p);
                    ksession.fireAllRules();
                    Assertions.assertThat(list.get(0)).isEqualTo((Object)p);
                }
                finally {
                    ksession.dispose();
                }
            }).doesNotThrowAnyException();
        }
    }

    @Test
    public void testRHSClone() {
        String drl = "import java.util.Map;\ndialect \"mvel\"\nrule \"RHSClone\"\nwhen\n   Map($valOne : this['keyOne'] !=null)\nthen\n   System.out.println( $valOne.clone() );\nend\n";
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromDrls((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (boolean)false, (String[])new String[]{"import java.util.Map;\ndialect \"mvel\"\nrule \"RHSClone\"\nwhen\n   Map($valOne : this['keyOne'] !=null)\nthen\n   System.out.println( $valOne.clone() );\nend\n"});
        Assertions.assertThat((List)kieBuilder.getResults().getMessages()).isNotEmpty();
        Assertions.assertThat((List)kieBuilder.getResults().getMessages()).extracting(Message::getText).doesNotContain((Object[])new String[]{""});
    }

    public static class ChildB
    extends Parent {
        private final int x;

        public ChildB(int x) {
            this.x = x;
        }

        public int getX() {
            return this.x;
        }
    }

    public static class ChildA
    extends Parent {
        private final int x;

        public ChildA(int x) {
            this.x = x;
        }

        public int getX() {
            return this.x;
        }
    }

    public static class Parent {
    }
}

