/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.compiler.conf;

import org.assertj.core.api.Assertions;
import org.drools.core.BeliefSystemType;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.KieServices;
import org.kie.api.conf.Option;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.api.runtime.conf.AccumulateNullPropagationOption;
import org.kie.api.runtime.conf.BeliefSystemTypeOption;
import org.kie.api.runtime.conf.ClockTypeOption;

public class KnowledgeSessionConfigurationTest {
    private KieSessionConfiguration config;

    @Before
    public void setUp() throws Exception {
        this.config = KieServices.Factory.get().newKieSessionConfiguration();
    }

    @Test
    public void testClockTypeConfiguration() {
        this.config.setOption((Option)ClockTypeOption.PSEUDO);
        Assertions.assertThat((Object)((ClockTypeOption)this.config.getOption(ClockTypeOption.KEY))).isEqualTo((Object)ClockTypeOption.PSEUDO);
        Assertions.assertThat((String)this.config.getProperty("drools.clockType")).isEqualTo("pseudo");
        this.config.setProperty("drools.clockType", "realtime");
        Assertions.assertThat((Object)((ClockTypeOption)this.config.getOption(ClockTypeOption.KEY))).isEqualTo((Object)ClockTypeOption.REALTIME);
        Assertions.assertThat((String)this.config.getProperty("drools.clockType")).isEqualTo("realtime");
    }

    @Test
    public void testBeliefSystemType() {
        this.config.setOption((Option)BeliefSystemTypeOption.get((String)BeliefSystemType.JTMS.toString()));
        Assertions.assertThat((Object)((BeliefSystemTypeOption)this.config.getOption(BeliefSystemTypeOption.KEY))).isEqualTo((Object)BeliefSystemTypeOption.get((String)BeliefSystemType.JTMS.toString()));
        Assertions.assertThat((String)this.config.getProperty("drools.beliefSystem")).isEqualTo(BeliefSystemType.JTMS.getId());
        this.config.setProperty("drools.beliefSystem", BeliefSystemType.DEFEASIBLE.getId());
        Assertions.assertThat((Object)((BeliefSystemTypeOption)this.config.getOption(BeliefSystemTypeOption.KEY))).isEqualTo((Object)BeliefSystemTypeOption.get((String)BeliefSystemType.DEFEASIBLE.getId()));
        Assertions.assertThat((String)this.config.getProperty("drools.beliefSystem")).isEqualTo(BeliefSystemType.DEFEASIBLE.getId());
    }

    @Test
    public void testAccumulateNullPropagation() {
        Assertions.assertThat((Comparable)((AccumulateNullPropagationOption)this.config.getOption(AccumulateNullPropagationOption.KEY))).isEqualTo((Object)AccumulateNullPropagationOption.NO);
        Assertions.assertThat((String)this.config.getProperty("drools.accumulateNullPropagation")).isEqualTo("false");
        this.config.setOption((Option)AccumulateNullPropagationOption.YES);
        Assertions.assertThat((Comparable)((AccumulateNullPropagationOption)this.config.getOption(AccumulateNullPropagationOption.KEY))).isEqualTo((Object)AccumulateNullPropagationOption.YES);
        Assertions.assertThat((String)this.config.getProperty("drools.accumulateNullPropagation")).isEqualTo("true");
        this.config.setProperty("drools.accumulateNullPropagation", "false");
        Assertions.assertThat((Comparable)((AccumulateNullPropagationOption)this.config.getOption(AccumulateNullPropagationOption.KEY))).isEqualTo((Object)AccumulateNullPropagationOption.NO);
        Assertions.assertThat((String)this.config.getProperty("drools.accumulateNullPropagation")).isEqualTo("false");
    }
}

