/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.compiler.test;

import java.util.ArrayList;
import java.util.Collection;
import org.assertj.core.api.Assertions;
import org.drools.mvel.compiler.test.Man;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.runtime.KieSession;

@RunWith(value=Parameterized.class)
public class PositionalTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public PositionalTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    @Test
    public void testPositional() {
        String drl = "import " + Man.class.getCanonicalName() + ";\n\nglobal java.util.List list;\nrule \"To be or not to be\"\nwhen\n    $m : Man( \"john\" , 18 , $w ; )\nthen\n    list.add($w); end";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession kSession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        kSession.setGlobal("list", list);
        kSession.insert((Object)new Man("john", 18, 84.2));
        kSession.insert((Object)new Man("john", 19, 85.2));
        kSession.fireAllRules();
        Assertions.assertThat((boolean)list.contains(84.2)).isTrue();
        Assertions.assertThat((boolean)list.contains(85.2)).isFalse();
    }

    @Test(timeout=5000L)
    public void testPositionalWithNull() {
        String str = "declare Bean\n  value : String\nend\n\nrule \"Init\"\nwhen\nthen\n  insert( new Bean( null ) );\n  insert( \"test\" );\nend\n\nrule \"Bind\"\nwhen\n  $s : String(  )\n  $b : Bean( null ; )\nthen\n  modify ( $b ) { setValue( $s ); }\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        Assertions.assertThat((int)ksession.fireAllRules()).isEqualTo(2);
    }
}

