/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.drools.core.common.DefaultEventHandle;
import org.drools.core.common.InternalFactHandle;
import org.drools.drl.ast.descr.PackageDescr;
import org.drools.drl.ast.dsl.AbstractClassTypeDeclarationBuilder;
import org.drools.drl.ast.dsl.DescrFactory;
import org.drools.drl.ast.dsl.PackageDescrBuilder;
import org.drools.mvel.DrlDumper;
import org.drools.mvel.compiler.Cheese;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.KieUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.Message;
import org.kie.api.definition.type.FactType;
import org.kie.api.runtime.ClassObjectFilter;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.ObjectFilter;
import org.kie.api.runtime.rule.FactHandle;

@RunWith(value=Parameterized.class)
public class ExtendsTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public ExtendsTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)false);
    }

    @Test
    public void testExtends() throws Exception {
        KieBase kbase = KieBaseUtil.getKieBaseFromClasspathResources(this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"test_Extends.drl"});
        KieSession ksession = kbase.newKieSession();
        FactType person = ksession.getKieBase().getFactType("defaultpkg", "Person");
        FactType eqPair = ksession.getKieBase().getFactType("defaultpkg", "EqualityPair");
        Object p = person.newInstance();
        Assertions.assertThat((Object)p).isNotNull();
        ksession.insert((Object)"Populate");
        ksession.fireAllRules();
        Assertions.assertThat((int)ksession.getObjects((ObjectFilter)new ClassObjectFilter(person.getFactClass())).size()).isEqualTo(6);
        Assertions.assertThat((int)ksession.getObjects((ObjectFilter)new ClassObjectFilter(eqPair.getFactClass())).size()).isEqualTo(10);
        ksession.dispose();
    }

    @Test
    public void testGeneratedMethods() throws Exception {
        KieBase kbase = KieBaseUtil.getKieBaseFromClasspathResources(this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"test_Extends.drl"});
        KieSession ksession = kbase.newKieSession();
        FactType student = ksession.getKieBase().getFactType("defaultpkg", "Student");
        Constructor constructor = student.getFactClass().getConstructor(String.class, Integer.TYPE, String.class);
        Assertions.assertThat(constructor).isNotNull();
        Method equals = student.getFactClass().getMethod("equals", Object.class);
        Assertions.assertThat((Object)equals).isNotNull();
        Object s1 = constructor.newInstance("John", 18, "Skool");
        Assertions.assertThat(s1).isNotNull();
        Assertions.assertThat((String)s1.toString()).isEqualTo("Student( name=John, age=18, school=Skool )");
        Object s2 = constructor.newInstance("John", 25, "Skool");
        Assertions.assertThat(s2).isNotNull();
        Assertions.assertThat((String)s2.toString()).isEqualTo("Student( name=John, age=25, school=Skool )");
        Assertions.assertThat((int)s2.hashCode()).isEqualTo(s1.hashCode());
        Assertions.assertThat((Boolean)((Boolean)equals.invoke(s1, s2))).isTrue();
        Assertions.assertThat((boolean)s1.equals(s2)).isTrue();
        Object s3 = constructor.newInstance("Mark", 18, "Skool");
        Assertions.assertThat(s3).isNotNull();
        Assertions.assertThat((String)s3.toString()).isEqualTo("Student( name=Mark, age=18, school=Skool )");
        Assertions.assertThat((int)s3.hashCode()).isNotEqualTo(s1.hashCode());
        Assertions.assertThat((int)s3.hashCode()).isNotEqualTo(s2.hashCode());
        Assertions.assertThat((boolean)s1.equals(s3)).isFalse();
        Assertions.assertThat((boolean)s2.equals(s3)).isFalse();
        Object s4 = constructor.newInstance("John", 25, "AnotherSkool");
        Assertions.assertThat(s4).isNotNull();
        Assertions.assertThat((String)s4.toString()).isEqualTo("Student( name=John, age=25, school=AnotherSkool )");
        Assertions.assertThat((int)s4.hashCode()).isNotEqualTo(s1.hashCode());
        Assertions.assertThat((int)s4.hashCode()).isNotEqualTo(s2.hashCode());
        Assertions.assertThat((int)s4.hashCode()).isNotEqualTo(s3.hashCode());
        Assertions.assertThat((boolean)s1.equals(s4)).isFalse();
        Assertions.assertThat((boolean)s2.equals(s4)).isFalse();
        Assertions.assertThat((boolean)s3.equals(s4)).isFalse();
        ksession.dispose();
    }

    @Test
    public void testDeepExt() throws Exception {
        KieBase kbase = KieBaseUtil.getKieBaseFromClasspathResources(this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"test_Extends.drl"});
        KieSession ksession = kbase.newKieSession();
        FactType LTstudent = ksession.getKieBase().getFactType("defaultpkg", "LongTermStudent");
        Constructor constructor = LTstudent.getFactClass().getConstructor(String.class, Integer.TYPE, String.class, String.class, Integer.TYPE);
        Assertions.assertThat(constructor).isNotNull();
        Object ls1 = constructor.newInstance("John", 18, "Skool", "C1245", 4);
        Object ls2 = constructor.newInstance("John", 33, "Skool", "C1421", 4);
        Assertions.assertThat(ls2).isEqualTo(ls1);
        ksession.dispose();
    }

    @Test
    public void testIllegalExtendsLegacy() throws Exception {
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromClasspathResources((KieBaseTestConfiguration)this.kieBaseTestConfiguration, this.getClass(), (boolean)false, (String[])new String[]{"test_ExtLegacyIllegal.drl"});
        List errors = kieBuilder.getResults().getMessages(new Message.Level[]{Message.Level.ERROR});
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)errors.isEmpty()).as("Should have an error", new Object[0])).isFalse();
    }

    @Test
    public void testExtendsLegacy() throws Exception {
        KieBase kbase = KieBaseUtil.getKieBaseFromClasspathResources(this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"test_ExtLegacy.drl"});
        KieSession ksession = kbase.newKieSession();
        FactType leg = ksession.getKieBase().getFactType("org.drools.compiler", "BetterLegacy");
        Assertions.assertThat((Object)leg).isNotNull();
        Object b = leg.newInstance();
        Assertions.assertThat((Object)leg.get(b, "doubleField")).isEqualTo((Object)3.3);
        Assertions.assertThat((Object)leg.get(b, "objField")).isNull();
        Assertions.assertThat((Object)leg.get(b, "intField")).isEqualTo((Object)245);
        Assertions.assertThat((Object)leg.get(b, "strField")).isEqualTo((Object)"XX");
        Assertions.assertThat((Object)leg.get(b, "prop")).isEqualTo((Object)true);
        Assertions.assertThat((Object)leg.get(b, "oneMoreField")).isEqualTo((Object)"Hello");
        System.out.println(b);
    }

    @Test
    public void testExtendsAcrossFiles() throws Exception {
        KieBase kbase = KieBaseUtil.getKieBaseFromClasspathResources(this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"test_Ext1.drl", "test_Ext2.drl", "test_Ext3.drl", "test_Ext4.drl"});
        KieSession ksession = kbase.newKieSession();
        FactType person = ksession.getKieBase().getFactType("org.drools.mvel.compiler.ext.test", "Person");
        Assertions.assertThat((Object)person).isNotNull();
        FactType student = ksession.getKieBase().getFactType("org.drools.mvel.compiler.ext.test", "Student");
        Assertions.assertThat((Object)student).isNotNull();
        FactType worker = ksession.getKieBase().getFactType("org.drools.mvel.compiler.anothertest", "Worker");
        Assertions.assertThat((Object)worker).isNotNull();
        FactType ltss = ksession.getKieBase().getFactType("defaultpkg", "SubLTStudent");
        Assertions.assertThat((Object)ltss).isNotNull();
        Constructor ctor = worker.getFactClass().getConstructor(String.class, Integer.TYPE, String.class, Double.TYPE, Integer.TYPE);
        Assertions.assertThat(ctor).isNotNull();
        Object w = ctor.newInstance("Adam", 20, "Carpenter", 150.0, 40);
        System.out.println(w);
        Assertions.assertThat((Object)worker.get(w, "name")).isEqualTo((Object)"Adam");
        ksession.fireAllRules();
    }

    @Test
    public void testFieldInit() throws Exception {
        KieBase kbase = KieBaseUtil.getKieBaseFromClasspathResources(this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"test_ExtFieldInit.drl"});
        KieSession ksession = kbase.newKieSession();
        FactType test = ksession.getKieBase().getFactType("org.drools.compiler", "MyBean3");
        Object x = test.newInstance();
        Assertions.assertThat((Object)x).isNotNull();
        Assertions.assertThat((Object)test.get(x, "fieldint")).isEqualTo((Object)12);
        Assertions.assertThat((Object)test.get(x, "fieldstr")).isEqualTo((Object)"xyz");
        Assertions.assertThat((Object)test.get(x, "fielddbl")).isEqualTo((Object)3.23);
        Assertions.assertThat((Object)test.get(x, "field0")).isEqualTo((Object)0);
        Assertions.assertThat((Object)test.get(x, "field1")).isEqualTo((Object)Float.valueOf(0.0f));
        Assertions.assertThat((Object)test.get(x, "fieldflt")).isEqualTo((Object)Float.valueOf(1.2f));
        short sht = 2;
        Assertions.assertThat((Object)test.get(x, "fieldsht")).isEqualTo((Object)sht);
        Assertions.assertThat((Object)test.get(x, "field2")).isEqualTo((Object)0);
        byte byt = 1;
        Assertions.assertThat((Object)test.get(x, "fieldbyt")).isEqualTo((Object)byt);
        Assertions.assertThat((Object)test.get(x, "fieldbln")).isEqualTo((Object)true);
        Assertions.assertThat((Object)test.get(x, "fieldchr")).isEqualTo((Object)Character.valueOf('x'));
        Assertions.assertThat((Object)test.get(x, "fieldlng")).isEqualTo((Object)9999L);
        System.out.println(x);
    }

    @Test
    public void testBoxedFieldInit() throws Exception {
        KieBase kbase = KieBaseUtil.getKieBaseFromClasspathResources(this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"test_ExtFieldInit.drl"});
        KieSession ksession = kbase.newKieSession();
        FactType test = ksession.getKieBase().getFactType("org.drools.compiler", "MyBoxBean");
        Object x = test.newInstance();
        Assertions.assertThat((Object)x).isNotNull();
        Assertions.assertThat((Object)test.get(x, "fieldint")).isEqualTo((Object)12);
        Assertions.assertThat((Object)test.get(x, "fielddbl")).isEqualTo((Object)3.23);
        Assertions.assertThat((Object)test.get(x, "fieldflt")).isEqualTo((Object)Float.valueOf(1.2f));
        short sht = 2;
        Assertions.assertThat((Object)test.get(x, "fieldsht")).isEqualTo((Object)sht);
        byte byt = 1;
        Assertions.assertThat((Object)test.get(x, "fieldbyt")).isEqualTo((Object)byt);
        Assertions.assertThat((Object)test.get(x, "fieldbln")).isEqualTo((Object)true);
        Assertions.assertThat((Object)test.get(x, "fieldchr")).isEqualTo((Object)Character.valueOf('x'));
        Assertions.assertThat((Object)test.get(x, "fieldlng")).isEqualTo((Object)9999L);
        System.out.println(x);
    }

    @Test
    public void testExpressionFieldInit() throws Exception {
        KieBase kbase = KieBaseUtil.getKieBaseFromClasspathResources(this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"test_ExtFieldInit.drl"});
        KieSession ksession = kbase.newKieSession();
        FactType test = ksession.getKieBase().getFactType("org.drools.compiler", "MyBoxExpressionBean");
        Object x = test.newInstance();
        Assertions.assertThat((Object)x).isNotNull();
        Assertions.assertThat((Object)test.get(x, "f0")).isEqualTo((Object)"foobar");
        Assertions.assertThat((Object)test.get(x, "fieldint")).isEqualTo((Object)-32);
        Assertions.assertThat((Object)test.get(x, "fielddbl")).isEqualTo((Object)4.0);
        Assertions.assertThat((Object)test.get(x, "fieldflt")).isEqualTo((Object)Float.valueOf(0.5f));
        short sht = 6;
        Assertions.assertThat((Object)test.get(x, "fieldsht")).isEqualTo((Object)sht);
        byte byt = 2;
        Assertions.assertThat((Object)test.get(x, "fieldbyt")).isEqualTo((Object)byt);
        Assertions.assertThat((Object)test.get(x, "fieldbln")).isEqualTo((Object)true);
        Assertions.assertThat((Object)test.get(x, "fieldchr")).isEqualTo((Object)Character.valueOf('x'));
        Assertions.assertThat((Object)test.get(x, "fieldlng")).isEqualTo((Object)9999L);
        System.out.println(x);
        FactType test2 = ksession.getKieBase().getFactType("org.drools.compiler", "MySimpleExpressionBean");
        x = test2.newInstance();
        Assertions.assertThat((Object)x).isNotNull();
        Assertions.assertThat((Object)test2.get(x, "f0")).isEqualTo((Object)"foobar");
        Assertions.assertThat((Object)test2.get(x, "fieldint")).isEqualTo((Object)-32);
        Assertions.assertThat((Object)test2.get(x, "fielddbl")).isEqualTo((Object)4.0);
        Assertions.assertThat((Object)test2.get(x, "fieldflt")).isEqualTo((Object)Float.valueOf(0.5f));
        sht = 6;
        Assertions.assertThat((Object)test2.get(x, "fieldsht")).isEqualTo((Object)sht);
        byt = 2;
        Assertions.assertThat((Object)test2.get(x, "fieldbyt")).isEqualTo((Object)byt);
        Assertions.assertThat((Object)test2.get(x, "fieldbln")).isEqualTo((Object)true);
        Assertions.assertThat((Object)test2.get(x, "fieldchr")).isEqualTo((Object)Character.valueOf('x'));
        Assertions.assertThat((Object)test2.get(x, "fieldlng")).isEqualTo((Object)9999L);
        System.out.println(x);
    }

    @Test
    public void testHierarchy() throws Exception {
        KieBase kbase = KieBaseUtil.getKieBaseFromClasspathResources(this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"test_ExtHierarchy.drl"});
        KieSession ksession = kbase.newKieSession();
        ksession.setGlobal("list", new LinkedList());
        ksession.fireAllRules();
        Assertions.assertThat((int)((List)ksession.getGlobal("list")).size()).isEqualTo(1);
    }

    @Test
    public void testExtendOverride() {
        String drl = "package test.beans;\n\nimport java.util.List;\nimport java.util.ArrayList;\n\nglobal List ans;\n\ndeclare ArrayList\nend\ndeclare Bean extends ArrayList\n  fld : int = 4 \n  myField : String = \"xxx\" \nend\n\ndeclare Bean2 extends Bean\n  moref : double\n  myField : String\nend\nrule \"Init\"\nwhen\nthen\n  Bean b = new Bean2();\n  ans.add(b);  System.out.println(b);\t\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        ArrayList out = new ArrayList();
        ksession.setGlobal("ans", out);
        ksession.fireAllRules();
        Object x = out.get(0);
        FactType type = kbase.getFactType("test.beans", "Bean2");
        Assertions.assertThat((Object)type.get(x, "fld")).isEqualTo((Object)4);
        Assertions.assertThat((Object)type.get(x, "myField")).isEqualTo((Object)"xxx");
        Assertions.assertThat((Object)type.get(x, "moref")).isEqualTo((Object)0.0);
        Assertions.assertThat((boolean)(x instanceof ArrayList)).isTrue();
    }

    @Test
    public void testRedefineDefaults() throws Exception {
        KieBase kbase = KieBaseUtil.getKieBaseFromClasspathResources(this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"test_Extends.drl"});
        KieSession ksession = kbase.newKieSession();
        FactType person = ksession.getKieBase().getFactType("defaultpkg", "Person");
        FactType student = ksession.getKieBase().getFactType("defaultpkg", "Student");
        Object p = person.newInstance();
        Object s = student.newInstance();
        Assertions.assertThat((Object)p).isNotNull();
        Assertions.assertThat((Object)s).isNotNull();
        Assertions.assertThat((Object)person.get(p, "age")).isEqualTo((Object)99);
        Assertions.assertThat((Object)person.get(s, "age")).isEqualTo((Object)18);
        ksession.dispose();
    }

    @Test
    public void testExtendFromOtherPackage() throws Exception {
        String s1 = "package org.drools.mvel.compiler.test.pack1;\n\ndeclare Base\n  id    : int\nend\n\ndeclare Sub extends Base\n  field : int\nend\n";
        String s2 = "package org.drools.mvel.compiler.test.pack2;\n\nimport org.drools.mvel.compiler.test.pack1.Base;\nimport org.drools.mvel.compiler.test.pack1.Sub;\n\ndeclare Sub end\n\ndeclare SubChild extends Sub\n  field2 : int\nend\n\nrule \"Init\"\nwhen\nthen\n  insert( new SubChild( 1, 2, 3 ) );\nend\n\nrule \"Touch Base\"\nwhen\n  $b : Base()\nthen\n  System.out.println( $b );\nend \nrule \"Touch Base 2\"\nwhen\n  $c : Sub()\nthen\n  System.out.println( $c );\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{s1, s2});
        KieSession kSession = kbase.newKieSession();
        Assertions.assertThat((int)kSession.fireAllRules()).isEqualTo(3);
    }

    @Test
    public void testInheritAnnotationsInOtherPackage() throws Exception {
        String s1 = "package org.drools.mvel.compiler.test.pack1;\nglobal java.util.List list;\ndeclare Event\n@role(event)  id    : int\nend\n\nrule \"X\"\nwhen\n  $s1 : Event()\nthen\n  System.out.println( $s1 );\n  list.add( $s1.getId() );\n end";
        String s2 = "package org.drools.mvel.compiler.test.pack2;\n\nimport org.drools.mvel.compiler.test.pack1.Event;\nglobal java.util.List list;\ndeclare Event end\n\ndeclare SubEvent extends Event\nend\n\nrule \"Init\"\nwhen\nthen\n  list.add( 0 );\n  insert( new SubEvent( 1 ) );\n  insert( new SubEvent( 2 ) );\nend\n\nrule \"Seq\"\nwhen\n  $s1 : SubEvent( id == 1 )\n  $s2 : SubEvent( id == 2, this after[0,10s] $s1 )\nthen\n  list.add( 3 );\n  System.out.println( $s1 + \" after \" + $s1 );\nend \n\nrule \"Seq 2 \"\nwhen\n  $s1 : Event( id == 1 )\n  $s2 : Event( id == 2, this after[0,10s] $s1 )\nthen\n  list.add( 4 );\n  System.out.println( $s1 + \" after II \" + $s1 );\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{s1, s2});
        KieSession kSession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        kSession.setGlobal("list", list);
        kSession.fireAllRules();
        for (Object o : kSession.getObjects()) {
            FactHandle h = kSession.getFactHandle(o);
            Assertions.assertThat((boolean)(h instanceof DefaultEventHandle)).isTrue();
        }
        System.out.println(list);
        Assertions.assertThat((int)list.size()).isEqualTo(5);
        Assertions.assertThat((boolean)list.contains(0)).isTrue();
        Assertions.assertThat((boolean)list.contains(1)).isTrue();
        Assertions.assertThat((boolean)list.contains(2)).isTrue();
        Assertions.assertThat((boolean)list.contains(3)).isTrue();
        Assertions.assertThat((boolean)list.contains(4)).isTrue();
    }

    @Test
    public void testInheritFromClassWithDefaults() throws Exception {
        String s1 = "package org.drools.mvel.compiler;\nglobal java.util.List list;\ndeclare Car end\n\ndeclare MyCar extends Car \n miles : int\nend\n\nrule \"Init\"\nwhen\nthen\n  MyCar c = new MyCar();\n  c.setMiles( 100 );  insert( c );\nend\nrule \"Match\"\nwhen\n  MyCar( brand == \"ferrari\", expensive == true, $miles : miles ) then\n  list.add( $miles );\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{s1});
        KieSession kSession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        kSession.setGlobal("list", list);
        kSession.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(1);
        Assertions.assertThat((boolean)list.contains(100)).isTrue();
    }

    @Test
    public void testExtendSelf() throws Exception {
        String s1 = "package org.drools;\nglobal java.util.List list;\n\ndeclare Bean extends Bean \n foo : int @key\nend\n";
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromDrls((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (boolean)false, (String[])new String[]{s1});
        List errors = kieBuilder.getResults().getMessages(new Message.Level[]{Message.Level.ERROR});
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)errors.isEmpty()).as("Should have an error", new Object[0])).isFalse();
    }

    @Test
    public void testExtendCircular() throws Exception {
        String s1 = "package org.drools;\nglobal java.util.List list;\n\ndeclare Bean1 extends Bean2 \n foo : int @key\nend\ndeclare Bean2 extends Bean3 \n foo : int @key\nend\ndeclare Bean3 extends Bean1 \n foo : int @key\nend\n";
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromDrls((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (boolean)false, (String[])new String[]{s1});
        List errors = kieBuilder.getResults().getMessages(new Message.Level[]{Message.Level.ERROR});
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)errors.isEmpty()).as("Should have an error", new Object[0])).isFalse();
        System.out.println(errors);
        Assertions.assertThat((boolean)errors.toString().contains("circular")).isTrue();
    }

    @Test
    public void testExtendsDump() {
        PackageDescrBuilder pkgd = DescrFactory.newPackage();
        ((AbstractClassTypeDeclarationBuilder)((PackageDescrBuilder)((AbstractClassTypeDeclarationBuilder)pkgd.name("org.test").newDeclare().type().name("Foo").newField("id").type("int").end()).end()).newDeclare().type().name("Bar").superType("Foo").newField("val").type("int").initialValue("42").end()).end();
        String drl = new DrlDumper().dump((PackageDescr)pkgd.getDescr());
        KieBase kb = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        FactType bar = kb.getFactType("org.test", "Bar");
        try {
            Object x = bar.newInstance();
            Assertions.assertThat((Object)bar.get(x, "val")).isEqualTo((Object)42);
            bar.set(x, "id", (Object)1);
            Assertions.assertThat((Object)bar.get(x, "id")).isEqualTo((Object)1);
        }
        catch (Exception e) {
            Assertions.fail((String)e.getMessage());
        }
    }

    @Test
    public void testDeclareInheritance() throws Exception {
        String s1 = "package org.drools;\nimport org.drools.mvel.integrationtests.ExtendsTest.*;\n\ndeclare A \n @role( event ) @typesafe( false )\nend\ndeclare C @role( event ) @typesafe( false ) end \nrule R \nwhen    $x : C( this.x == 1 ) \nthen\n   System.out.println( $x ); \nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{s1});
        KieSession knowledgeSession = kbase.newKieSession();
        FactHandle h = knowledgeSession.insert((Object)new X());
        Assertions.assertThat((boolean)((InternalFactHandle)h).isEvent()).isTrue();
    }

    @Test
    public void testDeclareExtendsJavaParent() {
        String drl = "package org.drools.test; \nimport org.drools.mvel.compiler.Person; \ndeclare Student extends Person end \n";
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromDrls((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (boolean)false, (String[])new String[]{drl});
        List errors = kieBuilder.getResults().getMessages(new Message.Level[]{Message.Level.ERROR});
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)errors.isEmpty()).as(errors.toString(), new Object[0])).isTrue();
    }

    @Test
    public void testDeclareExtendsJavaParentOuterPackaga() {
        String drl = "package org.drools.test; \nimport org.drools.mvel.integrationtests.ExtendsTest.X; \ndeclare Student extends X end \n";
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromDrls((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (boolean)false, (String[])new String[]{drl});
        List errors = kieBuilder.getResults().getMessages(new Message.Level[]{Message.Level.ERROR});
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)errors.isEmpty()).as(errors.toString(), new Object[0])).isTrue();
    }

    @Test
    public void testDeclareExtendsMissingJavaParent() {
        String drl = "package org.drools.test; \nimport org.drools.mvel.integrationtests.ExtendsTest.Y; \ndeclare Student extends Y end \n";
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromDrls((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (boolean)false, (String[])new String[]{drl});
        List errors = kieBuilder.getResults().getMessages(new Message.Level[]{Message.Level.ERROR});
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)errors.isEmpty()).as("Should have an error", new Object[0])).isFalse();
    }

    @Test
    public void testDeclareExtendsWithFullyQualifiedName() {
        String drl = "package org.drools.extends.test; \ndeclare org.drools.extends.test.Foo end \ndeclare org.drools.extends.test.Bar extends org.drools.extends.test.Foo end \n";
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromDrls((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (boolean)false, (String[])new String[]{drl});
        List errors = kieBuilder.getResults().getMessages(new Message.Level[]{Message.Level.ERROR});
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)errors.isEmpty()).as(errors.toString(), new Object[0])).isTrue();
    }

    @Test
    public void testExtendsBasic() throws Exception {
        KieBase kbase = KieBaseUtil.getKieBaseFromClasspathResources(this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"extend_rule_test.drl"});
        KieSession session = kbase.newKieSession();
        ArrayList list = new ArrayList();
        session.setGlobal("list", list);
        Cheese mycheese = new Cheese("cheddar", 4);
        FactHandle handle = session.insert((Object)mycheese);
        session.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(2);
        Assertions.assertThat((boolean)list.contains("rule 4")).isTrue();
        Assertions.assertThat((boolean)list.contains("rule 2b")).isTrue();
        list = new ArrayList();
        session.setGlobal("list", list);
        session.delete(handle);
        Cheese mycheese2 = new Cheese("notcheddar", 4);
        FactHandle handle2 = session.insert((Object)mycheese2);
        session.fireAllRules();
        Assertions.assertThat(list.get(0)).isEqualTo((Object)"rule 4");
        Assertions.assertThat((int)list.size()).isEqualTo(1);
        list = new ArrayList();
        session.setGlobal("list", list);
        session.delete(handle2);
        Cheese mycheese3 = new Cheese("stilton", 6);
        FactHandle handle3 = session.insert((Object)mycheese3);
        session.fireAllRules();
        Assertions.assertThat(list.get(0)).isEqualTo((Object)"rule 3");
        Assertions.assertThat((int)list.size()).isEqualTo(1);
        list = new ArrayList();
        session.setGlobal("list", list);
        session.delete(handle3);
        Cheese mycheese4 = new Cheese("notstilton", 6);
        FactHandle handle4 = session.insert((Object)mycheese4);
        session.fireAllRules();
        Assertions.assertThat((((List)session.getGlobal("list")).size() == 0 ? 1 : 0) != 0).isTrue();
        list = new ArrayList();
        session.setGlobal("list", list);
        session.delete(handle4);
        Cheese mycheese5 = new Cheese("stilton", 7);
        session.insert((Object)mycheese5);
        session.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(0);
    }

    @Test
    public void testExtendsBasic2() {
        KieBase kbase = KieBaseUtil.getKieBaseFromClasspathResources(this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"test_RuleExtend.drl"});
        KieSession ksession = kbase.newKieSession();
        ArrayList results = new ArrayList();
        ksession.setGlobal("results", results);
        Cheese stilton = new Cheese("stilton", 5);
        Cheese cheddar = new Cheese("cheddar", 7);
        Cheese brie = new Cheese("brie", 5);
        ksession.insert((Object)stilton);
        ksession.insert((Object)cheddar);
        ksession.insert((Object)brie);
        ksession.fireAllRules();
        Assertions.assertThat((int)results.size()).isEqualTo(2);
        Assertions.assertThat(results.get(0)).isEqualTo((Object)"stilton");
        Assertions.assertThat(results.get(1)).isEqualTo((Object)"brie");
    }

    public static class X
    implements C {
        private int x = 1;

        public int getX() {
            return this.x;
        }
    }

    public static interface C
    extends B {
    }

    public static interface B
    extends A {
    }

    public static interface A {
    }
}

