/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests.marshalling;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Date;
import java.util.Objects;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class InputStreamMarkResetTest {
    @Test
    public void basicReadAndWriteObjectTest() throws Exception {
        DataObject thingy = new DataObject();
        thingy.type = (char)97;
        thingy.time = new Date().getTime();
        thingy.strCount = "1";
        byte[] bytes = this.marshallThingy(thingy);
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        BufferedInputStream bis = new BufferedInputStream(bais);
        ObjectInputStream stream = new ObjectInputStream(bis);
        DataObject unmaThingy = new DataObject();
        unmaThingy.type = stream.readChar();
        unmaThingy.time = stream.readLong();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)bis.markSupported()).as("Mark/reset is not supported", new Object[0])).isTrue();
        bis.mark(8);
        int[] intBytes = new int[]{bis.read(), bis.read(), bis.read(), bis.read()};
        if ((intBytes[0] | intBytes[1] | intBytes[2] | intBytes[3]) < 0) {
            bis.reset();
        }
        unmaThingy.strCount = stream.readUTF();
        Assertions.assertThat((boolean)thingy.equals(unmaThingy)).isTrue();
    }

    private byte[] marshallThingy(DataObject thingy) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream stream = new ObjectOutputStream(baos);
        stream.writeChar(thingy.type);
        stream.writeLong(thingy.time);
        if (thingy.intCount != null) {
            stream.writeInt(thingy.intCount);
        } else if (thingy.strCount != null) {
            stream.writeUTF(thingy.strCount);
        } else {
            throw new IllegalStateException("Neither the integer nor String count is filled.");
        }
        stream.close();
        return baos.toByteArray();
    }

    private class DataObject {
        char type;
        long time;
        Integer intCount;
        String strCount;

        private DataObject() {
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!this.getClass().equals(obj.getClass())) {
                return false;
            }
            DataObject newThingy = (DataObject)obj;
            if (this.type != newThingy.type) {
                return false;
            }
            if (this.time != newThingy.time) {
                return false;
            }
            Integer count = this.intCount != null ? this.intCount : Integer.valueOf(Integer.parseInt(this.strCount));
            Integer newCount = newThingy.intCount != null ? newThingy.intCount : Integer.valueOf(Integer.parseInt(newThingy.strCount));
            return !(count != null && newCount != null ? !count.equals(newCount) : !Objects.equals(count, newCount));
        }
    }
}

