/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.rule;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import org.assertj.core.api.Assertions;
import org.drools.base.base.ClassObjectType;
import org.drools.base.base.ObjectType;
import org.drools.base.rule.Declaration;
import org.drools.base.rule.Pattern;
import org.drools.base.rule.accessor.ReadAccessor;
import org.drools.core.base.ClassFieldAccessorCache;
import org.drools.core.test.model.Cheese;
import org.drools.mvel.accessors.ClassFieldAccessorStore;
import org.drools.mvel.accessors.ClassFieldReader;
import org.junit.Before;
import org.junit.Test;

public class DeclarationTest {
    ClassFieldAccessorStore store = new ClassFieldAccessorStore();

    @Before
    public void setUp() throws Exception {
        this.store.setClassFieldAccessorCache(new ClassFieldAccessorCache(Thread.currentThread().getContextClassLoader()));
        this.store.setEagerWire(true);
    }

    @Test
    public void testDeclaration() {
        ClassFieldReader extractor = this.store.getReader(Cheese.class, "type");
        Pattern pattern = new Pattern(5, (ObjectType)new ClassObjectType(Cheese.class));
        Declaration declaration = new Declaration("typeOfCheese", (ReadAccessor)extractor, pattern);
        Assertions.assertThat((String)declaration.getIdentifier()).isEqualTo("typeOfCheese");
        Assertions.assertThat((Class)declaration.getDeclarationClass()).isSameAs(String.class);
        Assertions.assertThat((Object)declaration.getExtractor()).isSameAs((Object)extractor);
        Assertions.assertThat((int)declaration.getPattern().getPatternId()).isEqualTo(5);
    }

    @Test
    public void testGetFieldValue() {
        ClassFieldReader extractor = this.store.getReader(Cheese.class, "type");
        Pattern pattern = new Pattern(5, (ObjectType)new ClassObjectType(Cheese.class));
        Declaration declaration = new Declaration("typeOfCheese", (ReadAccessor)extractor, pattern);
        Cheese cheddar = new Cheese("cheddar", 5);
        Assertions.assertThat((Object)declaration.getValue(null, (Object)cheddar)).isEqualTo((Object)"cheddar");
    }

    public static int getIndex(Class clazz, String name) throws IntrospectionException {
        PropertyDescriptor[] descriptors = Introspector.getBeanInfo(clazz).getPropertyDescriptors();
        for (int i = 0; i < descriptors.length; ++i) {
            if (!descriptors[i].getName().equals(name)) continue;
            return i;
        }
        return -1;
    }
}

