/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.integrationtests.incrementalcompilation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import org.assertj.core.api.Assertions;
import org.drools.compiler.integrationtests.incrementalcompilation.TestUtil;
import org.drools.kiesession.rulebase.InternalKnowledgeBase;
import org.drools.testcoverage.common.model.Person;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieServices;
import org.kie.api.builder.ReleaseId;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.KieSession;

@RunWith(value=Parameterized.class)
public class AddRuleTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public AddRuleTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    @Test
    public void testMemoriesCCEWhenAddRemoveAddRule() {
        String rule1 = "import " + AddRuleTest.class.getCanonicalName() + ".*\nimport java.util.Date\nrule \"RTR - 28717 retract\"\nwhen\n        $listMembership0 : SimpleMembership( $listMembershipPatientSpaceIdRoot : patientSpaceId,\n        ( listId != null && listId == \"28717\" ) ) and not ($patient0 : SimplePatient( $patientSpaceIdRoot : spaceId, spaceId != null &&\n        spaceId == $listMembershipPatientSpaceIdRoot ) and\n        (($ruleTime0 : RuleTime( $ruleTimeStartOfDay4_1 : startOfDay, $ruleTimeTime4_1 : time ) and $patient1 :\n        SimplePatient( spaceId != null && spaceId == $patientSpaceIdRoot, birthDate != null && (birthDate after[0s,1d] $ruleTimeStartOfDay4_1) ) ) ) )\nthen\nend";
        String rule2 = "import " + AddRuleTest.class.getCanonicalName() + ".*\nimport java.util.Date\nrule \"RTR - 28717 retract\"\nwhen  $listMembership0 : SimpleMembership( $listMembershipPatientSpaceIdRoot : patientSpaceId, ( listId != null && listId == \"28717\" ) )\n    and not ($patient0 : SimplePatient( $patientSpaceIdRoot : spaceId, spaceId != null && spaceId == $listMembershipPatientSpaceIdRoot )\n    and ( ($ruleTime0 : RuleTime( $ruleTimeStartOfDay4_1 : startOfDay, $ruleTimeTime4_1 : time )\n    and $patient1 : SimplePatient( spaceId != null && spaceId == $patientSpaceIdRoot, birthDate != null && (birthDate not after[0s,1d] $ruleTimeStartOfDay4_1) ) ) ) )\nthen\nend";
        KieServices kieServices = KieServices.get();
        ReleaseId releaseId = kieServices.newReleaseId("org.kie", "test-memories-cce-when-add-remove-rule", "1.0");
        KieUtil.getKieModuleFromDrls((ReleaseId)releaseId, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[0]);
        KieContainer kieContainer = kieServices.newKieContainer(releaseId);
        InternalKnowledgeBase kbase = (InternalKnowledgeBase)kieContainer.getKieBase();
        kbase.newKieSession();
        kbase.addPackages(TestUtil.createKnowledgeBuilder(null, rule1).getKnowledgePackages());
        kbase.addPackages(TestUtil.createKnowledgeBuilder(null, rule2).getKnowledgePackages());
    }

    @Test
    public void testAddRuleWithFrom() {
        String str1 = "global java.util.List names;\nglobal java.util.List list;\n";
        String str2 = "import " + Person.class.getCanonicalName() + ";\nglobal java.util.List names;\nglobal java.util.List list;\nrule R1 when\n   $p : Person( )\n   String( this == $p.name ) from names\nthen\n list.add( $p );\nend";
        KieServices kieServices = KieServices.get();
        ReleaseId releaseId = kieServices.newReleaseId("org.kie", "test-add-rule-with-from", "1.0");
        KieUtil.getKieModuleFromDrls((ReleaseId)releaseId, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"global java.util.List names;\nglobal java.util.List list;\n"});
        KieContainer kieContainer = kieServices.newKieContainer(releaseId);
        InternalKnowledgeBase kbase = (InternalKnowledgeBase)kieContainer.getKieBase();
        KieSession ksession = kbase.newKieSession();
        ArrayList<String> names = new ArrayList<String>();
        names.add("Mark");
        ksession.setGlobal("names", names);
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        Person p = new Person("Mark");
        ksession.insert((Object)p);
        ksession.fireAllRules();
        kbase.addPackages(TestUtil.createKnowledgeBuilder(null, str2).getKnowledgePackages());
        ksession.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(1);
        Assertions.assertThat((Object)((Person)list.get(0))).isSameAs((Object)p);
        ksession.dispose();
    }

    @Test
    public void testDynamicallyAddInitialFactRule() {
        String rule = "package org.drools.compiler.test\nglobal java.util.List list\nrule xxx when\n   i:Integer()\nthen\n   list.add(i);\nend";
        KieServices kieServices = KieServices.get();
        ReleaseId releaseId = kieServices.newReleaseId("org.kie", "test-add-dynamically-init-fact-rule", "1.0");
        KieUtil.getKieModuleFromDrls((ReleaseId)releaseId, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{rule});
        KieContainer kieContainer = kieServices.newKieContainer(releaseId);
        InternalKnowledgeBase kbase = (InternalKnowledgeBase)kieContainer.getKieBase();
        KieSession session = kbase.newKieSession();
        ArrayList list = new ArrayList();
        session.setGlobal("list", list);
        session.insert((Object)5);
        session.fireAllRules();
        Assertions.assertThat(list.get(0)).isEqualTo((Object)5);
        rule = "package org.drools.compiler.test\nglobal java.util.List list\nrule xxx when\nthen\n   list.add(\"x\");\nend";
        Collection kpkgs = TestUtil.createKnowledgeBuilder(null, rule).getKnowledgePackages();
        kbase.addPackages(kpkgs);
        session.fireAllRules();
        Assertions.assertThat(list.get(1)).isEqualTo((Object)"x");
    }

    public class SimplePatient {
        public String getSpaceId() {
            return "";
        }

        public String getFactHandleString() {
            return "";
        }

        public Date getBirthDate() {
            return new Date();
        }
    }

    public static class SimpleMembership {
        public String getListId() {
            return "";
        }

        public String getPatientSpaceId() {
            return "";
        }
    }

    public static class RuleTime {
        public Date getTime() {
            return new Date();
        }

        public Date getStartOfDay() {
            return new Date();
        }
    }
}

