/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import org.assertj.core.api.Assertions;
import org.drools.mvel.compiler.Cheese;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.runtime.KieSession;

@RunWith(value=Parameterized.class)
public class DateComparisonTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public DateComparisonTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    @Test
    public void testDateComparisonThan() throws Exception {
        Object str = "";
        str = (String)str + "package org.drools.mvel.compiler;\n";
        str = (String)str + "global java.util.List results;\n";
        str = (String)str + "rule \"test date greater than\"\n";
        str = (String)str + "     when\n";
        str = (String)str + "         $c : Cheese(type == \"Yesterday\")\n";
        str = (String)str + "         Cheese(type == \"Tomorrow\",  usedBy > ($c.usedBy))\n";
        str = (String)str + "     then\n";
        str = (String)str + "         results.add( \"test date greater than\" );\n";
        str = (String)str + "end\n";
        str = (String)str + "rule \"test date less than\"\n";
        str = (String)str + "    when\n";
        str = (String)str + "        $c : Cheese(type == \"Tomorrow\")\n";
        str = (String)str + "        Cheese(type == \"Yesterday\", usedBy < ($c.usedBy));\n";
        str = (String)str + "    then\n";
        str = (String)str + "        results.add( \"test date less than\" );\n";
        str = (String)str + "end\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        ArrayList results = new ArrayList();
        ksession.setGlobal("results", results);
        Cheese yesterday = new Cheese("Yesterday");
        yesterday.setUsedBy(this.yesterday());
        Cheese tomorrow = new Cheese("Tomorrow");
        tomorrow.setUsedBy(this.tomorrow());
        ksession.insert((Object)yesterday);
        ksession.insert((Object)tomorrow);
        ksession.fireAllRules();
        Assertions.assertThat((int)results.size()).isEqualTo(2);
        Assertions.assertThat((boolean)results.contains("test date greater than")).isTrue();
        Assertions.assertThat((boolean)results.contains("test date less than")).isTrue();
    }

    @Test
    public void testDateComparisonAfter() throws Exception {
        Object str = "";
        str = (String)str + "package org.drools.mvel.compiler;\n";
        str = (String)str + "global java.util.List results;\n";
        str = (String)str + "rule \"test date greater than\"\n";
        str = (String)str + "     when\n";
        str = (String)str + "         $c : Cheese(type == \"Yesterday\")\n";
        str = (String)str + "         Cheese(type == \"Tomorrow\", $c.usedBy before usedBy)\n";
        str = (String)str + "     then\n";
        str = (String)str + "         results.add( \"test date greater than\" );\n";
        str = (String)str + "end\n";
        str = (String)str + "rule \"test date less than\"\n";
        str = (String)str + "    when\n";
        str = (String)str + "        $c : Cheese(type == \"Tomorrow\")\n";
        str = (String)str + "        Cheese(type == \"Yesterday\", $c.usedBy after usedBy);\n";
        str = (String)str + "    then\n";
        str = (String)str + "        results.add( \"test date less than\" );\n";
        str = (String)str + "end\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        ArrayList results = new ArrayList();
        ksession.setGlobal("results", results);
        Cheese yesterday = new Cheese("Yesterday");
        yesterday.setUsedBy(this.yesterday());
        Cheese tomorrow = new Cheese("Tomorrow");
        tomorrow.setUsedBy(this.tomorrow());
        ksession.insert((Object)yesterday);
        ksession.insert((Object)tomorrow);
        ksession.fireAllRules();
        Assertions.assertThat((int)results.size()).isEqualTo(2);
        Assertions.assertThat((boolean)results.contains("test date greater than")).isTrue();
        Assertions.assertThat((boolean)results.contains("test date less than")).isTrue();
    }

    @Test
    public void testDateComparisonAfterWithThisBinding() throws Exception {
        Object str = "";
        str = (String)str + "package org.drools.mvel.compiler;\n";
        str = (String)str + "global java.util.List results;\n";
        str = (String)str + "rule \"test date greater than\"\n";
        str = (String)str + "     when\n";
        str = (String)str + "         Cheese(type == \"Yesterday\", $c: this)\n";
        str = (String)str + "         Cheese(type == \"Tomorrow\", $c.usedBy before usedBy)\n";
        str = (String)str + "     then\n";
        str = (String)str + "         results.add( \"test date greater than\" );\n";
        str = (String)str + "end\n";
        str = (String)str + "rule \"test date less than\"\n";
        str = (String)str + "    when\n";
        str = (String)str + "        Cheese(type == \"Tomorrow\", $c: this)\n";
        str = (String)str + "        Cheese(type == \"Yesterday\", $c.usedBy after usedBy);\n";
        str = (String)str + "    then\n";
        str = (String)str + "        results.add( \"test date less than\" );\n";
        str = (String)str + "end\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        ArrayList results = new ArrayList();
        ksession.setGlobal("results", results);
        Cheese yesterday = new Cheese("Yesterday");
        yesterday.setUsedBy(this.yesterday());
        Cheese tomorrow = new Cheese("Tomorrow");
        tomorrow.setUsedBy(this.tomorrow());
        ksession.insert((Object)yesterday);
        ksession.insert((Object)tomorrow);
        ksession.fireAllRules();
        Assertions.assertThat((int)results.size()).isEqualTo(2);
        Assertions.assertThat((boolean)results.contains("test date greater than")).isTrue();
        Assertions.assertThat((boolean)results.contains("test date less than")).isTrue();
    }

    private Date yesterday() {
        GregorianCalendar c = new GregorianCalendar();
        c.set(5, c.get(5) - 1);
        return c.getTime();
    }

    private Date tomorrow() {
        GregorianCalendar c = new GregorianCalendar();
        c.set(5, c.get(5) + 1);
        return c.getTime();
    }
}

