/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.assertj.core.api.Assertions;
import org.drools.mvel.compiler.Person;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.FactHandle;

@RunWith(value=Parameterized.class)
public class RuleExecutionTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public RuleExecutionTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)false);
    }

    @Test
    public void testNoAll() throws Exception {
        String str = "global java.util.List list\nrule R1 when\n    $i : Integer()\n    $s : String( this == $i.toString() )\nthen\n    list.add( $i );\nend\n\nrule R2 when\n    $i : Integer()\n    $s : Long( intValue == $i )\nthen\n    insert( \"\" + $i );\n    list.add( -$i );\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)1);
        ksession.insert((Object)2);
        ksession.insert((Object)3);
        ksession.insert((Object)1L);
        ksession.insert((Object)2L);
        ksession.insert((Object)3L);
        ksession.fireAllRules();
        Assertions.assertThat(list).isEqualTo(Arrays.asList(-1, 1, -2, 2, -3, 3));
    }

    @Test
    public void testAll() throws Exception {
        String str = "global java.util.List list\nrule R1 when\n    $i : Integer()\n    $s : String( this == $i.toString() )\nthen\n    list.add( $i );\nend\n\nrule R2 @All when\n    $i : Integer()\n    $s : Long( intValue == $i )\nthen\n    insert( \"\" + $i );\n    list.add( -$i );\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)1);
        ksession.insert((Object)2);
        ksession.insert((Object)3);
        ksession.insert((Object)1L);
        ksession.insert((Object)2L);
        ksession.insert((Object)3L);
        ksession.fireAllRules();
        Assertions.assertThat(list).isEqualTo(Arrays.asList(-1, -2, -3, 1, 2, 3));
    }

    @Test
    public void testAllWithBeforeAndAfter() throws Exception {
        String str = "global java.util.List list\nrule R1 when\n    $i : Integer()\n    $s : String( this == $i.toString() )\nthen\n    list.add( $i );\nend\n\nrule R2 @All when\n    $i : Integer()\n    $s : Long( intValue == $i )\nthen\n    insert( \"\" + $i );\n    list.add( -$i );\nthen[$onBeforeAllFire$]\n    list.add( -$i * 5 );\nthen[$onAfterAllFire$]\n    list.add( -$i * 4 );\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)1);
        ksession.insert((Object)2);
        ksession.insert((Object)3);
        ksession.insert((Object)1L);
        ksession.insert((Object)2L);
        ksession.insert((Object)3L);
        ksession.fireAllRules();
        Assertions.assertThat(list).isEqualTo(Arrays.asList(-5, -1, -2, -3, -12, 1, 2, 3));
    }

    @Test
    public void testOnDeleteMatchConsequence() throws Exception {
        String str = "import " + Person.class.getCanonicalName() + ";\nrule R1 when\n    $p : Person( age > 30 )\nthen\n    $p.setStatus(\"in\");\nthen[$onDeleteMatch$]\n    $p.setStatus(\"out\");\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        Person mario = new Person("Mario", 40);
        FactHandle fact = ksession.insert((Object)mario);
        ksession.fireAllRules();
        Assertions.assertThat((String)mario.getStatus()).isEqualTo("in");
        ksession.delete(fact);
        ksession.fireAllRules();
        Assertions.assertThat((String)mario.getStatus()).isEqualTo("out");
    }
}

